% BOT.pl
% Copyright (C) 1996 Kouichi Furukawa 
%                    (Read README.ps for detailed information.)

:- dynamic vset/2, stored/2, counter/1. %, mgtp_option/2.

main_loop(InBuf,_,_,_,[buf(InBuf)]-_,_,Gen) :-
	mgtp_option(r,R), Gen>R,!.
main_loop(InBuf,_,_,_,[buf(InBuf)]-_,0,_) :- !.
main_loop(InBuf,Case,Msize,TM,Bh-Bt,H,Gen) :-
	pickup(InBuf,Next,Buf,Gen,Gen1) ->
	  ( mgtp_option(r,R), Gen1>R -> Bh=[buf(InBuf)] ;
   	    ( Next='ATOM'(Atom,_,Tcall,Hcall,_,_),
	      tm_put(Atom,TM,LEAF),
	      ( var(LEAF) ->
		  Msize1 is Msize+1, 
		  ( mgtp_option(dup,yes) -> LEAF=Msize1 ; true ),
		  ( fire_testers(Tcall,(Atom,Msize1,TM),_) ->
		      write(user_output,false),ttynl;
		    fire_generators(Hcall,(Atom,Msize1,TM),NewUs),
		    LEAF=Msize1,
		    %note_atom(Msize1,Atom,Info),
		    add_buf(NewUs,Buf,NewBuf),
		    Bh=[Atom|Bh1],
		    H1 is H-1,
		    main_loop(NewBuf,Case,Msize1,TM,Bh1-Bt,H1,Gen1) ) ;
	        main_loop(Buf,Case,Msize,TM,Bh-Bt,H,Gen1) ) ) ) ;
	abolish(status,1),assert(status(sat)),
	Bh=Bt.


%%  buffer handling

init_buf((U,Q)-(U,Q)).

pickup(((Uhd,Qhd)-TL,B_Buf),Next,((NewUhd,Qhd)-TL,B_Buf),Gen,Gen) :-
	nonvar(Uhd),!,
	( Uhd=[(_,Next)|NewUhd] -> true ; Uhd=[Next|NewUhd] ).
pickup(((Uhd,Qhd)-TL,B_Buf),Next,((Uhd,NewQhd)-TL,B_Buf),Gen,Gen) :-
	nonvar(Qhd),!,
	Qhd=[Next|NewQhd].
pickup((A_Buf,(Uhd,Qhd)-TL),Next,((NewUhd,Qhd)-TL,A_Buf),Gen,Gen1) :-
	nonvar(Uhd),!,
	Gen1 is Gen+1,
	( Uhd=[(_,Next)|NewUhd] -> true ; Uhd=[Next|NewUhd] ).
pickup((A_Buf,(Uhd,Qhd)-TL),Next,((Uhd,NewQhd)-TL,A_Buf),Gen,Gen1) :-
	nonvar(Qhd),!,
	Gen1 is Gen+1,
	Qhd=[Next|NewQhd].

add_buf(Us,B,NewB) :-
	mgtp_option(buffer,Btype),
	( Btype=queue -> add_queue(Us,B,NewB) ;
	  true ).

add_queue([X|Rest],(A_Buf,HD-(Utl,[X|Qtl])),NewBuf) :-
	X='ATOM'(_,_,_,_,_,explosive),!,
	add_queue(Rest,(A_Buf,HD-(Utl,Qtl)),NewBuf).
add_queue([X|Rest],(A_Buf,HD-([X|Utl],Qtl)),NewBuf) :-
	add_queue(Rest,(A_Buf,HD-(Utl,Qtl)),NewBuf).
add_queue([],Buf,Buf).

%%  add_inTerms

add_inTerms(InTerms) :-	asserta(InTerms).

%%  extract_bot

extract_bot(X,(Head:-Body),Level) :- extract_bot1(X,Head,BodyL,0,Level),
	list2conj2(BodyL,Body).

list2conj2([H],H) :- !.
list2conj2([H|T],(H,B)) :- list2conj2(T,B).
list2conj2([],true).


extract_bot1([],_,[],L,L) :- !.
extract_bot1([buf(_)],_,[],L,L) :- !.
%extract_bot1([buf(((Ah,_)-(At,_),(Bh,_)-(Bt,_)))],Head,BL,Li,Lo) :- !,
%%	write(user_output,'Scanning buf...'),ttynl,
%	extract_bot2(Ah-At,Head,BL-Bm,Li,Lm),
%	extract_bot2(Bh-Bt,Head,Bm-[],Lm,Lo).

extract_bot1([head(A)|L],Head,BL,Li,Lo) :- var(Head),!, Head=A,
	extract_bot1(L,Head,BL,Li,Lo).
%extract_bot1([body(X=X)|L],H,BL,Li,Lo) :- !, extract_bot1(L,H,BL,Li,Lo).
extract_bot1([body(A)|L],H,[A|BL],Li,Lo) :-
	A=..[_|As], check_limit(As,Li,Lm),
	mgtp_option(i,LIM), Lm=<LIM,!,
	extract_bot1(L,H,BL,Lm,Lo).
extract_bot1([_|L],H,BL,Li,Lo) :- extract_bot1(L,H,BL,Li,Lo).


extract_bot2(T-T,_,B-B,L,L) :- var(T),!.
extract_bot2(['ATOM'(head(A),_,_,_,_,_)|T]-Z,Head,BL,Li,Lo) :-
	var(Head),!, Head=A,
	extract_bot2(T-Z,Head,BL,Li,Lo).
%extract_bot2(['ATOM'(body(X=X),_,_,_,_,_)|T]-Z,Head,BL,Li,Lo) :- !,
%	extract_bot2(T-Z,Head,BL,Li,Lo).
extract_bot2(['ATOM'(body(A),_,_,_,_,_)|T]-Z,Head,[A|Bh]-Bt,Li,Lo) :- !,
	A=..[_|As], check_limit(As,Li,Lm),
	mgtp_option(i,LIM), Lm=<LIM,!,
	extract_bot2(T-Z,Head,Bh-Bt,Lm,Lo).
extract_bot2([_|T]-Z,Head,BL,Li,Lo) :-
	extract_bot2(T-Z,Head,BL,Li,Lo).


check_limit([A|As],Li,Lo) :- atom(A),!,
	( v_level(A,L) -> ( L<0 -> !,fail ; L>Li -> Lm = L; Lm=Li ) ;
                          Lm = Li ),
	check_limit(As,Lm,Lo).
check_limit([A|As],Li,Lo) :- A=..[_|Bs],!,
	check_limit(Bs,Li,Lm), check_limit(As,Lm,Lo).
check_limit([_|As],Li,Lo) :- check_limit(As,Li,Lo).
check_limit([],L,L).

%%  init_level, fix_level

:- dynamic v_level/2.

init_level([V|Vs]) :- asserta(v_level(V,0)), init_level(Vs).
init_level([]). 

fix_level(Vs) :-
	update_vset([],Vs),!.

update_vset(Vs1,[V|Vs2]) :-
	( retract(vset(V,VS)) ; VS=[] ),
	add_vset(Vs1,Vs2,V,VS,NewVS),
	assert(vset(V,NewVS)),
	update_vset([V|Vs1],Vs2).
update_vset(_,[]).

add_vset([],[],_,VS,VS).
add_vset([],[V|Vs2],V,VS,NewVS) :- !,add_vset([],Vs2,V,VS,NewVS).
add_vset([],[U|Vs2],V,VS,NewVS) :- member(U,VS),!,
	add_vset([],Vs2,V,VS,NewVS).
add_vset([],[U|Vs2],V,VS,NewVS) :- add_vset([],Vs2,V,[U|VS],NewVS).
add_vset([V|Vs1],Vs2,V,VS,NewVS) :- !,add_vset(Vs1,Vs2,V,VS,NewVS).
add_vset([U|Vs1],Vs2,V,VS,NewVS) :- member(U,VS),!,
	add_vset(Vs1,Vs2,V,VS,NewVS).
add_vset([U|Vs1],Vs2,V,VS,NewVS) :- add_vset(Vs1,Vs2,V,[U|VS],NewVS).

%member(V,[V|_]).
%member(V,[_|X]) :- member(V,X).

:- dynamic changed/1.

fix_var_level :-
%	write(user_output,'Fixing var_level...'),ttynl,
	abolish(changed,1), assert(changed(no)),
	fix_var_level1,
	( changed(yes) -> fix_var_level ; true ).

fix_var_level1 :-
	vset(V,VS),
	( v_level(V,L) -> L1 is L+1, update_level(VS,L1) ; true ),
	fail.
fix_var_level1.

update_level([],_).
update_level([V|VS],L1) :-
	( v_level(V,L) -> (L=<L1 -> true ;
	                   retract(v_level(V,L)), assert(v_level(V,L1)),
			   asserta(changed(yes))) ;
          assert(v_level(V,L1)), asserta(changed(yes)) ),!,
	update_level(VS,L1).
