/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
----------------------------------------------------------- */
/* ----------------------------------------------------------
	 Copyright (C) 1996 Kazuhiko Ohno, Masahiko Ikawa,
	 and Computer Architecture Laboratory, Depertment of
	 Information Science, Kyoto University.
----------------------------------------------------------- */	 
#ifndef FIRST
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/sighndl.h>
#include <klic/primitives.h>
#include <klic/schedule.h>
#ifdef DIST
#include <klic/rmon.h>
#else
#define GC_ON()
#define GC_OFF()
#endif
#ifdef SHM
#include <klic/shm.h>
#endif
#ifdef SCHED
#include <klic/sched.h>
#endif

int sigint_interrupt = 0;

#ifdef SCHED
static struct threadrec *enqueue_resumed_threads(qp)
     struct threadrec *qp;
{
  declare_globals;
  struct threadrec *rsmt = resumed_threads;
  if (rsmt != 0) {
		/* thread change is occured ,but
		 the reason is not finished execution of before thread */
    struct threadrec *newqp = rsmt->next;
    rsmt->next = qp;
/* 		qp->stack->top = stackp; */
    qp = newqp;
    resumed_threads = 0;
/* 		stackp = qp->stack->top; */
    if (interrupt_off) heaplimit = real_heaplimit;
  }
  return qp;
}


q *klic_interrupt(allocp, qp, stackp)
	q *allocp;
	struct threadrec *qp;
	q * stackp;
{
  declare_globals;
  long retry;
  extern q *klic_signal_handler();
#ifdef DEBUGLIB
  extern int trace_flag;
#ifdef SCHED
  extern struct threadrec *trace_after();
#else
  extern struct goalrec *trace_after();
#endif
#endif

	/* resumption first */
	if(loop_check_flag){
		qp = enqueue_resumed_threads(qp);
		loop_check_flag = 0;
	}
	/*
  qp = enqueue_resumed_threads(qp);
*/
#ifdef DEBUGLIB
  if (trace_flag) {
    qp = trace_after(qp, allocp, stackp);
    allocp = heapp;
  }
#endif

  do {
    retry = 0;

    /* signal handling */
#ifdef USESIG
    if (!signal_done) {
      allocp = klic_signal_handler(allocp);
      retry = (allocp + this_more_space >= real_heaplimit);
      /* some goals may have been resumed by the signal handler */
      qp = enqueue_resumed_threads(qp);
    }
#endif

    if (sigint_interrupt) {
      fatal("Execution aborted by SIGINT");
    }

#ifdef SHM
    while( (Volatile int)ext_queued ) {
      *cur_status = 1;
      ext_queued = 0;
      klic_barrier();
      qp = get_invoked_goals(qp);
      interrupt_off = -1;
      heaplimit = real_heaplimit;
      retry |= (allocp + this_more_space >= heaplimit);
    }
#endif

    /* priority support */
    if (higher_priority_thread) {
      higher_priority_thread = 0;
      put_priority_queue(qp, current_prio);
      qp = get_top_priority_queue();
      if (interrupt_off) heaplimit = real_heaplimit;
    }

#ifdef SHM
    if (ck_shm_gc() || allocp + this_more_space >= real_heaplimit) {
      extern struct goalrec *klic_gc();
      *cur_status = 3;
    /* ck_shm_gc will call another GC */
#else
    if (allocp + this_more_space >= real_heaplimit) {
      extern struct threadrec *klic_gc();
#endif
#ifdef DEBUGLIB
			extern int gc_count;
#endif
      GC_ON();
/*			printf("allocp %x this_more_space %x real_heaplimit %x\n",
							allocp,this_more_space,real_heaplimit);*/
#ifdef DEBUGLIB
			gc_count++;
#endif
      qp = klic_gc(qp);
#ifdef SHM
      *cur_status = 1;
#endif
      GC_OFF();

      allocp = heapp;
    }
  } while (retry);

  current_queue = qp;
  return allocp;
}
#else
static struct goalrec *enqueue_resumed_goals(qp)
     struct goalrec *qp;
{
  declare_globals;
  struct goalrec *rsmg = resumed_goals;
  if (rsmg != 0) {
    struct goalrec *newqp = rsmg->next;
    rsmg->next = qp;
    qp = newqp;
    resumed_goals = 0;
    if (interrupt_off) heaplimit = real_heaplimit;
  }
  return qp;
}

q *klic_interrupt(allocp, qp)
     q *allocp;
     struct goalrec *qp;
{
  declare_globals;
  long retry;
  extern q *klic_signal_handler();
#ifdef DEBUGLIB
  extern int trace_flag;
  extern struct goalrec *trace_after();
#endif

  qp = enqueue_resumed_goals(qp);

#ifdef DEBUGLIB
  if (trace_flag) {
    qp = trace_after(qp, allocp);
    allocp = heapp;
  }
#endif

  do {
    retry = 0;

    /* signal handling */
#ifdef USESIG
    if (!signal_done) {
      allocp = klic_signal_handler(allocp);
      retry = (allocp + this_more_space >= real_heaplimit);
      /* some goals may have been resumed by the signal handler */
      qp = enqueue_resumed_goals(qp);
    }
#endif

    if (sigint_interrupt) {
      fatal("Execution aborted by SIGINT");
    }

#ifdef SHM
    while( (Volatile int)ext_queued ) {
      *cur_status = 1;
      ext_queued = 0;
      klic_barrier();
      qp = get_invoked_goals(qp);
      interrupt_off = -1;
      heaplimit = real_heaplimit;
      retry |= (allocp + this_more_space >= heaplimit);
    }
#endif

    /* priority support */
    if (higher_priority_goal) {
      higher_priority_goal = 0;
      put_priority_queue(qp, current_prio);
      qp = get_top_priority_queue();
      if (interrupt_off) heaplimit = real_heaplimit;
    }

#ifdef SHM
    if (ck_shm_gc() || allocp + this_more_space >= real_heaplimit) {
      extern struct goalrec *klic_gc();
      *cur_status = 3;
    /* ck_shm_gc will call another GC */
#else
    if (allocp + this_more_space >= real_heaplimit) {
      extern struct goalrec *klic_gc();
#endif
      GC_ON();
      qp = klic_gc(qp);
#ifdef SHM
      *cur_status = 1;
#endif
      GC_OFF();

      allocp = heapp;
    }
  } while (retry);

  current_queue = qp;
  return allocp;
}
#endif	
#endif/* aho */
