/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ----------------------------------------------------------
	 Copyright (C) 1996 Kazuhiko Ohno, Masahiko Ikawa,
	 and Computer Architecture Laboratory, Depertment of
	 Information Science, Kyoto University.
----------------------------------------------------------- */	 
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/timing.h>
#include <klic/index.h>

#include <stdio.h>

#include <klic/interpe.h>
#include <klic/distio.h>
#include <klic/rmon.h>

#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

combuf *alloc_combuf();
void init_comm();
void init_rmonitor();

timerstruct before_exec, after_exec;

void init_rusage()
{
  measure(before_exec);
}


static void initiate_global_data()
{
/* Hack to avoid sending %unify when a ReadHook receives answer_value. */
  receive_answer_flag = 0;
  answer_return_exp_index = -1;
/* Hack to avoid sending %unify when a ReadHook receives answer_value. */

  active_exp_entry = 0;

  /* for suspending message */
  susp_msg_list = (struct susp_msg_rec *)0;

  /* Measurement Initialization */
  BZERO((char *)&netstat, sizeof(netstat));

  /* For runtime monitor */
}

#ifdef REDUCTION_CNT
long reduction_cnt = 0;
long garbage_collection_cnt = 0;
#endif

#ifdef PACKSEND
#include <pk_macro.h>
#define INITIAL_PKBUF_SIZE 0x100000
combuf *pk_buffer;
struct pk_flag *pk_flg;
struct pk_flag pk_flg_tail;
struct pk_flag *pk_flg_top;
int pk_flag;
int gcend = 0;
int pending = 0;
q outexref_unify_result = 0;
void init_pkbuffer()
{
	declare_globals;
	long flg;
	pk_flg_tail.next = &pk_flg_tail;
	pk_flg_tail.value = makeint(1);

	pk_flg = &pk_flg_tail;
	pk_flg_top = pk_flg;
	
	pk_buffer = alloc_combuf(INITIAL_PKBUF_SIZE);
}
#endif

void init_dist()
{
  initiate_exp_table();
  initiate_global_data();
  initiate_imp_table();
  init_comm();
  init_rmonitor();
  initiate_decode_stack();
#ifdef SCHED
	init_memory();
#endif
#ifdef PACKSEND
	init_pkbuffer();
#endif
}
