#include <stdio.h>
#include <klic/gdobject.h>
#include <klic/interpe.h>
#include <klic/distproc.h>
#include "atom.h"
#include "funct.h"

#include <klic/sighndl.h>
#include <klic/traceio.h>

#include <pk_struct.h> 

#define GC_CLASS_NAME() unifyhook
#define GC_OBJ_TYPE struct unifyhook_object
#define GC_OBJ_SIZE(obj)  G_SIZE_IN_Q(GC_OBJ_TYPE)


#include <klic/gc_macro.h>
#include <klic/gd_macro.h>

extern void *decode_unify();
extern long get_wtc();
extern void message_suspend();
extern void send_message();
extern void push_exp_table_entry();

/*extern void send_request_wtc();*/


GCDEF_UNIFY()
{
  G_STD_DECL;
	extern combuf *pk_buffer;
	long wtc,send_wtc;
	
	INT_CL_DEBUG_X(iosprintf("%d:unifyhook active_unify for %d\n", my_node,GC_SELF->node));
	INT_CL_PROBE_X(netstat.send_unify_cnt++);

	wtc = get_wtc(UNIFY_WTC_UNIT,get_wtc_normal_request);
	send_wtc = wtc;
	if(send_wtc == 0)
		send_wtc = UNIFY_WTC_UNIT;

	PUT4_BUFFER(pk_buffer,decode_unify,send_wtc,
							GC_SELF->index,GC_SELF->wec);

/*----------------   send message for unifyhook  ---------------------*/

	if(wtc == 0){
		message_suspend(UNIFY_WTC_UNIT, GC_SELF->node,pk_buffer);
	}else{
		send_message(GC_SELF->node, pk_buffer);
	}
/*	
	push_exp_table_entry(&exp_table[GC_SELF->own_index]);
	active_exp_entry--;
*/
	GC_TERMINATE;
}
	

GCDEF_GC()
{
  G_STD_DECL;
  GC_OBJ_TYPE *newself;

	INT_CL_DEBUG_X(iosprintf("%d:gc for unifyhook\n",my_node));

  GCSET_NEWOBJ_IN_NEWGEN(newself);
	newself->node = GC_SELF->node;
  newself->index = GC_SELF->index;
  newself->wec = GC_SELF->wec;
/*	newself->own_index = GC_SELF->own_index; */
  GC_RETURN_FROM_GC(newself);
}

GCDEF_PRINT()
{}

#define GCUSE_MY_UNIFY
#define GCUSE_MY_GC
#define GCUSE_MY_PRINT

#include <klic/gc_methtab.h>

GCDEF_NEW() /*  node, index,  wec */
{
  GC_STD_DECL_FOR_NEW;
  GC_OBJ_TYPE *new_unifyhook;
  q var;

	INT_CL_DEBUG_X(iosprintf("%d:new for unifyhook\n",my_node));

  GCSET_NEWOBJ_FOR_NEW(new_unifyhook, GC_OBJ_SIZE(new_unifyhook));

  new_unifyhook->node = (long)intval(GC_ARGV[0]);
  new_unifyhook->index  = (long)intval(GC_ARGV[1]);
  new_unifyhook->wec    = (long)intval(GC_ARGV[2]);
  var = GC_MAKE_HOOK_VAR(new_unifyhook);
/*
	new_unifyhook->own_index = regist_exptbl(var);
*/
  GC_RETURN_FROM_NEW(var);
}
