#include <stdio.h>  
#define DEBUG
#include <klic/gdobject.h>
#include <klic/interpe.h>
#include <klic/generic.h>
#include <klic/susp.h>
#include <klic/gobj.h>
#include "atom.h"
#include "funct.h"

#include <pk_struct.h>
#include <pk_index.h>
#include <pk_macro.h>

#include <klic/g_vector.h>

#include "pvm3.h"

#define GD_CLASS_NAME() packbuf
#define GD_OBJ_TYPE struct packbuf_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

#include <klic/gd_macro.h>


struct exref_object{
  struct generator_object_method_table *method_table;
  long node;
  long index;
  long wec;
  q    to_exref;
  long gc_flag;
};

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;
	struct susprec *susp;
	
	susp = suspp(derefone(GD_SELF->hook));
	
  GDSET_NEWOBJ_IN_NEWGEN(newself);
  GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->hook, newself->hook);
  newself->node = GD_SELF->node;
  newself->pk_flg = (q*)*GD_SELF->pk_flg;
	
  GD_RETURN_FROM_GC(newself);
}


/* ---------------- Generic method for packing ----------------- */

extern q *decode_atomic_or_const();
extern q* packbuf_unify();

GDDEF_METHOD(put__atomic_2)
{
	G_STD_DECL;
	long data = (long)GD_ARGV[0];
	extern combuf *pk_buffer;
	
	INT_CL_DEBUG_X(iosprintf("%d:put_atomic\n",my_node));

	PUT2_BUFFER(pk_buffer, decode_atomic_or_const,data);
	g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
	GD_RETURN;
}

extern q *decode_list();

GDDEF_METHOD(put__cons_2)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	q data = (q)GD_ARGV[0];
	
	INT_CL_DEBUG_X(iosprintf("%d:put_cons\n",my_node));
	
	PUT_BUFFER(pk_buffer, decode_list);
	/*	derefone(GD_ARGV[1]) = GD_ARGV[1]; */ 
	g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
	GD_RETURN;
}

extern q *decode_funct();

GDDEF_METHOD(put__functor_2)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	q data = (q)GD_ARGV[0];

	INT_CL_DEBUG_X(iosprintf("%d:put_functor\n",my_node));

	PUT2_BUFFER(pk_buffer,decode_funct,functor_of(data));
	g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
	GD_RETURN;
}


extern q *decode_exref();
extern q *decode_unused_atomic();
extern long regist_exptbl();

GDDEF_METHOD(put__unused_2)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	q data = (q)GD_ARGV[0];

	INT_CL_DEBUG_X(iosprintf("%d:put_unused\n",my_node));

	if(isatomic(data)){
		PUT2_BUFFER(pk_buffer,decode_atomic_or_const,data)
	}else{ 
			long index = regist_exptbl(data);
			PUT4_BUFFER(pk_buffer,decode_exref,my_node,index,EXPORT_UNIT_WEC);
		}
	g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
	GD_RETURN;
}

q inref_g_new();
q *decode_inexref();

GDDEF_METHOD(put__in__ref_3)
{
	G_STD_DECL;
	extern combuf* pk_buffer;
	q data;
	q *allocp;
	long index,wec;

	INT_CL_DEBUG_X(iosprintf("%d:put_inref\n",my_node));

	data = (q)GD_ARGV[0];

	PACK_SWITCH_ON_PACK_INREF(data, ref_label, susp_label);

 ref_label:
	{
		long index = regist_exptbl(data);
		PUT5_BUFFER(pk_buffer,decode_inexref,my_node,index,EXPORT_UNIT_WEC,
								intval(GD_ARGV[1]));
		g_allocp = packbuf_unify(g_allocp,GD_ARGV[2],GD_SELF);
		GD_RETURN;
	}
 susp_label:
	{
		long send_wec;
		struct susprec *sdata = (struct susprec *)derefone(data);
		if(is_generator_susp(sdata->u)){
			struct generator_susp *genobj = generator_suspp(sdata);
			struct exref_object *exref = 
				(struct exref_object *)untag_generator_susp(genobj->u.o);
			
			if (exref->wec < MIN_WEC){
				fatal("illegal WEC in put_in_ref");      
				}
			if (exref->wec < MIN_WEC*2){
				goto ref_label;
			}
			 send_wec = (exref->wec)>>1;
			
			exref->wec = exref->wec - send_wec;
			
			PUT5_BUFFER(pk_buffer,decode_inexref,exref->node,exref->index,
									send_wec,intval(GD_ARGV[1]));
			g_allocp = packbuf_unify(g_allocp,GD_ARGV[2],GD_SELF);			
			GD_RETURN;
		}else{
			goto ref_label;
		}
	}
}

extern q *decode_outexref();

GDDEF_METHOD(put__unify_3)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	extern struct predicate *packsend_goal[];
	long index;

	q data = (q)GD_ARGV[0];

	INT_CL_DEBUG_X(iosprintf("%d:put_unify\n",my_node));

	index = regist_exptbl(data);
	PUT5_BUFFER(pk_buffer,decode_outexref,my_node,index,
							EXPORT_UNIT_WEC,intval(GD_ARGV[1]));
	g_allocp = packbuf_unify(g_allocp,GD_ARGV[2],GD_SELF);			
	GD_RETURN;
}

extern q *decode_vector();


GDDEF_METHOD(put__vector_2)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	q data = (q)GD_ARGV[0];
	INT_CL_DEBUG_X(iosprintf("%d:put_vector\n",my_node));
#ifdef DEBUG
	if(isfunctor(data)){
		q f = functor_of(data);
		if(isref(f)){
#endif
			{
				struct vector_object *vector;
				vector = (struct vector_object *)functorp(data);
				PUT_BUFFER(pk_buffer, decode_vector);
				PUT_BUFFER(pk_buffer, vector->index);
				g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
				GD_RETURN;
			}
#ifdef DEBUG
		}else{
			fatal("pack data is not data object in put_vector");
		}
	}else{
		fatal("pack data is not data object in put_vector");
	}
#endif
}

GDDEF_METHOD(put__string_2)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	q data = GD_ARGV[0];
	INT_CL_DEBUG_X(iosprintf("%d:put_string\n",my_node));
#ifdef DEBUG
	if(isfunctor(data)){
		q f = functor_of(data);
		if(isref(f)){
#endif
			generic_encode((struct data_object *)functorp(data), pk_buffer, 1);
			g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
			GD_RETURN;
#ifdef DEBUG
		}else{
			fatal("pack data is not string in put_string");
		}
	}else{
		fatal("pack data is not string in put_string");
	}
#endif
}


GDDEF_METHOD(put__atomic__or__ref_2)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	q data = (q)GD_ARGV[0];
	
	PACK_SWITCH_ON_BOUND_OR_REF(data, ref_label, susp_label, bound_label);

 ref_label:
	{
		long index = regist_exptbl(data);
		INT_CL_DEBUG_X(iosprintf("%d:put ref in put_atomic_or_ref\n",my_node));
		PUT4_BUFFER(pk_buffer,decode_exref,my_node,index,EXPORT_UNIT_WEC);
		g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
		GD_RETURN;
	}
 susp_label:
	{
		long send_wec;
		struct susprec *sdata = (struct susprec *)derefone(data);
		INT_CL_DEBUG_X(iosprintf
									 ("%d:put susp in put_atomic_or_ref\n",my_node));		
		if(is_generator_susp(sdata->u)){
			struct generator_susp *genobj = generator_suspp(sdata);
			struct exref_object *exref = 
				(struct exref_object *)untag_generator_susp(genobj->u.o);
			
			if (exref->wec < MIN_WEC){
				fatal("illegal WEC in put_in_ref");      
			}
			if (exref->wec < MIN_WEC*2){
				goto ref_label;
			}
			send_wec = (exref->wec)>>1;
			
			exref->wec = exref->wec - send_wec;
			
			PUT4_BUFFER(pk_buffer,decode_exref,exref->node,exref->index,
									send_wec);
			g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
			GD_RETURN;
		}else{
			goto ref_label;
		}
	}
 bound_label:
			INT_CL_DEBUG_X(iosprintf
									 ("%d:put atomic in put_atomic_or_ref\n",my_node));		

#ifdef DEBUG
	if(isatomic(data)){
#endif
		PUT2_BUFFER(pk_buffer,decode_atomic_or_const,data);
		g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
		GD_RETURN;
#ifdef DEBUG
	}else{
		fatal("pack data is not atomic or ref in put_atomic_or_ref");
	}
#endif
}

GDDEF_METHOD(put__string__or__ref_2)
{
	G_STD_DECL;
	extern combuf *pk_buffer;
	q data = (q)GD_ARGV[0];
	
	INT_CL_DEBUG_X(iosprintf("%d:put_string_or_ref\n",my_node));
	
	PACK_SWITCH_ON_BOUND_OR_REF(data, ref_label, susp_label, bound_label);

 ref_label:
	{
		long index = regist_exptbl(data);
		PUT4_BUFFER(pk_buffer,decode_exref,my_node,index,EXPORT_UNIT_WEC);
		g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
		GD_RETURN;
	}
 susp_label:
	{
		long send_wec;
		struct susprec *sdata = (struct susprec *)derefone(data);
		if(is_generator_susp(sdata->u)){
			struct generator_susp *genobj = generator_suspp(sdata);
			struct exref_object *exref = 
				(struct exref_object *)untag_generator_susp(genobj->u.o);
			
			if (exref->wec < MIN_WEC){
				fatal("illegal WEC in put_in_ref");      
			}
			if (exref->wec < MIN_WEC*2){
				goto ref_label;
			}
			send_wec = (exref->wec)>>1;
			
			exref->wec = exref->wec - send_wec;
			
			PUT4_BUFFER(pk_buffer,decode_exref,exref->node,exref->index,
									send_wec);
			g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
			GD_RETURN;
		}else{
			goto ref_label;
		}
	}
 bound_label:
#ifdef DEBUG
	if(isfunctor(data)){
		q f = functor_of(data);
		if(isref(f)){
#endif
			generic_encode((struct data_object *)functorp(data), pk_buffer, 1);
			g_allocp = packbuf_unify(g_allocp,GD_ARGV[1],GD_SELF);
			GD_RETURN;
#ifdef DEBUG
		}else{
			fatal("pack data is not string or ref in put_string_or_ref");
		}
	}else{
			fatal("pack data is not string or ref in put_string_or_ref");
	}
#endif
}


extern q* resume_goals();
extern q* set_semaphore();
extern q* pk_resume_goals();

GDDEF_METHOD(sendbuf_0)
{
  G_STD_DECL;
	INT_CL_DEBUG_X(iosprintf("%d:send pk_buffer\n",my_node));
	
	if(isref(GD_SELF->hook))
		{
			q temp = derefone(GD_SELF->hook);     
		deref_hook: 
			if(GD_SELF->hook != temp){
				if(isref(temp)){
					q temp1 = derefone(temp);
					if (temp1 == GD_SELF->hook) {
						g_allocp = resume_goals(g_allocp, temp, makeint(1));
						set_flg(GD_SELF->pk_flg);  
/*						g_allocp = do_unify(g_allocp,GD_SELF->pk_flg,makeint(1)); */
		 				GD_SELF = 0;
					}else{
						GD_SELF->hook = temp; 
						temp = temp1;
						goto deref_hook;
					}
		 		}else{
					GD_FAIL("Error hook is not Consumer0!!!");
				}
			}else{
				GD_FAIL("Error hook is not Consumer1!!!");
			}
		}else{
			GD_FAIL("Error hook is not Consumer2!!!");
		}
  GD_RETURN;
}
  


/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_METHOD{
    GD_METHOD_CASE(put__atomic_2);
    GD_METHOD_CASE(put__cons_2);
    GD_METHOD_CASE(put__functor_2);
    GD_METHOD_CASE(put__unused_2);
    GD_METHOD_CASE(put__in__ref_3);
    GD_METHOD_CASE(put__unify_3);
    GD_METHOD_CASE(put__vector_2);
    GD_METHOD_CASE(put__string_2);
		GD_METHOD_CASE(put__atomic__or__ref_2);
		GD_METHOD_CASE(put__string__or__ref_2);
    GD_METHOD_CASE(sendbuf_0);
    GD_METHOD_CASE_DEFAULT;
  }
  GD_RETURN;
}


/* guard generic methods */

   
#define GDUSE_MY_GC
#define GDUSE_MY_GENERIC

/* define the method table structure of the vector */
#include <klic/gd_methtab.h> 

/*  new_string function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  GD_OBJ_TYPE *newbuf;
	struct susprec *susp;
/*	extern int gcend; */

	INT_CL_DEBUG_X(iosprintf("%d:new for packbuf\n",my_node));

  GDSET_NEWOBJ_FOR_NEW(newbuf, (G_SIZE_IN_Q(GD_OBJ_TYPE)));  

  newbuf->method_table = &GD_method_table;
	newbuf->hook = (q)GD_ARGV[0];
	newbuf->node  = (long)intval(GD_ARGV[1]);
	newbuf->pk_flg = (q *)GD_ARGV[2];
	if(isint(newbuf->pk_flg)){
		puts("isint pk_flg in new_generic");
	}
/*
	if(gcend){
		iosprintf("%d:new for pkbuf\n",my_node);
		gcend = 0;
		}
		*/
	/*	susp = suspp(derefone(newbuf->hook)); */
	/*	iosprintf("%d:hook %d %d\n",my_node,newbuf->hook,susp->u.first_hook.u.o);
	 */
  GD_RETURN_FROM_NEW(newbuf);
}
 
