#include <stdio.h>

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/bb.h>
#include <klic/g_basic.h>
#include <klic/g_extern.h>
#include <klic/g_extern_inline.h>
#include <klic/susp.h>
#include <klic/gg_macro.h>

#include <klic/interpe.h>
#include <klic/distio.h>
#include <klic/traceio.h>

#include "atom.h"
#include "funct.h"

/* packsend/include */
#include <pk_struct.h>
#include <pk_macro.h>

#define GG_CLASS_NAME() out_exref
#define GG_OBJ_TYPE struct out_exref_object

#include <klic/gc_macro.h>
#include <klic/gd_macro.h>
#include <klic/generic.h>

extern q *decode_outexref();
extern q *pk_suspend_goal();
extern q *suspend_goal();
extern void *decode_exref();

GGDEF_ENCODE()
{
/*	GG_FAIL("Unexpected Unify method in out_exref"); */
	G_STD_DECL;
	long send_wec;

	INT_CL_DEBUG_X(iosprintf("%d:encode in exref\n",my_node));
	
	if(GG_SELF->wec <MIN_WEC){
		fatal("illegal WEC in exref object");
	}

  if (GG_SELF->wec < MIN_WEC*2){
    return(GENERIC_FAILED);
  }
  send_wec = (GG_SELF->wec)>>1;
  GG_SELF->wec -= send_wec;

	PUT_BUFFER(buffer, decode_exref);
	PUT_BUFFER(buffer, GG_SELF->node);
  PUT_BUFFER(buffer, GG_SELF->index);
  PUT_BUFFER(buffer, send_wec);

  return(GENERIC_SUCCEEDED);
}

q read_hook_g_new();

GGDEF_GENERATE()
{
	G_STD_DECL;
  q rdhok;
  q* allocp;

	INT_CL_DEBUG_X(iosprintf("%d:generate method in out_exref\n",my_node));

  generic_arg[0] = makeint(GG_SELF->node);
  generic_arg[1] = makeint(GG_SELF->index);
  generic_arg[2] = makeint(GG_SELF->wec);

  allocp = g_allocp;                    /* Using allocp in 'new_generic' */
  new_generic(read_hook_g_new, 3, rdhok, 0); 
  g_allocp = allocp;                    /* Using allocp in 'new_generic' */

  GG_SELF->method_table = 0;

  GG_SELF->node = 0;
  GG_SELF->index = 0;
  GG_SELF->wec = 0;
	GG_SELF->goalnum=0;

  GG_SELF->gc_flag = IMPREC_RELEASED;

  heapp = g_allocp;
  return(rdhok);
} 

q unifyhook_g_new();
q packbuf_g_new();
struct generator_object_method_table *get_outexref_methtab();
struct generator_object_method_table *get_exref_methtab();
struct generator_object_method_table *get_inexref_methtab();

GGDEF_UNIFY()
{
  G_STD_DECL; 

	q unifyhok;
	q *allocp;
	extern struct pk_flag *pk_flg;
	extern struct pk_flag *pk_flg_top;	
	extern struct pk_flag pk_flg_tail;
	extern struct predicate **pk_goal;
	
	extern struct predicate *packsend_goal[];
	extern combuf *pk_buffer;
	struct goalrec *newgoal;
	struct generator_susp *gsusp = generator_suspp(derefone(GG_SELF));
	struct out_exref_object *GG_OBJ 
		= (struct out_exref_object *)untag_generator_susp(gsusp->u.o);


	INT_CL_DEBUG_X(iosprintf("%d:out_exref active unify\n",my_node));

	GG_SWITCH_ON_TERM(list0,atomic0,functor0,generic_data0,susp0);
 list0:
 atomic0:
 functor0:
 generic_data0: 
  
/*     Make unifyhook Object   */


/* Make sendopt goal */

	if(pk_buffer_unused()){
		struct pk_flag *new_pk_flg;
		q pk_buf;

		if(g_allocp + this_more_space + 14 >= real_heaplimit){
			INT_CL_DEBUG_X(iosprintf("%d:unify pending in outexref\n",my_node));
			puts("unify pendig");
			GG_TERMINATE_WITH_GC(14);
		}

		generic_arg[0] = makeint(GG_OBJ->node);
		generic_arg[1] = makeint(GG_OBJ->index);
		generic_arg[2] = makeint(GG_OBJ->wec);
		allocp = g_allocp;
		new_generic(unifyhook_g_new, 3, unifyhok, 0);
		g_allocp = allocp;
		
		new_pk_flg = (struct pk_flag *)g_allocp;
		new_pk_flg->next = &pk_flg_tail;
		new_pk_flg->value = (q)&(new_pk_flg->value);
		
		g_allocp += 2;
		
		generic_arg[0] = unifyhok;
		generic_arg[1] = makeint(my_node);
		generic_arg[2] = (q)&(new_pk_flg->value);
		allocp = g_allocp;
		new_generic(packbuf_g_new, 3, pk_buf, 0);
		g_allocp = allocp;

		pk_flg = new_pk_flg;
		pk_flg_top = new_pk_flg;		

 		newgoal = (struct goalrec *)g_allocp;
		newgoal->pred = (struct predicate *)packsend_goal[GG_OBJ->goalnum];
		newgoal->args[0] = GG_TERM;
		newgoal->args[1] = pk_buf;
/*		newgoal->args[2] = (q)&(newgoal->args[2]); */

		g_allocp += 4;
		resume_same_prio(newgoal);
	}else{
		struct pk_flag *new_pk_flg;
		struct pk_flag *tmp_pk_flg;
		q pk_flg1;
		q pk_buf;

		if(g_allocp + this_more_space + 20 >= real_heaplimit){
 			INT_CL_DEBUG_X(iosprintf("%d:unify pending in outexref \n",my_node));
			puts("unify pendig");
			GG_TERMINATE_WITH_GC(20);
		} 

		generic_arg[0] = makeint(GG_OBJ->node);
		generic_arg[1] = makeint(GG_OBJ->index);
		generic_arg[2] = makeint(GG_OBJ->wec);
		allocp = g_allocp;
		new_generic(unifyhook_g_new, 3, unifyhok, 0);
		g_allocp = allocp;

		tmp_pk_flg = pk_flg;
		deref_pk_flg(tmp_pk_flg);
		new_pk_flg = (struct pk_flag *)g_allocp;
		tmp_pk_flg->next = new_pk_flg;
		new_pk_flg->next = &pk_flg_tail;
		new_pk_flg->value = (q)&(new_pk_flg->value);

		g_allocp += 2;

		generic_arg[0] = unifyhok;
		generic_arg[1] = makeint(my_node);
		generic_arg[2] = (q)&(new_pk_flg->value);
		allocp = g_allocp;
		new_generic(packbuf_g_new, 3, pk_buf, 0);
		g_allocp = allocp;

		pk_flg = new_pk_flg;

		newgoal = (struct goalrec *)g_allocp;
		newgoal->pred = (struct predicate *)packsend_goal[GG_OBJ->goalnum];
		newgoal->args[0] = GG_TERM;
		newgoal->args[1] = pk_buf;
/*		newgoal->args[2] = (q)&(newgoal->args[2]); */

		g_allocp += 4;

/*		iosprintf("%d:suspend goal in out %d\n",my_node,pk_flg1);*/
		g_allocp = pk_suspend_goal(g_allocp, newgoal, pk_flg1);
	}
	
	heapp = g_allocp;

	derefone(GG_SELF) = GG_TERM;
	
	GG_OBJ->method_table = 0;
	GG_OBJ->gc_flag = IMPREC_RELEASED;
	
	GG_TERMINATE_OUTEXREF;
	
 susp0:
	 {
      struct susprec *gterm = (struct susprec *)(derefone(GG_TERM));

      if(is_generator_susp(gterm->u)){
				struct generator_susp *gsusp1 = generator_suspp(derefone(GG_TERM));
				struct generator_object *dummy_obj = untag_generator_susp(gsusp1->u.o);
				if(dummy_obj-> method_table == get_exref_methtab()
					 ||dummy_obj-> method_table == get_inexref_methtab()
					 ||dummy_obj-> method_table == get_outexref_methtab()){
				} else {
					fatal("unify EXREF-UnknownGEN occur"); 
				}
				send_unify(GG_OBJ->node, GG_OBJ->index, GG_OBJ->wec, GG_TERM);
				derefone(GG_SELF) = GG_TERM;
				GG_OBJ->method_table = 0;
				GG_OBJ->gc_flag = IMPREC_RELEASED;
				GG_TERMINATE;
      }
			INT_CL_DEBUG_X(iosprintf("%d:Can't unify now\n"));
		}
	return(NULL);
	
}

GGDEF_GC()
{
  G_STD_DECL;
  GG_OBJ_TYPE *newself;

	INT_CL_DEBUG_X(iosprintf("GGDEF_GC in OUT_EXREF \n"));

	if(GG_SELF->gc_flag != IMPREC_NOT_COPIED){
		ioeprintf("illegal outexref in GC\n");
		ERROR_STOP;
	}

  GGSET_NEWOBJ_IN_NEWGEN(newself);
  newself->node = GG_SELF->node;
  newself->index = GG_SELF->index;
  newself->wec = GG_SELF->wec;
	newself->goalnum = GG_SELF->goalnum;
 	G_COPY_KL1_TERM_TO_NEWGEN(GG_SELF->to_exref, newself->to_exref);	

	GG_SELF->gc_flag = IMPREC_COPIED;
	newself->gc_flag = IMPREC_NOT_COPIED;

  GG_RETURN_FROM_GC(newself);
}


GGDEF_PRINT()
{	
	iosprintf("print method in out_exref\n");
	return(1);
}

#define GGUSE_MY_GENERATE
#define GGUSE_MY_UNIFY
#define GGUSE_MY_ENCODE
#define GGUSE_MY_GC
#define GGUSE_MY_PRINT

#include <klic/gg_methtab.h>

GGDEF_NEW() /*  node, index,  wec */
{
  GG_STD_DECL_FOR_NEW;
  GG_OBJ_TYPE *new_outexref;
  q var;

  GGSET_NEWOBJ_FOR_NEW(new_outexref, (struct out_exref_object *)); 

	INT_CL_DEBUG_X(iosprintf("%d:new for out_exref",my_node));
  new_outexref->node = (long)intval(GG_ARGV[0]);
  new_outexref->index  = (long)intval(GG_ARGV[1]);
  new_outexref->wec    = (long)intval(GG_ARGV[2]);
	new_outexref->goalnum = (long)intval(GG_ARGV[3]);

  new_outexref->to_exref = GG_MAKE_HOOK_VAR(new_outexref);

	new_outexref->gc_flag = IMPREC_NOT_COPIED;
	
	regist_imp_entry(new_outexref);

  GG_RETURN_FROM_NEW(new_outexref->to_exref);
}

struct generator_object_method_table*
get_outexref_methtab()
{
	return(&GG_method_table);
}
