#include <stdio.h>

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/bb.h>
#include <klic/g_basic.h>
#include <klic/g_extern.h>
#include <klic/g_extinl.h>
#include <klic/susp.h>
#include <klic/gg_macro.h>
#include <klic/gobj.h>

#include <klic/interpe.h>
#include <klic/distio.h>
 
#include "atom.h"
#include "funct.h"

#include <pk_struct.h>

#define GG_CLASS_NAME() in_exref
#define GG_OBJ_TYPE struct in_exref_object

#include <klic/gc_macro.h>
#include <klic/gd_macro.h>
#include <klic/generic.h>

q read_all_hook_g_new();

GGDEF_GENERATE()
{
	G_STD_DECL;
	q rdhok;
	q* allocp;

	generic_arg[0] = makeint(GG_SELF->node);
	generic_arg[1] = makeint(GG_SELF->index);
	generic_arg[2] = makeint(GG_SELF->wec);
	generic_arg[3] = makeint(GG_SELF->goalnum);

	allocp = g_allocp;
	new_generic(read_all_hook_g_new, 4, rdhok, 0); 
  g_allocp = allocp;                   

  GG_SELF->method_table = 0;

  GG_SELF->node = 0;
  GG_SELF->index = 0;
  GG_SELF->wec = 0;
	GG_SELF->goalnum = 0;

  GG_SELF->gc_flag = IMPREC_RELEASED;

  heapp = g_allocp;
  return(rdhok);
}	

extern struct generator_object_method_table* get_exref_methtab();
extern struct generator_object_method_table* get_inexref_methtab();
extern struct generator_object_method_table* get_outexref_methtab();
void send_unify_inref();

GGDEF_UNIFY()
{
	G_STD_DECL;
  struct generator_susp *gsusp = generator_suspp(derefone(GG_SELF));
  GG_OBJ_TYPE *GG_OBJ = (GG_OBJ_TYPE *)untag_generator_susp(gsusp->u.o);

	INT_CL_DEBUG_X(iosprintf("%d:unify in inexref\n",my_node));
	GG_SWITCH_ON_TERM(list0,atomic0,functor0,generic_data0,susp0);
	
 list0:
	puts("unify inexref-list");
	goto error;
 atomic0:
	puts("unify inexref-atomic");
	goto error;
 functor0:
	puts("unify inexref-functor");
	goto error;
 generic_data0:
	puts("unify inexref-data_object");
 error:
	derefone(GG_SELF) == GG_TERM;
	GG_OBJ->method_table = 0;
	GG_OBJ->gc_flag = IMPREC_RELEASED;
	GG_TERMINATE;
	/*GG_FAIL("ERROR in INEXREF->UNIFY");*/
 susp0:
	{
		struct susprec *gterm = (struct susprec *)(derefone(GG_TERM));
		if(is_generator_susp(gterm->u)){
			struct generator_susp *gsusp1 = generator_suspp(derefone(GG_TERM));
			struct generator_object *dummy_obj = untag_generator_susp(gsusp1->u.o);
			if(dummy_obj-> method_table == get_exref_methtab()
				 ||dummy_obj-> method_table == get_inexref_methtab()
				 ||dummy_obj-> method_table == get_outexref_methtab()){

				send_unify_inref(GG_OBJ->node, GG_OBJ->index, GG_OBJ->wec,dummy_obj);
				derefone(GG_SELF) = GG_TERM;
				GG_OBJ->method_table = 0;
				GG_OBJ->gc_flag = IMPREC_RELEASED;
				GG_TERMINATE;
			}else{
				fatal("unify INEXREF-UnknownGEN occur"); 
			}
		}
		return(NULL); /* Cannot unify now */
	}
}

extern q *decode_exref();

GGDEF_ENCODE()
{
	G_STD_DECL;
	long send_wec;

	INT_CL_DEBUG_X(iosprintf("%d:encode in exref\n",my_node));
	
	if(GG_SELF->wec <MIN_WEC){
		fatal("illegal WEC in exref object");
	}

  if (GG_SELF->wec < MIN_WEC*2){
    return(GENERIC_FAILED);
  }
  send_wec = (GG_SELF->wec)>>1;
  GG_SELF->wec -= send_wec;

	PUT_BUFFER(buffer, decode_exref);
	PUT_BUFFER(buffer, GG_SELF->node);
  PUT_BUFFER(buffer, GG_SELF->index);
  PUT_BUFFER(buffer, send_wec);

  return(GENERIC_SUCCEEDED);
}


GGDEF_GC()
{
	G_STD_DECL;
	GG_OBJ_TYPE *newself;

  INT_CL_DEBUG_X(klic_fprintf(stdout,"inexref GC invoked\n"));

  if(GG_SELF->gc_flag != IMPREC_NOT_COPIED){
    ioeprintf("illegal inexref in GC\n");
    ERROR_STOP;
  }

  GGSET_NEWOBJ_IN_NEWGEN(newself);

  newself->node = GG_SELF->node;
  newself->index = GG_SELF->index;
  newself->wec = GG_SELF->wec;
	newself->goalnum = GG_SELF->goalnum;
 	G_COPY_KL1_TERM_TO_NEWGEN(GG_SELF->to_exref, newself->to_exref);

  GG_SELF->gc_flag = IMPREC_COPIED;
  newself->gc_flag = IMPREC_NOT_COPIED;

  GG_RETURN_FROM_GC(newself);
}

GGDEF_PRINT()
{}

#define GGUSE_MY_GENERATE
#define GGUSE_MY_UNIFY
#define GGUSE_MY_GC
#define GGUSE_MY_PRINT
#define GGUSE_MY_ENCODE

#include <klic/gg_methtab.h>

GGDEF_NEW() /* node, index, wec */
{
  GG_STD_DECL_FOR_NEW;
  GG_OBJ_TYPE *new_inexref;

	GGSET_NEWOBJ_FOR_NEW(new_inexref, (struct in_exref_object *));

  new_inexref->node   = (long)intval(GG_ARGV[0]);
  new_inexref->index  = (long)intval(GG_ARGV[1]);
  new_inexref->wec    = (long)intval(GG_ARGV[2]);
	new_inexref->goalnum = (long)intval(GG_ARGV[3]);
	
  new_inexref->to_exref = GG_MAKE_HOOK_VAR(new_inexref);

  new_inexref->gc_flag  = IMPREC_NOT_COPIED;

  regist_imp_entry(new_inexref);

  GG_RETURN_FROM_NEW(new_inexref->to_exref);
}	

extern q* decode_unify();

static long
encode_unify_inref(buffer, index, wec, inref)
	combuf *buffer;
	struct generator_object *inref;
	long index, wec;
{
	declare_globals;
	long wtc, send_wtc;
	INT_CL_PROBE_X(netstat.send_unify_cnt++);
	wtc = get_wtc(UNIFY_WTC_UNIT, get_wtc_normal_request);
	send_wtc = wtc;
	if (send_wtc == 0)
		send_wtc = UNIFY_WTC_UNIT;
	if(generic_encode(inref,buffer,1)){
		PUT4_BUFFER(buffer, decode_exref, my_node, index, EXPORT_UNIT_WEC);
	}
	PUT4_BUFFER(buffer, decode_unify, send_wtc, index, wec);
	return(wtc);
}

static void
send_unify_inref(node, index, wec, inref)
	long node,index,wec;
	struct generator_object *inref;
{
	INT_CL_DEBUG_X(declare_globals;)
	combuf *buffer = NODE_TO_BUFFER(node);
	
	INT_CL_DEBUG_X(iosprintf("%d:send_unify\n", my_node));
	
	if(!encode_unify_inref(buffer, index, wec, inref)){
		message_suspend(UNIFY_WTC_UNIT, node, buffer);
	} else {
		send_message(node, buffer);
	}
}

struct generator_object_method_table*
get_inexref_methtab()
{
	return(&GG_method_table);
}
