#include <stdio.h>
#include <klic/gdobject.h>
#include <signal.h>
#include <klic/distio.h>
#include <klic/interpe.h>
#include <klic/susp.h>
#include "atom.h"
#include "funct.h"

#include <klic/traceio.h>

#include <pk_struct.h> 

#define GC_CLASS_NAME() answerhook
#define GC_OBJ_TYPE struct answerhook_object
#define GC_OBJ_SIZE(obj)  G_SIZE_IN_Q(GC_OBJ_TYPE)

#include <klic/gc_macro.h>
#include <klic/gd_macro.h>

extern int requesting_wtc;

extern void *decode_answer_value();
extern long get_wtc();
extern void message_suspend();
extern void send_message();
extern void send_request_wtc();
extern void push_exp_table_entry();

GCDEF_UNIFY()
{
  G_STD_DECL;
	extern combuf *pk_buffer;
	long wtc,send_wtc;

	INT_CL_DEBUG_X(iosprintf("%d:answerhook active unify for %d\n",my_node,GC_SELF->node));
	INT_CL_PROBE_X(netstat.send_answer_cnt++);

	wtc = get_wtc(ANSWER_WTC_UNIT,get_wtc_normal_request);
	send_wtc = wtc;
	if(send_wtc == 0)
		send_wtc = ANSWER_WTC_UNIT;
	PUT4_BUFFER(pk_buffer,decode_answer_value,send_wtc,
							GC_SELF->index,GC_SELF->wec);

/*----------------   send message for answerhook  ---------------------*/
	if(wtc == 0){
		message_suspend(ANSWER_WTC_UNIT, 
												 GC_SELF->node, pk_buffer);
	}else{
		send_message(GC_SELF->node, pk_buffer);
	}

/*--------------------------------------------------------------------*/
/*
	push_exp_table_entry(&exp_table[GC_SELF->own_index]);
	active_exp_entry--;
*/
	GC_TERMINATE;
}
	

GCDEF_GC()
{
  G_STD_DECL;
  GC_OBJ_TYPE *newself;

  GCSET_NEWOBJ_IN_NEWGEN(newself);
	newself->node = GC_SELF->node;
  newself->index = GC_SELF->index;
  newself->wec = GC_SELF->wec;
  GC_RETURN_FROM_GC(newself);
}

GCDEF_PRINT()
{}

#define GCUSE_MY_UNIFY
#define GCUSE_MY_GC
#define GCUSE_MY_PRINT

#include <klic/gc_methtab.h>

GCDEF_NEW() 
{
  GC_STD_DECL_FOR_NEW;
  GC_OBJ_TYPE *new_answerhook;
  q var;

	INT_CL_DEBUG_X(iosprintf("%d:new for answerhook\n",my_node));

  GCSET_NEWOBJ_FOR_NEW(new_answerhook, GC_OBJ_SIZE(new_answerhook));

  new_answerhook->node = (long)intval(GC_ARGV[0]);
  new_answerhook->index  = (long)intval(GC_ARGV[1]);
  new_answerhook->wec    = (long)intval(GC_ARGV[2]);

  var = GC_MAKE_HOOK_VAR(new_answerhook);
  GC_RETURN_FROM_NEW(var);
}
