/* ---------------------------------------------------------- 
%   (C)1993,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ----------------------------------------------------------
	 Copyright (C) 1996 Kazuhiko Ohno, Masahiko Ikawa,
	 and Computer Architecture Laboratory, Depertment of
	 Information Science, Kyoto University.
----------------------------------------------------------- */	 
#ifndef FIRST
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>

#ifdef SCHED
#include <klic/sched.h>
#endif

extern char *malloc(), *realloc();

char *malloc_check(size)
     unsigned long size;
{
  char *res = malloc(size);
  if (res == 0) {
    fatalf("No more memory available from Unix\nMalloc failed for %d bytes",
	   size);
  }
  return res;
}

char *realloc_check(original, newsize)
     char *original;
     unsigned long newsize;
{
  char *res = realloc(original, newsize);
  if (res == 0) {
    fatalf("No more memory available from Unix\nRealloc failed for %d bytes",
	   newsize);
  }
  return res;
}


#ifdef SCHED

struct stackrec topsucceed_stack;

void reinit_alloc()
{
  declare_globals;
	int i;
	
	/* Heap Area initiation */
  heaplimit = real_heaplimit = new_space_top+heapsize;
  heapbottom = real_heaplimit+incrementsize;
  heaptop = heapp = new_space_top;
  real_heapbytesize = (unsigned long)heaptop - (unsigned long)heapbottom;
  this_more_space = 0;
  gc_hooktab_size = 32;
  num_gc_hooks = 0;
  gc_hook_table = (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
  after_gc_hooktab_size = 32;
  num_after_gc_hooks = 0;
  after_gc_hook_table =
    (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));

}



extern module queue_empty();
extern module stack_empty();

struct stackrec stack_tail;
extern struct predicate queue_empty_pred;
extern struct predicate stack_empty_pred;

void
init_stack()
{
	declare_globals;
	int i;
	unsigned long stackbytesize;
	struct stackrec *stack;

	if(stacksize != 0 && number_of_stack != 0) {
		stackbytesize = stacksize * sizeof(q);
	}else{
    fatalf
			("Illegal memory size specification: stack = %d, number_of_stack = %d",
			 stacksize, number_of_stack);
	}	

	stack =
		(struct stackrec*)calloc((number_of_stack+1),sizeof(struct stackrec));
	for(i=0;i<number_of_stack;i++){
		stack[i].next = &stack[i+1];
		stack[i].bottom = stack[i].top = (q *)malloc_check(stackbytesize);
		stack[i].limit = stack[i].bottom + stacksize;
		*(stack[i].top)++ = (q)&stack_empty_pred;
	}
	stack[number_of_stack-1].next = &stack_tail;
	stack[number_of_stack].next = 0;
	stack[number_of_stack].bottom = stack[number_of_stack].top =
		(q *)malloc_check(stackbytesize);
	stack[number_of_stack].limit = stack[i].bottom + stacksize;
	*(stack[number_of_stack].top)++ = (q)&stack_empty_pred;

	stack_tail.bottom = stack_tail.top = (q *)malloc_check(3*sizeof(q));
	stack_tail.limit  = stack_tail.bottom + 3;
	*(stack_tail.top++) = (q)&queue_empty_pred;
	
	stq = stack;
	topsucceed_stack = stack[number_of_stack];

	/* generic suspend stack */
	gs_stack.stp = (q *)malloc_check(GS_STACKSIZE);
	gs_stack.flag = 0;
	gs_stack.num = 0;
}



void initalloc()
{
  declare_globals;
  unsigned long bytesize;
	
  if(heapsize != 0  && incrementsize != 0) {
    bytesize = (heapsize + incrementsize)*sizeof(q);
  } else {
    fatalf("Illegal memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
  }

  old_space_size = new_space_size = bytesize;
  new_space_top = (q *)malloc_check(bytesize);
  old_space_top = (q *)malloc_check(bytesize);

	init_stack();
  reinit_alloc();
}


q*
realloc_stack(stack,stack_size)
	q* stack;
	long stack_size;
{
	declare_globals;
	q* newstack;
	newstack = (q *)realloc((char *)stack,
											 stack_size * sizeof(q));
	return newstack;
}

void
expand_stack(stack,stackp)
	struct stackrec *stack;
	q* stackp;
{
	declare_globals;
	q* ret;

	long stack_size = (stack->limit - stack->bottom)*2;
	long stack_ndata = (long)(stackp - stack->bottom);

	stack->bottom = ret = realloc_stack(stack->bottom,stack_size*sizeof(q));
	if(!ret)
		fatal("realloc failed in expanding stack");
	stack->limit = stack->bottom + stack_size;
	stackp = stack->bottom + stack_ndata;
/*	ioprintf("PE %d stack expanded to %d\n",my_node,stacksize); */
}


void
expand_stack_area()
{
	declare_globals;
	int i;
	unsigned long stackbytesize;
	struct stackrec *stack;
#ifdef DEBUGSCHED
	printf("expand stack area\n");
#endif
	
	stack =
		(struct stackrec*)calloc(EXPAND_STACK_NUM,sizeof(struct stackrec));
	for(i=0;i<EXPAND_STACK_NUM;i++){
		stack[i].next = &stack[i+1];
		stack[i].bottom = stack[i].top = (q *)malloc_check(stackbytesize);
		stack[i].limit = stack[i].bottom + stacksize;
		*(stack[i].top)++ = (q)&stack_empty_pred;
	}
	stack[EXPAND_STACK_NUM].next = &stack_tail;
	stack[EXPAND_STACK_NUM].next = 0;
	stack[EXPAND_STACK_NUM].bottom = stack[EXPAND_STACK_NUM].top =
		(q *)malloc_check(stackbytesize);
	stack[EXPAND_STACK_NUM].limit = stack[i].bottom + stacksize;
	*(stack[EXPAND_STACK_NUM].top)++ = (q)&stack_empty_pred;
	
	stq = stack;
}



#else
void reinit_alloc()
{
  declare_globals;
  heaplimit = real_heaplimit = new_space_top+heapsize;
  heapbottom = real_heaplimit+incrementsize;
  heaptop = heapp = new_space_top;
  real_heapbytesize = (unsigned long)heaptop - (unsigned long)heapbottom;
  this_more_space = 0;
  gc_hooktab_size = 32;
  num_gc_hooks = 0;
  gc_hook_table = (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
  after_gc_hooktab_size = 32;
  num_after_gc_hooks = 0;
  after_gc_hook_table =
    (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
}

void initalloc()
{
  declare_globals;
  unsigned long bytesize;

  if(heapsize != 0  && incrementsize != 0) {
    bytesize = (heapsize + incrementsize)*sizeof(q);
  } else {
    fatalf("Illegal memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
  }

  old_space_size = new_space_size = bytesize;
  new_space_top = (q *)malloc_check(bytesize);
  old_space_top = (q *)malloc_check(bytesize);
  reinit_alloc();
}
#endif

void register_gc_hook(routine)
     q*(*routine)();
{
  declare_globals;
  if (num_gc_hooks >= gc_hooktab_size) {
    gc_hooktab_size *= 2;
    gc_hook_table = (q*(**)())
      realloc_check(gc_hook_table,
		    gc_hooktab_size*sizeof(q*(**)()));
  }
  gc_hook_table[num_gc_hooks++] = routine;
}

void register_after_gc_hook(routine)
     q*(*routine)();
{
  declare_globals;
  if (num_after_gc_hooks >= after_gc_hooktab_size) {
    after_gc_hooktab_size *= 2;
    after_gc_hook_table = (q*(**)())
      realloc_check(after_gc_hook_table,
		    after_gc_hooktab_size*sizeof(q*(**)()));
  }
  after_gc_hook_table[num_after_gc_hooks++] = routine;
}

#endif


