/* ---------------------------------------------------------- 
%   (C)1993,1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifndef FIRST
/* Reasons of interruption */
#define EXTEVENT	makeint(0)
#define FAILURE		makeint(1)

#ifdef SCHED
extern q *interrupt_thread();
#else
extern q *interrupt_goal();
#endif
int check_stack_for_alternatively();
struct goalrec *enqueue_goal();
struct goalrec *enqueue_after_waiting();
struct goalrec *enqueue_throw_goal();

#ifdef SCHED
#define enqueue_at_priority(p,q0,q)	\
{	\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 0); \
}

#define enqueue_at_priority_no_check(x,q0,q)		\
{							\
  long prio = intval(x);				\
  qp = enqueue_thread(q0, prio, q, glbl);			\
}

#define enqueue_at_lower_priority(p,q0,q)		\
{							\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 1);	\
}

#define enqueue_at_lower_priority_no_check(x,q0,q)	\
{							\
  long prio = current_prio-intval(x);			\
  qp = enqueue_thread(q0, prio, q, glbl);			\
}
#else
#define enqueue_at_priority(p,q0,q)			\
{							\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 0);	\
}

#define enqueue_at_priority_no_check(x,q0,q)		\
{							\
  long prio = intval(x);				\
  qp = enqueue_goal(q0, prio, q, glbl);			\
}

#define enqueue_at_lower_priority(p,q0,q)		\
{							\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 1);	\
}

#define enqueue_at_lower_priority_no_check(x,q0,q)	\
{							\
  long prio = current_prio-intval(x);			\
  qp = enqueue_goal(q0, prio, q, glbl);			\
}
#endif


#define switch_on_pred()	switch (toppred->pred)

#define case_pred(p, label)	case (p): goto label;

#define last_case_pred(p, label) default: goto label;

#ifdef SCHED

#define resume_check() \
{ \
	if(resumed_threads != 0){ \
    struct threadrec *rsmt = resumed_threads; \
		struct threadrec *newqp = rsmt->next; \
		rsmt->next = qp; \
		qp->stack->top=stackp; \
		qp=current_queue=newqp; \
		resumed_threads = 0; \
		stackp = qp->stack->top ; \
	} \
	goto proceed_label; \
}

#define loop_within_module(f)	\
{ \
  module (*func)(); \
		if (allocp >= heaplimit) { \
      interrupt_check: \
			qp->stack->top = stackp; \
      if(gs_stack.flag) \
			  push_gs_stack(); \
			allocp = klic_interrupt(allocp, qp, stackp); \
      qp = current_queue; \
			stackp = qp->stack->top; \
	  } \
	proceed_label: \
  	toppred = (struct predicate *)*--stackp; \
	if ((func = toppred->func) == (f)){ \
		/* next goal is in same module */ \
		goto module_top; \
	} \
	/* next goal is not in same module, \
		 but thread is not change */ \
	heapp = allocp;  \
	qp->stack->top = stackp; \
	current_queue = qp; \
	return (module) func; \
}



#else
#define loop_within_module(f)				\
{ \
  module (*func)(); \
  if (allocp >= heaplimit) { \
    allocp = klic_interrupt(allocp, qp); \
    qp = current_queue; \
  } \
  if ((func = (toppred = qp->pred)->func) == (f)) \
    goto module_top; \
  heapp = allocp; \
  current_queue = qp; \
  return (module) func; \
}
#endif
#endif /* aho */
#define execute(label)\
{\
  if (allocp < heaplimit) goto label;\
}


#ifdef SCHED
#define execute_for_loop(label) \
{  \
	if (resumed_threads != 0){ \
		loop_check_flag = 1; \
		heaplimit = 0; \
	}else{ \
		if (allocp < heaplimit) goto label; \
	} \
}
	

#define proceed() \
{ \
		if (allocp < heaplimit) goto proceed_label; \
		else goto interrupt_check; \
}
		
#else
#define proceed()	\
{	\
  goto proceed_label;	\
}
#endif

#ifdef PACKSEND
#define throw_goal(parent_pred,node,oldqp,goal) \
{\
	 qp = enqueue_throw_goal((node),(goal),(oldqp),(parent_pred),allocp); \
}
#else
#define throw_goal(node, oldqp, goal) \
{ \
  qp = enqueue_throw_goal((node), (goal), (oldqp), allocp);\
}
#endif
