// Copyright (C) 1996  Toyoda Masashi (toyoda@is.titech.ac.jp)

/* ---------------- Initalize routine ---------------- */
void Initialize_KL_Widgets(void);

/* ---------------- common slot keys ---------------- */
extern Am_Slot_Key FRAME_PART;
extern Am_Slot_Key CONTENTS_PART;
extern Am_Slot_Key NAME_PART;

/* ---------------- Module ---------------- */

/* ---- global objects ---- */
extern Am_Object Module_Win;
extern Am_Object Process_Agg;

/* ---- slot keys ---- */
extern Am_Slot_Key MODULE_WINS;
extern Am_Slot_Key MODULE_NAME;
extern Am_Slot_Key MODULE_NUM;

/* ---- operations ---- */
void Module_Rename(Am_Object win, char* name);
void Modules_Add(Am_Object modules, Am_Object win, char* name);

/* ---------------- Process, Rule, Goal ---------------- */

/* ---- global objects ---- */
extern Am_Object Process_Proto;
extern Am_Object Creator_Proto;
extern Am_Object Rule_Proto;
extern Am_Object Vanishing_Rule_Proto;
extern Am_Object Continuous_Rule_Proto;

/* ---- slot keys ---- */
/* Process */
extern Am_Slot_Key PROC_NAME;
extern Am_Slot_Key PROC_TYPE;
#define KL_Creator_Proc 0
#define KL_Normal_Proc  1
extern Am_Slot_Key PROC_RULES;
extern Am_Slot_Key NAME_LIST;
/* Rule */
extern Am_Slot_Key RULE_NUMBER;
extern Am_Slot_Key RULE_TYPE;
#define KL_Transition_Rule 0
#define KL_Network_Rule    1
extern Am_Slot_Key PARENT_PROC;
extern Am_Slot_Key INNER_PORT_LIST;
/* Graphical parts */
extern Am_Slot_Key PORTS_PART;
extern Am_Slot_Key GOALS_PART;
extern Am_Slot_Key GUARD_PART;
extern Am_Slot_Key BINDER_PART;
extern Am_Slot_Key PARTS_MOVER;
extern Am_Slot_Key TEXT_INTER_PART;
extern Am_Slot_Key SUB_FRAME_PART;

/* ---- operations ---- */
void Add_Name(Am_Object rule, char* name);
void Remove_Name(Am_Object rule, char* name);
bool Member_Name(Am_Object rule, char* name);
Am_String Next_Name(Am_Object rule, char* base);

Am_Value_List sort_ports(Am_Value_List ports);
void Add_Process(Am_Object proc_agg, Am_Object proc);
void Remove_Process(Am_Object proc_agg, Am_Object proc);
bool Proc_Rename(Am_Object proc, char* name);
void Proc_Add_Port(Am_Object proc, Am_Object port, int x, int y, Am_Object ref_obj);
void Proc_Remove_Port(Am_Object proc, Am_Object port);
Am_Object Proc_Ports_Part(Am_Object process);
Am_Value_List Proc_Ports(Am_Object process);
Am_Object Proc_Get_Port(Am_Object process, char* name);

Am_Object Rule_Create(Am_Object process, Am_Object rule_proto);
void Rule_Toggle_Icon(Am_Object rule);
void Add_Rule(Am_Object rules_agg, Am_Object rule);
void Remove_Rule(Am_Object rules_agg, Am_Object rule);
void Rule_Add_Inner_Port(Am_Object rule, Am_Object port);
void Rule_Remove_Inner_Port(Am_Object rule, Am_Object port);
void Rule_Add_Guard(Am_Object rule, Am_Object guard, int x, int y, Am_Object ref_obj);
void Rule_Add_Goal(Am_Object rule, Am_Object goal, int x, int y, Am_Object ref_obj);
Am_Object Rule_Ports_Part(Am_Object rule);
Am_Value_List Rule_Ports(Am_Object rule);
Am_Object Rule_Binder_Part(Am_Object rule);
Am_Value_List Rule_Binder(Am_Object rule);
Am_Object Rule_Guard_Part(Am_Object rule);
Am_Value_List Rule_Guard(Am_Object rule);
Am_Object Rule_Goals_Part(Am_Object rule);
Am_Value_List Rule_Goals(Am_Object rule);

void Add_Port_ID(Am_Object rule, int id);
void Remove_Port_ID(Am_Object rule, int id);
bool Member_Port_ID(Am_Object rule, int id);
int Next_Port_ID(Am_Object rule);

Am_Object Goal_Create(Am_Object process);
void Goal_Toggle_Icon(Am_Object goal);

/* ---- global objects ---- */
extern Am_Object Port_Proto;
extern Am_Object In_Single_Proto;
extern Am_Object Out_Single_Proto;
extern Am_Object In_Stream_Proto;
extern Am_Object Out_Stream_Proto;

/* ---- Port's slot keys ---- */
extern Am_Slot_Key VALUE_PART;
extern Am_Slot_Key MARKER_PART;

extern Am_Slot_Key PORT_NAME;
extern Am_Slot_Key PORT_ID;
extern Am_Slot_Key PORT_AGE;
#define KL_New_Port	0
#define KL_Old_Port	1
extern Am_Slot_Key PORT_TYPE;
#define KL_Single	0
#define KL_Stream	1
extern Am_Slot_Key PORT_MODE;
#define KL_Output	0
#define KL_Input	1
extern Am_Slot_Key PORT_OPEN;
#define KL_Open		0
#define KL_Close	1
extern Am_Slot_Key PORT_DIR;
extern Am_Slot_Key PORT_DIR_DAEMON;
extern Am_Slot_Key PORT_DIR_TOGGLER;
#define KL_Left		0
#define KL_Right	1
extern Am_Slot_Key PORT_BINDERS;

/* ---- operations ---- */
bool Port_Rename(Am_Object port, char* name);
void Port_Add(Am_Object port, Am_Object data);
void Port_Remove(Am_Object port, Am_Object data);
void Port_Remove_Value(Am_Object value);
Am_Object Port_Values_Part(Am_Object port);
Am_Value_List Port_Values(Am_Object port);
bool Port_Add_Allowed(Am_Object src_port, Am_Object dest_port);
bool Port_Move_Allowed(Am_Object src_port, Am_Object dest_port);
bool Port_Unify_Allowed(Am_Object src_port, Am_Object dest_port);
bool Port_Has_Value(Am_Object port);
bool Port_Is_Bound(Am_Object port);

Am_Object Port_Parent(Am_Object port);
Am_Object Port_Parent_Proc(Am_Object port);
Am_Object Port_Parent_Rule(Am_Object port);

void Remove_All_Binder(Am_Object port);


/* ---------------- Atom data ---------------- */

/* ---- global objects ---- */
extern Am_Object Atom_Proto;

/* ---------------- Structure ---------------- */

/* ---- global objects ---- */
extern Am_Object Structure_Proto;

/* ---------------- Guard ---------------- */

/* ----  global objects ---- */
extern Am_Object Guard_Proto;

/* ---------------- Binding Line ---------------- */

/* ---- global objects ---- */
extern Am_Object Binding_Line;
extern Am_Object Unify_Line;
extern Am_Object Binding_Terminal;
extern Am_Object Append_Line;
extern Am_Object Merge_Line;

/* ---- slot keys ---- */
extern Am_Slot_Key BINDING_LINE;
extern Am_Slot_Key BL_ID;
extern Am_Slot_Key BL_SRC;
extern Am_Slot_Key BL_DEST;
extern Am_Slot_Key LT_LINE;
extern Am_Slot_Key RT_LINE;
extern Am_Slot_Key LB_LINE;
extern Am_Slot_Key RB_LINE;

/* ---- operations ---- */
Am_Object Binding_Line_Create(Am_Object src_port, Am_Object dest_port);
void Binding_Line_Remove(Am_Object line);
