// Copyright (C) 1996  Toyoda Masashi (toyoda@is.titech.ac.jp)

/* Inline functions */

inline int imin(int i1, int i2) {if (i1<i2) return i1; else return i2;}
inline int imax(int i1, int i2) {if (i1>i2) return i1; else return i2;}
inline int iabs(int i1) {if (i1<0) return -i1; else return i1;}

/* Useful functions */
void Value_List_Slot_Add(Am_Object parent, Am_Slot_Key list_slot, Am_Object obj);
int Object_List_Index(Am_Value_List list, Am_Object value);
Am_Object Object_List_Get(Am_Value_List list, int i);
Am_Object Object_List_Get_By_Key(Am_Value_List list, Am_Slot_Key key, Am_String s);
int Object_List_Max(Am_Value_List list, Am_Slot_Key key);
int Group_Index(Am_Object obj);
Am_Object Group_Get_By_Index(Am_Object group, int idx);
int String_List_Index(Am_Value_List list, Am_String value);

Am_Declare_Object_Formula(loopback_form);
Am_Object My_Add_Part(Am_Object parent, Am_Object part);
void Set_Slot_Inherit_Rule(Am_Object obj, Am_Slot_Key key, Am_Inherit_Rule rule);
void My_Set_Single_Constraint_Mode(Am_Object obj, Am_Slot_Key key, bool mode);
void Am_Center_Of_Object(Am_Object obj, int& cx, int& cy);
int Am_Distance_Of_Objects(Am_Object obj1, Am_Object obj2);

/* Opal */
extern Am_Constraint* Am_Horizontal_Rev_Layout;
extern Am_Slot_Key Am_ARROW_LENGTH;
extern Am_Slot_Key Am_ARROW_WIDTH;

/* Interactors */
void Grid_Positive(Am_Object inter, int x, int y, int &out_x, int &out_y);

extern Am_Object Raise_Move_Grow_Command;
extern Am_Object Raise_Move_Grow_Interactor;
extern Am_Object My_Move_Grow_Interactor;

/* Widgets */
extern Am_Object Am_Border_Roundtangle;

/* Popup Menu */
extern Am_Object Popup_Menu;
extern Am_Object Popup_Button_Command;

extern Am_Slot_Key TARGET_OBJECT;

Am_Object Popup_Menu_and_Return_First_Item(Am_Object inter, Am_Object dest_obj, int x, int y);

/* Initialize */
void My_Amulet_Initialize(void);
