// Copyright (C) 1996  Toyoda Masashi (toyoda@is.titech.ac.jp)

void Initialize_Pattern(void);

/* Hole */
extern Am_Object Hole_Proto;

Am_Object Hole_Parent_Pattern(Am_Object hole);
Am_Object Hole_Copy(Am_Object hole);
Am_Object Hole_Parent_Linked_Copy(Am_Object hole);
Am_Object Hole_Place_Linked_Copy(Am_Object hole);
void Hole_Add_Port(Am_Object hole, Am_Object port);
void Hole_Add_Port_At(Am_Object hole, Am_Object port, int x, int y, Am_Object ref_obj);
void Hole_Remove_Port(Am_Object hole, Am_Object port);
bool Hole_Replace(Am_Object hole, Am_Object proc);

/* Pattern */
extern Am_Object Pattern_Proto;
extern Am_Object Sequence_Pattern_Proto;

extern Am_Slot_Key SEQ_DIR;
#define Left_Right 0
#define Top_Bottom 1
#define Right_Left 2
#define Bottom_Top 3

void Add_Pattern(Am_Object pattern_agg, Am_Object pattern);
void Remove_Pattern(Am_Object pattern);

void Pattern_Add_Port(Am_Object pattern, Am_Object port);
void Pattern_Remove_Port(Am_Object pattern, Am_Object port);
void Pattern_Add_Hole(Am_Object pattern, Am_Object hole);
void Pattern_Add_Hole_At(Am_Object pattern,Am_Object hole,int x,int y, Am_Object ref_obj);
void Pattern_Remove_Hole(Am_Object pattern, Am_Object hole);
void Pattern_Add_Goal(Am_Object rule, Am_Object goal);
Am_Object Pattern_Copy(Am_Object pattern);
void Seq_Pattern_Rotate(Am_Object pattern);

/* Special Ports */
extern Am_Object Pat_Single_Port;
extern Am_Object Pat_Stream_Port;
extern Am_Object Pat_In_Single_Port;
extern Am_Object Pat_Out_Single_Port;
extern Am_Object Pat_In_Stream_Port;
extern Am_Object Pat_Out_Stream_Port;
extern Am_Object Map_In_Port;
extern Am_Object Map_Out_Port;
extern Am_Object Recursive_Port;
extern Am_Object Broadcast_Single_Port;
extern Am_Object Broadcast_Stream_Port;
extern Am_Object Merge_Port;

void Seq_Port_Add(Am_Object port, Am_Object data);
