// Copyright (C) 1996  Toyoda Masashi (toyoda@is.titech.ac.jp)
#include <amulet/amulet.h>
#include <amulet/object_advanced.h>
#include <amulet/formula_advanced.h>
#include <amulet/inter_advanced.h>
#include <amulet/widgets_advanced.h>
#include <amulet/debugger.h>
#include <strstream.h>
#include "my_amulet.h"
#include "kl_widgets.h"
#include "kl_pattern.h"

/* ---------------- Hole ---------------- */

// ---- global objects ----
Am_Object Hole_Proto;

// ---- operations ----
Am_Object Hole_Parent_Pattern(Am_Object hole)
{
  Am_Object parent = hole.Get_Owner().Get_Owner().Get_Owner();
  if (parent.Is_Instance_Of(Pattern_Proto))
    return parent;
  else
    return NULL;
}

void Hole_Add_Port(Am_Object hole, Am_Object port)
{
  Am_Object parent = (Am_Object)hole.Get(PARENT_LINK); // $B%3%T!<85$X$NA`:n$KJQ99!%(B
  Proc_Add_Port(parent, port); // process$B$N$rN.MQ!%(B
}

void Hole_Add_Port_At(Am_Object hole, Am_Object port, int x, int y, Am_Object ref_obj)
{
  Am_Object parent = (Am_Object)hole.Get(PARENT_LINK); // $B%3%T!<85$X$NA`:n$KJQ99!%(B
  int dx = (int)hole.Get(Am_LEFT) - (int)parent.Get(Am_LEFT);
  int dy = (int)hole.Get(Am_TOP) - (int)parent.Get(Am_TOP);
  Set_Slot_Inherit_Rule(port, Am_LEFT, Am_STATIC);
  Set_Slot_Inherit_Rule(port, Am_TOP, Am_STATIC);
  Proc_Add_Port_At(parent, port, x - dx, y - dy, ref_obj);
}

void Hole_Remove_Port(Am_Object hole, Am_Object port)
{
  Am_Object parent = (Am_Object)hole.Get(PARENT_LINK); // $B%3%T!<85$X$NA`:n$KJQ99!%(B
  Am_Object parent_port = port.Get_Prototype();
  if (parent == hole) parent_port = port;
  Proc_Remove_Port(parent, parent_port);
}

Am_Object Hole_Copy(Am_Object hole)
{
  Am_Object new_hole = Hole_Proto.Create();
  new_hole
    .Set(PROC_NAME, (char*)(Am_String)hole.Get(PROC_NAME))
    .Set(HOLE_LINK, 0)
    .Set(Am_LEFT, (int)hole.Get(Am_LEFT))
    .Set(Am_TOP, (int)hole.Get(Am_TOP));
  Am_Value_List ports = Proc_Ports(hole);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = (Am_Object)ports.Get();
    Am_Object new_pt;
    Am_Function_Call(Copy_Method, pt, UNLINK_COPY, new_pt, (pt));
    pt.Set(TEMP_LINK, new_pt);
    Hole_Add_Port(new_hole, new_pt);
  }
  hole.Set(TEMP_LINK, new_hole);
  return new_hole;
}

//Am_Font Copy_Font = Am_Font(Am_FONT_SANS_SERIF, false, true, false, Am_FONT_MEDIUM);

Am_Object Hole_Parent_Linked_Copy(Am_Object hole)
{
//  Am_Object parent = (Am_Object)hole.Get(PARENT_LINK);
  Am_Object new_hole;
  Am_Function_Call(Copy_Method, Process_Proto, PARENT_COPY, new_hole, (hole));
//  new_hole.Get_Part(CONTENTS_PART).Get_Part(NAME_PART)
//    .Set(Am_FONT, Copy_Font);

//  new_hole.Set(PARENT_PROC, parent);
  new_hole.Set(Am_PRETEND_TO_BE_LEAF, true)
    .Set(HOLE_LINK, 0)
    .Set(Am_LEFT, (int)hole.Get(Am_LEFT))
    .Set(Am_TOP, (int)hole.Get(Am_TOP));
  hole.Set(TEMP_LINK, new_hole);
  return new_hole;
}

/*
Am_Object Hole_Place_Linked_Copy(Am_Object hole)
{
//  Am_Object parent = (Am_Object)hole.Get(PARENT_LINK);
  Am_Object new_hole;
  Am_Function_Call(Copy_Method, Process_Proto, PLACE_COPY, new_hole, (hole));
//  new_hole.Set(PARENT_PROC, parent);
//  new_hole.Set(Am_PRETEND_TO_BE_LEAF, true);
  hole.Set(TEMP_LINK, new_hole);
  return new_hole;
}
*/

/*
void set_all_binder_visible(Am_Object port, bool visible)
{
  if (KL_Type(port) == KL_Port) {
//  cout << port << endl;
    Am_Value_List binders = (Am_Value_List)port.Get(PORT_HOLE_BINDERS);
    for (binders.Start(); !binders.Last(); binders.Next()) {
      Am_Object line = (Am_Object)(Am_Object)binders.Get();
//    cout << line << endl;
      line.Set(Am_VISIBLE, visible);
    }
  }
  Am_Value_List values = Port_Values(port);
  for (values.Start(); !values.Last(); values.Next()) {
    Am_Object value = (Am_Object)(Am_Object)values.Get();
    if (!value.Is_Instance_Of(Atom_Proto)) {
      set_all_binder_visible(value, visible);
    }
  }
}
*/

/*
void single_hole_set_visible(Am_Object hole, bool visible)
{
  hole.Set(Am_VISIBLE, visible);
  Am_Value_List ports = Proc_Ports(hole);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = (Am_Object)ports.Get();
    set_all_binder_visible(pt, visible);
  }
}
*/

/*
void Hole_Set_Visibility(Am_Object hole, bool visible)
{
  Am_Object parent = hole.Get(PARENT_LINK);
  Am_Instance_Iterator copies = parent;
  for (copies.Start(); !copies.Last(); copies.Next()) {
    Am_Object hl = (Am_Object)copies.Get();
    single_hole_set_visible(hl, visible);
  }
  single_hole_set_visible(parent, visible);
}
*/

void bind_hole_port(Am_Object hport, Am_Object pport)
{
  Am_Value_List binders = (Am_Value_List)hport.Get(PORT_HOLE_BINDERS);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bl = (Am_Object)binders.Get();
    Am_Object src = (Am_Object)bl.Get(BL_SRC);
    Am_Object dest = (Am_Object)bl.Get(BL_DEST);
    if (src == hport) {
      Single_Binding_Line_Create(dest, pport);
    } else {
      Single_Binding_Line_Create(src, pport);
    }
  }
}

bool single_hole_replace(Am_Object hole, Am_Object proc)
{
  int x = hole.Get(Am_LEFT);
  int y = hole.Get(Am_TOP);
  Pattern_Add_Goal(Hole_Parent_Pattern(hole), proc.Set(Am_LEFT, x).Set(Am_TOP, y));

  Am_Value_List hole_ports = Proc_Ports(hole);
  Am_Value_List proc_ports = Proc_Ports(proc);
  for (hole_ports.Start(); !hole_ports.Last(); hole_ports.Next()) {
    Am_Object hpt = (Am_Object)hole_ports.Get();
    int min_dist = 999999;
    Am_Object min_pp = 0;
    for (proc_ports.Start(); !proc_ports.Last(); proc_ports.Next()) {
      Am_Object ppt = (Am_Object)proc_ports.Get();
      if ((int)hpt.Get(PORT_TYPE) == (int)ppt.Get(PORT_TYPE) &&
	  (int)hpt.Get(PORT_MODE) == (int)ppt.Get(PORT_MODE)) {
	int d = Am_Distance_Of_Objects(hpt, ppt);
	if (d < min_dist) {
	  min_dist = d;
	  min_pp = ppt;
	}
      }
    }
    if (min_pp.Valid()) {
      bind_hole_port(hpt, min_pp);
      proc_ports.Start();
      proc_ports.Member(min_pp);
      proc_ports.Delete(); // $B$[$s$H$K:o=|$O$5$l$J$$!%(B
    } else {
      Proc_Remove_All_Binder(proc);
      proc.Remove_From_Owner();
      return false;
    }
  }
  hole.Set(HOLE_LINK, proc);
  proc.Set(HOLE_LINK, hole);
  return true;
}

bool hole_replace_single_pattern(Am_Object hole, Am_Object proc, Am_Object pattern)
{
  Am_Value_List holes = Rule_Holes(pattern);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object hl = (Am_Object)holes.Get();
    if (hl.Is_Instance_Of(hole)) {
      Am_Object proc_copy;
      Am_Function_Call(Copy_Method, proc, PARENT_COPY, proc_copy, (proc));
      if (single_hole_replace(hl, proc_copy) == false) return false;
    }
  }
  return true;
}

bool Hole_Replace(Am_Object hole, Am_Object proc)
{
  Am_Object pattern = Hole_Parent_Pattern(hole);
  pattern = pattern.Get(PARENT_LINK);
  Am_Object parent_hole = (Am_Object)hole.Get(PARENT_LINK);
  Am_Object parent_copy;
  Am_Function_Call(Copy_Method, proc, UNLINK_COPY, parent_copy, (proc));

  Am_Value_List holes = Rule_Holes(pattern);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object hl = (Am_Object)holes.Get();
    if (hl.Is_Instance_Of(parent_hole)) {
      Am_Object proc_copy;
      if (hl == parent_hole)
	proc_copy = parent_copy;
      else
	Am_Function_Call(Copy_Method, parent_copy, PARENT_COPY, proc_copy, (parent_copy));

      if (single_hole_replace(hl, proc_copy) == false) return false;
    }
  }
  Am_Instance_Iterator pat_children = pattern;
  for (pat_children.Start(); !pat_children.Last(); pat_children.Next()) {
    Am_Object pat = pat_children.Get();
    if (hole_replace_single_pattern(parent_hole, parent_copy, pat) == false) return false;
  }
  return true;
}



Am_Define_Formula(bool, hole_visible_form) {
  if (((Am_Object)self.GV(HOLE_LINK)).Valid()) return false;
  return true;
}

void init_hole(void)
{
  Hole_Proto = Process_Proto.Create("Hole_Proto")
    .Set(KL_TYPE,     KL_Hole)
    .Set(HOLE_LINK,   0)
    .Set(Am_VISIBLE,  Am_Formula::Create(hole_visible_form))
    .Set(PARENT_PROC, Am_Formula::Create(loopback_form))
    .Set(PARENT_LINK, Am_Formula::Create(loopback_form))
//    .Set(PLACE_LINK,  Am_Formula::Create(loopback_form))
    .Set(UNLINK_COPY, (Am_Object_Proc*)Hole_Copy)
    .Set(PARENT_COPY, (Am_Object_Proc*)Hole_Parent_Linked_Copy)
//    .Set(PLACE_COPY,  (Am_Object_Proc*)Hole_Place_Linked_Copy)
    .Get_Part(FRAME_PART)
      .Set(Am_SELECTED, true) // $B7j$O$X$3$s$G$$$k!%(B
    .Get_Owner()
    ;
}

/* ---------------- Network Pattern ---------------- */

// ---- global objects ----
Am_Object Pattern_Proto;
Am_Object Sequence_Pattern_Proto;

// ---- slot keys ----
Am_Slot_Key PATTERN_TYPE = Am_Register_Slot_Name("PATTERN_TYPE");

Am_Slot_Key FIRST_ITEM  = Am_Register_Slot_Name("FIRST_ITEM");
Am_Slot_Key SECOND_ITEM = Am_Register_Slot_Name("SECOND_ITEM");
Am_Slot_Key ELLIPSIS    = Am_Register_Slot_Name("ELLIPSIS");
Am_Slot_Key LAST_ITEM   = Am_Register_Slot_Name("LAST_ITEM");

Am_Slot_Key SEQ_DIR     = Am_Register_Slot_Name("SEQ_DIR");

Am_Slot_Key FIRST_GAP = Am_Register_Slot_Name("FIRST_GAP");
Am_Slot_Key LAST_GAP  = Am_Register_Slot_Name("LAST_GAP");

// ---- bitmaps ----
#define BROADCAST_IMAGE_FILE "/home/nsl/toyoda/work/src/amulet/klieg/V0.2/broadcast.bmp"
#define MERGE_IMAGE_FILE "/home/nsl/toyoda/work/src/amulet/klieg/V0.2/merge.bmp"

// ---- operations ----
void Add_Pattern(Am_Object pattern_agg, Am_Object pattern)
{
/*
  Am_String proc_name = (Am_String)proc.Get(PROC_NAME);
  if (Member_Name(proc_agg, proc_name)) {
    proc_name = Next_Name(proc_agg, proc_name);
    Proc_Rename(proc, (char *)proc_name);
  }
*/
  pattern_agg.Add_Part(pattern);
//  Add_Name(proc_agg, proc_name);
}

void remove_single_pattern(Am_Object pattern)
{
  Proc_Remove_All_Binder(pattern);
  pattern.Remove_From_Owner();
}

void hole_remove_single_pattern(Am_Object hole)
{
  Am_Object pat = (Am_Object)hole.Get(HOLE_LINK);
  if (pat.Valid()) remove_single_pattern(pat);
  hole.Set(HOLE_LINK, 0);
//  Hole_Set_Visibility(hole, true);    
}

void Remove_Pattern(Am_Object pattern)
{
  Am_Object hole = (Am_Object)pattern.Get(HOLE_LINK);
  if (hole.Valid()) {
    Am_Object paren = (Am_Object)hole.Get(PARENT_LINK);
    hole_remove_single_pattern(paren);
    Am_Instance_Iterator children = paren;
    for (children.Start(); !children.Last(); children.Next()) {
      Am_Object child = children.Get();
      hole_remove_single_pattern(child);
    }
  } else {
    remove_single_pattern(pattern);
  }
}

void Pattern_Add_Port_Single(Am_Object pattern, Am_Object port)
{
  Am_Object port_agg = Rule_Ports_Part(pattern);
  Am_Object dist_agg = Proc_Ports_Part(pattern);
  int top  = port.Get(Am_TOP);
  int left = port.Get(Am_LEFT);
  My_Add_Part(dist_agg, port.Set(PORT_AGE, KL_New_Port)
	      .Set(Am_TOP,   top).Set(Am_LEFT,   left)
	      .Set(ORIG_TOP, top).Set(ORIG_LEFT, left)
	      .Set(ICON_TOP, top).Set(ICON_LEFT, left));
}

void Pattern_Add_Port(Am_Object pattern, Am_Object port)
{
  Am_String port_name = (Am_String)port.Get(PORT_NAME); // $BL>A0$N%A%'%C%/$*$h$SEPO?!%(B
  if (Member_Name(pattern, port_name)) {
    port_name = Next_Name(pattern, port_name);
    Port_Rename(port, port_name);
  }
  Set_Slot_Inherit_Rule(port, Am_LEFT, Am_STATIC);
  Set_Slot_Inherit_Rule(port, Am_TOP, Am_STATIC);
  Am_Object parent = (Am_Object)pattern.Get(PARENT_LINK);
  Pattern_Add_Port_Single(parent, port);
  Am_Instance_Iterator children = parent;
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object child = children.Get();
    Pattern_Add_Port_Single(child, Port_Create(port));
  }
}

void pattern_remove_port_single(Am_Object pattern, Am_Value_List pos)
{
  Am_Object port = Position_To_Obj(pattern, pos);  
  Remove_All_Binder(port);
  Am_Object port_agg = Proc_Ports_Part(pattern);
  port_agg.Remove_Part(port);
}

void Pattern_Remove_Port(Am_Object pattern, Am_Object port)
{
  Am_Object parent = (Am_Object)pattern.Get(PARENT_LINK);
  Am_Value_List pos = Position_Get(port, pattern);
  pattern_remove_port_single(parent, pos);
  Am_Instance_Iterator children = parent;
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object child = children.Get();
    pattern_remove_port_single(child, pos);
  }
}

void pattern_add_hole_single(Am_Object pattern, Am_Object hole)
{
  Am_Object holes_agg = Rule_Holes_Part(pattern);
  My_Add_Part(holes_agg, hole);
}

void pattern_add_hole_single_at(Am_Object pattern, Am_Object hole,
				int x, int y, Am_Object ref_obj)
{
  Am_Object holes_agg = Rule_Holes_Part(pattern);
  Am_Translate_Coordinates(ref_obj, x, y, holes_agg, x, y); // $B:BI8$NJQ49!%(B
  x = imax(0, x);
  y = imax(0, y);
  hole.Set(Am_LEFT, x).Set(Am_TOP, y);
  pattern_add_hole_single(pattern, hole);
}

void Pattern_Add_Hole(Am_Object pattern, Am_Object hole)
{
  Am_Object parent = (Am_Object)pattern.Get(PARENT_LINK);
  pattern_add_hole_single(pattern, hole);
  Am_Instance_Iterator children = parent;
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object child = children.Get();
    Am_Object hole_child;
    Am_Function_Call(Copy_Method, hole, PARENT_COPY, hole_child, (hole));
    pattern_add_hole_single(child, hole_child);
  }
}

void Pattern_Add_Hole_At(Am_Object pattern, Am_Object hole,
			 int x, int y, Am_Object ref_obj)
{
  Am_Object holes_agg = Rule_Holes_Part(pattern);
  Am_Translate_Coordinates(ref_obj, x, y, holes_agg, x, y); // $B:BI8$NJQ49!%(B
  x = imax(0, x);
  y = imax(0, y);
  hole.Set(Am_LEFT, x).Set(Am_TOP, y);
  Pattern_Add_Hole(pattern, hole);
}

void Pattern_Remove_Hole(Am_Object pattern, Am_Object hole)
{
  Am_Object parent = (Am_Object)hole.Get(PARENT_LINK);
  Am_Instance_Iterator copies = parent;
  for (copies.Start(); !copies.Last(); copies.Next()) {
    Am_Object hl = copies.Get();
    Proc_Remove_All_Binder(hl);
    hl.Remove_From_Owner();
  }
  Proc_Remove_All_Binder(parent);
  parent.Remove_From_Owner();
}

void Pattern_Add_Goal(Am_Object rule, Am_Object goal)
{
  Am_Object goals_agg = Rule_Goals_Part(rule);
  My_Add_Part(goals_agg, goal);
}

void make_temp_link(Am_Object proc1, Am_Object proc2)
{
  Am_Value_List ports1 = Proc_Ports(proc1);
  Am_Value_List ports2 = Proc_Ports(proc2);
  for (ports1.Start(),ports2.Start(); !ports1.Last(); ports1.Next(),ports2.Next()) {
    Am_Object pt1 = (Am_Object)ports1.Get();
    Am_Object pt2 = (Am_Object)ports2.Get();
    pt1.Set(TEMP_LINK, pt2);
  }    
}

void values_copy_iter(Am_Object port, Am_Object dest, Am_Object pattern, Am_Slot_Key mode)
{
  Am_Value_List values = Port_Values(port);
  for (values.Start(); !values.Last(); values.Next()) {
    Am_Object value = (Am_Object)values.Get();
    Am_Object new_val;
    Am_Function_Call(Copy_Method, value, mode, new_val, (value));
    Rule_Add_Inner_Port_No_Rename(pattern, dest, new_val);
    if (KL_Type(value) == KL_Port || KL_Type(value) == KL_Structure) {
      values_copy_iter(value, new_val, pattern, mode);
    }
  }
}

void ports_copy_with_values(Am_Object proc, Am_Object proc_copy,
			    Am_Object pattern, Am_Slot_Key mode)
{
  Am_Value_List ports = Proc_Ports(proc);
  Am_Value_List coports = Proc_Ports(proc_copy);
  for (ports.Start(), coports.Start(); !ports.Last(); ports.Next(), coports.Next()) {
    Am_Object port = (Am_Object)ports.Get();
    Am_Object coport = (Am_Object)coports.Get();
    values_copy_iter(port, coport, pattern, mode);
  }
}

Am_Object Pattern_Copy(Am_Object pattern)
{
  Am_Object new_pat;
  if (pattern.Is_Instance_Of(Sequence_Pattern_Proto)) {
    new_pat = Sequence_Pattern_Proto.Create()
      .Set(SEQ_DIR, (int)pattern.Get(SEQ_DIR))
      .Set(IS_ICON, false);
  } else {
    new_pat = Pattern_Proto.Create();
  }
  new_pat.Set(PROC_NAME, (char*)(Am_String)pattern.Get(PROC_NAME))
    .Set(PARENT_LINK, Am_Formula::Create(loopback_form))
    .Set(INNER_PORTS, Am_Value_List());

  Am_Value_List ports = Rule_Ports(pattern);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = (Am_Object)ports.Get();
    Am_Object new_pt;
    Am_Function_Call(Copy_Method, pt, UNLINK_COPY, new_pt, (pt));
    pt.Set(TEMP_LINK, new_pt);
    Pattern_Add_Port_Single(new_pat, new_pt);
    values_copy_iter(pt, new_pt, new_pat, UNLINK_COPY);
  }
  Am_Value_List holes = Rule_Holes(pattern);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object hl = (Am_Object)holes.Get();
    Am_Object parent = (Am_Object)hl.Get(PARENT_LINK);
    Am_Object new_hl;
    if (hl == parent) {
      Am_Function_Call(Copy_Method, hl, UNLINK_COPY, new_hl, (hl));
      ports_copy_with_values(hl, new_hl, new_pat, UNLINK_COPY);
      hl.Set(TEMP_LINK, new_hl);
    } else {
      Am_Object paren_copy = (Am_Object)parent.Get(TEMP_LINK);
      Am_Function_Call(Copy_Method, paren_copy, PARENT_COPY, new_hl, (paren_copy));
      ports_copy_with_values(hl, new_hl, new_pat, PARENT_COPY);
    }
    new_hl.Set(Am_LEFT, (int)hl.Get(Am_LEFT));
    new_hl.Set(Am_TOP, (int)hl.Get(Am_TOP));
    pattern_add_hole_single(new_pat, new_hl);

  }
  Am_Value_List goals = Rule_Goals(pattern);
  for (goals.Start(); !goals.Last(); goals.Next()) {
    Am_Object gl = (Am_Object)goals.Get();
    Am_Object parent = (Am_Object)gl.Get(PARENT_LINK);
    Am_Object hole = (Am_Object)gl.Get(HOLE_LINK);
    Am_Value_List pos = Position_Get(hole, pattern);
    Am_Object new_gl;
    if (gl == parent) {
      Am_Function_Call(Copy_Method, gl, UNLINK_COPY, new_gl, (gl));
      gl.Set(TEMP_LINK, new_gl);
      if (KL_Type(gl) == KL_Process)
	ports_copy_with_values(gl, new_gl, new_pat, UNLINK_COPY);
    } else {
      Am_Object paren_copy = (Am_Object)parent.Get(TEMP_LINK);
      Am_Function_Call(Copy_Method, paren_copy, PARENT_COPY, new_gl, (paren_copy));
      if (KL_Type(gl) == KL_Process)
	ports_copy_with_values(gl, new_gl, new_pat, PARENT_COPY);
    }
    new_gl.Set(Am_LEFT, (int)gl.Get(Am_LEFT));
    new_gl.Set(Am_TOP, (int)gl.Get(Am_TOP));
    single_hole_replace(Position_To_Obj(new_pat, pos), new_gl);
  }
  Am_Value_List binders = Rule_Binder(pattern);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bd = (Am_Object)binders.Get();
    Am_Value_List src_pos = Position_Get((Am_Object)bd.Get(BL_SRC), pattern);
    Am_Value_List des_pos = Position_Get((Am_Object)bd.Get(BL_DEST), pattern);
    Am_Object src_port = Position_To_Obj(new_pat, src_pos);
    Am_Object des_port = Position_To_Obj(new_pat, des_pos);    
    Single_Binding_Line_Create(src_port, des_port);
  }
  return new_pat;
}

Am_Object Pattern_Parent_Linked_Copy(Am_Object pattern)
{
  Am_Object new_pat = pattern.Create(); //*
  new_pat.Set(PARENT_LINK, pattern);
  Am_Value_List ports = Rule_Ports(pattern);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = (Am_Object)ports.Get();
    Am_Object new_pt;
    Am_Function_Call(Copy_Method, pt, PARENT_COPY, new_pt, (pt)); //*
    pt.Set(TEMP_LINK, new_pt);
    Pattern_Add_Port_Single(new_pat, new_pt);
    values_copy_iter(pt, new_pt, new_pat, PARENT_COPY);
  }
  Am_Value_List holes = Rule_Holes(pattern);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object hl = (Am_Object)holes.Get();
    Am_Object new_hl;
    Am_Function_Call(Copy_Method, hl, PARENT_COPY, new_hl, (hl)); //*
    new_hl.Set(Am_LEFT, (int)hl.Get(Am_LEFT));
    new_hl.Set(Am_TOP,  (int)hl.Get(Am_TOP));
    pattern_add_hole_single(new_pat, new_hl);
    ports_copy_with_values(hl, new_hl, new_pat, PARENT_COPY);
  }
  Am_Value_List goals = Rule_Goals(pattern);
  for (goals.Start(); !goals.Last(); goals.Next()) {
    Am_Object gl = (Am_Object)goals.Get();
    Am_Object hole = (Am_Object)gl.Get(HOLE_LINK);
    Am_Value_List pos = Position_Get(hole, pattern);
    Am_Object new_gl;
    Am_Function_Call(Copy_Method, gl, PARENT_COPY, new_gl, (gl)); //*
    new_gl.Set(Am_LEFT, (int)gl.Get(Am_LEFT));
    new_gl.Set(Am_TOP,  (int)gl.Get(Am_TOP));
    single_hole_replace(Position_To_Obj(new_pat, pos), new_gl);
    ports_copy_with_values(gl, new_gl, new_pat, PARENT_COPY);
  }
  Am_Value_List binders = Rule_Binder(pattern);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bd = (Am_Object)binders.Get();
    Am_Value_List src_pos = Position_Get((Am_Object)bd.Get(BL_SRC), pattern);
    Am_Value_List des_pos = Position_Get((Am_Object)bd.Get(BL_DEST), pattern);
    Am_Object src_port = Position_To_Obj(new_pat, src_pos);
    Am_Object des_port = Position_To_Obj(new_pat, des_pos);    
    Single_Binding_Line_Create(src_port, des_port);
  }
  return new_pat;
}

/*
Am_Object Pattern_Place_Linked_Copy(Am_Object pattern)
{
  Am_Object new_pat = pattern.Create(); //*
  Am_Value_List ports = Rule_Ports(pattern);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = ports.Get();
    Am_Object new_pt;
    Am_Function_Call(Copy_Method, pt, PLACE_COPY, new_pt, (pt)); //*
    pt.Set(TEMP_LINK, new_pt);
    Pattern_Add_Port(new_pat, new_pt);
  }
  Am_Value_List goals = Rule_Goals(pattern);
  for (goals.Start(); !goals.Last(); goals.Next()) {
    Am_Object gl = goals.Get();
    Am_Object parent = (Am_Object)gl.Get(PARENT_LINK);
    Am_Object new_gl;
    Am_Function_Call(Copy_Method, gl, PLACE_COPY, new_gl, (gl)); //*
    Pattern_Add_Goal(new_pat, new_gl);
  }
  Am_Value_List binders = Rule_Binder(pattern);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bd = binders.Get();
    Am_Object src_port = ((Am_Object)bd.Get(BL_SRC)).Get(TEMP_LINK);
    Am_Object dest_port = ((Am_Object)bd.Get(BL_DEST)).Get(TEMP_LINK);
    Binding_Line_Create(src_port, dest_port);
  }
  return new_pat;
}

Am_Object Seq_Pattern_Copy(Am_Object pattern)
{
  Am_Object new_pat = Sequence_Pattern_Proto.Create();
  new_pat.Set(PROC_NAME, (char*)(Am_String)pattern.Get(PROC_NAME));
  Am_Value_List ports = Rule_Ports(pattern);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = ports.Get();
    Am_Object new_pt;
    Am_Function_Call(Copy_Method, pt, UNLINK_COPY, new_pt, (pt));
    pt.Set(TEMP_LINK, new_pt);
    Pattern_Add_Port(new_pat, new_pt);
  }
  Am_Object new_goals = Rule_Goals_Part(new_pat);

  Am_Object goals_part = Rule_Goals_Part(pattern);
  Am_Object first = goals_part.Get_Part(FIRST_ITEM);
  Am_Object second = goals_part.Get_Part(SECOND_ITEM);
  Am_Object ellip = goals_part.Get_Part(ELLIPSIS);
  Am_Object last = goals_part.Get_Part(LAST_ITEM);
  Am_Object new_gl;
  Am_Function_Call(Copy_Method, first, UNLINK_COPY, new_gl, (first));
  make_temp_link(first, new_gl);
  first.Set(TEMP_LINK, new_gl);
  new_goals.Remove_Part(FIRST_ITEM);
  new_goals.Add_Part(FIRST_ITEM, new_gl);
  Am_Function_Call(Copy_Method, first, PARENT_COPY, new_gl, (first));  
  make_temp_link(second, new_gl);
  new_goals.Remove_Part(SECOND_ITEM);
  new_goals.Add_Part(SECOND_ITEM, new_gl);
  new_goals.Remove_Part(ELLIPSIS);
  new_goals.Add_Part(ELLIPSIS, ellip.Create());
  Am_Function_Call(Copy_Method, first, PARENT_COPY, new_gl, (first));  
  make_temp_link(last, new_gl);
  new_goals.Remove_Part(LAST_ITEM);
  new_goals.Add_Part(LAST_ITEM, new_gl);

  Am_Value_List binders = Rule_Binder(pattern);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bd = binders.Get();
    Am_Object src_port = ((Am_Object)bd.Get(BL_SRC)).Get(TEMP_LINK);
    Am_Object dest_port = ((Am_Object)bd.Get(BL_DEST)).Get(TEMP_LINK);
    Binding_Line_Create(src_port, dest_port);
  }
  return new_pat;
}

Am_Object Seq_Pattern_Parent_Linked_Copy(Am_Object pattern)
{
  Am_Object new_pat = pattern.Create(); //*
  Am_Value_List ports = Rule_Ports(pattern);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = ports.Get();
    Am_Object new_pt;
    Am_Function_Call(Copy_Method, pt, PARENT_COPY, new_pt, (pt)); //*
    pt.Set(TEMP_LINK, new_pt);
    Pattern_Add_Port(new_pat, new_pt);
  }
  Am_Object new_goals = Rule_Goals_Part(new_pat);
  Am_Object goals_part = Rule_Goals_Part(pattern);
  Am_Object first = goals_part.Get(FIRST_ITEM);
  Am_Object second = goals_part.Get(SECOND_ITEM);
  Am_Object ellip = goals_part.Get(ELLIPSIS);
  Am_Object last = goals_part.Get(LAST_ITEM);
  Am_Object new_gl;
  Am_Function_Call(Copy_Method, first, PARENT_COPY, new_gl, (first));
  new_goals.Add_Part(FIRST_ITEM, new_gl);
  Am_Function_Call(Copy_Method, second, PARENT_COPY, new_gl, (second));  
  new_goals.Add_Part(SECOND_ITEM, new_gl);
  new_goals.Add_Part(ELLIPSIS, ellip.Create());
  Am_Function_Call(Copy_Method, last, PARENT_COPY, new_gl, (last));  
  new_goals.Add_Part(LAST_ITEM, new_gl);

  Am_Value_List binders = Rule_Binder(pattern);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bd = binders.Get();
    Am_Object src_port = ((Am_Object)bd.Get(BL_SRC)).Get(TEMP_LINK);
    Am_Object dest_port = ((Am_Object)bd.Get(BL_DEST)).Get(TEMP_LINK);
    Binding_Line_Create(src_port, dest_port);
  }
  return new_pat;
}

Am_Object Seq_Pattern_Place_Linked_Copy(Am_Object pattern)
{
  Am_Object new_pat = pattern.Create(); //*
  Am_Value_List ports = Rule_Ports(pattern);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = ports.Get();
    Am_Object new_pt;
    Am_Function_Call(Copy_Method, pt, PLACE_COPY, new_pt, (pt)); //*
    pt.Set(TEMP_LINK, new_pt);
    Pattern_Add_Port(new_pat, new_pt);
  }
  Am_Object new_goals = Rule_Goals_Part(new_pat);
  Am_Object goals_part = Rule_Goals_Part(pattern);
  Am_Object first = goals_part.Get(FIRST_ITEM);
  Am_Object second = goals_part.Get(SECOND_ITEM);
  Am_Object ellip = goals_part.Get(ELLIPSIS);
  Am_Object last = goals_part.Get(LAST_ITEM);
  Am_Object new_gl;
  Am_Function_Call(Copy_Method, first, PLACE_COPY, new_gl, (first));
  new_goals.Add_Part(FIRST_ITEM, new_gl);
  Am_Function_Call(Copy_Method, second, PLACE_COPY, new_gl, (second));  
  new_goals.Add_Part(SECOND_ITEM, new_gl);
  new_goals.Add_Part(ELLIPSIS, ellip.Create());
  Am_Function_Call(Copy_Method, last, PLACE_COPY, new_gl, (last));  
  new_goals.Add_Part(LAST_ITEM, new_gl);

  Am_Value_List binders = Rule_Binder(pattern);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bd = binders.Get();
    Am_Object src_port = ((Am_Object)bd.Get(BL_SRC)).Get(TEMP_LINK);
    Am_Object dest_port = ((Am_Object)bd.Get(BL_DEST)).Get(TEMP_LINK);
    Binding_Line_Create(src_port, dest_port);
  }
  return new_pat;
}
*/

void Seq_Pattern_Rotate(Am_Object pattern)
{
  int dir = pattern.Get(SEQ_DIR);
  int new_dir = (dir + 1) % 4;
  pattern.Set(SEQ_DIR, new_dir);
}

// ---- formulas ----

Am_Define_Formula(int, seq_pattern_x_offset_form) {
  Am_Value_List glist = (Am_Value_List)self.GV(Am_GRAPHICAL_PARTS);
  glist.Start();
  if (!glist.Empty()) {
    return (int)((Am_Object)glist.Get()).GV(Am_LEFT);
  }
}

Am_Define_Formula(int, seq_pattern_y_offset_form) {
  Am_Value_List glist = (Am_Value_List)self.GV(Am_GRAPHICAL_PARTS);
  glist.Start();
  if (!glist.Empty()) {
    return (int)((Am_Object)glist.Get()).GV(Am_TOP);
  }
}

Am_Define_Formula(Am_Ptr, sequence_pattern_layout_form)
{
  Am_Value_List goals = (Am_Value_List)self.GV(Am_GRAPHICAL_PARTS);
  int dir = self.GV_Owner().GV_Owner().GV(SEQ_DIR);
  int first_gap = self.GV(FIRST_GAP);
  int last_gap = self.GV(LAST_GAP);
  int x_offset = self.GV(Am_X_OFFSET);
  int y_offset = self.GV(Am_Y_OFFSET);

  Am_Slot_Key same_key;
  Am_Slot_Key diff_key;
  Am_Slot_Key gap_key;
  if (dir == Left_Right || dir == Right_Left) {
    same_key = Am_TOP; diff_key = Am_LEFT; gap_key = Am_WIDTH;
  } else {
    same_key = Am_LEFT; diff_key = Am_TOP; gap_key = Am_HEIGHT;
  }
  int cur_gap;
  int scan_dir;
  if (dir == Left_Right || dir == Top_Bottom) {
    scan_dir = Left_Right; cur_gap = first_gap;
  } else {
    scan_dir = Right_Left; cur_gap = last_gap;
  }
  int same_coord = -10;
  int cur_coord = -10;
  if (x_offset < 0) {
    same_coord = 0;
    cur_coord = 0;
  }
  if (scan_dir == Left_Right) goals.Start(); else goals.End();
  for (; (scan_dir == Left_Right) ? !goals.Last() : !goals.First() ;) {
    Am_Object goal = (Am_Object)goals.Get();
    int diff = goal.GV(diff_key);
    int gap  = goal.GV(gap_key);
    if (same_coord < 0) same_coord = goal.GV(same_key);
    else goal.Set(same_key, same_coord);
//    if ((int)goal.GV(diff_key) < cur_coord) {
    if (cur_coord < 0) {
      cur_coord = diff + gap + cur_gap;
    } else {
      goal.Set(diff_key, cur_coord);
      cur_coord = cur_coord + gap + cur_gap;
    }
    if (scan_dir == Left_Right) {goals.Next(); cur_gap = last_gap;}
    else                        {goals.Prev(); cur_gap = first_gap;}
  }
}

Am_Define_Formula(int, ellipsis_line_x1) {
  Am_Object holes_part = self.GV_Sibling(HOLES_PART);
  Am_Object goals_part = self.GV_Sibling(GOALS_PART);
  if (!holes_part.Valid() || !goals_part.Valid()) return 0;
  Am_Value_List holes = (Am_Value_List)holes_part.GV(Am_GRAPHICAL_PARTS);
  Am_Value_List goals = (Am_Value_List)goals_part.GV(Am_GRAPHICAL_PARTS);
  Am_Value_List targets;
  if (holes.Empty()) return 0;
  if (goals.Empty()) targets = holes; else targets = goals;
  Am_Object second = Object_List_Get(targets, 2);
  Am_Object third =  Object_List_Get(targets, 3);
  if (!second.Valid() || !third.Valid()) return 0;
  int second_left   = second.GV(Am_LEFT);
  int second_top    = second.GV(Am_TOP);
  int second_width  = second.GV(Am_WIDTH);
  int second_height = second.GV(Am_HEIGHT);
  int third_left    = third.GV(Am_LEFT);
  int third_top     = third.GV(Am_TOP);
  int third_width   = third.GV(Am_WIDTH);
  int third_height  = third.GV(Am_HEIGHT);
  self.Set(Am_X2, third_left + third_width / 2);
  self.Set(Am_Y2, third_top + third_height / 2);
  self.Set(Am_Y1, second_top + second_height / 2);
  return second_left + second_width / 2;
}

Am_Define_Formula(bool, ellipsis_line_visible) {
  Am_Object pattern = self.GV_Owner().GV_Owner();
  if (pattern.Valid()) {
    if ((bool)pattern.GV(IS_ICON) == true) return false;
    else return true;
  }
  return true;
}

/*
Am_Define_Formula(int, ellipsis_line_x2) {
  Am_Object holes_part = self.GV_Sibling(HOLES_PART);
  Am_Object goals_part = self.GV_Sibling(GOALS_PART);
  if (!holes_part.Valid() || !goals_part.Valid()) return 0;
  Am_Value_List holes = holes_part.GV(Am_GRAPHICAL_PARTS);
  Am_Value_List goals = goals_part.GV(Am_GRAPHICAL_PARTS);
  Am_Value_List targets;
  if (holes.Empty()) return 0;
  if (goals.Empty()) targets = holes; else targets = goals;
  Am_Object second = Object_List_Get(targets, 2);
  Am_Object third =  Object_List_Get(targets, 3);
  if (!second.Valid() || !third.Valid()) return 0;
  int second_left   = second.GV(Am_LEFT);
  int second_top    = second.GV(Am_TOP);
  int second_width  = second.GV(Am_WIDTH);
  int second_height = second.GV(Am_HEIGHT);
  int third_left    = third.GV(Am_LEFT);
  int third_top     = third.GV(Am_TOP);
  int third_width   = third.GV(Am_WIDTH);
  int third_height  = third.GV(Am_HEIGHT);
  self.Set(Am_Y2, third_top + third_height / 2);
  return third_left + third_width / 2;
}
*/

Am_Define_Style_Formula(pattern_style_form) {
  if (!self.GV_Owner().Valid()) return Am_Motif_Light_Green;
  Am_Object holes_part = self.GV_Owner().GV_Part(CONTENTS_PART).GV_Part(HOLES_PART);
  Am_Value_List holes = (Am_Value_List)holes_part.GV(Am_GRAPHICAL_PARTS);
  if (holes.Empty()) {
    self.Set(Am_SELECTED, true);
    return Am_Motif_Light_Green;
  }    
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object hole = (Am_Object)holes.Get();
    Am_Object proc = (Am_Object)hole.GV(HOLE_LINK);
    if (! proc.Valid()) {
      self.Set(Am_SELECTED, true);
      return Am_Motif_Light_Green;
    } else {
      if (KL_Type(proc) == KL_Pattern) {
        if ((bool)proc.GV_Part(FRAME_PART).GV(Am_SELECTED) == true) {
          self.Set(Am_SELECTED, true);
          return Am_Motif_Light_Green;
        }
      }
    }
  }
  self.Set(Am_SELECTED, false);
  return Am_Motif_Light_Gray;
}

void init_pattern_frame(void)
{
  // $B4pK\$O%M%C%H%o!<%/%k!<%k!%(B
  Pattern_Proto = Vanishing_Rule_Proto.Create("Pattern_Proto")
    .Set(KL_TYPE,     KL_Pattern)
    .Set(PATTERN_TYPE,KL_Free_Pattern)
    .Set(PARENT_PROC, 0)
    .Set(PROC_NAME,   "pattern")
    .Set(RULE_TYPE,   KL_Network_Rule)
    .Set(SEQ_DIR,     Left_Right)
    .Set(HOLE_LINK,   0)
    .Set(PARENT_LINK, Am_Formula::Create(loopback_form))
//    .Set(PLACE_LINK,  Am_Formula::Create(loopback_form))
    .Set(UNLINK_COPY, (Am_Object_Proc*)Pattern_Copy)
    .Set(PARENT_COPY, (Am_Object_Proc*)Pattern_Parent_Linked_Copy)
    .Set(ADD_PORT,    (Am_Object_Proc*)Pattern_Add_Port_Single) 
//    .Set(PLACE_COPY,  (Am_Object_Proc*)Pattern_Place_Linked_Copy)
//     .Get_Part(FRAME_PART)
//       .Set(Am_FILL_STYLE, Am_Formula::Create(pattern_style_form))
//     .Get_Owner()
    .Get_Part(CONTENTS_PART)
      .Get_Part(HOLES_PART).Set(Am_TOP, 0).Get_Owner()
      .Get_Part(GOALS_PART).Set(Am_TOP, 0).Get_Owner()
      .Get_Part(PORTS_PART).Set(Am_TOP, 0).Get_Owner()
      .Get_Part(GUARD_PART).Set(Am_TOP, 0).Get_Owner()
      .Get_Part(BINDER_PART).Set(Am_TOP, 0).Get_Owner()
    .Get_Owner()
    .Add_Part(Am_INTERACTOR, Am_Text_Edit_Interactor.Create("text_inter")
	      .Set(Am_PRIORITY, 10)
	      .Set(Am_START_WHEN, "DOUBLE_LEFT_DOWN")
	      .Set(Am_START_WHERE_TEST, (Am_Object_Proc*)&Am_Inter_In_Text_Leaf)
//	      .Get_Part(Am_COMMAND)
//	      .Set(Am_DO_ACTION, &do_edit_name_in_proc)
//	      .Get_Owner()
	      )
    ;
  Pattern_Proto.Get_Part(FRAME_PART)
    .Set(Am_HEIGHT, 0).Set(Am_WIDTH, 0).Set(Am_VISIBLE, 0);
  Pattern_Proto.Remove_Part(FRAME_PART);
  Pattern_Proto.Add_Part(FRAME_PART, Am_Border_Roundtangle.Create("pattern_frame")
			 .Set(Am_RADIUS, 3)
			 .Set(Am_HEIGHT, KL_Frame_Height(8))
			 .Set(Am_WIDTH, KL_Frame_Width(8))
			 .Set(Am_FILL_STYLE, Am_Formula::Create(pattern_style_form)));
  Am_Object contents = Pattern_Proto.Get_Part(CONTENTS_PART);
  Pattern_Proto.Remove_Part(CONTENTS_PART);
  Pattern_Proto.Add_Part(CONTENTS_PART, contents);


  Am_Object firsth, secondh, lasth, ellip;
  Am_Function_Call(Copy_Method, Hole_Proto, UNLINK_COPY, firsth,  (Hole_Proto));
  Am_Function_Call(Copy_Method, firsth,     PARENT_COPY, secondh, (firsth));
  Am_Function_Call(Copy_Method, secondh,    PARENT_COPY, lasth,   (firsth));

  static char ellip_dash_list[2] = {1, 16};
  Am_Style ellip_line_dash ("black", 4, Am_CAP_ROUND, Am_JOIN_MITER,
			    Am_LINE_ON_OFF_DASH, ellip_dash_list);

  Am_Object ellipsis_line = Am_Line.Create()
    .Set(Am_VISIBLE, Am_Formula::Create(ellipsis_line_visible))
    .Set(Am_X1, Am_Formula::Create(ellipsis_line_x1))
    .Set(Am_LINE_STYLE, ellip_line_dash)
    ;

  Sequence_Pattern_Proto = Pattern_Copy(Pattern_Proto)
    .Set(PROC_NAME, "sequence")
    .Set(PATTERN_TYPE,KL_Seq_Pattern)
    .Set(SEQ_DIR, Left_Right)
    .Get_Part(CONTENTS_PART)
      .Get_Part(HOLES_PART)
         .Add_Part(firsth)
         .Add_Part(secondh)
         .Add_Part(lasth)
         .Set(FIRST_GAP, 10)
         .Set(LAST_GAP, 50)
         .Set(Am_LAYOUT, Am_Formula::Create(sequence_pattern_layout_form))
      .Get_Owner()
      .Get_Part(GOALS_PART)
         .Set(FIRST_GAP, 10)
         .Set(LAST_GAP, 50)
         .Set(Am_LAYOUT, Am_Formula::Create(sequence_pattern_layout_form))
      .Get_Owner()
      .Add_Part(ELLIPSIS, ellipsis_line)
    .Get_Owner()
    ;
  Am_To_Bottom(ellipsis_line);
}

/* ---------------- Special Ports for the Sequence Pattern ---------------- */

// ---- global objects ----
Am_Object Pat_Single_Port;
Am_Object Pat_Stream_Port;
Am_Object Pat_In_Single_Port;
Am_Object Pat_Out_Single_Port;
Am_Object Pat_In_Stream_Port;
Am_Object Pat_Out_Stream_Port;
Am_Object Map_In_Port;
Am_Object Map_Out_Port;
Am_Object Recursive_Port;
Am_Object Broadcast_Single_Port;
Am_Object Broadcast_Stream_Port;
Am_Object Merge_Port;

// ---- slot keys ----

// ---- operations ----
void Seq_Port_Add(Am_Object port, Am_Object data)
{
  if ((int)port.Get(PORT_SPECIAL) != KL_Map) return;
  if (KL_Type(data) != KL_Port) return;
  Am_Object rule = Port_Parent_Rule(port);
  char* names[3] = {"X1", "X2", "Xn"};
  Am_Slot_Key keys[3] = {FIRST_ITEM, SECOND_ITEM, LAST_ITEM};
  for (int i = 0; i < 3; ++i) {
    Am_Object pt = data.Create();
    Port_Rename(pt, names[i]);
    Rule_Add_Inner_Port(rule, port, pt);
  }
}

void Seq_Port_Remove(Am_Object port)
{

 
}

// ---- formulas ----

Am_Define_Formula(int, port_ellipsis_line_x1) {
  Am_Object value_part = self.GV_Owner().GV_Part(CONTENTS_PART).GV_Part(VALUE_PART);
  if (!value_part.Valid()) return 0;
  Am_Value_List values = (Am_Value_List)value_part.GV(Am_GRAPHICAL_PARTS);
  int x1, y1, x2, y2;
  if (values.Length() < 3) {
    value_part.Set(Am_WIDTH, 18).Set(Am_HEIGHT, 10);
    x1 = (int)value_part.GV(Am_LEFT);
    y1 = (int)value_part.GV(Am_HEIGHT) / 2;
    x2 = (int)value_part.GV(Am_LEFT) + (int)value_part.GV(Am_WIDTH);
    y2 = (int)value_part.GV(Am_HEIGHT) / 2;
  } else {
    Am_Object second = Object_List_Get(values, 2);
    Am_Object third =  Object_List_Get(values, 3);
    if (!second.Valid() || !third.Valid()) return 0;
    int second_left   = second.GV(Am_LEFT);
    int second_top    = second.GV(Am_TOP);
    int second_width  = second.GV(Am_WIDTH);
    int second_height = second.GV(Am_HEIGHT);
    int third_left    = third.GV(Am_LEFT);
    int third_top     = third.GV(Am_TOP);
    int third_width   = third.GV(Am_WIDTH);
    int third_height  = third.GV(Am_HEIGHT);
    x1 = second_left + second_width / 2;
    y1 = second_top + second_height / 2;
    x2 = third_left + third_width / 2;
    y2 = third_top + third_height / 2;
  }
  Am_Translate_Coordinates(value_part, x1, y1, self.GV_Owner(), x1, y1);
  Am_Translate_Coordinates(value_part, x2, y2, self.GV_Owner(), x2, y2);
  self.Set(Am_Y1, y1);
  self.Set(Am_X2, x2);
  self.Set(Am_Y2, y2);
  return x1;
}

Am_Define_Formula(int, port_seq_dir_form) {
  int dir = self.GV(PORT_DIR);
  if (dir == KL_Left) return Left_Right;
  else return Right_Left;
}

Am_Define_Formula(int, seq_head_dir_daemon) {
  Am_Object slot = self.GV_Owner();
  if (!slot.Valid()) return 0;
  int head_dir = slot.GV(PORT_DIR);
  if (head_dir == KL_Left) {
    self.Set(Am_LAYOUT, Am_Horizontal_Layout);
  } else {
    self.Set(Am_LAYOUT, Am_Horizontal_Rev_Layout);
  }
  return 0;
}

void init_special_ports(void)
{
  Pat_Single_Port = In_Single_Proto.Create().Set(PORT_SPECIAL, KL_Pat_Single);
  Pat_Stream_Port = In_Stream_Proto.Create().Set(PORT_SPECIAL, KL_Pat_Stream);  
  Pat_In_Single_Port  = Pat_Single_Port.Create().Set(PORT_MODE, KL_Input);
  Pat_Out_Single_Port = Pat_Single_Port.Create().Set(PORT_MODE, KL_Output);
  Pat_In_Stream_Port  = Pat_Stream_Port.Create().Set(PORT_MODE, KL_Input);
  Pat_Out_Stream_Port = Pat_Stream_Port.Create().Set(PORT_MODE, KL_Output);

  static char ellip_dash_list[2] = {1, 5};
  Am_Style ellip_line_dash ("black", 2, Am_CAP_ROUND, Am_JOIN_MITER,
			    Am_LINE_ON_OFF_DASH, ellip_dash_list);

  Map_In_Port = In_Stream_Proto.Create("Map_In_Port")
    .Set(PORT_NAME,    "Map")
    .Set(PORT_OPEN,    KL_Close)
    .Set(PORT_DIR,     KL_Left)
    .Set(PORT_SPECIAL, KL_Map)
    .Set(SEQ_DIR,      Am_Formula::Create(port_seq_dir_form))
    .Get_Part(CONTENTS_PART)
      .Set(PORT_DIR_DAEMON, Am_Formula::Create(seq_head_dir_daemon))
      .Get_Part(VALUE_PART)
        .Set(FIRST_GAP, 1)
        .Set(LAST_GAP,  18)
        .Set(Am_X_OFFSET, -1)
        .Set(Am_LAYOUT, Am_Formula::Create(sequence_pattern_layout_form))
      .Get_Owner()
    .Get_Owner()
    ;
  Am_To_Bottom(Map_In_Port.Get_Part(CONTENTS_PART).Get_Part(VALUE_PART));

  Am_Object ellipsis_line = Am_Line.Create()
    .Set(Am_X1, Am_Formula::Create(port_ellipsis_line_x1))
    .Set(Am_LINE_STYLE, ellip_line_dash)
    ;
  Am_Object value_part = Map_In_Port.Get_Part(CONTENTS_PART).Get_Part(VALUE_PART);
  My_Set_Single_Constraint_Mode(value_part, Am_WIDTH, false);
  My_Set_Single_Constraint_Mode(value_part, Am_HEIGHT, false);
  Map_In_Port.Add_Part(ELLIPSIS, ellipsis_line);
  Am_To_Top(Map_In_Port.Get_Part(CONTENTS_PART));

  Map_Out_Port = Map_In_Port.Create("Map_Out_Port")
    .Set(PORT_NAME,    "Map")
    .Set(PORT_MODE,    KL_Output)
    ;

  Am_Object broadcast_image = Am_Bitmap.Create("broadcast_image")
    .Set(Am_WIDTH, 17)
    .Set(Am_HEIGHT, 14)
    .Set(Am_LINE_STYLE, Am_Black)
    .Set(Am_FILL_STYLE, Am_No_Style)
    .Set(Am_IMAGE, Am_Image_Array::Make(Am_Image_Array(BROADCAST_IMAGE_FILE)));

  Broadcast_Single_Port = In_Single_Proto.Create("Broadcast_Single_Port")
    .Set(PORT_NAME, "Bcast")
    .Set(PORT_SPECIAL, KL_Broadcast)
    .Set(PORT_DIR, KL_Right)
    .Get_Part(CONTENTS_PART)
      .Set(Am_LAYOUT, Am_Horizontal_Rev_Layout)
      .Add_Part(MARKER_PART, broadcast_image.Create())
    .Get_Owner()
    ;

  Broadcast_Stream_Port = In_Stream_Proto.Create("Broadcast_Stream_Port")
    .Set(PORT_NAME, "Bcast")
    .Set(PORT_SPECIAL, KL_Broadcast)
    ;
  Broadcast_Stream_Port.Get_Part(CONTENTS_PART).Remove_Part(MARKER_PART);
  Broadcast_Stream_Port
    .Get_Part(CONTENTS_PART)
    .Add_Part(MARKER_PART, broadcast_image.Create())
    .Get_Owner()
    ;

  // ---------------- Merge Port ----------------
  Am_Object merge_image = Am_Bitmap.Create("merge_image")
    .Set(Am_WIDTH, 17)
    .Set(Am_HEIGHT, 14)
    .Set(Am_LINE_STYLE, Am_Black)
    .Set(Am_FILL_STYLE, Am_No_Style)
    .Set(Am_IMAGE, Am_Image_Array::Make(Am_Image_Array(MERGE_IMAGE_FILE)));

  Merge_Port = Out_Stream_Proto.Create("Merge_Port")
    .Set(PORT_NAME, "Merge")
    .Set(PORT_SPECIAL, KL_Merge)
    ;
  Merge_Port.Get_Part(CONTENTS_PART).Remove_Part(MARKER_PART);
  Merge_Port
    .Get_Part(CONTENTS_PART)
    .Add_Part(MARKER_PART, merge_image.Create())
    .Get_Owner()
    ;
}  



void Initialize_Pattern(void)
{
  init_hole();
  init_pattern_frame();
  init_special_ports();
  
/*
  Am_Object first_port = Out_Single_Proto.Create();
  Port_Rename(first_port, "X1");
  Am_Object second_port = Out_Single_Proto.Create();
  Port_Rename(second_port, "X2");
  Am_Object last_port = Out_Single_Proto.Create();
  Port_Rename(last_port, "Xn");

  Am_Object first_str = Out_Stream_Proto.Create();
  Port_Rename(first_str, "S1");
  Am_Object second_str = Out_Stream_Proto.Create();
  Port_Rename(second_str, "S2");
  Am_Object last_str = Out_Stream_Proto.Create();
  Port_Rename(last_str, "Sn");

  // ---------------- First_Item_Port ----------------
  
  First_Item_Single_Port = In_Stream_Proto.Create("First_Item_Port")
    .Set(PORT_AGE, KL_Old_Port)
    .Set(PORT_DIR, KL_Left);
  Port_Rename(First_Item_Single_Port, "In");
  
  Port_Values_Part(First_Item_Single_Port)
    .Add_Part(FIRST_ITEM, Port_Create(first_port))
    ;

  First_Item_Stream_Port = In_Stream_Proto.Create("First_Item_Port")
    .Set(PORT_AGE, KL_Old_Port)
    .Set(PORT_DIR, KL_Left);
  Port_Rename(First_Item_Stream_Port, "In");
  
  Port_Values_Part(First_Item_Stream_Port)
    .Add_Part(FIRST_ITEM, first_str.Create())
    ;p

    */
}
