// Written by Rick Halterman (haltermn@cs.southern.edu)
// Original Source: ftp://southern.edu/people/halterman/Amulet/my_widget.cc
// Modified by Toyoda Masashi (toyoda@is.titech.ac.jp)

//#include <amulet/amulet.h>
#include "file_box.h"
#include <amulet/debugger.h>
#include <amulet/object_advanced.h>
#include <amulet/inter_advanced.h>

#include <iostream.h>
#include <sys/types.h>
#include <sys/stat.h> 
#include <dirent.h>  //  for opendir(). etc.
#include <string.h>  //  for strcpy()
#include <unistd.h>     //  for getcwd()


//  Global slot identifiers

#define DECLARE_SLOT(x) Am_Slot_Key x = Am_Register_Slot_Name(#x)

DECLARE_SLOT(FS_CURRENT_DIR);
DECLARE_SLOT(FS_CURRENT_FILE);
DECLARE_SLOT(FS_FILE_LIST);
DECLARE_SLOT(FS_BUTTONS);
DECLARE_SLOT(FS_FRAME);
DECLARE_SLOT(FS_DONE);
DECLARE_SLOT(FS_ACCEPTED);

DECLARE_SLOT(FL_CURRENT_SELECTED);

DECLARE_SLOT(FL_CURSOR);

DECLARE_SLOT(MB_FRAME);
DECLARE_SLOT(MB_MESSAGE);
DECLARE_SLOT(MB_DONE);
DECLARE_SLOT(MB_BUTTON);


//  Text height value local to this file
static int TextHeight = 0;

static const char *FS_NO_FILE_SELECTED = "(No file selected)";

static const int FILE_NAME_WIDTH = 150,
                 GRAPHICAL_WIDTH = 480;

static const char *ACCEPT_STRING  = " Accept ",
                  *ABORT_STRING   = " Abort  ",
                  *DISMISS_STRING = " Dismiss ";


Am_Define_Formula(int, cursor_left) {
  Am_Object obj = (Am_Object)self.GV_Owner().GV(FL_CURRENT_SELECTED);
  if ( obj.Valid() )
    return obj.Get(Am_LEFT);
  return 0;
}

Am_Define_Formula(int, cursor_top) {
  Am_Object obj = (Am_Object)self.GV_Owner().GV(FL_CURRENT_SELECTED);
  if ( obj.Valid() )
    return obj.Get(Am_TOP);
  return 0;
}

Am_Define_Formula(int, cursor_width) {
  Am_Object obj = (Am_Object)self.GV_Owner().GV(FL_CURRENT_SELECTED);
  if ( obj.Valid() )
    return obj.Get(Am_WIDTH);
  return 0;
}

Am_Define_Formula(int, cursor_height) {
  Am_Object obj = (Am_Object)self.GV_Owner().GV(FL_CURRENT_SELECTED);
  if ( obj.Valid() )
    return obj.Get(Am_HEIGHT);
  return 0;
}


Am_Define_Formula(bool, cursor_visible) {
  Am_Object obj = (Am_Object)self.GV_Owner().GV(FL_CURRENT_SELECTED);
  if ( obj.Valid() )
    return true;
  return false;
}

Am_Define_String_Formula(current_file) {
  Am_Object filetext = (Am_Object)self.GV_Owner()
              .GV_Part(FS_FILE_LIST)
              .GV(FL_CURRENT_SELECTED);
  Am_String result;
  if ( filetext.Valid() ) {
    result = filetext.GV(Am_TEXT);
  }  else
    result = FS_NO_FILE_SELECTED;
  return result;
}


/***
Am_Define_Formula(int, scrollable_height) {
  int height = 0;
  Am_Value_List old_parts = self.GV(Am_GRAPHICAL_PARTS);
  for ( old_parts.Start();  !old_parts.Last();  old_parts.Next() ) {
    Am_Object curr_obj = old_parts.Get(), proto = curr_obj.Get_Prototype();
    if ( proto == Am_Text )
      height += (TextHeight + 3);
  }
  return height;
}
***/

static void FS_PadString(Am_Object str) {
  while ((int) str.Get(Am_WIDTH) < GRAPHICAL_WIDTH - 2) {
    char temp[FILE_NAME_WIDTH];
    Am_String temp_str = (Am_String)str.Get(Am_TEXT);
    strcpy(temp, (const char *) temp_str);
    strcat(temp, " ");
    str.Set(Am_TEXT, temp);
  }
}

static void FS_UnpadString(Am_Object str) {
  char temp[FILE_NAME_WIDTH];
  Am_String temp_str = (Am_String)str.Get(Am_TEXT);
  strcpy(temp, (const char *) temp_str);
  for ( int end = strlen(temp) - 1;  end >= 0  &&  temp[end] == ' ';  end-- )
    temp[end] = '\0';
  str.Set(Am_TEXT, temp);
}

static void FS_ls(char *name, Am_Object filesel) {
  DIR *dirp = opendir(name);

  //  Remove existing list, if necessary
  Am_Value_List old_parts = (Am_Value_List)filesel.Get(Am_GRAPHICAL_PARTS);
  for ( old_parts.Start();  !old_parts.Last();  old_parts.Next() ) {
    Am_Object curr_obj = (Am_Object)old_parts.Get(), proto = curr_obj.Get_Prototype();
    if ( proto == Am_Text )
      filesel.Remove_Part(curr_obj);
  }

  //  No file currently selected since dir has changed

  filesel.Set(FL_CURRENT_SELECTED, 0);

  if ( dirp != NULL ) {

    //  Determine text height plus adequate spacing
    int text_height = TextHeight + 3;
    struct dirent *dp;
    struct stat statbuff;
    int count = 0;
    for ( dp = readdir(dirp);  dp != NULL;  dp = readdir(dirp) ) {
      stat(dp->d_name, &statbuff);
      /***
      if ( (statbuff.st_mode & S_IFMT) == S_IFDIR )
        cout << "Directory: " << dp->d_name << endl;
      else
        cout << "File:      " << dp->d_name << endl;
      ***/
      Am_Object textline = Am_Text.Create()
        .Set(Am_LEFT, 2)
        .Set(Am_TOP, text_height*count)
        .Set(Am_TEXT, dp->d_name);
      FS_PadString(textline);
      filesel.Add_Part(textline);
      count++;
    }
    filesel.Set(Am_Y_OFFSET, 0);
    closedir(dirp);
  }
  else
    Am_Beep();   //  Beep if dir is not valid
//  Am_Do_Events();
}


void FL_FileSelectDoAction(Am_Object cmd_obj) {
  Am_Object obj = (Am_Object)cmd_obj.Get_Owner().Get(Am_START_OBJECT);
//  cout << obj << endl;
  Am_Object selected = cmd_obj.Get_Owner().Get_Owner(),
            fbox = selected.Get_Owner();

  char dir_name[FILE_NAME_WIDTH], path_name[FILE_NAME_WIDTH];
  FS_UnpadString(obj);
  Am_String amstr = (Am_String)obj.Get(Am_TEXT);
  strcpy(dir_name, amstr);
  FS_PadString(obj);
  struct stat statbuff;
  if ( stat(dir_name, &statbuff) < 0 )
    cout << "Stat not working properly" << endl;
  if ( (statbuff.st_mode & S_IFMT) == S_IFDIR ) {
    Am_Object new_dir = (Am_Object)fbox.Get(FS_CURRENT_DIR);
    getcwd(path_name, FILE_NAME_WIDTH - 2);
    strcat(path_name, "/");
    strcat(path_name, dir_name);
    chdir(path_name);
    getcwd(path_name, FILE_NAME_WIDTH - 2);
    new_dir.Set(Am_TEXT, path_name);
    
    FS_ls("." /*dir_name*/, selected);
    selected.Set(FL_CURRENT_SELECTED, 0);
  }
  else 
    selected.Set(FL_CURRENT_SELECTED, obj);
  Am_Call(Am_Object_Proc, Am_Command, Am_DO_ACTION, (cmd_obj));
}

void  FS_CurrDirStopAction(Am_Object inter, Am_Object object, Am_Object event_window,
                           Am_Input_Event *ev) {
  Am_Text_Stop_Action(inter, object, event_window, ev);

  char path_name[FILE_NAME_WIDTH];
  Am_String dir_name = (Am_String)inter.Get_Owner().Get(Am_TEXT);
  strcpy(path_name, dir_name);
  struct stat statbuff;
  if ( stat(path_name, &statbuff) < 0 )
    cout << "Stat not working properly" << endl;
  Am_Object fbox = inter.Get_Owner().Get_Owner(),
            flist = (Am_Object)fbox.Get(FS_FILE_LIST),
            new_dir = (Am_Object)fbox.Get(FS_CURRENT_DIR);
  if ( (statbuff.st_mode & S_IFMT) == S_IFDIR )  
    chdir(path_name);
  else
    Am_Beep();

  getcwd(path_name, FILE_NAME_WIDTH - 2);
  new_dir.Set(Am_TEXT, path_name);
  FS_ls(".", flist);
  flist.Set(FL_CURRENT_SELECTED, 0);

}


void FS_ButtonDo(Am_Object cmd) {
  Am_String button_str = (Am_String)cmd.Get(Am_VALUE);
  Am_Object fbox = cmd.Get_Owner().Get_Owner();
  fbox.Set(FS_DONE, true);
  if ( !strcmp(button_str, ACCEPT_STRING) )
    fbox.Set(FS_ACCEPTED, true);
  else if ( !strcmp(button_str, ABORT_STRING) )
    fbox.Set(FS_ACCEPTED, false);
}

Am_Object FileSelectorDialog = 0;



void Initialize_FileSelectBox(void)
{
  TextHeight = Am_Text.Get(Am_HEIGHT);

  Am_Object FL_FileSelectInter =
            Am_One_Shot_Interactor.Create("FL_FileSelectInteractor")
    .Set(Am_START_WHERE_TEST, (Am_Object_Proc *) Am_Inter_In_Text_Leaf);
  FL_FileSelectInter.Get_Part(Am_COMMAND)
    .Set(Am_DO_ACTION, (void *) FL_FileSelectDoAction);

  Am_Object scrolling_group = Am_Scrolling_Group.Create("scrolling_group")
    .Set(Am_LEFT, 10)
    .Set(Am_TOP, 70)
    .Set(Am_WIDTH, GRAPHICAL_WIDTH)
    .Set(Am_HEIGHT, 280)
    .Set(Am_INNER_HEIGHT, Am_Height_Of_Parts)
    .Set(Am_FILL_STYLE, Am_Motif_Light_Gray)
    .Set(Am_H_SCROLL_BAR, false)
    .Set(FL_CURRENT_SELECTED, 0)
//    .Set(Am_INNER_HEIGHT, Am_Formula::Create(scrollable_height))
    .Add_Part(FL_CURSOR, Am_Rectangle.Create("FL_CURSOR")
      .Set(Am_LEFT, Am_Formula::Create(cursor_left))
      .Set(Am_TOP, Am_Formula::Create(cursor_top))
      .Set(Am_WIDTH, Am_Formula::Create(cursor_width))
      .Set(Am_HEIGHT, Am_Formula::Create(cursor_height))
      .Set(Am_FILL_STYLE, Am_No_Style)
      .Set(Am_VISIBLE, Am_Formula::Create(cursor_visible)))
    .Add_Part(FL_FileSelectInter);

  FS_ls(".", scrolling_group);

  char cur_dir[FILE_NAME_WIDTH];
  getcwd(cur_dir, FILE_NAME_WIDTH - 2);

  Am_Object FS_NewDirInteractor = Am_Text_Edit_Interactor.Create("FS_NewDirInteractor")
    .Set(Am_STOP_ACTION, (Am_Object_Proc *) FS_CurrDirStopAction);

  Am_Object current_file_obj = Am_Text.Create()
    .Set(Am_TEXT, Am_Formula::Create(current_file))
    .Set(Am_LEFT, 12)
    .Set(Am_TOP, 402)
    .Add_Part(Am_Text_Edit_Interactor.Create())
    ;
  Am_Object_Advanced obj_adv = (Am_Object_Advanced&)current_file_obj;
  obj_adv.Get_Slot(Am_TEXT)->Set_Single_Constraint_Mode(false);

  FileSelectorDialog = Am_Group.Create("FileSelectorDialog")
    .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
    .Set(Am_TOP, Am_Center_Y_Is_Center_Of_Owner)
    .Set(Am_WIDTH, Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Set(FS_DONE, false)
    .Set(FS_ACCEPTED, false)
    .Add_Part(FS_FRAME, Am_Border_Rectangle.Create()
      .Set(Am_LEFT, 0)
      .Set(Am_TOP, 0)
      .Set(Am_WIDTH, 500)
      .Set(Am_HEIGHT, 470)
      .Set(Am_FILL_STYLE, Am_Motif_Gray))
    .Add_Part(Am_Text.Create()
      .Set(Am_TEXT, "Current Path")
      .Set(Am_LEFT, 10)
      .Set(Am_TOP, 10))
    .Add_Part(Am_Text.Create()
      .Set(Am_TEXT, "File Selected")
      .Set(Am_LEFT, 10)
      .Set(Am_TOP, 380))
    .Add_Part(Am_Border_Rectangle.Create()
      .Set(Am_LEFT, 10)
      .Set(Am_TOP, 40)
      .Set(Am_WIDTH, GRAPHICAL_WIDTH)
      .Set(Am_HEIGHT, TextHeight + 4)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Gray))
    .Add_Part(Am_Border_Rectangle.Create()
      .Set(Am_LEFT, 10)
      .Set(Am_TOP, 400)
      .Set(Am_WIDTH, GRAPHICAL_WIDTH)
      .Set(Am_HEIGHT, TextHeight + 4)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Gray))
    .Add_Part(FS_CURRENT_DIR, Am_Text.Create()
      .Set(Am_TEXT, cur_dir)  //".")
      .Set(Am_LEFT, 12)
      .Set(Am_TOP, 40)
      .Add_Part(FS_NewDirInteractor))
    .Add_Part(FS_CURRENT_FILE, current_file_obj)
    .Add_Part(FS_FILE_LIST, scrolling_group)
    .Add_Part(FS_BUTTONS, Am_Button_Panel.Create()
      .Set(Am_LAYOUT, Am_Horizontal_Layout)
      .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
      .Set(Am_TOP, 430)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Gray)
      .Set(Am_H_SPACING, 10)
      .Set(Am_ITEMS, Am_Value_List()
        .Add(ACCEPT_STRING)
        .Add(ABORT_STRING)));

  Am_Object obj = (Am_Object)FileSelectorDialog.Get(FS_BUTTONS);
  obj.Get_Part(Am_COMMAND).Set(Am_DO_ACTION, FS_ButtonDo);
}

bool FileSelectBox(Am_Object window, char *filename) {
  window.Add_Part(FileSelectorDialog);
  while ( bool(FileSelectorDialog.Get(FS_DONE)) == false )
    Am_Do_Events();
  Am_Object str_obj = (Am_Object)FileSelectorDialog.Get(FS_CURRENT_FILE);
  FS_UnpadString(str_obj);
  Am_String str = (Am_String)str_obj.Get(Am_TEXT);
  bool result = FileSelectorDialog.Get(FS_ACCEPTED);
  window.Remove_Part(FileSelectorDialog);
  FileSelectorDialog.Set(FS_DONE, false);
//   FileSelectorDialog.Destroy();
  if ( result )
    strcpy(filename, str);
  return result;

}


void MB_ButtonDo(Am_Object cmd) {
  Am_Object mbox = cmd.Get_Owner().Get_Owner();
  mbox.Set(MB_DONE, true);
}

Am_Define_Formula(int, MB_width) {
  Am_Object obj = self.GV_Owner().GV_Part(MB_MESSAGE);
  return (int)obj.GV(Am_WIDTH) + 2*(int)obj.GV(Am_LEFT);
}

void MessageBox(Am_Object window, char *message) {
  Am_Object MB_MessageBox = Am_Group.Create("MB_MessageBox")
    .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
    .Set(Am_TOP, Am_Center_Y_Is_Center_Of_Owner)
    .Set(Am_WIDTH, Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Set(MB_DONE, false)
    .Add_Part(MB_FRAME, Am_Border_Rectangle.Create()
      .Set(Am_LEFT, 0)
      .Set(Am_TOP, 0)
      .Set(Am_WIDTH, Am_Formula::Create(MB_width))
      .Set(Am_HEIGHT, 80)
      .Set(Am_FILL_STYLE, Am_Motif_Gray))
    .Add_Part(MB_MESSAGE, Am_Text.Create()
      .Set(Am_TEXT, message)
      .Set(Am_LEFT, 10)
      .Set(Am_TOP, 10))
    .Add_Part(MB_BUTTON, Am_Button_Panel.Create()
      .Set(Am_LAYOUT, Am_Horizontal_Layout)
      .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
      .Set(Am_TOP, 30)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Gray)
      .Set(Am_ITEMS, Am_Value_List()
        .Add(DISMISS_STRING)));

  Am_Object obj = (Am_Object)MB_MessageBox.Get(MB_BUTTON);
  obj.Get_Part(Am_COMMAND).Set(Am_DO_ACTION, MB_ButtonDo);
  window.Add_Part(MB_MessageBox).Remove_Part(MB_MessageBox);
  window.Add_Part(MB_MessageBox);
  while ( bool(MB_MessageBox.Get(MB_DONE)) == false ) 
    Am_Do_Events();
  window.Remove_Part(MB_MessageBox);
  MB_MessageBox.Destroy();
}


/////////////////////////////////////////////////////////////////////
//  The following main() can be used to test the functions above
/////////////////////////////////////////////////////////////////////


/*
main() {
  Am_Initialize();

  Am_Object my_win = Am_Window.Create("my_win")
    .Set(Am_WIDTH, 500)
    .Set(Am_HEIGHT, 500);


  Am_Screen.Add_Part(my_win);

  Am_Initialize_Inspector(my_win);

  char filename[100], message_string[100];
  strcpy(message_string, "File ");
  if ( FileSelectBox(my_win, filename) ) {
    strcat(message_string, filename);
    strcat(message_string, " was chosen.");
    MessageBox(my_win, message_string);
  }
  else
    MessageBox(my_win, "Action cancelled"); 

  Am_Main_Event_Loop();
}
*/

