/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	1996$BG/(B2$B7n(B1$BF|@=:n3+;O(B
*	FBDD$B$N(Btype$B$r:n$k$?$a$N%W%m%0%i%`(B
*	weight propagation$BIt(B
*	by KANADA.T 
*******************************************************************/

#include "debug_level.h"
#include "weight_datatype.h"
#include "debug_macro.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern int search_output_tbl(char *);
extern int search_input_tbl(char *);
#else
extern int search_output_tbl(/*char **/);
extern int search_input_tbl(/*char **/);
#endif/* __STDC__ */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern syntax_t *Syntax_start_pt;
extern syntax_t *Syntax_free_head_pt;	
extern input_t *Input_tbl;				
extern output_t *Output_tbl;
extern primary_t *Primary_tbl;
extern int Input_num;					
extern int Output_num;
extern int Primary_num;
extern int Input_tbl_idx;				
extern int Output_tbl_idx;				

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

int *Wei_sort_tbl; /* $B%2!<%H?t$NB?$$=g$K%=!<%H$9$k$?$a$N%F!<%V%k(B */
int *Order_tbl;/* $BJQ?t=g=x3JG<MQ$N%F!<%V%k(B */

/*
 *	$BJQ?t=g=x3JG<MQ%F!<%V%k$N=i4|2=4X?t(B
 *
 */
void
#ifdef __STDC__
init_order_tbl(void)
#else
init_order_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;
	
	Order_tbl = (int *)malloc(sizeof(int)*Input_num);

	if (Order_tbl == NULL){
		fprintf(stderr,"Can not get MEMORY for Order_tbl.\n");
		fprintf(stderr,"Program exit\n");
		exit(-1);
	}

	/* $B=i4|2=(B */
	for(i=0; i<Input_num; i++)
		Order_tbl[i] = NO_EXIST;

	return;

}


/*
 *	$B%=!<%HMQ%F!<%V%k$N=i4|2=4X?t(B
 *	$B%=!<%H%F!<%V%k$NCf?H$O(BOutput_tbl$B$N%$%s%G%C%/%9$K$J$C$F$$$k$3$H$KCm0U(B
 */

static void
#ifdef __STDC__
init_wei_sort_tbl(void)
#else
init_wei_sort_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;
	
	Wei_sort_tbl = (int *)malloc(sizeof(int)*Primary_num);

	if (Wei_sort_tbl == NULL){
		fprintf(stderr,"Can not get MEMORY for Wei_sort_tbl.\n");
		fprintf(stderr,"Program exit.\n");
		exit(-1);
	}

	/* $B=i4|2=(B */
	for(i=0; i<Primary_num; i++)
		Wei_sort_tbl[i] = GET_PRIMARY_OUT_IDX(i);
	

	return;

}
	
/*
 *	get_n_gate$B$K8F$P$l$F<B:]$K%2!<%H?t$rD4$Y$k4X?t(B
 *	
 */

static int
#ifdef __STDC__
gate_search(syntax_t *node, syntax_ope_t ope)
#else
gate_search(node, ope)
  syntax_t *node;
  syntax_ope_t ope;
#endif/* __STDC__ */
{
	int counter = 0;
	int left_node_ct = 0;
	syntax_t *left_node;
	syntax_t *right_node;
	
	assert(node != NULL);
	assert(GET_SYNTAX_LINE(node) == TRUE);
	assert((SY_AND <= ope) && (ope <= SY_LEAF));

	left_node = GET_SYNTAX_LEFT(node);
	right_node = GET_SYNTAX_RIGHT(node);
	
	/* $B@h$K:8$N;R$rD4$Y$k(B */
	if ((left_node != NULL) && (GET_SYNTAX_LINE(left_node) == TRUE)){
		/* $B:8$N;R$,F1$8%?%$%W$J$i$5$i$K:8$K9_$j$F$$$/(B */
		if (GET_SYNTAX_TYPE(left_node) == ope){
			left_node_ct = gate_search(left_node,ope);
		}
		/* $B$=$&$G$J$1$l$P(Bleft_node_ct$B$r>e$2$k(B */
		else{
			left_node_ct++;
		}
	}

	/* $B1&$N;R$,?.9f@~$+$I$&$+D4$Y$k(B */
	if (right_node != NULL){
		if (GET_SYNTAX_LINE(right_node) == TRUE){
			counter++;
		}
	}

	counter = counter + left_node_ct;

	return counter;

}
	
/*
 *	$B9=J8LZ$N%]%$%s%?!<$rM?$($k$H2?F~NO$N%2!<%H$+$rJV$94X?t(B
 *	$B$?$@$7!$(Bis_used_line$B$,(BFALSE$B$N$H$-$O$=$N?.9f@~$O%+%&%s%H$7$J$$(B
 * 	$BD4$Y$k$N$O0z?t$N%N!<%I$N;R$@$1$G!$?F$OD4$Y$J$$(B
 *	$BJV$jCM$O(Bint
 */

static int
#ifdef __STDC__
get_n_gate(syntax_t *node)
#else
get_n_gate(node)
  syntax_t *node;
#endif/* __STDC__ */
{
	int counter = 0;
	syntax_ope_t node_type;

	assert(node != NULL);
	assert(GET_SYNTAX_LINE(node) == TRUE);

	/* $B%N!<%I$N%?%$%W$rD4$Y$k(B */
	node_type = GET_SYNTAX_TYPE(node);

	assert((SY_AND <= node_type) && (node_type <= SY_LEAF));

	/* $B%?%$%WJL$K=hM}$r9T$J$&(B */
	switch(node_type){
	  case (SY_AND):
		  counter = gate_search(node,SY_AND);
		  break;
	  case (SY_OR):
		  counter = gate_search(node,SY_OR);
		  break;
	  case(SY_XOR):
		  counter = gate_search(node,SY_XOR);
		  break;
	  case(SY_NOT):
		  break;
	  case(SY_LEAF):
		  break;
	  default:
		  /* $B$3$3$K$?$I$jCe$/$O$:$O$J$$$N$G%(%i!<$K$J$k(B */
		  fprintf(stderr,"Syntax node type ERROR.\n");
		  fprintf(stderr,"Program exit.\n");
		  exit(-1);
		  break;
	}

	assert(0 <= counter );

	return counter;

}

/*
 *	$B%N!<%I$r:F5"E*$KC5:w$7$F:GBgCJ?t$r7W;;$9$k4X?t(B
 *
 */

static int
#ifdef __STDC__
search_depth(syntax_t *cur_node, int pre_n_depth)
#else
search_depth(cur_node, pre_n_depth)
  syntax_t *cur_node;
  int pre_n_depth;				/* $B?F$+$iAw$i$l$F$-$?CJ?t>pJs(B */
#endif/* __STDC__ */
{
	int tbl_idx;				/* SY_LEAF$B$N;~(BOutput_tbl$B$rD4$Y$k$?$a$K;H$&(B */
	int left_max_depth = 0;		/* $B:8$N;R$N:GBgCJ?t(B */
	int right_max_depth = 0;	/* $B1&$N;R$N:GBgCJ?t(B */
	int cur_max_depth;			/* $B$3$N%N!<%I$G$N:GBgCJ?t(B */
	int cur_n_depth = 0;		/* $B$3$N%N!<%I$+$i;R$KAw$k$?$a$NCJ?t>pJs(B*/
	syntax_t *left_node;		/* $B:8$N;R(B */
	syntax_t *right_node;		/* $B1&$N;R(B */
	int ope;					/* $B$3$N%N!<%I$N7?(B */
	
	assert(cur_node != NULL);
	assert(0 <= pre_n_depth);

	left_node = GET_SYNTAX_LEFT(cur_node);
	right_node = GET_SYNTAX_RIGHT(cur_node);
	ope = GET_SYNTAX_TYPE(cur_node);
	
	/* $B$b$7(Bcur_node$B$,(BSY_LEAF$B$@$C$?$i$=$NJQ?t$rD4$Y$FCJ?t$rJV$9(B*/
	if (ope == SY_LEAF){
		tbl_idx = search_output_tbl(GET_SYNTAX_NAME(cur_node));

		assert((NO_EXIST <= tbl_idx) && (tbl_idx < Output_num));

		/* $B$b$7JQ?t$,F~NOJQ?t$@$C$?$i(B */
		if (tbl_idx == NO_EXIST){
			return 0;
		}
		/* $B$b$7JQ?t$,(BOutput_tbl$B$KB8:_$7$?$i(B */
		else{
			return GET_OUTPUT_DEPTH(tbl_idx);
		}
	}
	/* $B$b$7(BSY_NOT$B$@$C$?$i(B */
	else if (ope == SY_NOT){
		return search_depth(left_node,0);
	}
	/* SY_AND,SY_OR,SY_XOR$B$@$C$?$i(B */
	else{

		/* $B$b$7(Bpre_n_depth == 0$B$@$C$?$i!$?7$?$KD4$Y$?%2!<%H>pJs$r;R$KAw$k(B */
		/* $B;R$K>pJs$rAw$k;~(B 1 $B$r0z$$$F$$$k(B */

		if (pre_n_depth == 0) {
			cur_n_depth = (get_n_gate(cur_node) -1); /* 1 $B0z$/$HCJ?t$K$J$k(B */
			left_max_depth = search_depth(left_node,(cur_n_depth -1));
		}
		/* $B$=$&$G$J$1$l$P?F$+$i$b$i$C$?CM$+$i(B 1 $B0z$$$F;R$KAw$k(B */
		else{
			left_max_depth = search_depth(left_node,(pre_n_depth - 1));
		}

		/* $B1&$N;R$O>r7o$J$7(B */
		right_max_depth = search_depth(right_node,0);
	}

	/* $B:GBgCJ?t$N7W;;(B */
	if (left_max_depth > right_max_depth){
		cur_max_depth = left_max_depth;
	}
	else{
		cur_max_depth = right_max_depth;
	}

	if (pre_n_depth == 0){
		cur_max_depth = cur_max_depth + cur_n_depth;
	}
	
	return cur_max_depth;

}
	
/*
 *	$B3F=PNOJQ?t$N:GBgCJ?t$rD4$Y$k4X?t(B
 * 	$B$?$@$7Cf4VJQ?t$,E83+$5$l$?$H$-$NCJ?t!%(B
 *
 */

static void
#ifdef __STDC__
get_max_depth(void)
#else
get_max_depth(/*void*/)
#endif/* __STDC__ */
{
	int i;

	/* $B<!$K(Bprimary out */
	for(i=0; i<Output_num; i++){
		GET_OUTPUT_DEPTH(i) = search_depth(GET_OUTPUT_ROOT(i),0);
	}

	return;

}

/*
 *	$BCJ?t$NB?$$=g$K%=!<%H(B
 *	$B$?$@$7!$(Bprimary out$B$N$_(B
 */

static void
#ifdef __STDC__
sort_decleasing_depth(void)
#else
sort_decleasing_depth(/*void*/)
#endif/* __STDC__ */
{
	int i;
	int j;
	int tmp;	


	for(i=0; i<(Primary_num - 1); i++){
		for(j=i+1; j<Primary_num; j++){
			if(GET_OUTPUT_DEPTH(Wei_sort_tbl[i]) < GET_OUTPUT_DEPTH(Wei_sort_tbl[j])){
				tmp = Wei_sort_tbl[i];
				Wei_sort_tbl[i] = Wei_sort_tbl[j];
				Wei_sort_tbl[j] = tmp;
			}
		}
	}

	SORT_CHECK;
	
	PRINT_PRIMARY_OUT9;
	PRINT_SORT_TBL9;
	
	return;

}

/*
 *	$B=E$_$rJ,G[$9$k4X?t(B
 *
 */

static void
#ifdef __STDC__
divide_weight(syntax_t *cur_node, float weight, int divisor)
#else
divide_weight(cur_node, weight, divisor)
  syntax_t *cur_node;			/* $B:#$$$k%N!<%I(B */
  float weight;					/* $BEO$5$l$k=E$_(B */
  int divisor;					/* $B%2!<%H$N>pJs(B */
#endif/* __STDC__ */
{
	syntax_t *left_node;
	syntax_t *right_node;
	float right_weight = 0;
	float left_weight = 0;
	int in_out_idx;
	int new_divisor;
	int ope;
	
	assert(cur_node != NULL);
	assert(0 < weight);
	assert(0 <= divisor);

	left_node = GET_SYNTAX_LEFT(cur_node);
	right_node = GET_SYNTAX_RIGHT(cur_node);
	ope = GET_SYNTAX_TYPE(cur_node);
	
	/* $B%N!<%I$N7?$K$h$C$F=hM}$,JQ$o$k(B */
	if (ope == SY_LEAF){

		/* Input_tbl$B$rD4$Y$k(B */
		in_out_idx = search_input_tbl(GET_SYNTAX_NAME(cur_node));

		assert((NO_EXIST <= in_out_idx) && (in_out_idx < Input_num));
		
		if (in_out_idx != NO_EXIST){
			GET_INPUT_WEIGHT(in_out_idx) = GET_INPUT_WEIGHT(in_out_idx) + weight;

			return;
		}
		
		/* Output_tbl$B$rD4$Y$k(B */
		in_out_idx = search_output_tbl(GET_SYNTAX_NAME(cur_node));

		assert((NO_EXIST < in_out_idx) && (in_out_idx < Output_num));

		GET_OUTPUT_WEIGHT(in_out_idx) = GET_OUTPUT_WEIGHT(in_out_idx) + weight;

	}
	else if (ope == SY_NOT){

		assert(left_node != NULL);
		assert(GET_SYNTAX_LINE(left_node) == TRUE);
		
		divide_weight(left_node, weight, 0);
	}
	else{/* AND,OR,XOR$B$N$H$-(B */
		assert((left_node != NULL) && (right_node != NULL));
		assert((GET_SYNTAX_LINE(left_node) == TRUE) || (GET_SYNTAX_LINE(right_node) == TRUE));
		
		/* divisor == 0 $B$N;~$O(Bgate$B$r7W;;$9$k(B */
		if(divisor == 0){
			new_divisor = get_n_gate(cur_node);
		}
		else{
			new_divisor = divisor;
		}

		/* $B$3$3$G$O=E$_$N7W;;$7$+$7$F$$$J$$(B */
		if (GET_SYNTAX_LINE(right_node) == TRUE){
			right_weight = weight / new_divisor;
			left_weight = weight - right_weight;
		}
		else{
			left_weight = weight;
		}

		/* $B;R$K=E$_$rJ,G[$9$k(B */
		if(GET_SYNTAX_LINE(right_node) == TRUE){
			assert(0 < right_weight);
			divide_weight(right_node, right_weight, 0);
			new_divisor--;
		}

		if(GET_SYNTAX_LINE(left_node) == TRUE){
			assert(0 < left_weight);
			if(GET_SYNTAX_TYPE(left_node) != ope)
				new_divisor--;
			divide_weight(left_node, left_weight, new_divisor);
		}

	}

	return;

}
	
		
/*
 * 	Output_tbl$B$K;D$C$F$$$k(Bweight$B$r(BInput_tbl$B$KJ,G[$9$k4X?t(B
 *	$BC5:w$N=gHV$O(BOutput_tbl$B$N8e$m$+$i(B
 */

static void
#ifdef __STDC__
weight_output2input(void)
#else
weight_output2input(/*void*/)
#endif/* __STDC__ */
{
	int i;

	for(i=Output_num - 1; i>=0; i--){
		if(GET_OUTPUT_WEIGHT(i) != 0){
			divide_weight(GET_OUTPUT_ROOT(i), GET_OUTPUT_WEIGHT(i), 0);
			GET_OUTPUT_WEIGHT(i) = 0;
		}
	}
	
	WEIGHT_CHECK;
	
	return;

}
				
/*
 *	Input_tbl$B$NCf$G!$(Bweight$B$NBg$-$$$N$rA*$V4X?t(B
 *	$BJV$jCM$O(BInput_tbl $B$N(Bindex
 */
	
static int	
#ifdef __STDC__
select_max_weight(void)
#else
select_max_weight(/*void*/)
#endif/* __STDC__ */
{
	double max_weight = 0;
	int max_idx;
	int cur_idx;

	USED_INPUT_CHECK;
	
	for(cur_idx=0; cur_idx < Input_num; cur_idx++){
		if(GET_INPUT_WEIGHT(cur_idx) > max_weight){
			max_idx = cur_idx;
			max_weight = GET_INPUT_WEIGHT(cur_idx);
		}
	}

	assert((0 <= max_idx) && (max_idx <Input_num));
	
	return max_idx;

}

/*
 *	$B0z?t$N(BInput_tbl$B$N(Bindex$B$r(BOrder_tbl$B$KEPO?$9$k4X?t(B
 *	type$B$N@8@.;~$K$O;HMQ$7$J$$(B
 */

static void
#ifdef __STDC__
set_order_tbl(int index)
#else
set_order_tbl(index)
  int index;
#endif/* __STDC__ */
{
	int i;

	assert((NO_EXIST < index) && (index < Input_num));

	for(i=0; i<Input_num; i++){
		if (Order_tbl[i] == NO_EXIST){
			Order_tbl[i] = index;
			break;
		}
	}

	assert((0 <= i) && (i <Input_num));

	return;

}

/*
 *	input_index$B$K4X78$9$k?.9f@~$N(BLINE$B$r(BFALSE$B$K$9$k4X?t(B	
 *
 */
	
static void
#ifdef __STDC__
change_signal_line(syntax_t *cur_node, int input_index)
#else
change_signal_line(cur_node, input_index)
  syntax_t *cur_node;
  int input_index;
#endif/* __STDC__ */
{
	syntax_t *left_node;
	syntax_t *right_node;
	syntax_ope_t ope;
	int leaf_index;

	assert(cur_node != NULL);
	assert((NO_EXIST < input_index) && (input_index < Input_num));
	assert(GET_SYNTAX_LINE(cur_node) == TRUE);
	
	left_node = GET_SYNTAX_LEFT(cur_node);
	right_node = GET_SYNTAX_RIGHT(cur_node);
	ope = GET_SYNTAX_TYPE(cur_node);

	assert((SY_AND <= ope) && (ope <= SY_LEAF));

	/* $B@h$K;R$N>uBV$r3NDj$5$;$k(B */
	if ((left_node != NULL) && (GET_SYNTAX_LINE(left_node) == TRUE))
		change_signal_line(left_node, input_index);

	if ((right_node != NULL) && (GET_SYNTAX_LINE(right_node) == TRUE))
		change_signal_line(right_node, input_index);

	/* $B%N!<%I7?$K$h$C$F=hM}$r9T$J$&(B */
	if (ope == SY_LEAF){

		/* $BF~NOJQ?t$N;~(B */
		leaf_index = search_input_tbl(GET_SYNTAX_NAME(cur_node));

		assert((NO_EXIST <= leaf_index) && (leaf_index < Input_num));

		if (leaf_index != NO_EXIST){
			if (strcmp(GET_INPUT_NAME(leaf_index),GET_INPUT_NAME(input_index)) == 0){
				GET_SYNTAX_LINE(cur_node) = FALSE;
				return;
			}
		}

		/* $BCf4VJQ?t$N;~(B */
		leaf_index = search_output_tbl(GET_SYNTAX_NAME(cur_node));

		assert((NO_EXIST <= leaf_index) && (leaf_index < Output_num));

		if (leaf_index != NO_EXIST){
			if (GET_SYNTAX_LINE(GET_OUTPUT_ROOT(leaf_index)) == FALSE)
				GET_SYNTAX_LINE(cur_node) = FALSE;
		}
	}
	else if (ope == SY_NOT){
		if (GET_SYNTAX_LINE(left_node) == FALSE)
			GET_SYNTAX_LINE(cur_node) = FALSE;
	}
	else{/* AND,OR,XOR */
		if ((GET_SYNTAX_LINE(left_node) == FALSE) && (GET_SYNTAX_LINE(right_node) == FALSE))
			GET_SYNTAX_LINE(cur_node) = FALSE;
	}

	return;

}

/*
 *	$B0lHV=E$_$NBg$-$$JQ?t$r$H$j$@$7!$(B
 *	$B<h$j=P$5$l$?JQ?t$r(BOrder_tbl$B$KEPO?$7!$(BInput_tbl$B$K0u$r$D$1$k4X?t(B
 *	$BJV$jCM$O(BInput$B$N%$%s%G%C%/%9(B
 */

static int
#ifdef __STDC__
set_and_mark_input_var(void)
#else
set_and_mark_input_var(/*void*/)
#endif/* __STDC__ */
{
	int target;

	/* $BJQ?t$N$H$j$@$7(B */
	target = select_max_weight();

	assert((0 <= target) && (target < Input_num));
	
	/*$B0u$r$D$1$k(B */
	GET_INPUT_USED(target) = TRUE;

	/* Order_tbl$B$KEPO?(B */
	set_order_tbl(target);

	return target;

}

/*
 *	Input_tbl$B$N=E$_$NJQ?t$r=i4|2=$9$k4X?t(B
 *
 */

static void
#ifdef __STDC__
reset_input_weight(void)
#else
reset_input_weight(/*void*/)
#endif/* __STDC__ */
{
	int i;
	
	for(i=0; i<Input_num; i++)
		GET_INPUT_WEIGHT(i) = 0;

	return;

}


/*
 *	$B0z?t$NJQ?t$K4X78$9$k9=J8LZ$N(BLINE$B$r(BFALSE$B$K$9$k4X?t(B
 *
 */

static void
#ifdef __STDC__
change_signal_line_all_tree(void)
#else
change_signal_line_all_tree(/*void*/)
#endif/* __STDC__ */
{
	int i;
	int target;

	/* $BJQ?t$N<h$j=P$7$H@_Dj(B */
	target = set_and_mark_input_var();

	assert((0 <= target) && (target < Input_num));
	
	/* $BCf4VJQ?t$+$i(Bline$B$rJQ99$9$k(B */
	for(i=0; i<Output_num; i++){
		if (GET_SYNTAX_LINE(GET_OUTPUT_ROOT(i)) == FALSE)
			continue;
		change_signal_line(GET_OUTPUT_ROOT(i), target);
	}

	return;

}
		
/*
 *	weight propagation
 *	$B$NK\BN(B
 */

void
#ifdef __STDC__
weight_propagation(void)
#else
weight_propagation(/*void*/)
#endif/* __STDC__ */
{
	int i;
	syntax_t *root_node;
	
	for(i=0; i<Primary_num; i++){

		/* $B=*N;>r7o(B */
		if(Order_tbl[Input_num-1] != NO_EXIST)
			break;

		/* continue$B>r7o(B */		
		root_node = GET_OUTPUT_ROOT(Wei_sort_tbl[i]);
		if(GET_SYNTAX_LINE(root_node) == FALSE)
			continue;

		/* $B7W;;3+;O(B */
		while(GET_SYNTAX_LINE(GET_OUTPUT_ROOT(Wei_sort_tbl[i])) == TRUE){

			divide_weight(GET_OUTPUT_ROOT(Wei_sort_tbl[i]), 1, 0);
			weight_output2input();
			change_signal_line_all_tree();

			PRINT_ALL_INPUT_TBL9;
			PRINT_PRIMARY_OUT9;
			
			reset_input_weight();
		}
		
	}

	/* $B$b$7;H$o$l$F$$$J$$JQ?t$,$"$C$?$N$J$i(B */
	if (Order_tbl[Input_num-1] != NO_EXIST){
		for(i=0; i<Input_num; i++){
			if (GET_INPUT_USED(i) == FALSE){
				UNUSED_INPUT_CHECK(i);
				fprintf(stderr,"WARNING: Unused input %s exist\n",GET_INPUT_NAME(i));
				set_order_tbl(i);
			}
		}
	}
	
	ORDER_TBL_CHECK;
	PRINT_ALL_ORDER_TBL9;
	
	return;

}
	
				
		
		
		
/*
 *	weight propagation$B$N%a%$%sItJ,(B
 *
 */

void
#ifdef __STDC__
weight_main(void)
#else
weight_main(/*void*/)
#endif/* __STDC__ */
{
	
	/* $B%=!<%HMQ%F!<%V%k$N=i4|2=(B */
	init_wei_sort_tbl();

	/* $BJQ?t=g=xMQ$N%F!<%V%k$N=i4|2=(B */
/*	init_order_tbl();*//* synth$B$G$O=i4|2=$N%?%$%_%s%0$rJQ99$7$?$?$a(B */

	/* $BCJ?t$N7W;;(B */
	get_max_depth();

	/* $BCJ?t$NB?$$=g$K%=!<%H(B */
	sort_decleasing_depth();

	/* weight propagation */
	weight_propagation();
	
	return;

}
/* ---------- end of file 'debug.c' ---------- */


