/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	1996$BG/(B2$B7n(B1$BF|@=:n3+;O(B
*	FBDD$B$N(Btype$B$r:n$k$?$a$N%W%m%0%i%`(B
*	$B9=B$BNDj5AIt(B
*   by KANADA.T
*******************************************************************/
#include <stdio.h>
#include <string.h>

#include "macro.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#define SYNTAX_NODE_NUM 3000		/* $B9=J8LZ$NNN0h$r3NJ]$9$k;~$N%5%$%:(B */
#define NO_EXIST -1					/* $BB8:_$7$J$$;~$N5"$jCM(B */

/*>>>>>>>>>>>>>>>>> enum$B7?Dj5AIt(B <<<<<<<<<<<<<<<<<<*/

typedef enum {FALSE,TRUE} wei_boolean_t;
typedef enum {SY_AND,SY_OR,SY_XOR,SY_NOT,SY_LEAF} syntax_ope_t; 	/* $B9=J8LZ$N%N!<%I$N7?$r<($9$?$a$NDj5A(B */

/*>>>>>>>>>>>>>>>>> $B9=B$BNDj5AIt(B<<<<<<<<<<<<<<<<<<*/

/* $B9=J8LZ$N9=B$BN(B */
typedef struct syntax {
	syntax_ope_t type;				/* $B%N!<%I$N7?$r<($9JQ?t(B */
	char function_name[30];		/* $BF~!$=PNOJQ?t$r<($9JQ?t(B */
	wei_boolean_t is_used_line;			/* $B:#$3$N?.9f@~$,;H$o$l$F$$$k$+$I$&$+$r<($9JQ?t(B */
	struct syntax *left;			/* $B:8$N;R$r;X$9%]%$%s%?(B */
	struct syntax *right;			/* $B1&$N;R$r;X$9%]%$%s%?(B */
	struct syntax *next;			/* $B%N!<%I$N4IM}MQ(B */
} syntax_t;
	
/* $BF~NO%F!<%V%k$N9=B$BN(B */
typedef struct input {
	char input_name[30];		/* $BF~NOJQ?t$NL>A0(B */
	double weight;					/* weight_propagation$B$G=E$_$r3JG<$9$k$?$a$NJQ?t(B */
	wei_boolean_t is_used;				/* $B$3$NJQ?t$,;H$o$l$?$+$I$&$+$r<($9$?$a$N%U%i%0(B */
} input_t;

/* $B=PNO%F!<%V%k$N9=B$BN!JCf4VJQ?t$b4^$`!K(B*/
typedef struct output {
	char output_name[30];	    /* $B=PNOJQ?t$NL>A0(B */
	double weight;					/* $B=E$_$r3JG<$9$k$?$a$NJQ?t(B */
	syntax_t *root;					/* $B9=J8LZ$N(Broot$B$r<($9$?$a$N%]%$%s%?(B */
	int max_depth;					/* $BCf4VJQ?t$rE83+$7$?;~$N:GBgCJ?t(B */
	int used_node_num;				/* $B?.9f@~$H$7$F;H$o$l$F$$$k%N!<%I$N8D?t!J(BLEAF,NOT$B$O=|$/!K(B */
} output_t;

/* primary out$BMQ$N9=B$BN(B */
typedef struct primary {
	char primary_name[30];		/* primary out$B$NL>A0(B */
	int output_tbl_idx;				/* Output_tbl$B>e$NEPO?>l=j(B */
} primary_t;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/







