/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	1996$BG/(B2$B7n(B7$BF|@=:n3+;O(B
*	type$B$r:n$k;~$K;HMQ$7$?(Bmake_syntax.c weight_propagetion.c yacc lex
*	$B%=!<%9$r=i4|JQ?t=g=x@8@.MQ$H$7$F(Bsynth$B$KAH$_9~$`$?$a$N%W%m%0%i%`(B
*	$B$G$-$k$@$1B>$N%=!<%9$O$$$8$i$:$K$3$3$G$N%W%m%0%i%`$G=hM}(B
*	$B$$$8$k;~$O(Btype$B$r@8@.$9$k;~$K;HMQ$7$?%=!<%9$r$$$8$k(B
*	synth $B$N(B yacc$B$KB8:_$7$?4X?t$N0lIt$,$3$3$K$"$j$^$9(B
*	by Konishi,K.
*******************************************************************/
#include "debug_level.h"
#include "weight_datatype.h"

#include "datatype.h"
#include "error.h"
#include "debug.h"
#include "etc.h"	
#include "bdd_etc.h"

#include "bdd_print.h"

#include "get_system_info.h"


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern int bdd_apply(int, int, ope_t);
extern int not_ope(int);
extern int val_to_level(char *);
extern int alloc_node(int, int, int);
extern int node_hash_search(int, int, int);
extern void (*gc_func)(void);
#else
extern int bdd_apply(/*int, int, ope_t*/);
extern int not_ope(/*int*/);
extern int val_to_level(char *);
extern int alloc_node(/* int, int, int */);
extern int node_hash_search(/* int, int, int */);
extern void (*gc_func)(/* void */);
#endif/* __STDC__ */
  
/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern void init_order_tbl(void);
extern int search_output_tbl(char *);
#else
extern void init_order_tbl(/*void*/);
extern int search_output_tbl(/*char **/);
#endif/* __STDC__ */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern int Input_val_num;
extern int Function_num;
extern int Free_list_ct;
extern int Max_node_num;
extern node_t *Node_tbl;
extern val_tbl_t *Input_val_tbl;
extern output_node_t *Output_val_tbl;

/* $B$3$NJQ?t$O8=:_;HMQ$7$F$$$J$$(B */
int Cur_input_num;
int Cur_function_num;
/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern input_t *Input_tbl;
extern output_t *Output_tbl;
extern primary_t *Primary_tbl;
extern int *Order_tbl;
extern int Input_num;
extern int Output_num;
extern int Primary_num;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>>  synth yacc $B$K$"$C$?%=!<%9$N6h4V(B <<<<<<<<<<<<<<<<<<*/	
	
/*
 *	$BF~NO!$=PNO%F!<%V%k$N=i4|2=4X?t(B
 *
 */
void
#ifdef __STDC__
init_in_out_tbl(void)
#else
init_in_out_tbl()
#endif /* __STDC__ */
{
	int i;

	/* $BF~NO%F!<%V%k$N=i4|2=(B */
	Input_val_tbl = (val_tbl_t *)malloc(sizeof(val_tbl_t)*(Input_val_num+3));
	if (Input_val_tbl == NULL)
		MALLOC_ERR;

	for (i = 0; i < (Input_val_num+3); i++) {
		Input_val_tbl[i].level = i;
		Input_val_tbl[i].node_num = 0;
		Input_val_tbl[i].is_used = FALSE;
		SET_VAL_TBL_T(&(Input_val_tbl[i]));
		CHECK_VAL_TBL_T(&(Input_val_tbl[i]));
	}

	Cur_input_num = 3;

    /* $B=PNO%F!<%V%k$N=i4|2=(B */
	Output_val_tbl = (output_node_t *)malloc(sizeof(output_node_t)*Function_num);
	if (Output_val_tbl == NULL){
		printf("malloc error\n");
		exit(-1);
	}

	for (i = 0; i < Function_num; i++){
		Output_val_tbl[i].pt_to_dag = 0;
		Output_val_tbl[i].next = 0;
		Output_val_tbl[i].is_primary_out = FALSE;
		SET_OUTPUT_NODE_T(&(Output_val_tbl[i]));
		CHECK_OUTPUT_NODE_T(&(Output_val_tbl[i]));
	}

	Cur_function_num = 0;

	return;

}

/*
 *	$BF~NOJQ?t$NEPO?(B
 *
 */
static void
#ifdef __STDC__
alloc_input(char *var)
#else
alloc_input(var)
  char *var;
#endif /* __STDC__ */
  
{
	int i;

	/* $B%A%'%C%/ItJ,(B */
	if (Cur_input_num > (Input_val_num + 3)){
		printf("Input_num error %d\n", Cur_input_num);
		exit(-1);
	}

	for(i = 0; i < Cur_input_num; i++){
		if (strcmp(var, Input_val_tbl[i].val) == 0){
			printf("same var exist: %s", var);
			exit(-1);
		}
	}

	
    /* $BEPO?ItJ,(B */
	strcpy(Input_val_tbl[Cur_input_num].val, var);
	CHECK_VAL_TBL_T(&(Input_val_tbl[Cur_input_num]));

	Cur_input_num++;

	return;
}

/*
 *	$B=PNO4X?t$NEPO?(B
 *
 */
static void
#ifdef __STDC__
alloc_output(char *func)
#else
alloc_output(func)
  char *func;
#endif /* __STDC__ */
{

	int i;
	
	/* $B%A%'%C%/ItJ,(B */
	if (Cur_function_num > Function_num){
		printf("Function_num error %d\n", Cur_function_num);
		exit(-1);
	}

	for(i = 0; i < Cur_function_num; i++){
		if (strcmp(func, Output_val_tbl[i].output_name) == 0){
			printf("same func exist: %s", func);
			exit(-1);
		}
	}

	/* $BEPO?ItJ,(B */
	strcpy(Output_val_tbl[Cur_function_num].output_name,func);
	Output_val_tbl[i].is_primary_out = TRUE;
	CHECK_OUTPUT_NODE_T(&(Output_val_tbl[Cur_function_num]));

	Cur_function_num++;

	return;
}


/*
 *	$BJQ?tL>$+$i=PNO$N9=B$BN$rA\$7=P$94X?t(B
 *	$BCf4VJQ?t$@$H?7$7$/EPO?$5$l$k!%(B
 */
int
#ifdef __STDC__
search_and_alloc_out_tbl(char *func)
#else
search_and_alloc_out_tbl(func)
  char *func;
#endif /* __STDC__ */
{
	int i;

	assert((0 <= Cur_function_num) && (Cur_function_num <= Function_num));

	for(i=0; i < Cur_function_num; i++){

		/*$B4{$KEPO?$5$l$F$$$k>l9g(B */
		if (strcmp(func,Output_val_tbl[i].output_name) == 0){

			/* $B4{$K7W;;7k2L$,B8:_$9$k>l9g$O$*$+$7$$(B */
			if (Output_val_tbl[i].pt_to_dag != 0){
				printf("Output_val_tbl[%d].pt_to_dag exist stop program\n",i);
				exit(-1);
			}
			return i;
		}
	}


	/* $B%F!<%V%k>e$KB8:_$7$J$$>l9gEPO?(B */


	CHECK_OUTPUT_NODE_T(&(Output_val_tbl[Cur_function_num]));
	strcpy(Output_val_tbl[Cur_function_num].output_name, func);

	Cur_function_num++;

	return (Cur_function_num - 1);
}

/*
 * $BCf4VJQ?t$r<h$j=P$94X?t(B
 *	
 */
int
#ifdef __STDC__
search_mid_var(char *func)
#else
search_mid_var(func)
  char *func;
#endif /* __STDC__ */
{
	int i;

	assert((Cur_function_num <= Function_num) && (Cur_function_num > 0));

	for(i=0;i<Cur_function_num;i++){
		if (strcmp(func,Output_val_tbl[i].output_name) == 0){

			/* $B7W;;7k2L$,B8:_$7$J$$>l9g(B */
			if (Output_val_tbl[i].pt_to_dag == 0){
				printf("Output_val_tbl[%d].pt_to_dag do not exist. stop program\n",i);
				exit(-1);
			}

			return i;
		}
	}
	fprintf(stderr, "%s [ERROR] : LINE:%d in %s\n", __LINE__, __FILE__);
	fprintf(stderr, "Function:%s is firstly used before definition.\n",
			func);
	exit(-1);
}

/*>>>>>>>>>>>>>>>>> synth yacc $B$N%=!<%96h4V=*$j(B <<<<<<<<<<<<<<<<<<*/

/*
 *	$B9=J8LZ$r$?$I$C$F1i;;$r9T$J$&$?$a$N4X?t(B
 *	$BJV$jCM$O(Bbdd$B$N%N!<%I$N%$%s%G%C%/%9$,JV$k(B
 * 	$B4pK\$O(Bsynth yacc$B$HF1$8$3$H$r$7$F$$$k$,!$0lItJQ99E@$"$j(B
 */

int
#ifdef __STDC__
apply_syntax_tree(syntax_t *cur_syntax_pt)
#else
apply_syntax_tree(cur_syntax_pt)
  syntax_t *cur_pt;
#endif/* __STDC__ */
{
	int left_bdd_idx = UNKNOWN;
	int right_bdd_idx = UNKNOWN;
	int cur_bdd_idx = UNKNOWN;
	int get_level;
	int get_node;
	
	assert(cur_syntax_pt != NULL);

	/* $B@h$K;R$r=hM}$9$k(B */	
	if (GET_SYNTAX_LEFT(cur_syntax_pt) != NULL)
		left_bdd_idx = apply_syntax_tree(GET_SYNTAX_LEFT(cur_syntax_pt));
	
	if (GET_SYNTAX_RIGHT(cur_syntax_pt) != NULL)
		right_bdd_idx = apply_syntax_tree(GET_SYNTAX_RIGHT(cur_syntax_pt));
										  
	assert((0 <= left_bdd_idx) && (left_bdd_idx < Max_node_num));
	assert((0 <= right_bdd_idx) && (right_bdd_idx < Max_node_num));

	/* $B%N!<%I$N7?$K$7$?$,$C$F=hM}$r9T$J$&(B */
	if (GET_SYNTAX_TYPE(cur_syntax_pt) == SY_LEAF){
		
		get_level = val_to_level(GET_SYNTAX_NAME(cur_syntax_pt));
		
		/* $BCf4VJQ?t$N>l9g(B */
		if (get_level == NOT_EXIST){
			cur_bdd_idx = Output_val_tbl[search_output_tbl(GET_SYNTAX_NAME(cur_syntax_pt))].pt_to_dag;
			
			assert((0 < cur_bdd_idx) && (cur_bdd_idx < Max_node_num));
			
		} else{/* $B$=$l0J30(B */
			get_node = node_hash_search(get_level, BDD_FALSE, BDD_TRUE);
			if (get_node == NOT_EXIST) {
				cur_bdd_idx = alloc_node(get_level, BDD_FALSE, BDD_TRUE);
			}else{
				cur_bdd_idx = get_node;
			}
		}

		INC_REF_CT(cur_bdd_idx);

	}
	else if (GET_SYNTAX_TYPE(cur_syntax_pt) == SY_NOT){
		DEC_REF_CT(left_bdd_idx);
		cur_bdd_idx = not_ope(left_bdd_idx);
		INC_REF_CT(cur_bdd_idx);
		assert((0 < Free_list_ct) && (Free_list_ct < (Max_node_num - 3)));
		if (Free_list_ct < (int)((1.0 - GC_MARGIN)*(double)Max_node_num)) {
			EDGE_CHECK;
			gc_func();
			assert(((Max_node_num - 1) - Free_list_ct) == get_cur_node_num());
			EDGE_CHECK;
		}
	}
	else{
		DEC_REF_CT(left_bdd_idx);
		DEC_REF_CT(right_bdd_idx);
		
		if (GET_SYNTAX_TYPE(cur_syntax_pt) == SY_AND){
			cur_bdd_idx = bdd_apply(left_bdd_idx,right_bdd_idx,AND_OPE);
		}
		else if (GET_SYNTAX_TYPE(cur_syntax_pt) == SY_OR){
			cur_bdd_idx = bdd_apply(left_bdd_idx,right_bdd_idx,OR_OPE);
		}
		else if (GET_SYNTAX_TYPE(cur_syntax_pt) == SY_XOR){
			cur_bdd_idx = bdd_apply(left_bdd_idx,right_bdd_idx,XOR_OPE);
		}
		else{
			printf("[ERROR] Can not reach here LINE: %d in %s\n",__LINE__, __FILE__);
		}
		
		INC_REF_CT(cur_bdd_idx);
		assert((0 < Free_list_ct) && (Free_list_ct < (Max_node_num - 3)));
		if (Free_list_ct < (int)((1.0 - GC_MARGIN)*(double)Max_node_num)) {
			EDGE_CHECK;
			gc_func();
			assert(((Max_node_num - 1) - Free_list_ct) == get_cur_node_num());
			EDGE_CHECK;
		}
	}

	return cur_bdd_idx;

}

/*
 *	$BF~NOJQ?t$N%G!<%?$N0\F0(B
 *	$B$?$@$7(BOrder_tbl$B$NJQ?t=g=x$O(BInput_val_tbl$B$N=g=x$H$O(B
 *	$B=g0L$O5U$K$J$C$F$$$k(B
 *	Input_val_tbl$B$O(B3$BHV$+$i;HMQ(B
 */

void
#ifdef __STDC__
input_tbl_to_input_val_tbl(void)
#else
input_tbl_to_input_val_tbl(/*void*/)
#endif/* __STDC__ */
{
	int cur_input_val_idx;
	int cur_weight_input_idx = Input_num-1;
	
	for(cur_input_val_idx = 3; cur_input_val_idx < (Input_val_num+3); cur_input_val_idx++){
		strcpy(Input_val_tbl[cur_input_val_idx].val,GET_INPUT_NAME(Order_tbl[cur_weight_input_idx]));
		cur_weight_input_idx--;
	}

	return;

}

/*
 *	$B=PNOJQ?t$N%G!<%?$N0\F0(B
 *
 */

void
#ifdef __STDC__
output_tbl_to_output_val_tbl(void)
#else
output_tbl_to_outout_val_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;

	/* $BL>A0$N%3%T!<(B */
	for(i=0; i < Output_num; i++){
		strcpy(Output_val_tbl[i].output_name,GET_OUTPUT_NAME(i));
	}
	
	/* primary flag */
	for(i=0; i < Primary_num; i++)
		Output_val_tbl[GET_PRIMARY_OUT_IDX(i)].is_primary_out = TRUE;

	return;

}

/*
 *	weight propagation $B$+$i(B synth $B$X$N%F!<%V%k$NCf?H$r0\$94X?t(B
 *
 */

void
#ifdef __STDC__
weight_tbl_to_synth_tbl(void)
#else
weight_tbl_to_synth_tbl(/*void*/)
#endif/* __STDC__ */
{
	input_tbl_to_input_val_tbl();

	output_tbl_to_output_val_tbl();

	return;

}

/*
 *	synth$B$NJQ?t!$%F!<%V%kEy$N=i4|2=(B
 *
 */

void
#ifdef __STDC__
init_synth(void)
#else
init_synth(/*void*/)
#endif/* __STDC__ */
{
	Function_num = Output_num;
	Input_val_num = Input_num;

	init_hash_tbl();
	init_sort_tbl();
	init_in_out_tbl();

	/* weight_peopagation.c$BFb$GJQ99$"$j(B */
	init_order_tbl();
	
	return;

}

/*
 *	$B9=J8LZ$r$b$H$K7W;;$7$?7k2L$r3JG<$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
result_entry(int output_val_tbl_idx, int bdd_result)
#else
result_entry(output_val_tbl_idx, bdd_result)
  int output_val_tbl_idx;
  int bdd_result;
#endif/* __STDC__ */
{

	assert((0 <= output_val_tbl_idx) && (output_val_tbl_idx < Output_num));
	assert((0 < bdd_result) && (bdd_result < Max_node_num));

	 Output_val_tbl[output_val_tbl_idx].pt_to_dag = bdd_result;
	/* fprintf(stderr, "=============> Function %s Output_tbl[%d].pt to DAG node:%d\n",
	   Output_val_tbl[output_val_tbl_idx].output_name, output_val_tbl_idx, Output_val_tbl[output_val_tbl_idx].pt_to_dag);*/

	assert((0 < Free_list_ct) && (Free_list_ct < (Max_node_num - 3)));
	if (Free_list_ct < (int)((1.0 - GC_MARGIN)*(double)Max_node_num)) {
		EDGE_CHECK;
		gc_func();
		assert(((Max_node_num - 1) - Free_list_ct) == get_cur_node_num());
		EDGE_CHECK;
	}

	return;
}


/*
 *	Output_tbl$B$r=g$K8+$J$,$i(Bbdd$B$r:n$C$F$$$/4X?t(B
 *	$B1i;;K\BNItJ,(B
 */

void
#ifdef __STDC__
make_bdd_from_output_tbl(void)
#else
make_bdd_from_output_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;
	int bdd_result;

	for(i=0; i<Output_num; i++){

		bdd_result = apply_syntax_tree(GET_OUTPUT_ROOT(i));

		assert((0 < bdd_result) && (bdd_result < Max_node_num));

		result_entry(i, bdd_result);

	}

	return;

}

/*
 * 	$B=i4|JQ?t=g=x$r7W;;$7$J$$;~$N(B
 *	$B%F!<%V%k$N@_Dj(Bsynth_main$B$KAH$_9~$`(B
 *
 */

void
#ifdef __STDC__
do_not_exec_weight_propagation(void)
#else
do_not_exec_weight_propagation(/*void*/)
#endif/* __STDC__ */
{

	int i;
	int input_idx = Input_num-1;

	/* weight_propagation$B$H(Bsynth$B$G$OJQ?t$N=g0L$,5U$K$J$C$F$$$k(B */
	for(i=0; i<Input_num; i++){
		Order_tbl[i] = input_idx;
		input_idx--;
	}

	
	return;

}
	
/*
 *	synth_main$B$KAH$_9~$_$N4X?t(B
 *
 */

void
#ifdef __STDC__
syntax_to_bdd(void)
#else
syntax_to_bdd(/*void*/)
#endif/* __STDC__ */
{

	weight_tbl_to_synth_tbl();

	make_bdd_from_output_tbl();

	return;

}


/* ---------- end of file 'transform.c' ---------- */
