/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	$BO@M}9g@.%W%m%0%i%`$N(Bmain$BItJ,(B
*
*******************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"
#include "etc.h"
#include "bdd_print.h"
#include "get_system_info.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/* $B4X?t$X$N%]%$%s%?$rMQ0U(B */
#ifdef __STDC__
void (*gc_func)(void);
#else
void (*gc_func)(/* void */);
#endif /* __STDC__ */  


#ifdef __STDC__
extern int yyparse(void);
extern void bdd_init(void);
extern void last_gc(void);
extern void write_verilog(char *);
extern void write_hspice(char *);
extern void write_netlist(char *);
extern void bdd_ps_out(char *);
extern void set_back_pt(void);
extern void gc(void);
extern void gc_and_sift(void);
extern void free_all_area(void);
extern void	set_switch_pattern(void);
extern void calc_delay_with_buf(char *);
extern void weight_main(void);
extern void do_not_exec_weight_propagation(void);
extern void syntax_to_bdd(void);
extern void	check_unused_primary_out(void);
extern void	check_output_tbl(void);
extern void init_synth(void);

#else
extern int yyparse(/* void */);
extern void bdd_init(/* void */);
extern void last_gc(/* void */);
extern void write_verilog(/* char * */);
extern void write_hspice(/* char * */);
extern void write_netlist(/* char * */);
extern void bdd_ps_out(/* char * */);
extern void set_back_pt(/* void */);
extern void gc(/* void */);
extern void gc_and_sift(/* void */);
extern void free_all_area(/* void */);
extern void	set_switch_pattern(/* void */);
extern void calc_delay_with_buf(/* char * */);
extern void weight_main(/* void */);
extern void do_not_exec_weight_propagation(/* void */);
extern void syntax_to_bdd(/* void */);
extern void	check_unused_primary_out(/* void */);
extern void	check_output_tbl(/* void */);
extern void init_synth(/*void*/);

#endif /* __STDC__ */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern FILE *yyin;
extern int LINE_NO;
extern int yylineno;

extern int Before_swap_node_num;

extern int Lower_level_node_ct;
extern int Upper_level_node_ct;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

int Input_val_num;
int Function_num;

int Max_node_num;
int Max_edge_num;
int Ope_cache_size;
int Node_hash_size;
int Edge_free_list_head;

double Const_time;

int Free_list_head;
int Free_list_ct;

val_tbl_t *Input_val_tbl;
output_node_t *Output_val_tbl;

sort_tbl_t *Sort_tbl;
sort_tbl_for_bufins *Bufins_sort_tbl;


node_t *Node_tbl;
edge_t *Edge_tbl;
ope_cache_t *Ope_cache_tbl;
int **Node_hash_tbl;
int *Tmp_hash_tbl_for_swap;

boolean_t Layout_flag;
boolean_t Hspice_cmos_flag;
boolean_t Power_vector_flag;

char Spice_file_name[BUFSIZ];

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

void
#ifdef __STDC__
yyerror(char *str)
#else
yyerror(str)
  char *str;
#endif /* __STDC__ */
{
	fprintf(stderr, "Syntax Error: %s Line: %d\n", str,yylineno);
	exit(-1);
}

int
#ifdef	__STDC__
yywrap(void)
#else
yywrap()
#endif	/* __STDC__ */
{
	return (1);
}


int
#ifdef __STDC__
main(int argc, char **argv)
#else
main(argc, argv)
  int argc;
  char **argv;
#endif /* __STDC__ */
{
	char logic_file_name[BUFSIZ];
	char spice_file_name[BUFSIZ];
	int max_fanout;
	int arg_ct = 1;
	int no_option_ct = 0;
	char option_str[STRSIZE];

	boolean_t eps_flag = FALSE;
	boolean_t hspice_flag = FALSE;
	boolean_t verilog_flag = FALSE;
	boolean_t bddlist_flag = FALSE;
	boolean_t sift_flag = FALSE;
	boolean_t init_order_flag = FALSE;

	/* usage memory information */
	double node_t_mem_size;
	double hash_t_mem_size;
	double cache_t_mem_size;
	double edge_t_mem_size;
	double sum_mem_size;


	Layout_flag = FALSE;
	Hspice_cmos_flag = FALSE;
	Power_vector_flag = FALSE;
	Max_node_num = 0;

	while (--argc) {
		assert(arg_ct > 0);

		if (*argv[arg_ct] == '-') {
			strcpy(option_str, ++argv[arg_ct]);
			if (strcmp(option_str, "eps") == 0)
				eps_flag = TRUE;
			else if (strcmp(option_str, "hspice") == 0)
				hspice_flag = TRUE;
			else if (strcmp(option_str, "hspice_cmos") == 0)
				Hspice_cmos_flag = TRUE;
			else if (strcmp(option_str, "powvec") == 0)
				Power_vector_flag = TRUE;
			else if (strcmp(option_str, "verilog") == 0)
				verilog_flag = TRUE;
			else if (strcmp(option_str, "bddlist") == 0)
				bddlist_flag = TRUE;
			else if (strcmp(option_str, "initorder") == 0)
				init_order_flag = TRUE;
			else if (strcmp(option_str, "sift") == 0)
				sift_flag = TRUE;
			else if (strcmp(option_str, "layout") == 0)
				Layout_flag = TRUE;
			else if ((strcmp(option_str, "h") == 0) ||
					 (strcmp(option_str, "help") == 0)) {
				fprintf(stderr, "\n\t COMMAND\n");
				fprintf(stderr,
						"\t\t %s -[sift|hspice|verilog|eps|bddlist] #Max_node Data\n",
						argv[0]);
				fprintf(stderr, "\n\t OPTIONS\n\n");
				fprintf(stderr, "\t\t -sift\t\tDo Sifting Algorithm for BDD(Default no sifting)\n\n");
				fprintf(stderr, "\t\t -initorder\tDetermine Initial Variable Order(Default no determine)\n\n");
				fprintf(stderr, "\t\t -hspice\tOutput netlist for HSPICE(Default Don't output it)\n\n");
				fprintf(stderr, "\t\t -verilog\tOutput Verilog-HDL(Default Don't output it)\n\n");
				fprintf(stderr, "\t\t -eps\t\tOutput BDD Image EPS(Default Don't output it)\n\n");
				fprintf(stderr, "\t\t -bddlist\tOutput netlist of BDD(Default Don't output it)\n\n");
				fprintf(stderr, "\n\n");
				return -1;
			} else {
				fprintf(stderr, "Unknown Option! : -%s\n",
						option_str);
				fprintf(stderr, "Type follows as :  %s -h (or -help)\n", argv[0]);
				return -1;
			}
		} else {
			if (no_option_ct == 0) {
				if (sscanf(argv[arg_ct], "%d", &Max_node_num) != 1) {
					fprintf(stderr, "[Argument Error]:%s is not integer..\n",
							argv[arg_ct]);
					fprintf(stderr, "\tMax Node Number must be integer number(<= %d).\n",
							MAX_NODE_NUM);
					fprintf(stderr, "Retry!\n");
					return -1;
				}
				fprintf(stderr, "Max_node_num = %d\n", Max_node_num);
				if (Max_node_num > MAX_NODE_NUM) {
					fprintf(stderr, "Max_node_num should be < %d.\n",
							MAX_NODE_NUM);
					fprintf(stderr, "Retry!\n");
					return -1;
				}
				no_option_ct++;
			} else if (no_option_ct == 1) {	/* $BF~NO$NO@M}%U%!%$%k(B */
				f_exist(argv[arg_ct]);
				strcpy(logic_file_name, argv[arg_ct]);
				fprintf(stderr, "Input File Name : %s\n", logic_file_name);
				no_option_ct++;
			} else if (no_option_ct == 2) { /* SPICE$B$N%Q%i%a!<%?%U%!%$%k(B */
				f_exist(argv[arg_ct]);
				strcpy(Spice_file_name, argv[arg_ct]);
				strcpy(spice_file_name, argv[arg_ct]);
				fprintf(stderr, "Spice Parameter File Name : %s\n", Spice_file_name);
				no_option_ct++;
			} else {
				assert(no_option_ct > 3);
				fprintf(stderr, "[Argument Error]:%s\n", argv[arg_ct]);
				return -1;
			}
		}
		arg_ct++;
	}

	if ((hspice_flag == TRUE) && (Layout_flag == TRUE)) {
		fprintf(stderr, "[Argument ERROR]:\n Specify only one of -hspice and -layout.\n");
		fprintf(stderr, "Retry!\n");
		return -1;
	}
	if ((hspice_flag == FALSE) && (Power_vector_flag == TRUE)) {
		fprintf(stderr, "[Argument ERROR]:\n -hspice and -powvec must be ON simultaneously!\n");
		fprintf(stderr, "Retry!\n");
		return -1;
	}
	if ((hspice_flag == FALSE) && (Hspice_cmos_flag == TRUE)) {
		fprintf(stderr, "[Argument ERROR]:\n -hspice and -hspice_cmos must be ON simultaneously!\n");
		fprintf(stderr, "Retry!\n");
		return -1;
	}
	if ((Hspice_cmos_flag == TRUE) && (Power_vector_flag == TRUE)) {
		fprintf(stderr, "[Argument ERROR]:\n Specify only one of -hspice_cmos and -powvec.\n");
		fprintf(stderr, "Retry!\n");
		return -1;
	}

	if (no_option_ct > 4) {
		fprintf(stderr, "[Argument Error]:\nCheck File Name or Max Node Number.\n");
		fprintf(stderr, "Retry!\n");
		return -1;
	}

	/* Sift$B$9$k$+$I$&$+$r%A%'%C%/$7$F!$4X?t$X$N%]%$%s%?$r%;%C%H(B */
	if (sift_flag == FALSE) {
		gc_func = gc;
	} else {
		assert(sift_flag == TRUE);
		gc_func = gc_and_sift;
	}

	/*>>>>>>>>>>>>>>>>> $B$3$3$^$G0z?t$N%A%'%C%/$H%3%^%s%I%i%$%s2r@O(B<<<<<<<<<<<<<<<<<<*/


	Ope_cache_size = (int)((double)Max_node_num * OPE_CACHE_RATIO);

	yyin = fopen(logic_file_name, "rt");
	if (yyin == NULL)
		FOPEN_ERR(logic_file_name);

	bdd_init();

	yyparse();

	check_unused_primary_out();
	check_output_tbl();

	init_synth();

	/* $B=E$_IU$1$K$h$k=i4|JQ?t=g=x$r7hDj$9$k$+!$(B*/
	/* $B%G!<%?%U%!%$%k$KB8:_$7$F$$$k=g=x$G9=C[$9$k$+$r7hDj(B */

	if (init_order_flag == TRUE) {
		/* $B=E$_IU$1$K$h$kJQ?t=g=x$N7hDj(B */
		weight_main();
	} else {
		/* $B$*$b$_$:$1$K$h$kJQ?t=g=x$r$7$J$$;~$O$3$C$A$rA*Br(B */
		assert(init_order_flag == FALSE);
		do_not_exec_weight_propagation();		
	}

	t_start();	/* $B;~4V7WB,3+;O(B */

	/* $B9=J8LZ$+$i(BBDD$B$r:n@.(B */
	syntax_to_bdd();
	
	t_stop();

	printf("BDD Construction rtime = %lf[sec] utime = %lf[sec] stime = %lf[sec]\n",
		   t_getrtime(),
		   t_getutime(),
		   t_getstime());
	fflush(stdout);
	
	fclose(yyin);

	gc_func();

	node_t_mem_size = (double)((Max_node_num*sizeof(node_t))/1000.0);
	hash_t_mem_size = (double)((Node_hash_size*Input_val_num*sizeof(int))/1000.0);
	cache_t_mem_size = (double)((Ope_cache_size*sizeof(ope_cache_t))/1000.0);
	edge_t_mem_size = (double)((Max_edge_num*sizeof(edge_t))/1000.0);
	sum_mem_size = node_t_mem_size + hash_t_mem_size*Input_val_num
		+ cache_t_mem_size + edge_t_mem_size;

	printf("Before Last GC: Node_num : %d\n", (get_cur_node_num() - 2));


	last_gc();	/* $BCf4VJQ?t$N%j%U%!%l%s%9%+%&%s%H$r30$9(B */

	printf("After Last GC: Node_num : %d\n", (get_cur_node_num() - 2));

	/*******************************************************************
	 ********************************************************************
	 ********************************************************************
	 $B$3$3$+$i8e$N=hM}$OI,$:;vA0$K(Blast_gc()$B$r8F$S=P$9$3$H(B
	 ********************************************************************
	 ********************************************************************
	 *******************************************************************/
	
/*	set_back_pt();

	set_switch_pattern();

	t_start();


   calc_delay_with_buf(spice_file_name);

	t_stop();
	printf("Delay Calc. rtime = %lf[sec] utime = %lf[sec] stime = %lf[sec]\n",
		   t_getrtime(),
		   t_getutime(),
		   t_getstime());*/

	printf("***************Printing Informations*************************\n");
	printf("*\n");
	printf("* Program Information\n");
	printf("*          Max Number of Node : %d ---> %3.1lf [KByte]\n",
		   Max_node_num, node_t_mem_size);
	printf("*          Hash Table Size of Each Variable : %d ---> %3.1lf [KByte]\n",
		   Node_hash_size, hash_t_mem_size);
	printf("*          All Hash Table Size : %d ---> %3.1lf [KByte]\n",
		   Node_hash_size*Input_val_num, hash_t_mem_size*Input_val_num);
	printf("*          Cache Table Size : %d ---> %3.1lf [KByte]\n",
		   Ope_cache_size, cache_t_mem_size);
	printf("*          Edge Table Size : %d ---> %3.1lf [KByte]\n",
		   Max_edge_num, edge_t_mem_size);
	printf("*                                    -----------------\n");
	printf("*                                    Sum. %lf [MByte]\n",
		   (sum_mem_size/1000.0));
	printf("*\n");
	printf("*\n");
	
	printf("*\n");
/*	printf("* rtime = %lf[sec], utime = %lf[sec], stime = %lf[sec]\n",
			t_getrtime(),
			t_getutime(),
			t_getstime());*/
/*	printf("*  All time information include BDD Construction, GC(GC and Sift) and Delay Calculation!\n");*/
	printf("*\n");
	printf("*\n*\n*\n");


	printf("* Final Node num : %d\n", (get_cur_node_num() - 2));
	
	print_cur_val_order();
	printf("* \n");
	printf("* \n");
	printf("* #Input Val -------------> %d\n", Input_val_num);
	printf("* #Given Primary Output --> %d\n", given_PO_num());
	printf("* #Middle Variable -------> %d\n", (Function_num - given_PO_num()));
	printf("* #Final Primary Output --> %d\n", final_PO_num());
	printf("* #BDD Node --------------> %d(Max:%d)\n", (get_cur_node_num() - 2), Max_node_num);
	printf("* #nMOS Tr.  -------------> %d\n", cur_nmos_tr_num());
	printf("* #Nega. Signal ----------> %d\n", cur_nega_signal());
	printf("* #Posi. Signal ----------> %d\n", cur_posi_signal()); 

	max_fanout = cur_max_fanout_num();

	printf("* #Max. Fanout -----------> %d\n", max_fanout);

	print_fanout_info(max_fanout);
	printf("*************************************************************\n");

	print_val_num_each_level();

	assert(((Max_node_num - 1) - Free_list_ct) == get_cur_node_num());

	/* output */
	if (eps_flag == TRUE)
		bdd_ps_out(logic_file_name);
	if ((hspice_flag == TRUE) || (Layout_flag == TRUE))
		write_hspice(logic_file_name);
	if (verilog_flag == TRUE)
		write_verilog(logic_file_name);
	if (bddlist_flag == TRUE)
		write_netlist(logic_file_name);
	/* output end */

	print_comment_for_user();

	CHECK_SHANNON_EDGE;
	CHECK_LEVEL_IN_HASH_TBL;
	CHECK_SHARED_NODE;
	FINAL_CHECK_REF_CT;
	CHECK_REF_CT_ON_EACH_NODE;
	CHECK_LEVEL_IN_HASH_TBL;
	CHECK_SAME_NODE_IN_HASH_TBL;
	CHECK_HASH_NODE_NUM; 
	CHECK_COMPLEMENT;


	free_all_area();

	fprintf(stderr, "\t\t\t\t\tProgram Terminated.\n");

	return 0;
}

