/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	2$BJQ?t$N8r49$r9T$J$&$?$a$NNN0h(B
*
*******************************************************************/

#include <stdio.h>
#include <string.h>

#include <stdlib.h>
#include <time.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "bdd_etc.h"
#include "error.h"


/* $B8r49%Q%?%s(B */
typedef enum{PATTERN0, PATTERN1, PATTERN2, PATTERN3} swap_type_t;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern void search_complement(int);
extern int node_hash_func(int, int, int);
extern int node_hash_search(int, int, int);
extern int alloc_node(int, int, int);
extern void entry_into_hash(int, int, int);
extern void delete_node(int);
#else
extern void search_complement(/* int */);
extern int node_hash_func(/* int, int, int */);
extern int node_hash_search(/* int, int, int */);
extern int alloc_node(/* int, int, int */);
extern void entry_into_hash(/* int, int, int */);
extern void delete_node(/* int */);
#endif /* __STDC__ */


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

int Swap_type_tbl[4];	/* $B8r49$N%Q%?%s$r$V$i2<$2$k%F!<%V%k(B */

int Lower_level_node_ct;
int Upper_level_node_ct;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern int *Tmp_hash_tbl_for_swap;
extern val_tbl_t *Input_val_tbl;
extern node_t *Node_tbl;
extern int **Node_hash_tbl;

extern int Free_list_ct;
extern int Free_list_head;

extern int Max_node_num;
extern int Input_val_num;
extern int Node_hash_size;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*
 *		$B8r49%Q%?%s$r$V$i2<$2$k%F!<%V%k$H(B
 *		Temp.$B$N%O%C%7%e%F!<%V%k$r=i4|2=(B
 */

static void
#ifdef __STDC__
clear_swap_tbl(void)
#else
clear_swap_tbl(/* void */)
#endif /* __STDC__ */
{
	int i;

	/* $B8r49%Q%?%s$r$V$i2<$2$k%F!<%V%k$r=i4|2=(B */
	for (i = 0; i < 4; i++)
		Swap_type_tbl[i] = SWAP_TBL_END;

	/* Temp.$B$N%O%C%7%e%F!<%V%k$r=i4|2=(B */
	for (i = 0; i < Node_hash_size; i++)
		Tmp_hash_tbl_for_swap[i] = HASH_END;

	return;
}

/*
 *	swap_val_tbl(lower_level, upper_level);
 *
 *		Input_val_tbl$B$K3JG<$5$l$F$$$kJQ?t$N>l=j$rJQ99$9$k!%(B
 *		Input_val_tbl$B$G$O!$(BInput_val_tbl[i]$B$K%l%Y%k(Bi$B$NJQ?t(B
 *		$B$K4X$9$k>pJs$,3JG<$5$l$F$$$k!%(B
 */		

static void
#ifdef __STDC__
swap_val_in_valtbl(int lower_level, int upper_level)
#else
swap_val_in_valtbl(lower_level,upper_level)
  int upper_level;
  int lower_level;
#endif /* __STDC__ */
{
	char tmp_str[STRSIZE];

	assert((2 < upper_level) && (upper_level < (Input_val_num + 3)));
	assert((2 < lower_level) && (lower_level < (Input_val_num + 3)));
	assert((upper_level - lower_level) == 1);
	
	/* upper$B%l%Y%k$H(Blower$B%l%Y%k$NJQ?tL>$r8r49(B */
	strcpy(tmp_str, Input_val_tbl[upper_level].val);
	strcpy(Input_val_tbl[upper_level].val, Input_val_tbl[lower_level].val);
	strcpy(Input_val_tbl[lower_level].val, tmp_str);

	return;
}

/*
 *	node_idx$B$GI=$5$l$k(BBDD$B$N%N!<%I$r(B pat $B$N%Q%?%s$K=>$C$F!$(B
 *	$B%F!<%V%k(BSwap_type_tbl$B$KEPO?$9$k!%(B
 */

static void
#ifdef __STDC__
entry_to_type_tbl(int node_idx, swap_type_t pat)
#else
entry_to_type_tbl(node_idx, pat)
  int node_idx;
  swap_type_t pat;
#endif /* __STDC__ */
{
	assert((2 < node_idx) && (node_idx < Max_node_num));
	assert((pat == PATTERN0) ||
		   (pat == PATTERN1) ||
		   (pat == PATTERN2) ||
		   (pat == PATTERN3));


	GET_BDD_NEXT(node_idx) = Swap_type_tbl[pat];
	Swap_type_tbl[pat] = node_idx;

	return;
}


/*
 *	select_node_type(level)
 *
 *		$B%l%Y%k$rM?$($i$l$?$i!$8=:_$N$=$N%l%Y%k$N%N!<%I$r%Q%?%s#0!A#3!J#4!K$KJ,N`$9$k!%(B
 *
 *				TYPE0
 *
 *				$B%l%Y%k#0(B		$B%l%Y%k#0$O(Blevel i+1$B$N%N!<%I$N(B	
 *	i$B0J>e(B			  |			0,1$B;^$H$b$K!$(Bi$B0J2<$N%N!<%I$r(B
 *					  |			$B;X$7$F$$$k!%(B
 *	level i+1		node			
 *				   /    \		
 *				  /      \		
 *				 /        \		
 *	level i 	/          \		
 *			   /            \	
 *	i$B0J2<(B     /              \		
 *
 *
 *				TYPE1
 *
 *				$B%l%Y%k#1(B		$B%l%Y%k#0$O(Blevel i+1$B$N%N!<%I$N(B	
 *	i$B0J>e(B			  |			0,1$B;^$H$b$K!$(Bi$B$N%N!<%I$r(B
 *					  |			$B;X$7$F$$$k!%(B
 *	level i+1		node			
 *				   /    \		
 *				  /      \		
 *				 /        \		
 *	level i    node		  node
 *			   / \        /  \	
 *	i$B0J2<(B     /   \      /    \		
 *
 *
 *				TYPE2
 *
 *				$B%l%Y%k#2(B		$B%l%Y%k#2$O(Blevel i+1$B$N%N!<%I$N(B	
 *	i$B0J>e(B			  |			0$B;^$O(Bi$B$N%N!<%I$r$5$7!$(B
 *					  |			1$B;^$O(Bi$B0J2<$N%N!<%I$r;X$9!%(B
 *	level i+1		node			
 *				   /    \		
 *				  /      \		
 *				 /        \		
 *	level i    node        \		
 *			   / \          \	
 *	i$B0J2<(B     /   \          \		
 *
 *
 *				TYPE3
 *
 *
 *				$B%l%Y%k#3(B		$B%l%Y%k#3$O(Blevel i+1$B$N%N!<%I$N(B	
 *	i$B0J>e(B			  |			0$B;^$O(Bi$B0J2<$N%N!<%I$r$5$7(B
 *					  |			1$B;^$O(Bi$B$N%N!<%I$r;X$9!%(B
 *	level i+1		node			
 *				   /    \		
 *				  /      \		
 *				 /        \		
 *	level i 	/         node		
 *			   /          / \	
 *	i+1$B0J2<(B   /          /   \		
 *
 *
 *				TYPE4
 *
 *
 *			$B"((B $B%l%Y%k#4$O!$2<B&!J(Bi$B!K$N%l%Y%k$G$7$+4X78L5$$$N$G!$$3$3$G$O$G$F$3$J$$$,(B
 *							node_type_4()$B$H$$$&4X?t$G9T$J$&=hM}$G$"$k!%(B
 *				$B%l%Y%k#4(B		
 *	i$B0J>e(B			  |			
 *					  |			$B%l%Y%k(B i $B$N%N!<%I$,!$(Bi+1$B$h$j>eB&$N%N!<%I(B
 *	level i+1		  |			$B$+$iD>@\$5$5$l$F$$$k!%(B
 *				      |
 *				      |
 *				      |
 *	level i	         node       
 *			         / \
 *	i+1$B0J2<(B         /   \
 *
 *
 */


static void
#ifdef __STDC__
select_node_type(int level)
#else
select_node_type(level)
  int level;
#endif /* __STDC__ */
{
	int *cur_hash_tbl = Node_hash_tbl[level];
	int cur_node;
	int i;
	int self_level, f0_level, f1_level;
	int move_node;


	for (i = 0; i < Node_hash_size; i++) {
		if (cur_hash_tbl[i] != HASH_END) {
			cur_node = cur_hash_tbl[i];
			while (cur_node != HASH_END) {
				/* $B@hF,$N%N!<%I$r@Z$j=P$9(B */
				move_node = cur_node;
				assert((move_node == HASH_END) ||
					   ((2 < move_node) && (move_node < Max_node_num)));
				/* cur_node$B$r<!$KB`Hr(B */
				cur_node = GET_BDD_NEXT(cur_node);
				assert((cur_node == HASH_END) ||
					   ((2 < cur_node) && (cur_node < Max_node_num)));

				self_level = GET_BDD_LEVEL(move_node);
				f0_level = GET_BDD_LEVEL(GET_BDD_F0(move_node));
				f1_level = GET_BDD_LEVEL(GET_BDD_F1(move_node));

				assert((3 < self_level) && (self_level < (Input_val_num + 3)));
				assert((0 < f0_level) && (f0_level < self_level));
				assert((0 < f1_level) && (f1_level < self_level));

				/* 0$B;^$N%l%Y%k$,<+J,$N2<B&(B */
				if ((f0_level + 1) == self_level) {
					/* 1$B;^$N%l%Y%k$,<+J,$N2<B&(B */
					if ((f1_level + 1) == self_level) {
						entry_to_type_tbl(move_node, PATTERN1);
					} else {
						
						assert((f1_level + 1) < self_level);

						entry_to_type_tbl(move_node, PATTERN2);
					}
				} else {

					assert((f0_level + 1) < self_level);

					/* 1$B;^$N%l%Y%k$,<+J,$N2<B&(B */
					if ((f1_level + 1) == self_level) {
						entry_to_type_tbl(move_node, PATTERN3);
					} else {
						assert((f1_level + 1) < self_level);

						entry_to_type_tbl(move_node, PATTERN0);
					}
				}
			}
			cur_hash_tbl[i] = HASH_END;
		}
	}
	return;
}

/*
 *	$B2<0L$N%l%Y%k$NJQ?t$r!$%O%C%7%e%F!<%V%k$N$^$^NW;~$N%O%C%7%e%F!<%V%k(B
 *	$B$K%3%T!<$7$F$*$/!%(B
 */

static void
#ifdef __STDC__
copy_hash_tbl(int level)
#else
copy_hash_tbl(level)
  int level;
#endif /* __STDC__ */
{
	int *cur_hash_tbl = Node_hash_tbl[level];
	int i;

	assert((2 < level) && (level < (Input_val_num + 3)));

	for (i = 0; i < Node_hash_size; i++) {
		Tmp_hash_tbl_for_swap[i] = cur_hash_tbl[i];
		cur_hash_tbl[i] = HASH_END;
	}
	
	return;
}

/*
 *	$BJQ?t=g=x$N8r49$KH<$$Jx$l$?!$H]Dj4X78$r=&$$D>$9(B 
 */

static void
#ifdef __STDC__
re_search_complement(int node_idx)
#else
re_search_complement(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int comp_node;

	assert((0 < node_idx) && (node_idx < Max_node_num));

	comp_node = GET_BDD_COMP(node_idx);
	if (comp_node != UN_USED) {
		GET_BDD_COMP(comp_node) = UN_USED;
		comp_node = UN_USED;	
	}
	search_complement(node_idx);

	return;
}


/*
 *	delete_node_for_swap(int)
 *
 */

void
#ifdef __STDC__
delete_node_for_swap(int node_idx)
#else
delete_node_for_swap(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int *hash_tbl;
	int hash_idx;
	int level = GET_BDD_LEVEL(node_idx);
	int f0 = GET_BDD_F0(node_idx);
	int f1 = GET_BDD_F1(node_idx);
	int cur_node, prev_node;

	int infinite_loop_ct = 0;

	assert((3 <= node_idx) && (node_idx < Max_node_num));

	assert((0 < level) && (level < (Input_val_num + 3)));
	assert((0 < f0) && (f0 < Max_node_num));
	assert((0 < f1) && (f1 < Max_node_num));

	CHECK_NODE_T(&(Node_tbl[node_idx]));

	if ((node_idx == BDD_FALSE) || (node_idx == BDD_TRUE))
		return;
	
	/* $BNW;~$N%O%C%7%e%F!<%V%k$r;X$9(B */
	hash_tbl = Tmp_hash_tbl_for_swap;

	hash_idx = node_hash_func(level, f0, f1);
	assert((0 <= hash_idx) && (hash_idx < Node_hash_size));

	cur_node = hash_tbl[hash_idx];
	assert((0 < cur_node) && (cur_node < Max_node_num));

	if (cur_node == node_idx) { /* hash table$B$N@hF,$J$i(B */
		hash_tbl[hash_idx] = GET_BDD_NEXT(cur_node);
	} else {
		infinite_loop_ct = 0;
		while (cur_node != node_idx) {
			/* cur_node$B$,30$7$?$$%N!<%I$KC#$9$k$^$G(B */
			prev_node = cur_node;
			cur_node = GET_BDD_NEXT(cur_node);
#if DEBUG > 2			
			infinite_loop_ct++;
			if (infinite_loop_ct > Max_node_num)
				fprintf(stderr, "Infinite LOOP LINE:%d in %s\n",
						__LINE__, __FILE__);
#endif /* DEBUG > 2 */			
		}
		GET_BDD_NEXT(prev_node) = GET_BDD_NEXT(cur_node);
	}
	assert((2 < cur_node) && (cur_node < Max_node_num));

	/* Free_list_head$B$NIU$149$((B */
	GET_BDD_NEXT(cur_node) = Free_list_head;
	Free_list_head = cur_node;
	assert((2 < Free_list_head) && (Free_list_head < Max_node_num));

	Free_list_ct++;
	assert((0 < Free_list_ct) && (Free_list_ct <= (Max_node_num - 3)));

	/* $BITMW$K$J$C$?%N!<%I$,;2>H$7$F$$$?%N!<%I$N(Bref_ct$B$r(BDEC. */
	/* $B$=$N1F6A$G%4%_$,H/@8$9$l$P!$$=$l$b>C5n(B */
	/* $B$^$:(B0$B;^$+$i(B */
	assert(GET_BDD_REF_CT(GET_BDD_F0(cur_node)) > 0);

	
	DEC_REF_CT(GET_BDD_F0(cur_node));
	if ((GET_BDD_F0(node_idx) != BDD_FALSE) &&
		(GET_BDD_F0(node_idx) != BDD_TRUE) &&
		(GET_BDD_REF_CT(GET_BDD_F0(node_idx)) == 0))
		delete_node(GET_BDD_F0(node_idx));
	
	/* $B$D$.$K(B1$B;^(B */	
	assert(GET_BDD_REF_CT(GET_BDD_F1(cur_node)) > 0);

	DEC_REF_CT(GET_BDD_F1(cur_node));
	if ((GET_BDD_F1(node_idx) != BDD_FALSE) &&
		(GET_BDD_F1(node_idx) != BDD_TRUE) &&
		(GET_BDD_REF_CT(GET_BDD_F1(node_idx)) == 0))
		delete_node(GET_BDD_F1(node_idx));

	/* $BH]Dj4X78$NAj<j$N;2>H$rBG$A>C$9(B */
	if (GET_BDD_COMP(cur_node) != UN_USED)
		GET_BDD_COMP(GET_BDD_COMP(cur_node)) = UN_USED;

	/* $BITMQ$K$J$C$?%N!<%I$KL$;HMQ$N0u(B */

	GET_BDD_LEVEL(cur_node) = UN_USED;
	GET_BDD_F0(cur_node) = UN_USED;
	GET_BDD_F1(cur_node) = UN_USED;
	GET_BDD_COMP(cur_node) = UN_USED;

	return;
}

/*
 *	$B8r49$N:]$N2<B&$K$G$-$k%N!<%I$r:n@.$9$k$+H=CG$7$F!$(B
 *	$B:n@.$9$k$J$i!$%O%C%7%e$X$NEPO?$^$G$9$k4X?t!%(B
 */

static int
#ifdef __STDC__
get_child_node(int level, int f0, int f1)
#else
get_child_node(level, f0, f1)
  int level;
  int f0;
  int f1;
#endif /* __STDC__ */
{
	int new_node;

	assert((2 < level) && (level < (Input_val_num + 3)));
	assert((0 < f0) && (f0 < Max_node_num));
	assert((0 < f1) && (f1 < Max_node_num));

	if (f0 == f1)
		return f0;
	else {
		new_node = node_hash_search(level, f0, f1);

		assert((new_node == NOT_EXIST) ||
			   ((2 < new_node) && (new_node < Max_node_num)));

		if (new_node == NOT_EXIST) {
			new_node = alloc_node(level, f0, f1);

			assert((2 < new_node) && (new_node < Max_node_num));

			search_complement(new_node);

			Lower_level_node_ct++;
		}
	}
	assert((2 < new_node) && (new_node < Max_node_num));

	return new_node;
}

/*
 *	$B%N!<%I$K>e=q$-$7$F!$:FEPO?(B
 *
 */

static void
#ifdef __STDC__
re_entry_hash_tbl(int node_idx, int f0, int f1)
#else
re_entry_hash_tbl(node_idx, f0, f1)
  int node_idx;
  int f0;
  int f1;
#endif /* __STC__ */
{
	int hash_idx;

	assert((2 < node_idx) && (node_idx < Max_node_num));
	assert((0 < f0) && (f0 < Max_node_num));
	assert((0 < f1) && (f1 < Max_node_num));

	INC_REF_CT(f0);
	INC_REF_CT(f1);

	GET_BDD_F0(node_idx) = f0;
	GET_BDD_F1(node_idx) = f1;

	re_search_complement(node_idx);

	hash_idx = node_hash_func(GET_BDD_LEVEL(node_idx), f0, f1);
	entry_into_hash(node_idx, GET_BDD_LEVEL(node_idx), hash_idx);

	Upper_level_node_ct++;

	return;
}

/*
 *		$B%Q%?%s#0$N%N!<%I$N8r49(B
 *		
 */

static void
#ifdef __STDC__
node_type_0(int node_idx)
#else
node_type_0(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int hash_idx;
	int old_level;
	int new_level;

	assert((2 < node_idx) && (node_idx < Max_node_num));

	/* $B8E$$%l%Y%k$rJ]B8$7$?$&$($G!$%l%Y%k$r(B -1 */
	old_level = GET_BDD_LEVEL(node_idx);
	GET_BDD_LEVEL(node_idx) = old_level - 1;
	new_level = old_level - 1;

	hash_idx = node_hash_func(new_level, GET_BDD_F0(node_idx), GET_BDD_F1(node_idx));
	entry_into_hash(node_idx, new_level, hash_idx);

	re_search_complement(node_idx);

	Lower_level_node_ct++;
	
	return;
}

/*
 *		$B%Q%?%s#1$N%N!<%I$N8r49(B
 *		
 */

static void
#ifdef __STDC__
node_type_1(int node_idx)
#else
node_type_1(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int level = (GET_BDD_LEVEL(node_idx) - 1);
	int old_f0 = GET_BDD_F0(node_idx);
	int old_f1 = GET_BDD_F1(node_idx);
	int f00 = GET_BDD_F0(GET_BDD_F0(node_idx));
	int f01 = GET_BDD_F1(GET_BDD_F0(node_idx));
	int f10 = GET_BDD_F0(GET_BDD_F1(node_idx));
	int f11 = GET_BDD_F1(GET_BDD_F1(node_idx));
	int new_f0;
	int new_f1;
	
	assert((2 < node_idx) && (node_idx < Max_node_num));

	assert((2 < level) && (level < (Input_val_num + 3)));
	assert((0 < old_f0) && (old_f0 < Max_node_num));
	assert((0 < old_f1) && (old_f1 < Max_node_num));

	assert((0 < f00) && (f00 < Max_node_num));
	assert((0 < f01) && (f01 < Max_node_num));
	assert((0 < f10) && (f10 < Max_node_num));
	assert((0 < f11) && (f11 < Max_node_num));
	
	new_f0 = get_child_node(level, f00, f10);
	new_f1 = get_child_node(level, f01, f11);


	assert((0 < new_f0) && (new_f0 < Max_node_num));
	assert((0 < new_f1) && (new_f1 < Max_node_num));
	
	re_entry_hash_tbl(node_idx, new_f0, new_f1);
	
	assert(GET_BDD_REF_CT(old_f0) > 0);
	DEC_REF_CT(old_f0);

	if (GET_BDD_REF_CT(old_f0) == 0) {
		delete_node_for_swap(old_f0);
	}
	
	assert(GET_BDD_REF_CT(old_f1) > 0);
	DEC_REF_CT(old_f1);

	if (GET_BDD_REF_CT(old_f1) == 0) {
		delete_node_for_swap(old_f1);
	}

	return;
}


/*
 *		$B%Q%?%s#2$N%N!<%I$N8r49(B
 *		
 */

static void
#ifdef __STDC__
node_type_2(int node_idx)
#else
node_type_2(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int level = (GET_BDD_LEVEL(node_idx) - 1);
	int old_f0 = GET_BDD_F0(node_idx);
	int old_f1 = GET_BDD_F1(node_idx);
	int f00 = GET_BDD_F0(old_f0);
	int f01 = GET_BDD_F1(old_f0);
	int f1  = GET_BDD_F1(node_idx);
	int new_f0, new_f1;

	assert((2 < node_idx) && (node_idx < Max_node_num));

	assert((2 < level) && (level < (Input_val_num + 3)));

	assert((0 < old_f0) && (old_f0 < Max_node_num));
	assert((0 < f00) && (f00 < Max_node_num));
	assert((0 < f01) && (f01 < Max_node_num));
	assert((0 < f1) && (f1 < Max_node_num));

	new_f0 = get_child_node(level, f00, f1);
	new_f1 = get_child_node(level, f01, f1);

	assert((0 < new_f0) && (new_f0 < Max_node_num));
	assert((0 < new_f1) && (new_f1 < Max_node_num));

	re_entry_hash_tbl(node_idx, new_f0, new_f1);

	assert(GET_BDD_REF_CT(old_f0) > 0);
	DEC_REF_CT(old_f0);

	if (GET_BDD_REF_CT(old_f0) == 0) {
		delete_node_for_swap(old_f0);
	}

	assert(GET_BDD_REF_CT(old_f1) > 0);
	DEC_REF_CT(old_f1);

/*
 *  f1 $B$OI,$:(Bswap$B8e$K;2>H$5$l$k$N$G$3$N(Bif$BJ8$O$$$i$J$$$N$G$O!)(B
 *  $B$$$l$k$J$i!$(Bdelete_node$B$G$O!)(B
 *       $B#4!?#7(B  by S.Kishimoto
 */
	
/* 	if (GET_BDD_REF_CT(old_f1) == 0) {
		delete_node_for_swap(old_f1);
	} */

	return;
}


/*
 *		$B%Q%?%s#3$N%N!<%I$N8r49(B
 *		
 */

static void
#ifdef __STDC__
node_type_3(int node_idx)
#else
node_type_3(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int level = (GET_BDD_LEVEL(node_idx) - 1);
	int old_f0 = GET_BDD_F0(node_idx);
	int old_f1 = GET_BDD_F1(node_idx);
	int f0 = GET_BDD_F0(node_idx);
	int f10 = GET_BDD_F0(old_f1);
	int f11 = GET_BDD_F1(old_f1);
	int new_f0, new_f1;

	assert((2 < node_idx) && (node_idx < Max_node_num));

	assert((2 < level) && (level < (Input_val_num + 3)));
	assert((0 < old_f1) && (old_f1 < Max_node_num));
	assert((0 < f0) && (f0 < Max_node_num));
	assert((0 < f10) && (f10 < Max_node_num));
	assert((0 < f11) && (f11 < Max_node_num));

	new_f0 = get_child_node(level, f0, f10);
	new_f1 = get_child_node(level, f0, f11);

	re_entry_hash_tbl(node_idx, new_f0, new_f1);

	assert(GET_BDD_REF_CT(old_f1) > 0);
	DEC_REF_CT(old_f1);

	if (GET_BDD_REF_CT(old_f1) == 0) {
		delete_node_for_swap(old_f1);
	}

	assert(GET_BDD_REF_CT(old_f0) > 0);
	DEC_REF_CT(old_f0);

/*
 *  f0 $B$OI,$:(Bswap$B8e$K;2>H$5$l$k$N$G$3$N(Bif$BJ8$O$$$i$J$$$N$G$O!)(B
 *  $B$$$l$k$J$i!$(Bdelete_node$B$G$O!)(B
 *       $B#4!?#7(B  by S.Kishimoto
 */

/* 	if (GET_BDD_REF_CT(old_f0) == 0) {
		delete_node_for_swap(old_f0);
	} 
*/
	
	return;
}


/*
 *		$B%Q%?%s#4$N%N!<%I$N8r49(B
 *		
 */

static void
#ifdef __STDC__
node_type_4(int node_idx)
#else
node_type_4(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int hash_idx;
	int old_level;
	int new_level;

	assert((2 < node_idx) && (node_idx < Max_node_num));

	old_level = GET_BDD_LEVEL(node_idx);

	GET_BDD_LEVEL(node_idx) = old_level + 1;
	new_level = old_level + 1;

	hash_idx = node_hash_func(new_level,
							  GET_BDD_F0(node_idx),
							  GET_BDD_F1(node_idx));

	entry_into_hash(node_idx, new_level, hash_idx);

	re_search_complement(node_idx);
	
	Upper_level_node_ct++;
	
	return;
}

/*
 *	$B;D$j$N%Q%?%s#4$r=hM}$9$k$?$a(B $B$N8F$S$@$785(B
 *
 */

static void
#ifdef __STDC__
post_prces_for_swap(void)
#else
post_prces_for_swap(/* void */)
#endif /* __STDC__ */
{
	int i;
	int cur_node;

	for (i = 0; i < Node_hash_size; i++) {
		cur_node = Tmp_hash_tbl_for_swap[i];

		while (cur_node != HASH_END) {
			Tmp_hash_tbl_for_swap[i] = GET_BDD_NEXT(cur_node);
			node_type_4(cur_node);
			cur_node = Tmp_hash_tbl_for_swap[i];
		}
	}
	return;
}

/*
 *	swap(level i, level (i+1))
 *	BDD$B$N3($N>e$G$O!$(Bi$B$,2<B&!$(B(i+1)$B$,>eB&(B
 */

void
#ifdef __STDC__
swap_val(int lower_level, int upper_level)
#else
swap_val(lower_level, upper_level)
  int lower_level;
  int upper_level;
#endif /* __STDC__ */
{
	int pat;
	int cur_node;
	int move_node;

	assert((2 < lower_level) && (lower_level < (Input_val_num + 3)));
	assert((2 < upper_level) && (upper_level < (Input_val_num + 3)));
	assert((upper_level - lower_level) == 1);


	/* $BJQ?t$N=g=x8r49$N$?$a$NNW;~%O%C%7%e%F!<%V%k$r%j%;%C%H(B */
	clear_swap_tbl();

	/* $BJQ?t$,3JG<$5$l$F$$$k%F!<%V%k$NJQ?t$N>l=j$r8r49(B */
	swap_val_in_valtbl(lower_level, upper_level);

	/* $B>e0L$NJQ?t$r!$8r49$N%Q%?%s!J(B0$B!A(B3$B!K$KJ,N`(B */
	select_node_type(upper_level);

	/* $B2<0L$N%O%C%7%e%F!<%V%k$r$^$k$4$HNW;~%O%C%7%e%F!<%V%k$X%3%T!<(B */
	copy_hash_tbl(lower_level);

	for (pat = 0; pat < 4; pat++) {
		if (Swap_type_tbl[pat] != SWAP_TBL_END) {
			cur_node = Swap_type_tbl[pat];

			assert((cur_node == SWAP_TBL_END) ||
				   ((2 < cur_node) && (cur_node < Max_node_num)));

			while (cur_node != SWAP_TBL_END) {
				move_node = cur_node;
				cur_node = GET_BDD_NEXT(cur_node);

				assert((cur_node == SWAP_TBL_END) ||
					   ((2 < cur_node) && (cur_node < Max_node_num)));
				assert((2 < move_node) && (move_node < Max_node_num));
				
				if (pat == PATTERN0)
					node_type_0(move_node);
				else if (pat == PATTERN1)
					node_type_1(move_node);
				else if (pat == PATTERN2)
					node_type_2(move_node);
				else if (pat == PATTERN3)
					node_type_3(move_node);
				else {
					fprintf(stderr, "Bad Swap Pattern %d LINE:%d in %s\n",
							pat, __LINE__, __FILE__);
					exit(-1);
				}
			}
		}
	}
	
	post_prces_for_swap();

	return;
}
