/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	$BJQ?t=g=x$NF0E*=g=xIU$1$N$?$a$N%U%!%$%k(B
*
*******************************************************************/

#include <stdio.h>
#include <string.h>

#include "debug_level.h"
#include "datatype.h"
#include "bdd_etc.h"
#include "etc.h"
#include "debug.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern void swap_val(int, int);
extern void gc(void);
#else
extern void swap_val(/* int, int */);
extern void gc(/* void */);
#endif /* __STDC__ */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern val_tbl_t *Input_val_tbl;
extern node_t *Node_tbl;
extern int **Node_hash_tbl;
extern sort_tbl_t *Sort_tbl;
extern int Free_list_ct;

extern int Input_val_num;
extern int Max_node_num;
extern int Node_hash_size;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

static int Before_sifting_node_num;
/* Sifting$BA0$NJQ?t$rJ]B8$7$F$*$/!%6/@)=*N;>r7o$N$?$a(B*/

int Before_swap_node_num;
/* static int Before_swap_node_num;*/
static int Min_node_size_level;
static int Min_node_size;

static int Cur_level;

int Lower_level_node_ct;
int Upper_level_node_ct;



/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

static void
#ifdef __STDC__
sort_decrease_node_num(void)
#else
sort_decrease_node_num(/* void */)
#endif /* __STDC__ */
{
	int i, j;
	sort_tbl_t tmp;
	int leftmost, rightmost;

	count_each_level_node();

	leftmost = 3;
	rightmost = Input_val_num + 3;

	/* Input_val_tbl$B$NFbMF$r(BSort_tbl$B$K%3%T!<(B */
	for (i = leftmost; i < rightmost; i++) {
		strcpy(Sort_tbl[i].val, Input_val_tbl[i].val);
		Sort_tbl[i].old_level = Input_val_tbl[i].level;
		Sort_tbl[i].node_num = Input_val_tbl[i].node_num;
	}

	/* $B%N!<%I?t$NB?$$JQ?t=g$K%=!<%H$9$k!%(B*/
	/* $B$?$@$7!$(Bindex$B$N(B0,1,2$B$OL5;k$7$F!$(B3$B!A(B(Input_val_num + 3) */
	/*                          leftmost$B!A(Brightmost           */
	/* $B$^$G$N4V$G$9$k!%(B*/

	for (i = (leftmost + 1); i < rightmost; i++) {
		strcpy(tmp.val, Sort_tbl[i].val);
		tmp.old_level = Sort_tbl[i].old_level;
		tmp.node_num = Sort_tbl[i].node_num;
		
		for (j = (i - 1);
			 (j >= leftmost) && (Sort_tbl[j].node_num < tmp.node_num);
			 j--) {
			strcpy(Sort_tbl[j + 1].val, Sort_tbl[j].val);
			Sort_tbl[j + 1].old_level = Sort_tbl[j].old_level;
			Sort_tbl[j + 1].node_num = Sort_tbl[j].node_num;
		}
		strcpy(Sort_tbl[j + 1].val, tmp.val);
		Sort_tbl[j + 1].old_level = tmp.old_level;
		Sort_tbl[j + 1].node_num = tmp.node_num;
	}

	/* $B%=!<%H8e$N%A%'%C%/(B */
/*	printf("After Sort\n");
	for (i = leftmost; i < rightmost; i++) {
		printf("[%d] val:%s level:%d node_num:%d\n",
			   i, Sort_tbl[i].val, Sort_tbl[i].old_level,
			   Sort_tbl[i].node_num);
	}*/

	return;
}





/*
 *	Sifting$B$KI,MW$JJQ?t$N=i4|2=(B
 *
 */

static void
#ifdef __STDC__
set_val_for_swap(int val_idx)
#else  
set_val_for_swap(val_idx)
  int val_idx;
#endif /* __STDC__ */
{


	assert((2 < val_idx) && (val_idx < (Input_val_num + 3)));

	assert((2 < val_to_level(Sort_tbl[val_idx].val)) &&
		   (val_to_level(Sort_tbl[val_idx].val) < (Input_val_num + 3)));
	
	Cur_level = val_to_level(Sort_tbl[val_idx].val);

	Before_sifting_node_num = Before_swap_node_num;
	Min_node_size = Before_swap_node_num;
	Min_node_size_level = Cur_level;


	return;
}

/*
 *	Input_val_tbl$B$N(Bnode$B?t$rJ]B8$9$k%a%s%P$K(Bswap$B8e$N%N!<%I?t$r=q$-9~$_(B
 *
 */

static void
#ifdef __STDC__
set_node_num_after_swap(int lower_level, int upper_level)
#else
set_node_num_after_swap(lower_level, upper_level)
  int lower_level;
  int upper_level;
#endif /* __STDC__ */
{
	int before_node_sum = 0;
	int after_node_sum = 0;

	assert((2 < lower_level) && (lower_level < (Input_val_num + 3)));
	assert((2 < upper_level) && (Cur_level < (Input_val_num + 3)));
	assert(lower_level == (upper_level - 1));

	before_node_sum = Input_val_tbl[lower_level].node_num +
		Input_val_tbl[upper_level].node_num;

	after_node_sum = Upper_level_node_ct + Lower_level_node_ct;

	Before_swap_node_num -= (before_node_sum - after_node_sum);

	Input_val_tbl[lower_level].node_num = Lower_level_node_ct;
	Input_val_tbl[upper_level].node_num = Upper_level_node_ct;

	return;
}


/*
 *	level$B$r$I$s$I$s2<$2$F$$$/!%(B
 *
 */

static void
#ifdef __STDC__
sift_down(void)
#else
sift_down(/* void */)
#endif /* __STDC__ */
{
	int lower_level;
	
	while (Cur_level > 3) {
		lower_level = Cur_level - 1;

		assert((2 < Cur_level) && (Cur_level < (Input_val_num + 3)));
		assert((2 < lower_level) && (lower_level < (Input_val_num + 3)));

		Upper_level_node_ct = Lower_level_node_ct = 0;

		swap_val(lower_level, Cur_level);

		set_node_num_after_swap(lower_level, Cur_level);

		Cur_level--;

		assert((2 < Cur_level) && (Cur_level < (Input_val_num + 3)));

		if (Before_swap_node_num < Min_node_size) {
			Min_node_size = Before_swap_node_num;
			Min_node_size_level = lower_level;

			assert((2 < Min_node_size_level) &&
				   (Min_node_size_level < (Input_val_num + 3)));

		} else if (Before_swap_node_num > 2*Before_sifting_node_num) {
			break;
		}

	}
	return;
}

/*
 *	$B%l%Y%k$r$I$s$I$s>e$2$F$$$/!%(B
 *
 */

static void
#ifdef __STDC__
sift_up(void)
#else
sift_up(/* void */)
#endif /* __STDC__ */
{
	int upper_level;

	while(Cur_level < (Input_val_num + 2)) { /* Input_val_num+3$B$@$H8r49Aj<jIT:_(B */
		upper_level = Cur_level + 1;

		Upper_level_node_ct = Lower_level_node_ct = 0;

		swap_val(Cur_level, upper_level);

		set_node_num_after_swap(Cur_level, upper_level);

		Cur_level++;

		if (Before_swap_node_num <= Min_node_size) {
			Min_node_size = Before_swap_node_num;
			Min_node_size_level = upper_level;
		} else if (Before_swap_node_num > 2*Before_sifting_node_num) {
			break;
		}
	}
	return;
}

/*
 *	$B:GNI$N%l%Y%k$KJQ?t$r%;%C%H$9$k!%(B
 *
 */

static void
#ifdef __STDC__
set_opt_level(void)
#else
set_opt_level(/* void */)
#endif /* __STDC__ */
{
	int lower_level;

	while (Cur_level != Min_node_size_level) {
		lower_level = Cur_level - 1;

		Upper_level_node_ct = Lower_level_node_ct = 0;

		swap_val(lower_level, Cur_level);

		set_node_num_after_swap(lower_level, Cur_level);

		Cur_level--;
	}
	return;
}

/*
 *	Sifting$B$N:,85(B
 *
 */

static void
#ifdef __STDC__
sifting(int val_idx)
#else
sifting(val_idx)
  int val_idx;
#endif /* __STDC__ */
{
	assert((2 < val_idx) && (val_idx < (Input_val_num + 3)));

	/* val_idx$B$K$"$?$kJQ?t$,B8:_$7$J$$(B */
	if (Sort_tbl[val_idx].node_num == 0)
		return;

	set_val_for_swap(val_idx);


	sift_down();

	sift_up();

	set_opt_level();

	return;
}


/*
 *	Sifting$B$r8F$S=P$9$?$a$N8F$S=P$785(B
 *
 */

static void
#ifdef __STDC__
dynamic_reordering(void)
#else
dynamic_reordering(/* void */)
#endif /* __STDC__ */
{
	int i;

	sort_decrease_node_num();

	Before_swap_node_num = get_cur_node_num();

	for (i = 3; i < Input_val_num; i++) {
		sifting(i);
	}

	return;
}


/*
 *	GC$B$N%?%$%_%s%0$G8F$S=P$7$F!$(BGC -> sift -> GC$B$r9T$J$&4X?t!%(B
 *
 */

void
#ifdef __STDC__
gc_and_sift(void)
#else
gc_and_sift(/* void */)
#endif /* __STDC__ */
{

#if VERBOSE > 2
	printf("*************** GC and Sift *************\n");
#endif /* VERBOSE > 2 */

	gc();
	dynamic_reordering();
	gc();

	assert(((Max_node_num - 1) - Free_list_ct) == get_cur_node_num());	
	
	CHECK_COMPLEMENT;
	CHECK_SAME_NODE_IN_HASH_TBL;
}
