/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	1996$BG/(B2$B7n(B1$BF|@=:n3+;O(B
*	FBDD$B$N(Btype$B$r:n$k$?$a$N%W%m%0%i%`(B
*	$B9=J82r@OIt(B
*	by KANADA.T
*******************************************************************/
#include "debug_level.h"
#include "weight_datatype.h"
#include "debug_macro.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

syntax_t *Syntax_start_pt;		/* $B9=J8LZ$N%N!<%I$N@hF,$N%]%$%s%?(B */
syntax_t *Syntax_free_head_pt;	/* $BL$;HMQ$N9=J8LZ$N%N!<%I$N@hF,$N%]%$%s%?(B */
input_t *Input_tbl;				/* Input_tbl$B$N%]%$%s%?(B */
output_t *Output_tbl;			/* Output_tbl$B$N%]%$%s%?(B*/
primary_t *Primary_tbl;			/* Primary_tbl$B$N%]%$%s%?(B */

int Input_num;					/* $BF~NOJQ?t$N?t(B */
int Output_num;					/* $B=PNOJQ?t$N?t(B */
int Primary_num;				/* primary out$B$N?t(B */

int Input_tbl_idx;				/* $BEPO?2DG=$J(BInput_tbl$B$N%$%s%G%C%/%9(B */
int Output_tbl_idx;				/* $BEPO?2DG=$J(BOutput_tbl$B$N%$%s%G%C%/%9(B */
int Primary_tbl_idx;			/* $BEPO?2DG=$J(BPrinary_tbl$B$N%$%s%G%C%/%9(B */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*
 *	$B0z?t$NL>A0$r(BPrimary_tbl$B$+$iC5$7$@$7$=$N%$%s%G%C%/%9(B
 *	$B$rJV$94X?t$J$1$l$P(BNO_EXIST$B$rJV$9!%(B
 */

int
#ifdef __STDC__
search_primary_tbl(char *name)
#else
search_primary_tbl(name)
  char *name;
#endif/* __STDC__ */
{
	int i;

	for(i=0; i<Primary_num; i++){
		if (strcmp(GET_PRIMARY_NAME(i),name) == 0)
			return i;
	}

	return NO_EXIST;

}


/*
 *	Input_tbl$B$+$i0z?t$NL>A0$NJQ?t$rC5$7(BOutput_tbl$B$N%$%s%G%C%/%9$rJV$94X?t(B
 *	$BJV$jCM$O(Bint $BB8:_$7$J$$;~$O(B-1(NO_EXIST)$B$rJV$9(B  
 */

int
#ifdef __STDC__
search_input_tbl(char *input_name)
#else
search_input_tbl(input_name)
  char *input_name;
#endif/* __STDC__ */
{
	int i;

	for(i=0; i<Input_num; i++){
		if(strcmp(GET_INPUT_NAME(i),input_name) == 0)
			return i;
	}

	return NO_EXIST;

}

/*
 *	Output_tbl$B$+$i0z?t$NL>A0$NJQ?t$rC5$7(BOutput_tbl$B$N%$%s%G%C%/%9$rJV$94X?t(B
 *	$BJV$jCM$O(Bint $BB8:_$7$J$$;~$O(B-1(NO_EXIST)$B$rJV$9(B  
 */

int
#ifdef __STDC__
search_output_tbl(char *output_name)
#else
search_output_tbl(output_name)
  char *output_name;
#endif/* __STDC__ */
{
	int i;

	for(i=0; i<Output_num; i++){
		if(strcmp(GET_OUTPUT_NAME(i),output_name) == 0)
			return i;
	}

	return NO_EXIST;

}
	

/*
 * 	Primary_tbl$B$N=i4|2=4X?t(B
 * 	$B8e$G!$NN0h$N:F3NJ]$b$"$jF@$k(B
 */

void
#ifdef __STDC__
init_primary_tbl(void)
#else
init_primary_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;
	
	Primary_tbl = (primary_t *)malloc(sizeof(primary_t)*Output_num);

	if (Primary_tbl == NULL){
		fprintf(stderr,"Can not get memory !!");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}

	for(i=0; i<Output_num; i++){
		GET_PRIMARY_OUT_IDX(i) = NO_EXIST;
	}
	
	Primary_tbl_idx = 0;
	Primary_num = Output_num;

	return;

}

/*
 *	Primary out$B$r(BPrimary_tbl$B$KEPO?$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
alloc_primary(char *primary_name)
#else
alloc_primary(primary_name)
  char *primary_name;
#endif/* __STDC__ */
{
	int idx;

	assert((0 <= Primary_tbl_idx) && (Primary_tbl_idx <= Output_num));

	/* $BF1$8L>A0$,(BInput_tbl$B$K;H$o$l$F$$$J$$$+$I$&$+$r%A%'%C%/(B */
	idx = search_input_tbl(primary_name);

	assert((NO_EXIST <= idx) && (idx < Input_num));
	
	if (idx != NO_EXIST){
		fprintf(stderr,"Primary out name \"%s\" exist in input_tbl\n",primary_name);
		fprintf(stderr,"Program exit\n");
		exit(-1);
	}
	
	
	/* $BF1$8L>A0$,(BPrimary_tbl$B$KEPO?$5$l$F$$$J$$$+$I$&$+$r%A%'%C%/(B */
	idx = search_primary_tbl(primary_name);

	assert((NO_EXIST <= idx) && (idx < Primary_num));
	
	if (idx != NO_EXIST){
			fprintf(stderr,"Same name \"%s\" exist in primary output\n",primary_name);
			fprintf(stderr,"Program exit\n");
			exit(-1);
	}

	/* FUNCTION$B$N?t0J>e$KEPO?$7$h$&$H$7$?;~(B */
	if (Primary_tbl_idx >= Output_num){
		fprintf(stderr,"FUNCTION is smaller than actual OUTPUT num\n");
		fprintf(stderr,"Program exit\n");
		exit(-1);
	}
	
	strcpy(GET_PRIMARY_NAME(Primary_tbl_idx),primary_name);

	Primary_tbl_idx++;

	return;

}
		
/*
 *	primary out$B$NEPO?$,=*$C$?8e$K(BPrimary_tbl_idx$B$H(BOutput_tbl
 *	$BHf$Y$F!$I,MW$J$i(BPrimary_tbl$B$r:n$jD>$94X?t(B
 */

void
#ifdef __STDC__
reset_primary_tbl(void)
#else
reset_primary_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;
	primary_t *new_tbl;
	
	/* $BA4$F$,(Bprimary out$B$N;~(B */
	if(Primary_tbl_idx == Output_num)
		return;

	/* $B$=$&$G$J$1$l$P:F9=@.(B */
	new_tbl = (primary_t *)malloc(sizeof(primary_t)*Primary_tbl_idx);

	if (new_tbl == NULL){
		fprintf(stderr,"Can not get memory !!");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}

	for(i=0; i<Primary_tbl_idx; i++){
		strcpy(new_tbl[i].primary_name,GET_PRIMARY_NAME(i));
		new_tbl[i].output_tbl_idx = NO_EXIST;
	}
	
	free(Primary_tbl);

	/* $BJQ?t$N=q$-49$((B */
	Primary_tbl = new_tbl;
	Primary_num = Primary_tbl_idx;
	
	return;

}

/*
 *	$B0z?t$H$7$FM?$($i$l$??t;z$r(BInput_num$B$K%;%C%H$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
set_input_num(int number)
#else
set_input_num(number)
  int number;
#endif/* __STDC__ */
{
	assert( 0 < number);

	Input_num = number;

	return;
}

/*
 *	$B0z?t$H$7$FM?$($i$l$??t;z$r(BOutput_num$B$K%;%C%H$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
set_output_num(int number)
#else
set_output_num(number)
  int number;
#endif/* __STDC__ */
{
	assert( 0 < number);

	Output_num = number;

	return;
}

/*
 *	$B9=J8LZ$NNN0h3NJ]$H=i4|2=4X?t(B
 *	$B%W%m%0%i%`<B9T3+;O;~$K9T$J$&NN0h3NJ](B
 */

void
#ifdef __STDC__
init_syntax_tbl(void)
#else
init_syntax_tbl(/* void */)
#endif/* __STDC__ */
{
	int i;
	int last_node = SYNTAX_NODE_NUM-1;

	/* $BNN0h3NJ](B */
	Syntax_free_head_pt = (syntax_t *)malloc(sizeof(syntax_t)*SYNTAX_NODE_NUM);

	if (Syntax_free_head_pt == NULL){
		fprintf(stderr,"Can not get memory !!");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}

	/* $B=i4|2=(B */
	for (i=0; i<last_node ; i++){
		Syntax_free_head_pt[i].is_used_line = TRUE;
		Syntax_free_head_pt[i].left = NULL;
		Syntax_free_head_pt[i].right = NULL;
		Syntax_free_head_pt[i].next = &Syntax_free_head_pt[i+1];
	}

	Syntax_free_head_pt[last_node].is_used_line = TRUE;
	Syntax_free_head_pt[last_node].left = NULL;
	Syntax_free_head_pt[last_node].right = NULL;
	Syntax_free_head_pt[last_node].next = NULL;;

	/* $B%N!<%I$N@hF,$r2!$($F$*$/(B */
	Syntax_start_pt = Syntax_free_head_pt;

	return;


}


/*
 *	$BESCf$G9=J8LZ$N%N!<%I$rDI2C$9$k;~$NNN0h3NJ]4X?t(B
 *
 */

static void
#ifdef __STDC__
add_syntax_tbl(void)
#else
add_syntax_tbl(/* void */)
#endif/* __STDC__ */
{
	int i;
	syntax_t *add_pt;
	int last_node = SYNTAX_NODE_NUM-1;

	/* $BNN0h3NJ](B */
	add_pt = (syntax_t *)malloc(sizeof(syntax_t)*SYNTAX_NODE_NUM);

	if (add_pt == NULL){
		fprintf(stderr,"Can not get memory !!");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}

	/* $B=i4|2=(B */
	for (i=0; i<last_node ; i++){
		add_pt[i].is_used_line = TRUE;
		add_pt[i].left = NULL;
		add_pt[i].right = NULL;
		add_pt[i].next = &add_pt[i+1];
	}

	add_pt[last_node].is_used_line = TRUE;
	add_pt[last_node].left = NULL;
	add_pt[last_node].right = NULL;
	add_pt[last_node].next = NULL;;

	/* $B?7$7$/$H$C$F$-$?NN0h$r(BSyntax_free_head_pt$B$K$D$J$$$G$$$k(B */
	GET_SYNTAX_NEXT(Syntax_free_head_pt) = add_pt;

	return;

}

/*
 *	$BF~NO%F!<%V%k$NNN0h3NJ](B
 *
 */

void
#ifdef __STDC__
init_input_tbl(void)
#else
init_input_tbl(/* void */)
#endif/* __STDC__ */
{
	int i;

	/* $BNN0h3NJ](B */
	Input_tbl = (input_t *)malloc(sizeof(input_t)*Input_num);

	if (Input_tbl == NULL){
		fprintf(stderr,"Can not get memory !\n");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}

	/* $B=i4|2=(B */
	for(i=0; i<Input_num; i++){
		GET_INPUT_WEIGHT(i) = 0;
		GET_INPUT_USED(i) = FALSE;
	}

	/* Input_tbl_idx$B$N=i4|2=(B*/
	Input_tbl_idx = 0;
	
	return;

}

/*
 *	$B=PNO%F!<%V%k$NNN0h3NJ]4X?t(B
 *
 */

void
#ifdef __STDC__
init_output_tbl(void)
#else
init_output_tbl(/* void */)
#endif/* __STDC__ */
{
	int i;

	/* $BNN0h3NJ](B */
	Output_tbl = (output_t *)malloc(sizeof(output_t)*Output_num);

	if (Output_tbl == NULL){
		fprintf(stderr,"Can not get memory !\n");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}

	/* $B=i4|2=(B */
	for(i=0; i<Output_num; i++){
		GET_OUTPUT_WEIGHT(i) = 0;
		GET_OUTPUT_ROOT(i) = NULL;
		GET_OUTPUT_DEPTH(i) = 0;
		GET_OUTPUT_NODE_NUM(i) = 0;
	}

	/* Output_tbl_idx$B$N=i4|2=(B */
	Output_tbl_idx = 0;
	
	return;
}

/*
 *	$BF~NOJQ?t$r(Binput_tbl$B$KEPO?$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
alloc_input(char *input_name)
#else
alloc_input(input_name)
  char *input_name;
#endif/* __STDC__ */
{
	
	assert((0 <= Input_tbl_idx) && (Input_tbl_idx <= Input_num));

	/* $BF1$8L>A0$NJQ?t$,EPO?$5$l$F$$$J$$$+$I$&$+$N%A%'%C%/(B */
	if (search_input_tbl(input_name) != NO_EXIST){
		fprintf(stderr,"Same input name \"%s\" exist\n",input_name);
		fprintf(stderr,"Program exit\n");
		exit(1);
	}
	

	/* Input_tbl$B$NBg$-$5$h$j<B:]$NF~NOJQ?t$N?t$,B?$$$H$-(B */
	if (Input_num <= Input_tbl_idx){
		fprintf(stderr,"INPUTNUM is smaller than actual input number\n");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}
	
	/* $BJQ?t$NEPO?(B */
	strcpy(GET_INPUT_NAME(Input_tbl_idx),input_name);

	Input_tbl_idx++;

	return;

}

/*
 *	$B=PNOJQ?t$r(Boutput_tbl$B$KEPO?$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
alloc_output(char *output_name)
#else
alloc_output(output_name)
  char *output_name;
#endif/* __STDC__ */
{

	int idx;
	
	assert((0 <= Output_tbl_idx) && (Output_tbl_idx <= Output_num));

	/* $BF1$8L>A0$NJQ?t$,F~NOJQ?t$K;H$o$l$F$$$J$$$+%A%'%C%/(B */
	if (search_input_tbl(output_name) != NO_EXIST){
		fprintf(stderr,"Function name \"%s\" exist as input name\n",output_name);
		fprintf(stderr,"Program exit\n");
		exit(1);
	}
	
	
	/* $BF1$8L>A0$NJQ?t$,=PNOJQ?t$K;H$o$l$F$$$J$$$+%A%'%C%/(B */
	if (search_output_tbl(output_name) != NO_EXIST){
		fprintf(stderr,"Same Function name \"%s\" exist\n",output_name);
		fprintf(stderr,"Program exit\n");
		exit(1);
	}


	/* Output_tbl$B$NBg$-$5$h$j<B:]$N=PNOJQ?t$N?t$,B?$$$H$-(B */
	if (Output_num <= Output_tbl_idx){
		fprintf(stderr,"FUNCTION is smaller than actual output number\n");
		fprintf(stderr,"Program exit\n");
		exit(1);
	}

	assert(strcmp(GET_OUTPUT_NAME(Output_tbl_idx),"") == 0);
	
	/* $BEPO?(B */
	strcpy(GET_OUTPUT_NAME(Output_tbl_idx),output_name);

	/* prinmary out$B$J$i(BPrimary_tbl$B$K$bEPO?(B */
	idx = search_primary_tbl(output_name);

	assert((NO_EXIST <= idx) && (idx < Primary_num));

	if (idx != NO_EXIST){
		GET_PRIMARY_OUT_IDX(idx) = Output_tbl_idx;
	}

	
	Output_tbl_idx++;

	return;

}

/*
 *	$BL$;HMQ$N9=J8LZ$N%N!<%I$N8D?t$rD4$Y$FI,MW$G$"$l$P?7$?$K%N!<%I$r3NJ]$9$k4X?t(B
 *
 */

static void
#ifdef __STDC__
check_syntax_node(void)
#else
check_syntax_node(/* void */)
#endif/* __STDC__ */
{
	assert(Syntax_free_head_pt != NULL);
	
	if (GET_SYNTAX_NEXT(Syntax_free_head_pt) == NULL)
		add_syntax_tbl();

	return;

}

/*
 *	$B?7$7$$9=J8LZ$N%N!<%I$r<h$j=P$94X?t(B
 *
 */

static syntax_t * 
#ifdef __STDC__
get_syntax_node(void)
#else
get_syntax_node(/* void */)
#endif/* __STDC__ */
{
	syntax_t *node;

	node = Syntax_free_head_pt;

	assert(node != NULL);

	Syntax_free_head_pt = GET_SYNTAX_NEXT(Syntax_free_head_pt);

	assert(Syntax_free_head_pt != NULL);
	
	/* $BI,MW$G$"$l$P?7$7$/%N!<%I$r3NJ]$9$k(B */
	check_syntax_node();

	return node;

}

/*
 *	$B0z?t$NJQ?t$,(BInput_tbl,Output_tbl$B$KEPO?$5$l$F$$$k$+D4$Y$k4X?t(B
 *	$BEPO?$,$J$$>l9g$O0[>o=*N;(B
 */
void
#ifdef __STDC__
check_var(char *var)
#else
check_var(var)
  char *var;
#endif/* __STDC__ */
{

	int idx;
	
	/* Input_tbl$B$rD4$Y$k(B */
	idx = search_input_tbl(var);

	assert((NO_EXIST <= idx) && (idx < Input_num));

	if(idx != NO_EXIST)
		return;

	/* Output_tbl$B$rD4$Y$k(B */
	idx = search_output_tbl(var);

	assert((NO_EXIST <= idx) && (idx < Output_num));

	if(idx != NO_EXIST)
		return;
	
	/* $B$3$3$^$GMh$?$i0[>o=*N;(B */
	fprintf(stderr,"\"%s\" do not exist in both Input_tbl and Output_tbl.\n",var);
	fprintf(stderr,"Program exit\n");
	exit(1);

	return;

}


/*
 *	$B0z?t$NL>A0$r9=J8LZ$N%N!<%I$KEPO?$7$F%N!<%I$N%]%$%s%?$rJV$94X?t(B
 *	$BJV$jCM$O(B syntax_t *
 */

syntax_t *
#ifdef __STDC__
set_leaf_node(char *leaf_name)
#else
set_leaf_node(leaf_name)
  char *leaf_name;
#endif/* __STDC__ */
{

	syntax_t *node;

	/* leaf_name$B$,(BInput_tbl,Output_tbl$B$KB8:_$7$F$k$+$r%A%'%C%/(B */
	check_var(leaf_name);

	/* $B%N!<%I$r<h$j=P$9(B */
	node = get_syntax_node();

	assert(node != NULL);

	/* $B%N!<%I$N@_Dj(B */
	GET_SYNTAX_TYPE(node) = SY_LEAF;
	strcpy(GET_SYNTAX_NAME(node),leaf_name);

	return node;

}

/*
 *  NOT$B$N%N!<%I$r$D$J$2%N!<%I$N%]%$%s%?$rJV$94X?t(B
 *	$BJV$jCM$O(B syntax_t *
 */

syntax_t *
#ifdef __STDC__
set_not_node(syntax_t *node)
#else
set_not_node(node)
  syntax_t *node;
#endif/* __STDC__ */
{
	syntax_t *not_node;

	assert(node != NULL);
	
	/* $B?7$7$$%N!<%I$r<h$j=P$9(B */
	not_node = get_syntax_node();

/*	PRINT_SYNTAX_NODE10(not_node);*/
	
	assert(not_node != NULL);

	/* $B7?$NEPO?(B */
	GET_SYNTAX_TYPE(not_node) = SY_NOT;

	/* $B$D$J$.9g$o$;(B */
	GET_SYNTAX_LEFT(not_node) = node;

	return not_node;
	
}
	
/*
 *	$B0z?t$N%*%Z%l!<%7%g%s$N%N!<%I$r$D$/$j!$%N!<%I$N:81&$K0z?t$N%N!<%I$r$D$J$2(B
 *	$B%N!<%I$N%]%$%s%?$rJV$94X?t!%JV$jCM$O(Bsyntax_t *
 */

syntax_t *
#ifdef __STDC__
set_ope_node(syntax_t *left_node, syntax_t *right_node, syntax_ope_t ope)
#else
set_ope_node(left_node, right_node, ope)
  syntax_t *left_node;
  syntax_t *right_node;
  syntax_ope_t ope;
#endif/* __STDC__ */
{
	syntax_t *ope_node;

	assert((left_node != NULL) && (right_node != NULL));
	assert((SY_AND <= ope) && (ope <= SY_XOR));
	
	/* $B?7$7$$%N!<%I$N$H$j$@$7(B */
	ope_node = get_syntax_node();

	assert(ope_node != NULL);

	/* $B%N!<%I$N7?$N%;%C%H(B */
	GET_SYNTAX_TYPE(ope_node) = ope;

	/* $B%N!<%I$N$D$J$.9g$o$;(B */
	GET_SYNTAX_LEFT(ope_node) = left_node;
	GET_SYNTAX_RIGHT(ope_node) = right_node;
	
	return ope_node;

}

/*
 *	$B0z?t$NJQ?tL>$K0z?t$N9=J8LZ$N%N!<%I$rEPO?$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
set_syntax_output_tbl(char *output_name, syntax_t *root_node)
#else
set_syntax_output_tbl(output_name, root_node)
  char *output_name;
  syntax_t *root_node;
#endif/* __STDC__ */
{
	int idx;

	assert(root_node != NULL);
	
	/* $B3NEv$9$k%$%s%G%C%/%9$rC5$9(B */
	idx = search_output_tbl(output_name);

	assert((NO_EXIST <= idx) && (idx <Output_num));

	/* $BL5$1$l$PL>A0$r?7$?$KEPO?(B */
	if (idx == NO_EXIST){
		alloc_output(output_name);
		idx = search_output_tbl(output_name);
	}

	assert((0 <= idx) && (idx <Output_num));
	
	/* root$B$NEPO?(B */
	GET_OUTPUT_ROOT(idx) = root_node;

	return;

}

/*
 *	INPUTNUM$B$h$j$bEPO?$5$l$?F~NOJQ?t$,>/$J$$$+$I$&$+$rD4$Y$k4X?t(B
 *	
 */

void
#ifdef __STDC__
check_input_tbl(void)
#else
check_input_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;

	for(i=0; i<Input_num; i++){
		if(strcmp(GET_INPUT_NAME(i),"") == 0){
			fprintf(stderr,"INPUTNUM is bigger than actual input number.\n");
			fprintf(stderr,"Program exit\n");
			exit(1);
		}
	}

	return;

}

/*
 *	FUNCTION$B$h$j$bEPO?$5$l$?=PNOJQ?t$,>/$J$$$+$I$&$+$rD4$Y$k4X?t(B
 *	
 */

void
#ifdef __STDC__
check_output_tbl(void)
#else
check_output_tbl(/*void*/)
#endif/* __STDC__ */
{
	int i;

	for(i=0; i<Output_num; i++){
		if(strcmp(GET_OUTPUT_NAME(i),"") == 0){

			/* BUGBUG */
			printf("output index: %d\n",i);
			
			fprintf(stderr,"FUNCTION is bigger than actual output number.\n");
			fprintf(stderr,"Program exit\n");
			exit(1);
		}
	}

	return;

}

/*
 *	$B;H$o$l$F$$$J$$(Bprimary out$B$,$J$$$+D4$Y$k4X?t(B
 *
 */

void
#ifdef __STDC__
check_unused_primary_out(void)
#else
check_unused_prinary_out(/*void*/)
#endif/* __STDC__ */
{
	int i;
	int flag =0;

	for(i=0; i<Primary_num; i++){
		if (GET_PRIMARY_OUT_IDX(i) == NO_EXIST){
			fprintf(stderr,"OUTPUT %s do not use in this data.\n",GET_PRIMARY_NAME(i));
			flag =1;
		}
	}

	if (flag ==1){
		fprintf(stderr,"Program exit\n");
		exit(-1);
	}

	return;

}
	
	

/* ---------- end of file 'make_syntax.c' ---------- */
