/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

%{
/*******************************************************************
*	1996$BG/(B2$B7n(B1$BF|@=:n3+;O(B
*	$B9=J82r@OIt(B
*   by Konishi,K.
*******************************************************************/
#include "weight_datatype.h"
#include "debug_macro.h"	


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern void set_output_num(int);
extern void set_inout_num(int);
extern void alloc_input(char *);
extern void alloc_output(char *);
extern syntax_t *set_leaf_node(char *);
extern syntax_t *set_not_node(syntax_t *);
extern syntax_t *set_ope_node(syntax_t *, syntax_t *, syntax_ope_t);
extern void set_syntax_output_tbl(char *, syntax_t *);
extern void check_input_tbl(void);
extern void init_primary_tbl(void);
extern void alloc_primary(char *);
extern void reset_primary_tbl(void);
#else
extern void set_output_num(/*int*/);
extern void set_inout_num(/*int*/);
extern void alloc_input(/*char **/);
extern void alloc_output(/*char **/);
extern syntax_t *set_leaf_node(/*char **/);
extern syntax_t *set_not_node(/*syntax_t **/);
extern syntax_t *set_ope_node(/*syntax_t *, syntax_t *, syntax_ope_t*/);
extern void set_syntax_output_tbl(/*char *, syntax_t **/);
extern void check_input_tbl(/*void*/);
extern void init_primary_tbl(/*void*/);
extern void alloc_primary(/*char **/);
extern void reset_primary_tbl(/*void*/);
#endif/* __STDC__ */
	
%}


/*----------$B%k!<%kIt(B---------- */
%union
{
	char *inchar;
	syntax_t *root;
	char buf[BUFSIZ];
	int num;
}

/* $B5-9fDj5AIt(B */
%token LP
%token RP
%token EQUAL
%token COMMENT
%token NL
%token END
%token LC
%token <inchar> INCHAR
%token LB
%token RB
%token FUNCTION
%token INPUTNUM
%token OUTPUT

%token LC

%type <root> expr
%type <buf> name
%type <num> num

/* $B1i;;;RM%@hEY(B */
%left OR NOR
%left XOR XNOR
%left AND NAND
%right NOT

/* $B3+;O5-9f(B */
%start s

%%

/* BNF$B!&%"%/%7%g%sIt(B */
 s:  func input list1 list2 list3 list4

 func: FUNCTION num NL				{set_output_num($2);
									 init_output_tbl();
									 init_primary_tbl();}
										  
     ;

 input: INPUTNUM num NL				{set_input_num($2);
									 init_input_tbl();}
      ;

 num: INCHAR						{$$ = atoi($1);}

    ;

 list1: LB inputs RB NL					{check_input_tbl();
										 PRINT_ALL_INPUT_TBL10;}

      ;

 inputs: INCHAR							{alloc_input($1);}

       | inputs LC INCHAR				{alloc_input($3);}

       ;

 list2: OUTPUT outputs NL				{init_syntax_tbl();
										 reset_primary_tbl();}

      ;

 outputs: INCHAR						{alloc_primary($1);}

        | outputs INCHAR				{alloc_primary($2);}
          
        ;

 list3: line3								

      | list3 line3         				

      ;

 line3: name EQUAL expr NL				{set_syntax_output_tbl($1,$3);
										 /* PRINT_SYNTAX_TREE10($3) */;}
      ;

 expr: expr OR expr						{$$ = set_ope_node($1,$3,SY_OR);}

     | expr NOR expr					{$$ = set_ope_node($1,$3,SY_OR);
										 $$ = set_not_node($$);}
						      
     | expr XOR expr					{$$ = set_ope_node($1,$3,SY_XOR);}

     | expr XNOR expr					{$$ = set_ope_node($1,$3,SY_XOR);
										 $$ = set_not_node($$);}
     						  
     | expr AND expr 					{$$ = set_ope_node($1,$3,SY_AND);}

     | expr NAND expr					{$$ = set_ope_node($1,$3,SY_AND);
										 $$ = set_not_node($$);}

     | NOT expr      					{$$ = set_not_node($2);}
				    		  
     | LP expr RP      					{$$ = $2;}
					    	  
     | INCHAR							{$$ = set_leaf_node($1);}

     ;

 name: INCHAR							{strcpy($$,$1);}
     ;


 list4: END 		           	 		{ YYACCEPT;} 
     ;

%%

/* -----------$B%5%V%k!<%A%sIt(B -----------*/
#include "lex.yy.c"








/* ---------- end of file 'eqn_parse.y' ---------- */
