/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

%{
/**
 **        BDD GENERATOR 1 (lex program)
 **/
%}

%o 4000							/* $B$3$l$,$J$$$H%3%s%Q%$%k$G$-$J$$(B */

/* $B%^%/%mDj5AIt(B */
D [_$a-zA-Z0-9\[\].-]
N [_$a-zA-Z0-9\[\]-]

%%

"~"                  return NOT;
"!"					 return NOT;
"&"                  return AND;
"*"					 return AND;
"|"                  return OR;
"+"					 return OR;
"~&"	             return NAND;
"!*"				 return NAND;
"~|"                 return NOR;
"!+"				 return NOR;
"^"                  return XOR;
"!="				 return XOR;
"~^"                 return XNOR;
"=="				 return XNOR;
"("                  return LP;
")"                  return RP;
"="                  return EQUAL;
"{"                  return LB; 
"}"                  return RB;
">"					 return LC;

"OUTPUT"			 return OUTPUT ;
"FUNCTION"	 	     return FUNCTION;
"INPUTNUM"			 return INPUTNUM;

"end"                return END ;

{D}+{N}*             { yylval.inchar=yytext;
					   return INCHAR ; }
#.*\n                ;
[ \t\n]              ;
;                    return NL ;
.                    return yytext[0] ;

%%
