/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	$BCY1d7W;;$K4X78$"$kItJ,$N%G%P%04X?t72(B
*
*******************************************************************/

#include <stdio.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "bdd_etc.h"
#include "error.h"



/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern int Max_node_num;
extern int Max_edge_num;
extern int Edge_free_list_head;
extern int Input_val_num;
extern int Function_num;

extern int Max_delay_output_idx;

extern node_t *Node_tbl;
extern edge_t *Edge_tbl;
extern output_node_t *Output_val_tbl;
extern val_tbl_t *Input_val_tbl;
extern tr_on_off_tbl_t *Tr_on_off_tbl;
extern tr_usage_tbl_t **Tr_usage_tbl;

extern int *Prim_in_node_list;
extern int Prim_in_node_num;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*
 *	All_free_edge_list$B$,F0:n$7$?8e$K!$(BFree_list$B$KA4It$N(BEdge_node$B$,(B
 *	$B@\B3$5$l$F$$$k$+$I$&$+$r3NG'$9$k$?$a$N4X?t!%(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_all_free_edge_list(int line, char *fname)
#else
check_all_free_edge_list(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int edge_free_list_ct = 0;
	int cur_edge_node;

	
	cur_edge_node = Edge_free_list_head;
	while (cur_edge_node != Max_edge_num) {
		edge_free_list_ct++;
		cur_edge_node = Edge_tbl[cur_edge_node].next;
	}

	if (edge_free_list_ct != Max_edge_num) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "Free_list_node num. = %d, but now %d\n",
				Max_edge_num, cur_edge_node);
		exit(-1);
	} else {
#if VERBOSE > 2
		fprintf(stderr, "[Free_list_node_check OK!]\n");
#endif /* VERBOSE > 2 */		
	}
	
	return;
}

#endif /* DEBUG > 2 */

	
/*
 *	check_back_pt_num	$B%P%C%/%]%$%s%?$N?t$,!$(BREF.CT.$B$H0lCW$7$F$$$k$+!)(B
 *	$B$D$^$j!$(BBack Pointer$B$N8D?t$N$_$N%A%'%C%/!%(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_back_pt_num(int line, char *fname)
#else
check_back_pt_num(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	int back_pt_num;
	int pt;
	boolean_t is_error;

	for (i = 1; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0))
			continue;
		else {
			back_pt_num = 0;
			pt = GET_BDD_BP_LIST(i);

			is_error = FALSE;

			while (pt != BACK_PT_NULL) {
				back_pt_num++;
				assert((0 < back_pt_num) && (back_pt_num < Max_node_num));
				pt = Edge_tbl[pt].next;
			}
			if (back_pt_num != GET_BDD_REF_CT(i)) {
				is_error = TRUE;
				fprintf(stderr, "[ERROR] LINE:%d in %s\n",line, fname);
				fprintf(stderr, "Back Pointer Num :%d Node_tbl[%d].ref_ct :%d\n",
						back_pt_num, i, GET_BDD_REF_CT(i));
			}
		}
	}
	if (is_error == TRUE) {
		exit(-1);
	} else {
#if VERBOSE > 2
		fprintf(stderr, "[Back Pt == Ref.Ct Check OK!] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
	}
	return;
}

#endif /* DEBUG > 2 */


/*
 *	$B%P%C%/%]%$%s%?$,$A$c$s$H;X$;$F$$$k$+$r%A%'%C%/!%(B
 *
 *	********** CAUTION ***********
 *
 *	$B$3$N4X?t$OI,$:!$(Blast_gc$B$r<B9T$7$?8e$K!$<B9T$9$k$3$H!%(B
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_back_pt(int line, char *fname)
#else
check_back_pt(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{

	int i;
	int f0, f1;
	int cur_back_pt;
	int exist_ct;
	boolean_t is_error = FALSE;


	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0))
			continue;
		else {

			if (Node_tbl[i].is_pt_from_pout == TRUE) {
				cur_back_pt = GET_BDD_BP_LIST(i);
				while (cur_back_pt != BACK_PT_NULL) {
					if (Edge_tbl[cur_back_pt].is_PO == TRUE) {
						assert(Output_val_tbl[Edge_tbl[cur_back_pt].from_node].pt_to_dag == i);
						break;
					}
					cur_back_pt = Edge_tbl[cur_back_pt].next;
				}
			}

			/* 0$B;^B&$+$i%A%'%C%/(B */
			f0 = GET_BDD_F0(i);
			
			cur_back_pt = GET_BDD_BP_LIST(f0);
			exist_ct = 0;
			while (cur_back_pt != BACK_PT_NULL) {
				if ((Edge_tbl[cur_back_pt].is_PO == FALSE) &&
					(Edge_tbl[cur_back_pt].from_node == i)) {
					exist_ct++;
					cur_back_pt = Edge_tbl[cur_back_pt].next;
				} else
					cur_back_pt = Edge_tbl[cur_back_pt].next;
			}
			if (exist_ct == 0) {
				fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Not Exist %d in %d-back pt list\n", i, f0);
				is_error = TRUE;
			} else if (exist_ct > 1) {
				fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Multiply Back Pt %d in %d-back pt list\n", i, f0);
				is_error = TRUE;
			} else {
				assert(exist_ct == 1);
			}

			/* 1$B;^B&$r%A%'%C%/(B */
			f1 = GET_BDD_F1(i);
			
			cur_back_pt = GET_BDD_BP_LIST(f1);
			exist_ct = 0;
			while (cur_back_pt != BACK_PT_NULL) {
				if ((Edge_tbl[cur_back_pt].is_PO == FALSE) &&
					(Edge_tbl[cur_back_pt].from_node == i)) {
					exist_ct++;
					cur_back_pt = Edge_tbl[cur_back_pt].next;					
				} else
					cur_back_pt = Edge_tbl[cur_back_pt].next;
			}
			if (exist_ct == 0) {
				fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Not Exist %d in %d-back pt list\n", i, f1);
				is_error = TRUE;
			} else if (exist_ct > 1) {
				fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Multiply Back Pt %d in %d-back pt list\n", i, f1);
				is_error = TRUE;
			} else {
				assert(exist_ct == 1);
			}
		}
	}
	if (is_error == TRUE) {
		exit(-1);
	} else {
#if VERBOSE > 2
		fprintf(stderr, "[check back_pt OK!] LINE;%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
	}

	return;
}

#endif /* DEBUG > 2 */

/*
 *	Transistor $B$N(Bon, off$B$N>uBV$r3F=PNOJQ?t$4$H$K3JG<$7$F$$$k(B
 *	$B%F!<%V%k$rI=<(!%(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
print_tr_on_off_tbl_for_each_output(int line, char *fname)
#else
print_tr_on_off_tbl_for_each_output(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i, j;

	for (i = 0; i < Function_num; i++) {
		printf("************* Output Idx : %d\n LINE:%d in %s", i, line, fname);
		if (Output_val_tbl[i].is_primary_out == TRUE)
			for (j = 3; j < (Input_val_num + 3); j++) {
				printf("level:%d [%s] PHASE:%d usage:%d\n",
					   j, level_to_val(j), Tr_usage_tbl[i][j].phase, Tr_usage_tbl[i][j].usage);
			}
	}
	return;
}

#endif /* DEBUG > 2 */

/*
 *	Transistor $B$N(B on, off$B$N>uBV$rJ];}$9$k%F!<%V%k$NFbMF$rI=<(!%(B
 *
 */

#if DEBUG > 2 

void
#ifdef __STDC__
print_tr_on_off_tbl(int line, char *fname)
#else
print_tr_on_off_tbl(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;

	fprintf(stderr, "******** Print the Tr_on_off_tbl LINE:%d in %s\n", line, fname);
	for (i = 3; i < (Input_val_num + 3); i++)
		fprintf(stderr, "Tr_on_off_tbl[%d]---> %s:max_val:%d phase:%d\n",
				i,
				Input_val_tbl[i].val,
				Tr_on_off_tbl[i].max_val,
				Tr_on_off_tbl[i].phase);

	return;
}

#endif /* DEBUG > 2 */



/*
 *	Primary In$B$N%F!<%V%k$rI=<((B
 *
 */
#if DEBUG > 2

void
#ifdef __STDC__
print_prim_in_tbl(int line, char *fname)
#else
print_prim_in_tbl(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;

	fprintf(stderr, "********** Print Signal Node Information *******LINE:%d in %s\n", line, fname);

	for (i = 0; i < Prim_in_node_num; i++)
		fprintf(stderr, "Prim_in_node_list[%d] ----> %d\n", i, Prim_in_node_list[i]);

	return;
}

#endif /* DEBUG > 2 */

/*
 *	BDD$B$N%N!<%I$NMFNL7W;;(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
print_follows_cap(int line, char *fname)
#else
print_follows_cap(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	char tmp[STRSIZE];

	printf("********** Transistor ON/OFF Information ****LINE:%d in %s\n",
		   line, fname);
	for (i = 3; i < (Input_val_num + 3); i++) {
		strcpy(tmp, level_to_val(i));
		printf("level : %d (%s) ON/OFF : %d\n",
			   i, tmp, Tr_on_off_tbl[i].phase);
	}

	printf("********** Capacitor ***********\n");
	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0))
			printf("Node[%d(LEVEL:%d)].capacitor = %lf[pF]\n",
				   i, GET_BDD_LEVEL(i), Node_tbl[i].follows_cap);
	}

	return;
}

#endif  /* DEBUG > 2 */

/*
 *	$B3F=PNO$NCY1d;~4V$rI=<($9$k!%(B
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
print_delay_time(void)
#else
print_delay_time(/* void */)
#endif /* __STDC__ */
{
	int i;

	printf("************ Delay Time Display Start ****************\n");
						  
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE) {
			if (i == Max_delay_output_idx) {
				printf("Output : %s Max Delay : %lf [nsec]  <------ Max Delay Output\n",
					   Output_val_tbl[i].output_name,
					   Output_val_tbl[i].delay_time);
			} else {
				assert(i != Max_delay_output_idx);
				printf("Output : %s Max Delay : %lf [nsec]\n",
					   Output_val_tbl[i].output_name,
					   Output_val_tbl[i].delay_time);
			}
		}
	}

	return;
}

#endif /* DEBUG > 2 */

