/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	1996$BG/(B2$B7n(B1$BF|@=:n3+;O(B
*	FBDD$B$N(Btype$B$r:n$k$?$a$N%W%m%0%i%`(B
*	$B%G%P%C%0MQ$N%W%j%s%HIt(B
*	by KANADA.T
*******************************************************************/
#include "weight_datatype.h"
#include "debug_macro.h"


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern syntax_t *Syntax_node_head_pt;	
extern input_t *Input_tbl;				
extern output_t *Output_tbl;
extern primary_t *Primary_tbl;
extern int Input_num;					
extern int Output_num;
extern int Primary_num;
extern int Input_tbl_idx;				
extern int Output_tbl_idx;
extern int Primary_tbl_idx;
extern int *Wei_sort_tbl;
extern int *Order_tbl;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#if VERBOSE > 0
/*
 *	$BF~NO%F!<%V%k$NFCDj$NItJ,$rI=<($5$;$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_input_tbl(int line, char *fname, int idx)
#else
print_input_tbl(line, fname, idx)
  int line;
  char *fname;
  int idx;
#endif/* __STDC__ */
{
	printf("--------------- print Input_tbl LINE:%d in %s ---------------\n",line,fname);

	printf("idx: %d, name: %s, weight: %.10lf, is_used: %d\n",
		   idx,
		   GET_INPUT_NAME(idx),
		   GET_INPUT_WEIGHT(idx),
		   GET_INPUT_USED(idx));

	printf("--------------- print end ---------------\n");

	return;
}
#endif/* VERBOSE > 0 */


#if VERBOSE > 0
/*
 *	$BF~NO%F!<%V%k$rI=<($5$;$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_all_input_tbl(int line, char *fname)
#else
print_all_input_tbl(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;
	
	printf("--------------- print all Input_tbl LINE:%d in %s ---------------\n",line,fname);

	for(i=0; i<Input_num; i++){
		printf("idx: %d, name: %s, weight: %.10lf, is_used: %d\n",
			   i,
			   GET_INPUT_NAME(i),
			   GET_INPUT_WEIGHT(i),
			   GET_INPUT_USED(i));
	}
	
	printf("--------------- print end ---------------\n");

	return;

}
#endif/* VERBOSE > 0 */

#if VERBOSE > 0
/*
 *	$B=PNO%F!<%V%k$NFCDj$NItJ,$rI=<($5$;$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_output_tbl(int line, char *fname, int idx)
#else
print_output_tbl(line, fname, idx)
  int line;
  char *fname;
  int idx;
#endif/* __STDC__ */
{
	printf("--------------- print Output_tbl LINE: %d in %s ---------------\n",line,fname);

	printf("node: %d, name: %s, weight: %.10lf, root: %x, max_depth: %d, use_node_num: %d\n",
		   idx,
		   GET_OUTPUT_NAME(idx),
		   GET_OUTPUT_WEIGHT(idx),
		   GET_OUTPUT_ROOT(idx),
		   GET_OUTPUT_DEPTH(idx),
		   GET_OUTPUT_NODE_NUM(idx));

	printf("--------------- print end ---------------\n");

	return;

}
#endif /* VERBOSE > 0 */

#if VERBOSE > 0
/*
 *	$B=PNO%F!<%V%k$rI=<($5$;$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_all_output_tbl(int line, char *fname)
#else
print_all_output_tbl(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int idx;
	
	printf("--------------- print all Output_tbl LINE: %d in %s ---------------\n",line,fname);

	for(idx=0; idx<Output_num; idx++){
		printf("idx: %d, name: %s, weight: %.10lf, root: %x, max_depth: %d, use_node_num: %d\n",
			   idx,
			   GET_OUTPUT_NAME(idx),
			   GET_OUTPUT_WEIGHT(idx),
			   GET_OUTPUT_ROOT(idx),
			   GET_OUTPUT_DEPTH(idx),
			   GET_OUTPUT_NODE_NUM(idx));
	}

	printf("--------------- print end ---------------\n");

	return;

}
#endif/* VERBOSE > 0 */

#if VERBOSE > 0
/*
 *	$B9=J8LZ$N%N!<%I$rI=<($9$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_syntax_node(int line, char *fname, syntax_t *node)
#else
print_syntax_node(line, fname, node)
  int line;
  char *fname;
  int node;
#endif/* __STDC__ */
{
	printf("--------------- print syntax node LINE: %d in %s ---------------\n",line,fname);

	printf("node: %x, type: %d, neme: %s, is_used_line: %d, left: %x, right: %x, next: %x\n",
		   node,
		   GET_SYNTAX_TYPE(node),
		   GET_SYNTAX_NAME(node),
		   GET_SYNTAX_LINE(node),
		   GET_SYNTAX_LEFT(node),
		   GET_SYNTAX_RIGHT(node),
		   GET_SYNTAX_NEXT(node));

	printf("--------------- print end ---------------\n");

	return;

}
#endif/* VERBOSE > 0 */

#if VERBOSE > 0
/*
 *	$B?<$5M%@hC5:w$G9=J8LZ$rI=<((B
 *
 */

static void
#ifdef __STDC__
depth_first_search(syntax_t *node)
#else
depth_first_search(node)
  syntax_t *node;
#endif/* __STDC__ */
{
	if(GET_SYNTAX_LEFT(node) != NULL)
		depth_first_search(GET_SYNTAX_LEFT(node));

	if(GET_SYNTAX_RIGHT(node) != NULL)
		depth_first_search(GET_SYNTAX_RIGHT(node));

	printf("node: %x, type: %d, neme: %s, is_used_line: %d, left: %x, right: %x, next: %x\n",
		   node,
		   GET_SYNTAX_TYPE(node),
		   GET_SYNTAX_NAME(node),
		   GET_SYNTAX_LINE(node),
		   GET_SYNTAX_LEFT(node),
		   GET_SYNTAX_RIGHT(node),
		   GET_SYNTAX_NEXT(node));

	return;

}
#endif/* VERBOSE > 0 */
	
#if VERBOSE > 0
/*
 *	$B9=J8LZ$NLZ$rI=<($9$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_syntax_tree(int line, char *fname, syntax_t *root)
#else
print_syntax_tree(line, fname, root)
  int line;
  char *fname;
  syntax_t *root;
#endif/* __STDC__ */
{
	printf("--------------- print syntax tree LINE: %d in in %s ---------------\n",line,fname);

	depth_first_search(root);
	
	printf("--------------- print end ---------------\n");

	return;

}
#endif/* VERBOSE > 0 */

#if VERBOSE > 0

/*
 *	Primary_tbl$B$rI=<($5$;$k4X?t(B
 *	
 */

void
#ifdef __STDC__
print_primary_out_tbl(int line, char *fname)
#else
print_primary_out_tbl(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int idx;
	int output_idx;
	
	printf("--------------- print primary out LINE: %d in %s ---------------\n",line,fname);

	for(idx=0; idx<Primary_num; idx++){
		output_idx = GET_PRIMARY_OUT_IDX(idx);
		printf("idx: %d, name: %s, out_idx %d,  weight: %.10lf, root: %x, max_depth: %d, use_node_num: %d\n",
			   idx,
			   GET_PRIMARY_NAME(idx),
			   output_idx,
			   GET_OUTPUT_WEIGHT(output_idx),
			   GET_OUTPUT_ROOT(output_idx),
			   GET_OUTPUT_DEPTH(output_idx),
			   GET_OUTPUT_NODE_NUM(output_idx));
	}

	printf("--------------- print end ---------------\n");

	return;

}
#endif/* VERBOSE > 0 */

#if VERBOSE > 0

/*
 *	$B%=!<%H%F!<%V%k$NFbMF$rI=<($9$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_sort_tbl(int line, char *fname)
#else
print_sort_tbl(line,fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;

	printf("--------------- print sort_tbl LINE: %d in %s ---------------\n",line,fname);

	for(i=0; i<Primary_num; i++){
		printf("sort idx: %d, output idx: %d, depth: %d\n",
			   i,
			   Wei_sort_tbl[i],
			   GET_OUTPUT_DEPTH(Wei_sort_tbl[i]));
	}

	printf("--------------- print end ---------------\n");

	return;

}

#endif/* VERBOSE > 0 */

#if VERBOSE > 0
/*
 *	Order_tbl$B$rI=<($5$;$k4X?t(B
 *
 */

void
#ifdef __STDC__
print_all_order_tbl(int line, char *fname)
#else
print_all_order_tbl(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;

	printf("--------------- print Order_tbl LINE: %d in %s ---------------\n",line,fname);

	for(i=0; i<Input_num; i++)
		printf("idx %d, name %s\n",i,GET_INPUT_NAME(Order_tbl[i]));

	printf("--------------- print end ---------------\n");

	return;

}

#endif/* VERBOSE > 0 */

/* ---------- end of file 'debug.c' ---------- */

