/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	1996$BG/(B2$B7n(B1$BF|@=:n3+;O(B
*	FBDD$B$N(Btype$B$r:n$k$?$a$N%W%m%0%i%`(B
*	$B%G%P%C%0MQ$N4X?tIt(B
*	by KANADA.T
*******************************************************************/
#include "debug_level.h"
#include "weight_datatype.h"
#include "debug_macro.h"


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern syntax_t *Syntax_start_pt;
extern syntax_t *Syntax_free_head_pt;	
extern input_t *Input_tbl;				
extern output_t *Output_tbl;
extern primary_t *Primary_tbl;
extern int Input_num;					
extern int Output_num;
extern int Primary_num;
extern int Input_tbl_idx;				
extern int Output_tbl_idx;				
extern int *Wei_sort_tbl;
extern int *Order_tbl;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#if DEBUG > 0
/*
 *	Output_tbl$B$G2!$($F$$$k9=J8LZ$GF1$8$b$N$,$J$$$+$I$&$+(B
 *	$B$r%A%'%C%/$9$k4X?t(B
 */
void
#ifdef __STDC__
check_same_root(int line, char *fname)
#else
check_same_root(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;
	int j;
	int flag = 0;

	for(i=0; i<Output_num; i++){
		for(j=i+1; j<Output_num; j++){
			if( GET_OUTPUT_ROOT(i) == GET_OUTPUT_ROOT(j)){
				fprintf(stderr,"[ERROR]: idx: %d and idx: %d have same syntax root %x LINE: %d in %s.\n",
						i,
						j,
						GET_OUTPUT_ROOT(i),
						line,
						fname);
				
				flag = 1;
			}
		}
	}

	if(flag == 0)
		printf("ROOT CHECK OK\n");

	return;

}
#endif/* DEBUG > 0 */	

#if DEBUG > 0
/*
 *	Input_tbl$B!$(BOutput_tbl$B$KF1$8L>A0$,B8:_$7$F$$$J$$$+$r%A%'%C%/(B
 *
 */
void
#ifdef __STDC__
check_in_out_tbl(int line, char *fname)
#else
check_in_out_tbl(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;
	int j;
	int flag = 0;

	for(i=0; i<Input_num; i++){

		/* Input_tbl vs Input_tbl */
		for(j=i+1; j<Input_num; j++){
			if (strcmp(GET_INPUT_NAME(i),GET_INPUT_NAME(j)) == 0){
				fprintf(stderr,"[ERROR] Same name \"%s\" exist in input_tbl(index: %d,%d) LINE: %d in %s\n",
						GET_INPUT_NAME(i),
						i,
						j,
						line,
						fname);
				flag = 1;
			}
		}

		/* Input_tbl vs Output_tbl */
		for(j=0; j<Output_num; j++){
			if (strcmp(GET_INPUT_NAME(i),GET_OUTPUT_NAME(j)) == 0){
				fprintf(stderr,"[ERROR] Same name \"%s\" exist in Input_tbl:%d, Output_tbl:%d, LINE: %d in %s\n",
						GET_INPUT_NAME(i),
						i,
						j,
						line,
						fname);
				flag = 1;
			}
		}
	}

	/* Output_tbl vs Output_tbl */
	for(i=0; i<Output_num; i++){
		for(j=i+1; j<Output_num; j++){
			if (strcmp(GET_OUTPUT_NAME(i),GET_OUTPUT_NAME(j)) == 0){
				fprintf(stderr,"[ERROR] Same name \"%s\" exist in Output_tbl(index: %d,%d) LINE: %d in %s\n",
						GET_OUTPUT_NAME(i),
						i,
						j,
						line,
						fname);
				flag = 1;
			}
		}
	}

	if (flag == 0)
		printf("VAR_CHECK OK\n");
	

	return;

}
#endif/* DEBUG > 0 */			
			
#if DEBUG > 0
/*
 *	$B%=!<%H%F!<%V%k$r%A%'%C%/$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
check_sort_tbl(int line, char *fname)
#else
check_sort_tbl(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i=0;
	int flag=0;

	for(i=0; i<Primary_num-1; i++){
		if(GET_OUTPUT_DEPTH(Wei_sort_tbl[i]) < GET_OUTPUT_DEPTH(Wei_sort_tbl[i+1])){
			fprintf(stderr,"[ERROR] sort idx %d is smaller than idx %d (out idx %d depth %d < idx %d depth %d) LINE: %d in %s\n",
					i,
					i+1,
					Wei_sort_tbl[i],
					GET_OUTPUT_DEPTH(Wei_sort_tbl[i]),
					Wei_sort_tbl[i+1],
					GET_OUTPUT_DEPTH(Wei_sort_tbl[i+1]),
					line,
					fname);
			flag = 1;
		}
	}

	if (flag == 0)
		printf("SORT_CHECK OK\n");

	return;

}


#endif/* DEBUG > 0 */

#if DEBUG > 0
/*
 *	weight propagation $B$G=E$_$rJ,;6$5$;$?8e$G=E$_$,(B
 *	Output_tbl$B$K;D$C$F$$$J$$$+$r%A%'%C%/$9$k4X?t(B
 */

void
#ifdef __STDC__
check_weight(int line, char *fname)
#else
check_weight(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;
	int flag = 0;
	
	for(i=0; i<Output_num; i++){
		if(GET_OUTPUT_WEIGHT(i) != 0){
			fprintf(stderr,"[ERROR] weight exist in Output_tbl idx: %d, weight: %.10lf LINE: %d in %s\n",
					i,
					GET_OUTPUT_WEIGHT(i),
					line,
					fname);
			flag = 1;
		}
	}


	if (flag == 0)
		printf("WEIGHT_CHECK OK\n");

	return;

}

#endif/* DEBUG > 0 */

#if DEBUG > 0
/*
 *	Primary_tbl$B$N(BOutput_tbl$B$X$N%$%s%G%C%/%9$,$"$C$F$$$k$+$r(B
 *	$B%A%'%C%/$9$k4X?t(B
 */
void
#ifdef __STDC__
check_primary_idx(int line, char *fname)
#else
check_primary_idx(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;
	int out_idx;
	int flag = 0;

	for (i=0; i<Primary_num; i++){
		out_idx = GET_PRIMARY_OUT_IDX(i);
		
		if (strcmp(GET_PRIMARY_NAME(i),GET_OUTPUT_NAME(out_idx)) != 0){
			fprintf(stderr,"[ERROR] Primary_tbl[%d].output_tbl_idx[%d] do not equal to Output_tbl.Pri name %s, Out name %s LINE: %d in %s\n",
					i,
					out_idx,
					GET_PRIMARY_NAME(i),
					GET_OUTPUT_NAME(out_idx),
					line,
					fname);
			flag = 1;
		}
	}

	if (flag == 0)
		printf("PRIMARY CHECK OK\n");

	return;

}

#endif /* DEBUG > 0 */

#if DEBUG > 0

/*
 *	Order_tbl$B$KEPO?$5$l$F$$$J$$JQ?t$,K\Ev$K;H$o$l$F$$$J$$$+$r%A%'%C%/$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
check_unused_input(int line, char *fname, int target)
#else
check_unused_input(line, fname, target)
  int line;
  char *fname;
  int target;
#endif/* __STDC__ */
{
	syntax_t *cur_pt;
	int flag = 0;

	cur_pt = Syntax_start_pt;
	while(cur_pt != Syntax_free_head_pt){

		if(strcmp(GET_SYNTAX_NAME(cur_pt),GET_INPUT_NAME(target)) == 0){
			fprintf(stderr,"[ERROR] input var %s do not exist Order_tbl. it exist in syntax node %x LINE: %d in %s\n",
					GET_INPUT_NAME(target),
					cur_pt,
					line,
					fname);
			flag = 1;
		}

		cur_pt = GET_SYNTAX_NEXT(cur_pt);

	}

	if(flag == 0)
		printf("UNUSED INPUT CHECK OK\n");

	return;

}

#endif/* __STDC__ */

#if DEBUG > 0

/*
 *	$B4{$K(BOeder_tbl$B$KEPO?$5$l$?JQ?t$K=E$_$,;D$C$F$$$J$$$+$r%A%'%C%/$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
check_used_input(int line, char *fname)
#else
check_used_input(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;
	int flag = 0;

	for(i=0; i<Input_num; i++){
		if((GET_INPUT_USED(i) == TRUE) && (0 < GET_INPUT_WEIGHT(i))){
			fprintf(stderr,"[ERROR] Used input idx %d, name\"%s\"  have weight LINE: %d in %s\n",
					i,
					GET_INPUT_NAME(i),
					line,
					fname);
			flag = 1;
		}
	}

	if (flag == 0)
		printf("USED INPUT CHECK OK\n");

	return;

}

#endif/* DEBUG > 0 */					

#if DEBUG > 0
/*
 *	Order_tbl$B$KF1$8JQ?t$,EPO?$5$l$F$$$J$$$+%A%'%C%/(B
 *
 */

void
#ifdef __STDC__
check_order_tbl(int line, char *fname)
#else
check_order_tbl(line, fname)
  int line;
  char *fname;
#endif/* __STDC__ */
{
	int i;
	int j;
	int flag = 0;

	for(i=0; i<Input_num - 1; i++){
		for(j=i+1; j<Input_num; j++){
			if(strcmp(GET_INPUT_NAME(Order_tbl[i]),GET_INPUT_NAME(Order_tbl[j])) == 0){
				fprintf(stderr,"[ERROR] Same Input exist in Order_tbl(idx %d,idx %d, name %s) LINE: %d in %s\n",
						i,
						j,
						GET_INPUT_NAME(Order_tbl[i]),
						line,
						fname);
				flag = 1;
			}
		}
	}

	if (flag == 0)
		printf("ORDER TBL CHECK OK\n");

	return;

}
#endif/* DEBUG > 0 */
/* ---------- end of file 'debug.c' ---------- */
