/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	BDD$B=hM}7O$N%G%P%0@lMQ%3!<%I(B
*	$B<BBN$O%^%/%m$r;HMQ$7$F8F$S=P$9!%(B
*******************************************************************/

#include <stdio.h>

#include "debug_level.h"
#include "datatype.h"
#include "bdd_etc.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern void gc(void);
extern void all_print_node_tbl(int, char *);
#else
extern void gc(/* void */);
extern void all_print_node_tbl(/* int, char * */);
#endif /* __STDC__ */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern val_tbl_t *Input_val_tbl;
extern node_t *Node_tbl;
extern output_node_t *Output_val_tbl;
extern int **Node_hash_tbl;
extern ope_cache_t *Ope_cache_tbl;
extern int Swap_type_tbl[];

extern int Input_val_num;
extern int Max_node_num;
extern int Function_num;
extern int Node_hash_size;
extern int Ope_cache_size;
extern int Free_list_head;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*
 *	$B9=B$BN(Bnode_t$B7?$N%]%$%s%H%A%'%C%/(B
 *	DEBUG > 1$B$GF0:n$9$k!%(B
 */

#if DEBUG > 1

void
#ifdef __STDC__
set_node_t(node_t *pt)
#else
set_node_t(pt)
  node_t *pt;
#endif /* __STDC__ */
{
	pt->uid = NODE_T_UID;
	return;
}

void
#ifdef __STDC__
check_node_t(node_t *pt, int line, char *fname)
#else
check_node_t(pt, line, fname)
  node_t *pt;
  int line;
  char *fname;
#endif /* __STDC__ */
{
	if (pt->uid != NODE_T_UID) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "Bad Point Address\n");
		exit(-1);
	}
	return;
}

#endif /* DEBUG > 1 */


/*
 *	$B9=B$BN(Bope_cache_t$B7?$N%]%$%s%H%A%'%C%/(B
 *	DEBUG > 1$B$GF0:n$9$k!%(B
 */

#if DEBUG > 1

void
#ifdef __STDC__
set_ope_cache_t(ope_cache_t *pt)
#else
set_ope_cache_t(pt)
  ope_cache_t *pt;
#endif /* __STDC__ */
{
	pt->uid = OPE_CACHE_T_UID;
	return;
}

void
#ifdef __STDC__
check_ope_cache_t(ope_cache_t *pt, int line, char *fname)
#else
check_ope_cache_t(pt, line, fname)
  ope_cache_t *pt;
  int line;
  char *fname;
#endif /* __STDC__ */
{
	if (pt->uid != OPE_CACHE_T_UID) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "Bad Point Address\n");
		exit(-1);
	}
	return;
}

#endif /* DEBUG > 1 */

/*
 *	$B9=B$BN(Bval_tbl_t$B7?$N%]%$%s%H%A%'%C%/(B
 *	DEBUG > 1$B$GF0:n$9$k!%(B
 */

#if DEBUG > 1

void
#ifdef __STDC__
set_val_tbl_t(val_tbl_t *pt)
#else
set_val_tbl_t(pt)
  val_tbl_t *pt;
#endif /* __STDC__ */
{
	pt->uid = VAL_TBL_T_UID;
	return;
}

void
#ifdef __STDC__
check_val_tbl_t(val_tbl_t *pt, int line, char *fname)
#else
check_val_tbl_t(pt, line, fname)
  val_tbl_t *pt;
  int line;
  char *fname;
#endif /* __STDC__ */
{
	if (pt->uid != VAL_TBL_T_UID) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "Bad Point Address\n");
		exit(-1);
	}
	return;
}

#endif /* DEBUG > 1 */

/*
 *	$B9=B$BN(Boutput_node_t$B7?$N%]%$%s%H%A%'%C%/(B
 *	DEBUG > 1$B$GF0:n$9$k!%(B
 */

#if DEBUG > 1

void
#ifdef __STDC__
set_output_node_t(output_node_t *pt)
#else
set_output_node_t(pt)
  output_node_t *pt;
#endif /* __STDC__ */
{
	pt->uid = OUTPUT_NODE_T_UID;
	return;
}

void
#ifdef __STDC__
check_output_node_t(output_node_t *pt, int line, char *fname)
#else
check_output_node_t(pt, line, fname)
  output_node_t *pt;
  int line;
  char *fname;
#endif /* __STDC__ */
{
	if (pt->uid != OUTPUT_NODE_T_UID) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "Bad Point Address\n");
		exit(-1);
	}
	return;
}

#endif /* DEBUG > 1 */


/*
 *	$B9=B$BN(Bsort_tbl_t$B7?$N%]%$%s%H%A%'%C%/(B
 *	DEBUG > 1$B$GF0:n$9$k!%(B
 */

#if DEBUG > 1

void
#ifdef __STDC__
set_sort_tbl_t(sort_tbl_t *pt)
#else
set_sort_tbl_t(pt)
  sort_tbl_t *pt;
#endif /* __STDC__ */
{
	pt->uid = SORT_TBL_T_UID;
	return;
}

void
#ifdef __STDC__
check_sort_tbl_t(sort_tbl_t *pt, int line, char *fname)
#else
check_sort_tbl_t(pt, line, fname)
  sort_tbl_t *pt;
  int line;
  char *fname;
#endif /* __STDC__ */
{
	if (pt->uid != SORT_TBL_T_UID) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "Bad Point Address\n");
		exit(-1);
	}
	return;
}

#endif /* DEBUG > 1 */

/*
 *	$B9=B$BN(Bedge_t$B7?$N%]%$%s%H%A%'%C%/(B
 *	DEBUG > 1$B$GF0:n$9$k!%(B
 */

#if DEBUG > 1

void
#ifdef __STDC__
set_edge_t(edge_t *pt)
#else
set_edge_t(pt)
  edge_t *pt;
#endif /* __STDC__ */
{
	pt->uid = EDGE_T_UID;
	return;
}

void
#ifdef __STDC__
check_edge_t(edge_t *pt, int line, char *fname)
#else
check_edge_t(pt, line, fname)
  edge_t *pt;
  int line;
  char *fname;
#endif /* __STDC__ */
{
	if (pt->uid != EDGE_T_UID) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "Bad Point Address\n");
		exit(-1);
	}
	return;
}

#endif /* DEBUG > 1 */

/*
 *	DEBUG > 2$B$G%a%s%P$H$J$k!$%G%P%0MQ%a%s%P$N=i4|2=4X?t(B
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
set_debug_ref_ct_zero(node_t *pt)
#else
set_debug_ref_ct_zero(pt)
  node_t *pt;
#endif /* __STDC__ */
{
	pt->ref_ct_check = 0;
	return;
}

#endif /* DEBUG > 2 */

/*
 *	Node_tbl$B$NITMW$J%N!<%I$r>J$$$?ItJ,$H!$=PNOJQ?t%F!<%V%k$r=PNO$9$k!%(B
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
print_ref_ct_info(int line, char *fname)
#else
print_ref_ct_info(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;

	/* $B=PNOJQ?t$N(BPrimary Out$B$N>pJs$r5-=R$9$k(B */
	
	fprintf(stderr, "******Output Table Information***** LINE:%d in %s\n",
			line, fname);
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE)
			fprintf(stderr, "Output_val_tbl[%d] name:%s pt_to_dag:%d\n",
					i, Output_val_tbl[i].output_name, Output_val_tbl[i].pt_to_dag);
	}

	fprintf(stderr, "******Node Table Information***** LINE:%d in %s\n",
			line, fname);
	for (i = 0; i < Max_node_num; i++) {
		if ((Node_tbl[i].level == UN_USED)||
			(Node_tbl[i].ref_ct == 0))
			continue;
		else {
			fprintf(stderr, "Node_tbl[%d].level:%d f0:%d f1:%d ref_ct:%d\n",
					i, Node_tbl[i].level,
					Node_tbl[i].f0, Node_tbl[i].f1, Node_tbl[i].ref_ct);
		}

	}
	return;
}

#endif /* DEBUG > 2 */

/*
 *	$BF~NOJQ?t$N%F!<%V%k$rI=<($9$k(B
 */

#if DEBUG > 3
void
#ifdef __STDC__
print_input_val(int line, char *fname)
#else
print_input_val(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;

	printf("***************************************\n");
	printf("******* Input_val_tbl Information *****\n");
	printf("******* LINE:%d in %s\n", line, fname);
	printf("***************************************\n");
	for (i = 0; i < (Input_val_num + 3); i++) {
		/* +3$B$9$k$N$O!$(Bindex$B$N(B0,1,2$B$OFC<l$JNN0h$H$7$F;HMQ$7$F$$$J$$$+$i(B */
		printf("Input_val_tbl[%d] val:%s level:%d\n",
			   i, Input_val_tbl[i].val, Input_val_tbl[i].level);
	}
	printf("******************* END ***************\n");

	return;
}

#endif /* DEBUG > 3 */

/*
 *	0$B;^$H(B1$B;^$,F1$8>l=j$r;X$7$F$$$k%N!<%I$,$J$$$+$I$&$+$rD4$Y$k!%(B
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_shannon_edge(int line, char *fname)
#else
check_shannon_edge(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	boolean_t error = FALSE;

	for (i = 3; i < Max_node_num; i++)
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0) &&
			(GET_BDD_F0(i) == GET_BDD_F1(i))) {
			fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
			fprintf(stderr, "Shannon Edge Exist in Node_tbl[%d]\n", i);
			error = TRUE;
		}

	if (error == FALSE) {
#if VERBOSE > 2
		fprintf(stderr, "[Shannon Edge Check OK] LINE:%d in %s\n",
				line, fname);
#endif /* VERBOSE > 2 */
	} else {
		print_ref_ct_info(__LINE__, __FILE__);
		exit(-1);
	}
	return;
}

#endif /* DEBUG > 2 */

/*
 *
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_shared_node(int line, char *fname)
#else
check_shared_node(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i, j;
	int cur_level;
	int cur_f0, cur_f1;
	boolean_t is_error = FALSE;

	for (i = 0; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0)) {
			cur_level = GET_BDD_LEVEL(i);
			cur_f0 = GET_BDD_F0(i);
			cur_f1 = GET_BDD_F1(i);
			for (j = 0; j < Max_node_num; j++) {
				if ((GET_BDD_LEVEL(j) == UN_USED) ||
					(GET_BDD_REF_CT(j) == 0))
					continue;
				else {
					if ((j != i) &&
						(GET_BDD_LEVEL(j) == cur_level) &&
						(GET_BDD_F0(j) == cur_f0) &&
						(GET_BDD_F1(j) == cur_f1)) {
						fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
						fprintf(stderr, "Same Node Exist %d <-> %d\n", i, j);
						fprintf(stderr, "[%d] level:%d f0:%d f1:%d ref_ct:%d\n",
								i, GET_BDD_LEVEL(i), GET_BDD_F0(i), GET_BDD_F1(i),
								GET_BDD_REF_CT(i));
						fprintf(stderr, "[%d] level:%d f0:%d f1:%d ref_ct:%d\n",
								j, GET_BDD_LEVEL(j), GET_BDD_F0(j), GET_BDD_F1(j),
								GET_BDD_REF_CT(j));
						is_error = TRUE;
					}
				}
			}
		}
	}
	if (is_error == FALSE) {
#if VERBOSE > 2		
		fprintf(stderr, "[Same Node Check OK] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */
	} else {
		print_ref_ct_info(__LINE__, __FILE__);
	}

	return;
}

#endif /* DEBUG > 2 */

/*
 *
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_ref_ct_on_each_node(int line, char *fname)
#else
check_ref_ct_on_each_node(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	boolean_t is_error = FALSE;

	for (i = 0; i < Max_node_num; i++)
		Node_tbl[i].ref_ct_check = 0;

	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE)
			(Node_tbl[Output_val_tbl[i].pt_to_dag].ref_ct_check)++;
	}


	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED)||
			(GET_BDD_REF_CT(i) == 0))
			continue;
		else {
			(Node_tbl[GET_BDD_F0(i)].ref_ct_check)++;
			(Node_tbl[GET_BDD_F1(i)].ref_ct_check)++;
		}
	}

	for (i = 1; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED)||
			(GET_BDD_REF_CT(i) == 0))
			continue;
		else {
			if (Node_tbl[i].ref_ct != Node_tbl[i].ref_ct_check) {
				fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
				is_error = TRUE;
			}
		}
	}

	if (is_error == TRUE) {
		all_print_node_tbl(__LINE__, __FILE__);
		exit(-1);
	} else {
#if VERBOSE > 2
		fprintf(stderr, "[Check_ref_ct_on_each_node OK] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
	}

	return;
}


#endif /* DEBUG > 2 */

/*
 *	Reference Count$B$NAm9g%A%'%C%/!%$?$@$7!$%W%m%0%i%`$N:G8e$K(BGC$B$r$+$1$?8e$O(B
 *	$B$3$l$N<!$K$"$k(Bfinal_check_ref_ct$B$r;H$&$3$H!%(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_ref_ct(int line, char *fname)
#else
check_ref_ct(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i, j, k;
	int ref_ct;
	boolean_t is_error = FALSE;

	for (i = 1; i < Max_node_num; i++) {
		ref_ct = 0;
		
		if (GET_BDD_LEVEL(i) != UN_USED) {
			
			/* root$B$N$&$A$G(Bi$B$r;X$7$F$$$k$b$N$N8D?t(B */
			for (k = 0; k < Function_num; k++) {
				if (Output_val_tbl[k].pt_to_dag == i)
					ref_ct++;
			}

			for (j = 0; j < Max_node_num; j++) {
				if ((GET_BDD_LEVEL(j) != UN_USED) &&
					((GET_BDD_F0(j) == i) || (GET_BDD_F1(j) == i)))
					ref_ct++;
			}


			if (GET_BDD_REF_CT(i) != ref_ct) {
				fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Illegal Ref.ct Node_tbl[%d]\n", i);
				fprintf(stderr, "Node_tbl[%d].ref_ct = %d not equal %d\n",
						i, Node_tbl[i].ref_ct, ref_ct);
				is_error = TRUE;
			}
		}
	}
	if (is_error == FALSE) {
#if VERBOSE > 2		
		fprintf(stderr, "[Refernece Count Check OK] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
	} else {
		print_ref_ct_info(__LINE__, __FILE__);
	}
		

	return;
}
 
#endif /* DEBUG > 2 */

/*
 *	Reference Count$B$N%A%'%C%/!%$?$@$7!$%W%m%0%i%`$N:G8e$K(BGC$B$r$+$1$?8e$N$_(B
 *	$B;HMQ2DG=!%ESCf$G8F$S$?$$$H$-$O!$>e$N(Bcheck_ref_ct$B$r;HMQ$9$k$3$H!%(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
final_check_ref_ct(int line, char *fname)
#else
final_check_ref_ct(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i, j, k;
	int ref_ct;
	boolean_t is_error = FALSE;

	for (i = 1; i < Max_node_num; i++) {
		ref_ct = 0;
		
		if (GET_BDD_LEVEL(i) != UN_USED) {
			
			/* root$B$N$&$A$G(Bi$B$r;X$7$F$$$k$b$N$N8D?t(B */
			/* $BCf4VJQ?t$N%]%$%s%H$OL5;k$9$k(B */
			for (k = 0; k < Function_num; k++) {
				if ((Output_val_tbl[k].is_primary_out == TRUE) &&
					(Output_val_tbl[k].pt_to_dag == i)) {
					ref_ct++;
				}
			}

			for (j = 0; j < Max_node_num; j++) {
				if ((GET_BDD_LEVEL(j) != UN_USED) &&
					((GET_BDD_F0(j) == i) || (GET_BDD_F1(j) == i)))
					ref_ct++;
			}

			if (GET_BDD_REF_CT(i) != ref_ct) {
				fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Illegal Ref.ct Node_tbl[%d]\n", i);
				fprintf(stderr, "Node_tbl[%d].ref_ct = %d not equal %d\n",
						i, Node_tbl[i].ref_ct, ref_ct);
				is_error = TRUE;
			}
		}
	}
	if (is_error == FALSE) {
#if VERBOSE > 2
		fprintf(stderr, "[Final Refernece Count Check OK] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */
	} else {
		print_ref_ct_info(__LINE__, __FILE__);
	}

	return;
}
 
#endif /* DEBUG > 2 */

/*
 *	print_hash_image
 *
 */

#if DEBUG > 2 

void
#ifdef __STDC__
print_hash_image(int line, char *fname)
#else
print_hash_image(line, fname)
  int	line;
  char	*fname;
#endif /* __STDC__ */
{
	int i, j;
	int *cur_hash_tbl;
	int cur_node;

	printf("*************** HASH TABLE INFORMATION ** LINE:%d in %s\n",
		   line, fname);
	printf("Now, Node_hash_size = %d\n", Node_hash_size);
	
	for (i = 3; i < Input_val_num + 3; i++) {
		cur_hash_tbl = Node_hash_tbl[i];

		printf("------------- level %d-----------\n", i);
		for (j = 0; j < Node_hash_size; j++) {
			if (cur_hash_tbl[j] != HASH_END) {
				cur_node = cur_hash_tbl[j];
				while (cur_node != HASH_END) {
					printf("[%d] level:%d f0:%d f1:%d ref_ct:%d next:%d comp:%d\n",
						   cur_node,
						   GET_BDD_LEVEL(cur_node),
						   GET_BDD_F0(cur_node),
						   GET_BDD_F1(cur_node),
						   GET_BDD_REF_CT(cur_node),
						   GET_BDD_NEXT(cur_node),
						   GET_BDD_COMP(cur_node));
					cur_node = GET_BDD_NEXT(cur_node);
				}
			}
		}
	}
	return;
}
#endif /* DEBUG > 2 */

/*
 *	print_hash_image_each_level
 *
 */

#if DEBUG > 2 

void
#ifdef __STDC__
print_hash_image_each_level(int level, int line, char *fname)
#else
print_hash_image_each_level(level, line, fname)
  int level;
  int	line;
  char	*fname;
#endif /* __STDC__ */
{
	int j;
	int *cur_hash_tbl;
	int cur_node;

	printf("*************** HASH TABLE INFORMATION on EACH LEVEL** LINE:%d in %s\n",
		   line, fname);
	printf("Now, Node_hash_size = %d\n", Node_hash_size);
	
	cur_hash_tbl = Node_hash_tbl[level];
	
	printf("------------- level %d-----------\n", level);
	for (j = 0; j < Node_hash_size; j++) {
		if (cur_hash_tbl[j] != HASH_END) {
			cur_node = cur_hash_tbl[j];
			while (cur_node != HASH_END) {
				printf("[%d] level:%d f0:%d f1:%d ref_ct:%d next:%d comp:%d\n",
					   cur_node,
					   GET_BDD_LEVEL(cur_node),
					   GET_BDD_F0(cur_node),
					   GET_BDD_F1(cur_node),
					   GET_BDD_REF_CT(cur_node),
					   GET_BDD_NEXT(cur_node),
					   GET_BDD_COMP(cur_node));
				cur_node = GET_BDD_NEXT(cur_node);
			}
		}
	}

	return;
}
#endif /* DEBUG > 2 */


/*
 *
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
print_ope_cache(int line, char *fname)
#else
print_ope_cache(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;


	printf("*********** OPE CACHE INFORMATION LINE:%d in %s\n", line, fname);
	for (i = 0; i < Ope_cache_size; i++) {
		if (Ope_cache_tbl[i].ope != NO_OP)
			printf("OPE[%d] : bdd1:%d bdd2:%d ope:%d result:%d\n",
				   i, 
				   Ope_cache_tbl[i].bdd1,
				   Ope_cache_tbl[i].bdd2,
				   Ope_cache_tbl[i].ope,
				   Ope_cache_tbl[i].result);
	}
	return;
}

#endif /* DEBUG > 2 */

/*
 *
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
all_print_node_tbl(int line, char *fname)
#else
all_print_node_tbl(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	int cur_bp_list;

	printf("*********** Node Table All Print ***LINE:%d in %s\n",
		   line, fname);
	for (i = 0; i < Max_node_num; i++) {
		printf("[%d] level:%d f0:%d f1:%d ref_ct:%d complement:%d from_f0:%d from_f1:%d all:%d part:%d buf:%d phase:%d\n",
			   i, GET_BDD_LEVEL(i),
			   GET_BDD_F0(i), GET_BDD_F1(i),
			   GET_BDD_REF_CT(i),
			   GET_BDD_COMP(i),
			   Node_tbl[i].from_f0, Node_tbl[i].from_f1,
			   Node_tbl[i].all, Node_tbl[i].part,
			   Node_tbl[i].is_buf_inserted, Node_tbl[i].phase);
		/* Back Pointer $B$N=PNO(B */
	/*	cur_bp_list = GET_BDD_BP_LIST(i);
		while(cur_bp_list != BACK_PT_NULL) {
			printf("%d \n", cur_bp_list);
			cur_bp_list = GET_BDD_BP_LIST(cur_bp_list); 
		} */
	}
	return;
}

#endif /* DEBUG > 2 */

/*
 *
 *
 */


#if DEBUG > 2

void
#ifdef __STDC__
print_free_list(int line, char *fname)
#else
print_free_list(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int cur_node = Free_list_head;

	printf("********** Free List Connect Information *** LINE:%d in %s\n",
		   line, fname);
	while (cur_node != Max_node_num) {
		printf("%d ", cur_node);
		cur_node = GET_BDD_NEXT(cur_node);
	}
	printf("\n");
	return;
}

#endif /* DEBUG > 2 */


/*
 *
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
edge_check(int line, char *fname)
#else
edge_check(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	boolean_t is_error = FALSE;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0)) {
			/* $BJQ$J>l=j$r;X$7$F$$$J$$$+%A%'%C%/(B */
			if ((GET_BDD_F0(i) <= 0) && (GET_BDD_F0(i) >= Max_node_num)) {
				fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Node_tbl[%d].f0 = %d is bad number.\n",
						i, GET_BDD_F0(i));
				is_error = TRUE;
			}
			if ((GET_BDD_F1(i) <= 0) && (GET_BDD_F1(i) >= Max_node_num)) {
				fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Node_tbl[%d].f1 = %d is bad number.\n",
						i, GET_BDD_F1(i));
				is_error = TRUE;
			}
		}
	}
	if (is_error == FALSE) {
#if VERBOSE > 2
		fprintf(stderr, "[EDGE CHECK OK] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
		return;
	} else {
		all_print_node_tbl(__LINE__, __FILE__);
		exit(-1);
	}
	return;
}


#endif /* DEBUG > 2 */

/*
 *		Hash $B%F!<%V%k$K$V$i$5$,$C$F$$$k%N!<%I?t$H!$(B
 *		$B<B:]$N%N!<%I?t$N@09g@-$H%A%'%C%/(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_hash_node_num(int line, char *fname)
#else
check_hash_node_num(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int hash_ct = 0;
	int i;

	gc();

	/* gc$B$r$+$1$F$+$i%N!<%I?t$r%+%&%s%H$9$k$3$H(B */
	count_each_level_node();

	for (i = 3; i < (Input_val_num + 3); i++)
		hash_ct += Input_val_tbl[i].node_num;

	hash_ct += 2;	/* 0,1$B$NJ,(B */

	if (hash_ct != get_cur_node_num()) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
		fprintf(stderr, "(Number of node entried in hash tbl) not equal (get_cur_node)\n");
		exit(-1);
	} else {
#if VERBOSE > 2
		fprintf(stderr, "[CHECK HASH NODE NUMBER OK!]: LINE:%d in %s\n",line, fname);
#endif /* VERBOSE > 2 */		
	}

	return;
}


#endif /* DEBUG > 2 */

/*
 *	$B%l%Y%k(Bi$B$N%O%C%7%e%F!<%V%k$K0[$J$k%l%Y%k$N%N!<%I$,EPO?$5$l$F$$$J$$$+!)(B
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_level_in_hash_tbl(int line, char *fname)
#else
check_level_in_hash_tbl(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i, j;
	int *cur_hash_tbl;
	int cur_node;
	boolean_t is_error = FALSE;

	for (i = 3; i < Input_val_num + 3; i++) {
		cur_hash_tbl = Node_hash_tbl[i];

		for (j = 0; j < Node_hash_size; j++) {
			if (cur_hash_tbl[j] != HASH_END) {
				cur_node = cur_hash_tbl[j];
				while (cur_node != HASH_END) {
					if (GET_BDD_LEVEL(cur_node) != i) {
						fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
						fprintf(stderr, "In table level:%d, but Node_tbl[%d].level = %d\n",
								i, i, Node_tbl[cur_node].level);
						is_error = TRUE;
					}
					cur_node = GET_BDD_NEXT(cur_node);
				}
			}
		}
	}
	if (is_error == TRUE) {
		exit(-1);
	} else {
#if VERBOSE > 2
		fprintf(stderr, "[Check Level in Hash Table OK] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
		return;
	}
}

#endif /* DEBUG > 2 */

/*
 *	$B%O%C%7%e%F!<%V%k$KF1$8%N!<%I$,(B2$B=EEPO?$5$l$F$$$J$$$+!)(B
 *
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_same_node_in_hash_tbl(int line, char *fname)
#else
check_same_node_in_hash_tbl(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i, j;
	int *cur_hash_tbl;
	int cur_node;
	boolean_t is_error = FALSE;
	int exist_ct;
	int search_node;

	for (i = 3; i < Input_val_num + 3; i++) {
		cur_hash_tbl = Node_hash_tbl[i];

		for (j = 0; j < Node_hash_size; j++) {
			if (cur_hash_tbl[j] != HASH_END) {
				cur_node = cur_hash_tbl[j];

				assert((0 < cur_node) && (cur_node < Max_node_num));

				while (cur_node != HASH_END) {
					/* cur_node$B$KEPO?$5$l$F$$$kE[$,!$$b$&0l$D$J$$$+!)(B */
					search_node = cur_hash_tbl[j];

					exist_ct = 0;
					while (search_node != HASH_END) {
						if ((GET_BDD_LEVEL(cur_node) == GET_BDD_LEVEL(search_node)) &&
							(GET_BDD_F0(cur_node) == GET_BDD_F0(search_node)) &&
							(GET_BDD_F1(cur_node) == GET_BDD_F1(search_node)))
							exist_ct++;
						assert((0 < search_node) && (search_node < Max_node_num));
						search_node = GET_BDD_NEXT(search_node);
					}

					if (exist_ct > 1) {
						fprintf(stderr, "[ERROR] LINE:%d in %s\n", line, fname);
						fprintf(stderr, "In hash table level:%d, node:%d have same node entry!\n",
								i, cur_node);

						print_hash_image(__LINE__, __FILE__);

						is_error = TRUE;
					}
					cur_node = GET_BDD_NEXT(cur_node);
				}
			}
		}
	}
	if (is_error == TRUE) {
		fprintf(stderr, "[ERROR] in LINE:%d in %s\n", line, fname);
		exit(-1);
	} else {
#if VERBOSE > 2		
		fprintf(stderr, "[Same node check in each hash table OK] LINE:%d in %s\n",
				line, fname);
#endif /* VERBOSE > 2 */		
		return;
	}
}

#endif /* DEBUG > 2 */


/*
 *	$BH]Dj4X78$H$J$C$F$$$k%N!<%I$,8_$$$K;X$7$"$C$F$$$k$+!)(B
 */

#if DEBUG > 2

void
#ifdef __STDC__
check_complement(int line, char *fname)
#else
check_complement(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	int comp_node;
	boolean_t is_error = FALSE;

	for (i = 3; i < Max_node_num; i++) {
		comp_node = GET_BDD_COMP(i);

		if (comp_node == UN_USED)
			continue;
		else {
			assert((0 < comp_node) &&
				   (comp_node < Max_node_num));

			assert(GET_BDD_COMP(comp_node) == i);

			if ((GET_BDD_COMP(GET_BDD_F0(i)) == GET_BDD_F0(comp_node)) &&
				(GET_BDD_COMP(GET_BDD_F0(comp_node)) == GET_BDD_F0(i)) &&
				(GET_BDD_COMP(GET_BDD_F1(i)) == GET_BDD_F1(comp_node)) &&
				(GET_BDD_COMP(GET_BDD_F1(comp_node)) == GET_BDD_F1(i)))
				continue;
			else  {
				fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
				fprintf(stderr, "Complement Error.\n");
				fprintf(stderr, "Node_tbl[%d].comp = %d Node_tbl[%d].comp = %d\n",
						i, Node_tbl[i].complement, comp_node, Node_tbl[comp_node].complement);
				fprintf(stderr, "But, Each Cofactors don't have compelement relation!\n");
				is_error = TRUE;
			}
		}
	}

	if (is_error == TRUE) {
		exit(-1);
	} else {
#if VERBOSE > 2
		fprintf(stderr, "[Check Complement OK!] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
	}
	return;
}

#endif /* DEBUG > 2 */
	

/*
 *	$B8r49$N:]$N!$7?JL$KJ,N`$9$k%F!<%V%k$K!$K\Ev$K(B
 *	$B$=$N7?$+$I$&$+$r%A%'%C%/$9$k4X?t!%(B
 */

void
#ifdef __STDC__
check_swap_pattern(int line, char *fname)
#else
check_swap_pattern(line, fname)
  int line;
  char *fname;
#endif /* __STDC__ */
{
	int i;
	int cur_node;
	int under_level;
	int f0;
	int f1;
	boolean_t is_error = FALSE;

	for(i = 0; i < 4; i++){
		cur_node = Swap_type_tbl[i];

		assert((cur_node == SWAP_TBL_END) ||
			   ((2 < cur_node) && (cur_node < Max_node_num)));

		if (cur_node == SWAP_TBL_END)
			continue;

		while(cur_node != SWAP_TBL_END){
			
			under_level = GET_BDD_LEVEL(cur_node) - 1;
			f0 = GET_BDD_F0(cur_node);
			f1 = GET_BDD_F1(cur_node);

			assert((2 < under_level) && (under_level < (Input_val_num +2)));
			assert((0 < f0) && (f0 < Max_node_num));
			assert((0 < f1) && (f1 < Max_node_num));

			if (i == 0){
				if ((GET_BDD_LEVEL(f0) >= under_level) ||
					(GET_BDD_LEVEL(f1) >= under_level)){
					fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
					fprintf(stderr, " Swap Pattern 0  Error.\n");
					fprintf(stderr, "Node_tbl[%d].level = %d, ->F0 Node_tbl[%d].level = %d, ->F1 Node_tbl[%d].level = %d\n",
							cur_node,GET_BDD_LEVEL(cur_node),f0,GET_BDD_LEVEL(f0),f1,GET_BDD_LEVEL(f1));
					is_error = TRUE;
				}
			}
			else if (i == 1){
				if ((GET_BDD_LEVEL(f0) != under_level) ||
					(GET_BDD_LEVEL(f1) != under_level)){
					fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
					fprintf(stderr, " Swap Pattern 1  Error.\n");
					fprintf(stderr, "Node_tbl[%d].level = %d, ->F0 Node_tbl[%d].level = %d, ->F1 Node_tbl[%d].level = %d\n",
							cur_node,GET_BDD_LEVEL(cur_node),f0,GET_BDD_LEVEL(f0),f1,GET_BDD_LEVEL(f1));
					is_error = TRUE;
				}
			}
			else if (i == 2){
				if ((GET_BDD_LEVEL(f0) != under_level) ||
					(GET_BDD_LEVEL(f1) >= under_level)){
					fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
					fprintf(stderr, " Swap Pattern 2  Error.\n");
					fprintf(stderr, "Node_tbl[%d].level = %d, ->F0 Node_tbl[%d].level = %d, ->F1 Node_tbl[%d].level = %d\n",
							cur_node,GET_BDD_LEVEL(cur_node),f0,GET_BDD_LEVEL(f0),f1,GET_BDD_LEVEL(f1));
					is_error = TRUE;
				}
			}
			else if (i == 3){
				if ((GET_BDD_LEVEL(f0) >= under_level) ||
					(GET_BDD_LEVEL(f1) != under_level)){
					fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
					fprintf(stderr, " Swap Pattern 3  Error.\n");
					fprintf(stderr, "Node_tbl[%d].level = %d, ->F0 Node_tbl[%d].level = %d, ->F1 Node_tbl[%d].level = %d\n",
							cur_node,GET_BDD_LEVEL(cur_node),f0,GET_BDD_LEVEL(f0),f1,GET_BDD_LEVEL(f1));
					is_error = TRUE;
				}
			}
			else{
				fprintf(stderr, "[ERROR] : LINE:%d in %s\n", line, fname);
				fprintf(stderr, " Swap Pattern ?  Error.\n");
				fprintf(stderr, "Node_tbl[%d].level = %d, ->F0 Node_tbl[%d].level = %d, ->F1 Node_tbl[%d].level = %d\n",
						cur_node,GET_BDD_LEVEL(cur_node),f0,GET_BDD_LEVEL(f0),f1,GET_BDD_LEVEL(f1));
				is_error = TRUE;
			}

			cur_node = GET_BDD_NEXT(cur_node);

		}

	}

	if (is_error == TRUE)
		exit(-1);
	else {
#if VERBOSE > 2		
		fprintf(stderr, "[Check Swap Pattern OK!] LINE:%d in %s\n", line, fname);
#endif /* VERBOSE > 2 */		
	}
	return;
	

}

