/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	Data Structure and TYPEDEF,DEFINE decralation
*
*******************************************************************/

/*>>>>>>>>>>>>>>>>> $B%H%i%s%8%9%?$N>pJs(B <<<<<<<<<<<<<<<<<<*/


/*>>>>>>>>>>>>>>>>> for Circuit <<<<<<<<<<<<<<<<<<*/

#define HOLDER_INITIAL_DELAY	0.0
/* [nsec] */

/* #define PRIMARY_OUTPUT_CAP		0.010268 */
/* $BCf4VA^F~%P%C%U%!$HF1$8MFNL(B */

#define PRIMARY_OUTPUT_CAP		0.0
/* $BMFNL$J$7!%(BSPICE$B$GB,Dj$9$k>l9g$O!$$3$A$i$rMQ$$$k(B */

/*>>>>>>>>>>>>>>>>> $BD>Ns$KA^F~$9$k%P%C%U%!$N8GM-CY1d(B <<<<<<<<<<<<<<<<<<*/

#define 	MID_BUF_CONST_DELAY		0.2	/* [nsec] */


/*>>>>>>>>>>>>>>>>> $B%Q%9$KD>Ns$KA^F~$9$k%P%C%U%!$N>pJs(B <<<<<<<<<<<<<<<<<<*/

#define		BUF_ON_PATH_NMOS	4			/* $BF~NOItJ,$N(Bnmos$B$NI}(B */
#define		BUF_ON_PATH_PMOS	1			/* $BF~NOItJ,$N(Bpmos$B$NI}(B */

/* $B:G=i$K%"%k%4%j%:%`$r9M$($?$H$-$N!$(BThreshold V */

/*
   BUF_ON_PATH_A, BUF_ON_PATH_Y0$B$O(B
   $B%P%C%U%!8GM-$NCY1d;~4V$rD>@~6a;w$7$?$H$-$K!$8eCJ$NMFNL$r(BC[pF]$B$H$7$?(B
$B$H$-!$CY1d;~4V$r(BA*C + Y0[nsec]$B$HI=$;$k!%$=$N$H$-$N(BA, Y0$B$NCM(B */

/*******************************************************************
********************************************************************
********************************************************************
       $B0J2<$N(B3$B$D$N%Q%?%s$N$$$:$l$+0l$D$r:NMQ$9$k$3$H(B
********************************************************************
********************************************************************
*******************************************************************/


#define 	V_INV 				1.0
#define		BUF_ON_PATH_A		4.646
#define		BUF_ON_PATH_Y0		0.162761


/*
#define 	V_INV				1.27
#define		BUF_ON_PATH_A		5.981
#define		BUF_ON_PATH_Y0		0.180156 */

/*
#define 	V_INV				1.5
#define		BUF_ON_PATH_A		7.1922	
#define		BUF_ON_PATH_Y0		0.1918040*/


#define MAX_DEPTH	4 /* $BMFNL7W;;$K;HMQ$9$kCM(B */

/*>>>>>>>>>>>>>>>>>--------------------------- <<<<<<<<<<<<<<<<<<*/

#define VDD_FOR_DELAY	3.0
#define GND_FOR_DELAY	0.0

/*>>>>>>>>>>>>>>>>> define <<<<<<<<<<<<<<<<<<*/

#define STRSIZE 30

#define MAX_NODE_NUM	300000

#define NODE_TBL_NULL	(MAX_NODE_NUM + 1)

#define UN_USED			(MAX_NODE_NUM + 2)

#define HASH_END		(MAX_NODE_NUM + 3)
#define NOT_EXIST		(MAX_NODE_NUM + 4)

#define EDGE_TBL_END	(MAX_NODE_NUM + 5)
#define BACK_PT_NULL	(MAX_NODE_NUM + 6)

#define SWAP_TBL_END	(MAX_NODE_NUM + 7)

#define UNKNOWN	0

#define GC_MARGIN	0.9

#define RAND_DATA_NUM	100

#define	IS_ODD(y)	(((unsigned)(y))&(0x0001))


#define BDD_FALSE		1
#define BDD_TRUE		2

#define INC_REF_CT(x)	{assert(Node_tbl[(x)].ref_ct >= 0);(Node_tbl[(x)].ref_ct)++;}
#define DEC_REF_CT(x)	{assert(Node_tbl[(x)].ref_ct > 0); (Node_tbl[(x)].ref_ct)--;}

#define GET_BDD_LEVEL(x)	Node_tbl[(x)].level
#define GET_BDD_REF_CT(x)	Node_tbl[(x)].ref_ct
#define GET_BDD_F0(x)		Node_tbl[(x)].f0
#define GET_BDD_F1(x)		Node_tbl[(x)].f1
#define GET_BDD_NEXT(x)		Node_tbl[(x)].next
#define GET_BDD_COMP(x)		Node_tbl[(x)].complement
#define GET_BDD_BP_LIST(x)	Node_tbl[(x)].back_pt_list

#define NODE_HASH_RATIO	0.4
#define OPE_CACHE_RATIO	0.4

#define NODE_T_UID			1001
#define OPE_CACHE_T_UID		1002
#define VAL_TBL_T_UID		1003
#define OUTPUT_NODE_T_UID	1004
#define SORT_TBL_T_UID		1005
#define EDGE_T_UID		1006

/*>>>>>>>>>>>>>>>>> typedef <<<<<<<<<<<<<<<<<<*/


#define NEGA			0
#define POSI			1

#define FALSE			2
#define TRUE			3

#define OFF				4
#define ON				5

#define USED_TR			6
#define UN_USED_TR		7

#define UNVISITED		8
#define VISITED			9

typedef unsigned int phase_t;
typedef unsigned int tr_usage_t;
typedef unsigned int on_off_t;
typedef unsigned int boolean_t;
typedef unsigned int visit_t;

typedef enum{NODE, POSI_SIGNAL, NEGA_SIGNAL, VDD, GND} node_type_t;

typedef enum{NOT_OPE, OR_OPE, NOR_OPE, AND_OPE, NAND_OPE, XOR_OPE, XNOR_OPE, COF_OPE, NO_OP} ope_t;

#define OPE_CHECK(op) assert((op == NOT_OPE) || (op == OR_OPE)   || (op == NOR_OPE) ||\
							 (op == AND_OPE) || (op == NAND_OPE) || (op == XOR_OPE) ||\
							 (op == XNOR_OPE))

/* BDD$B$N%N!<%I$rJ];}$9$k9=B$BN(B  */

typedef
struct node {
	int level;
	int ref_ct;
	int f0;
	int f1;
	int next;
	int complement;
	int from_f0;	/* for Transistor Switch */
	int from_f1;	/* for Transistor Switch */
	int all;		/* for Transistor Switch */
	int part;		/* for Transistor Switch */
	boolean_t is_pt_from_pout    ;	/* for Delay Calc. */
	int back_pt_list;					/* for Delay Calc. */
	int on_critical_path_ct;	/* for Buf. Ins. */
	int x_grid;	/* for PS OUT */
	int y_grid;	/* for PS OUT */
	phase_t phase                ;	/* for Delay_Calc. */
	boolean_t is_buf_inserted    ;	/* buffer insertion flag */
#if DEBUG > 1
	int uid;
#endif /* DEBUG > 1 */
#if DEBUG > 2
	int ref_ct_check;
#endif /* DEBUG > 2 */	

	double follows_cap;					/* for Delay Calc. */

} node_t;

/* Back Pointer$B$r<BAu$9$k$?$a$N;^$N%F!<%V%k(B  */

typedef
struct edge {
	int from_node ;
	int next;
	boolean_t is_PO;
#if DEBUG > 1
	int uid;
#endif /* DEBUG > 1 */
} edge_t;

/* $B%H%i%s%8%9%?$N(BON/OFF$B$r%A%'%C%/$9$k:]$K;HMQ$9$k9=B$BN(B  */

typedef
struct tr_on_off_tbl {
	int     max_val; 	/* $B8=:_$^$G$N:GBgCM(B */
	phase_t phase;	/* x, !x$B$rH=JL(B */
} tr_on_off_tbl_t;

typedef
struct tr_usage_tbl {
	tr_usage_t 	usage;
	phase_t		phase;
} tr_usage_tbl_t;


/* $B1i;;%-%c%C%7%eMQ$N9=B$BN(B  */

typedef
struct ope_cache {
	int bdd1;
	int bdd2;
	ope_t ope;
	int result;
#if DEBUG > 1
	int uid;
#endif /* DEBUG > 1 */	
} ope_cache_t;


/* $BF~NOJQ?t$H$=$N%l%Y%k$rJ]B8$9$k%F!<%V%k$N$?$a$N9=B$BN(B  */

typedef
struct val_tbl {
	char val[STRSIZE];
	int level;
	int node_num;
	boolean_t is_used;
#if DEBUG > 1
	int uid;
#endif /* DEBUG > 1 */	
} val_tbl_t;

/* $B2sO)$N=PNO!JCf4V!$(BPrimary$BN>J}!K$rJ]B8$9$k9=B$BN(B */

typedef
struct output_node {
	char output_name[STRSIZE];
	int pt_to_dag;
	struct output_node *next;
	double delay_time;
	boolean_t is_primary_out;
	boolean_t is_active;	/* $B9g@.$7$?7k2L!$J#?t$N=PNO$,F1$8$b$N$K$J$l$P!$0l$D$O=LB`(B */
#if DEBUG > 1
	int uid;
#endif /* DEBUG > 1 */	
} output_node_t;


/* $BF0E*JQ?t=g=x$r9T$J$&A0$N%=!<%H$K;HMQ$9$k%F!<%V%k(B */

typedef
struct sort_tbl {
	char val[STRSIZE];
	int node_num;
	int old_level;
#if DEBUG > 1
	int uid;
#endif /* DEBUG > 1 */	
} sort_tbl_t;

/* $B%P%C%U%!A^F~$NM%@h=g0L$r7hDj$9$k$?$a$N%F!<%V%k(B */

typedef
struct {
	int node_idx;
	int on_critical_path_ct;
	int fanout;
	int level;
	int diff;
} sort_tbl_for_bufins;

