/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	SPICE$B$N%Q%i%a!<%?%U%!%$%k$+$i!$I,MW$J>pJs$rCj=P(B
*	$B$"$k$$$OB>$N%U%!%$%k$+$i!$I,MW$J>pJs$rCj=P(B
*******************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"
#include "etc.h"
#include "delay_debug.h"

#ifdef __STDC__
extern void reset_critical_path_ct(void);
extern void buf_ins(void);
#else
extern void reset_critical_path_ct(/* void */);
extern void buf_ins(/* void */);
#endif /* __STDC__ */




/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern int Max_node_num;
extern int Max_edge_num;
extern node_t *Node_tbl;
extern edge_t *Edge_tbl;
extern tr_on_off_tbl_t *Tr_on_off_tbl;
extern output_node_t *Output_val_tbl;
extern int Function_num;
extern int Input_val_num;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

int Prim_in_node_num;
int *Prim_in_node_list;

double Ins_buf_on_path_cap;	/* $B%Q%9>e$KD>Ns$KA^F~$5$l$k%P%C%U%!$NMFNL(B */

FILE *Usr_elec_spec_fp;	/* $B%H%i%s%8%9%?%5%$%:!$ogCMEE05$J$I$N;XDj%U%!%$%k(B */

FILE *HSPICE_spec_fp;	/* HSPICE$B$N%Q%i%a!<%?%U%!%$%k(B */


/* ***************** $B%0%m!<%P%kJQ?t$N@k8@(B ******************* */

double Spice_level;			/* $BD>N.%b%G%k%;%l%/%?(B */

double Ldrawn_n, Wdrawn_n;	/* nMOS,pMOS Tr$B$N%A%c%M%kD9!$I}(B	*/
double Ldrawn_p, Wdrawn_p;	/* [um] */

double Leff_n, Weff_n;		/* nMOS,pMOS Tr$B$N%A%c%M%kD9!$I}$N<B8zD9(B */
double Leff_p, Weff_p;		/* [um] */

double Ldiff_n, Wdiff_n;	/* $B3H;6AX$ND9$5!$I}(B[um] */
double Ldiff_p, Wdiff_p;	/* $B3H;6AX$ND9$5!$I}(B[um] */

double UO_n;				/* nMOS,pMOS$B$N%-%c%j%"0\F0EY(B */
double UO_p;				/* [cm**2/Vsec] */

double Kp_n;				/* nMOS,pMOS$B$s??@-Aj8_%3%s%@%/%?%s%9(B */
double Kp_p;				/* [A/V**2]							 */

double Beta_n;				/* nMOS,pMOS$B$N%I%l%$%sEEN.78?t(B[cm**2/Vsec] */
double Beta_p;				/* Beta = Kp * Weff/Leff */

double Epsilon_sio2;		/* no dim. */
double Epsilon_0;			/* F/cm */

double Tox_n;				/* m */
double Tox_p;				/* m */

double Cox_n;				/* $B%2!<%H$NC10LLL@Q$"$?$j$N;@2=KlMFNL(B[F/m**2] */
double Cox_p;

double Vto_n;				/* $B%<%m%P%$%"%9ogCMEE05(B[V] */
double Vto_p;				

double Vth_n;				/* $B$$$o$f$kogCMEE05(B[V] */
double Vth_p;

double Gamma_n;				/* $B4pHD8z2L78?t(B [V**(1/2)] */
double Gamma2_n;
double Phi_n;				/* $BI=LLH?E>EE0L(B [V] */
double Eta_n;				/* $BogCMD4@aMQ$N%U%#!<%I%P%C%/78?t(B [no dim.]*/

double Gamma_p;				/* $B4pHD8z2L78?t(B [V**(1/2)] */
double Gamma2_p;
double Phi_p;				/* $BI=LLH?E>EE0L(B [V] */
double Eta_p;				/* $BogCMD4@aMQ$N%U%#!<%I%P%C%/78?t(B [no dim.]*/

double Vdd;					/* $BEE8;EE05(B [V] */
double V_inv;				/* Inverter$B$NO@M}H?E>EE05(B */

double Rsh;					/* Sheet $BDq93(B */

double Ld_n;
double Ld_p;

double Xw_n;
double Xw_p;

double Rd_n;
double Rd1_n;				/* LEVEL39$BFH<+$N%b%G%k(B */
double Rd2_n;
double Rd3_n;

double Rd_p;
double Rd1_p;
double Rd2_p;
double Rd3_p;

double Gate_cap_n;
double Gate_cap_p;

double Gate_delay_cap_n;
double Gate_delay_cap_p;

double Diff_cap_n;
double Diff_cap_p;

double CF5;					/* $B=$@5(BMeyer$B%b%G%k$K$*$$$F!$K0OBNN0h$K$"$k(Bcgs */
                            /* $B$r@)8f$9$kMFNL78?t(B */


double Cgso_n;				/* [F/m] */
double Cgdo_n;				/* [F/m] */
double Cgbo_n;				/* [F/m] */

double Cgso_p;              /* [F/m] */
double Cgdo_p;              /* [F/m] */
double Cgbo_p;              /* [F/m] */

double Cj_n;				/* [F/m**2] */
double Mj_n;
double Cjsw_n;				/* [F/m] */
double Mjsw_n;

double Cj_p;
double Mj_p;
double Cjsw_p;
double Mjsw_p;

/* *************** $B%0%m!<%P%kJQ?t$N@k8@=*$j(B****************** */

/*>>>>>>>>>>>>>>>>> SPICE$B$N%Q%i%a!<%?%;%C%H(B<<<<<<<<<<<<<<<<<<*/

/*
 *		SPICE$B$G%G%U%)%k%H$H$7$FDj5A$5$l$kCM$r%;%C%C%H$9$k(B
 *
 */

void
#ifdef __STDC__
set_param_default_value(void)
#else
set_param_default_value()
#endif /* __STDC__ */
{
	Spice_level = 1.0;

	UO_n = 600;				/* [cm**2/(V sec)] */
	UO_p = 250; 			/* [cm**2/(V sec)] */

	Kp_n = 2.0E-5;			/* [A/V**2] */
	Kp_p = 2.0E-5;			/* [A/V**2] */

	Beta_n = 0.0;			/* [cm**2/Vsec] */
	Beta_p = 0.0;			/* [cm**2/Vsec] */

	Epsilon_sio2 = 3.9;		/* no dim. */
	Epsilon_0 = 8.854E-12;	/* [F/m] */

	Tox_n = 1E-7;			/* [m] */
	Tox_p = 1E-7;			/* [m] */

	Cox_n = 3.453E-4;		/* [F/m**2] */
	Cox_p = 3.453E-4;

	CF5 = 0.667;			/* [no dim.] */

	Vto_n = 0.0;			/* [V] */
	Vto_p = 0.0;			/* [V] */

	Gamma_n = 0.5276;			/* [V**(1/2)] */
	Gamma2_n = 0.0;
	Phi_n = 0.576;			/* [V] */
	Eta_n = 0.0;				/* no dim. */

	Gamma_p = 0.5276;			/* [V**(1/2)] */
	Gamma2_p = 0.0;
	Phi_p = 0.576;			/* [V] */
	Eta_p = 0.0;				/* no dim. */

	Vdd = VDD_FOR_DELAY;				/* [V] */
	V_inv = V_INV;			/* [V] */

	return;
}

int
#ifdef __STDC__
skip_space_or_plus(char *buf, int idx)
#else
skip_space_or_plus(buf, idx)
  char *buf;
  int idx;
#endif /* __STDC__ */
{
	int i;

	i = idx;

	while ((isspace(buf[i]) != 0) ||
		   (buf[i] == '+'))
		i++;

	return i;
}

/*
 *	set_nmos_param
 *	nMOS Tr$B$N%Q%i%a!<%?$r3JG<$9$k4X?t(B
 */

void
#ifdef __STDC__
set_nmos_param(char *lval, double rval)
#else
set_nmos_param(lval, rval)
  char *lval;
  double rval;
#endif /* __STDC__ */
{
	if (strcmp(lval, "LEVEL") == 0)	/* OK */
		Spice_level = rval;
	else if (strcmp(lval, "TOX") == 0) /* OK */
		Tox_n = rval;
	else if (strcmp(lval, "RD1") == 0)
		Rd1_n = rval;
	else if (strcmp(lval, "RD2") == 0)
		Rd2_n = rval;
	else if (strcmp(lval, "RD3") == 0)
		Rd3_n = rval;
	else if (strcmp(lval, "RSH") == 0)
		Rsh = rval;
	else if (strcmp(lval, "CGSO") == 0) /* OK */
		Cgso_n = rval;
	else if (strcmp(lval, "CGDO") == 0) /* OK */
		Cgdo_n = rval;
	else if (strcmp(lval, "CGBO") == 0) /* OK */
		Cgbo_n = rval;
	else if (strcmp(lval, "CJ") == 0) /* OK */
		Cj_n = rval;
	else if (strcmp(lval, "MJ") == 0) /* OK */
		Mj_n = rval;
	else if (strcmp(lval, "CJSW") == 0) /* OK  */
		Cjsw_n = rval;
	else if (strcmp(lval, "MJSW") == 0) /* OK */
		Mjsw_n = rval;
	else if (strcmp(lval, "ETA") == 0) /* OK */
		Eta_n = rval;
	else if (strcmp(lval, "GAMMA") == 0) /* OK */
		Gamma_n = rval;
	else if (strcmp(lval, "GAMMA2") == 0)
		Gamma2_n = rval;
	else if (strcmp(lval, "VTO") == 0) /* OK */
		Vto_n = rval;
	else if (strcmp(lval, "PHI") == 0) /* OK */
		Phi_n = rval;
	else if (strcmp(lval, "UO") == 0) /* OK */
		UO_n = rval;
	else if (strcmp(lval, "LD") == 0)
		Ld_n = rval;
	else if (strcmp(lval, "XW") == 0)
		Xw_n = rval;
	else
		return;
}

/*
 *
 *
 */

void
#ifdef __STDC__
set_pmos_param(char *lval, double rval)
#else
set_pmos_param(lval, rval)
  char *lval;
  double rval;
#endif /* __STDC__ */
{
	if (strcmp(lval, "LEVEL") == 0)
		Spice_level = rval;
	else if (strcmp(lval, "TOX") == 0)
		Tox_p = rval;
	else if (strcmp(lval, "RD1") == 0)
		Rd1_p = rval;
	else if (strcmp(lval, "RD2") == 0)
		Rd2_p = rval;
	else if (strcmp(lval, "RD3") == 0)
		Rd3_p = rval;
	else if (strcmp(lval, "CGSO") == 0)
		Cgso_p = rval;
	else if (strcmp(lval, "CGDO") == 0)
		Cgdo_p = rval;
	else if (strcmp(lval, "CGBO") == 0)
		Cgbo_p = rval;
	else if (strcmp(lval, "CJ") == 0)
		Cj_p = rval;
	else if (strcmp(lval, "MJ") == 0)
		Mj_p = rval;
	else if (strcmp(lval, "CJSW") == 0)
		Cjsw_p = rval;
	else if (strcmp(lval, "MJSW") == 0)
		Mjsw_p = rval;
	else if (strcmp(lval, "ETA") == 0)
		Eta_p = rval;
	else if (strcmp(lval, "GAMMA") == 0)
		Gamma_p = rval;
	else if (strcmp(lval, "GAMMA2") == 0)
		Gamma2_p = rval;
	else if (strcmp(lval, "VTO") == 0)
		Vto_p = rval;
	else if (strcmp(lval, "PHI") == 0)
		Phi_p = rval;
	else if (strcmp(lval, "UO") == 0)
		UO_p = rval;
	else
		return;
}


/*
 *		lex_string
 *		1$BNsC10L$NJ8;zNs$r!$@Z$j=P$94X?t(B
 */

void
#ifdef __STDC__
lex_string(char *buf, int model_ct)
#else
lex_string(buf, model_ct)
  char *buf;
  int model_ct;
#endif /* __STDC__ */
{
	int i = 0, j;
	int str_size = strlen(buf);
	char tmp[BUFSIZ];
	char lval[BUFSIZ];
	double rval;
	on_off_t lval_flag = OFF;

	for (i = 0; i < str_size; i++) {
		i = skip_space_or_plus(buf, i);
		j = 0;
		while ((isalpha(buf[i]) != 0) ||
			   (isdigit(buf[i]) != 0) ||
			   (buf[i] == '-')        ||
			   (buf[i] == '.')) {
			tmp[j] = buf[i];
			i++; j++;
		}
		tmp[j] = '\0';
		if (lval_flag == OFF) {
			strcpy(lval, tmp);
			lval_flag = ON;
			while (buf[i] != '=')
				i++;
		} else {
			sscanf(tmp, "%lf", &rval);
			if (model_ct == 1)
				set_nmos_param(lval, rval);
			else if (model_ct == 2)
				set_pmos_param(lval, rval);
			lval_flag = OFF;
		}
	}
	return;
}

/*
 *		$BCY1d7W;;$KI,MW$J%Q%i%a!<%?$r(BSPICE$B$N%U%!%$%k$+$iFI$_9~$`(B 
 *
 */

void
#ifdef __STDC__
set_param_value(FILE *fp)
#else
set_param_value(fp)
  FILE *fp;
#endif /* __STDC__ */
{
	 char buf[BUFSIZ];
	 int model_ct = 0;

	 while (fgets(buf, BUFSIZ, fp) != NULL) {
		 if (strncmp(buf, "*", 1) == 0) /* comment$B9T(B */
			 continue;
		 else if (strncmp(buf, ".MODEL", 1) == 0) {
			 if (model_ct >= 2)
				 break;
			 model_ct++;
		 } else {
			 lex_string(buf, model_ct);
		 }	
	 }
	 return;
}


void
#ifdef __STDC__
read_spice_info(char *fname)
#else
read_spice_info(fname)
  char *fname;
#endif /* __STDC__ */
{
	FILE *fp;

	fp = fopen(fname, "r");
	if (fp == NULL)
		FOPEN_ERR(fname);

	set_param_value(fp);

	fclose(fp);

	return;
}

/*
 *	SPICE$B$N%Q%i%a!<%?%U%!%$%k$K4^$^$l$F$$$J$$>pJs$r%;%C%H$9$k4X?t!%(B
 *
 */

void
#ifdef __STDC__
set_usr_def_val(void)
#else
set_usr_def_val()
#endif /* __STDC__ */
{
	Ld_n *= 1000000; /* m -> um */
	Xw_n *= 1000000; /* m -> um */
	Ld_p = Ld_n;
	Xw_p = Xw_n;

	Ldrawn_n = 0.9;
	Wdrawn_n = 4.0;

	Ldrawn_p = 1.1;
	Wdrawn_p = 4.0;

	Leff_n = Ldrawn_n - 2.0*Ld_n;
	Weff_n = Wdrawn_n + Xw_n;

	Leff_p = Ldrawn_p - 2.0*Ld_p;
	Weff_p = Wdrawn_p + Xw_p;

	Ldiff_n = 2.3;
	Wdiff_n = Wdrawn_n;

	Ldiff_p = 2.3;
	Wdiff_p = Wdrawn_n;


	return;
}

/*
 *	nMOS$B$N%9%l%C%7%g%k%IEE05$r5a$a$k!%(B
 *
 */

double
#ifdef __STDC__
get_vth_n(void)
#else
get_vth_n()
#endif /* __STDC__ */
{
	double vth_n;
	double a, b;

	/* $B0JA0$N(BThreshold$BEE05$N5a$aJ}(B */
	vth_n = (-(Gamma2_n + 1.0)
				*(-Vto_n + Gamma_n*sqrt(Phi_n) - Gamma2_n*Vdd) - 0.5*Gamma_n*Gamma_n
				+ Gamma_n*sqrt(
							   (1.0 + Gamma2_n)
							   *(Phi_n + Gamma2_n*Phi_n
								 + Vdd -Vto_n + Gamma_n*sqrt(Phi_n))
							   + 0.25*Gamma_n*Gamma_n))
		/pow((1.0 + Gamma2_n), 2.0);
	printf("old vth_n : %lf\n", vth_n);
	/* ********************************************************************** */

	/* $B$3$3$+$i2<$G!$(BSPICE MOS Level3$B$N(BThreshold$BEE05$r;HMQ$7$?(B */

	a = Gamma_n*sqrt(Phi_n)-Vto_n + 0.5*Gamma_n*Gamma_n;
	b = pow(Gamma_n*sqrt(Phi_n), 2.0)
		- Gamma_n*Gamma_n*(Phi_n + Vdd);

	printf("New vth_n : %lf\n", -a + sqrt(a*a - b));

	vth_n = -a + sqrt(a*a - b);

	return vth_n;
}


/*
 *
 *  $B3H;6AX$N4s@8Dq93$r%;%C%H(B
 *
 */

void
#ifdef __STDC__
set_parasitic_resistance(void)
#else
set_parasitic_resistance(/* void */)
#endif /* __STDC__ */
{
	Rd_n = Rd1_n + Rd2_n/Wdiff_n + Rd3_n/(Wdiff_n*Wdiff_n);
	Rd_n /= 1000.0;   /* ohm -> Kohm */
	/* only Level36 */

	Rd_n = (Rsh/1000.0)*(Ldiff_n/Wdiff_n);
	/* kOhm */

	printf("Rd_n:%lf, Rsh:%lf Ldiff:%lf Wdiff:%lf\n",
		   Rd_n, Rsh, Ldiff_n, Wdiff_n);

#if VERBOSE > 2
	printf("Rd_n : %lf[kOhm]\n", Rd_n);
#endif /* VERBOSE > 2 */

	return;
}


/*
 *
 *	Gate_cap, Gate_delay_cap$B$N@bL@(B
 *              |
 *              |
 *          ----+----
 *          +-+--+--+
 *      +---+ |  |  |---+
 * Cgd ===  | |  |  |  === Cgs
 *      |   | | === |   |
 *  --+-+---+ | Cgo +---+-+--
 *    |       |           |
 *   ===Cdb  ===Cgb      ===Csb
 *    |       |           |
 *
 *
 *	Gate_cap = C_go*LEFF*WEFF + C_gs*WEFF + C_gd*WEFF
 *	Gate_delay_cap = L_diff*WDRAWN*C_j + 2.0*(L_diff + WDRAWN)*C_jsw;
 *
 */

void
#ifdef __STDC__
set_parasitic_capacitance(void)
#else
set_parasitic_capacitance()
#endif /* __STDC__ */
{
	double surface_n = Leff_n*Weff_n;
	double surface_p = Leff_p*Weff_p;

	double cgs_n;
	double cgd_n;
	

	/*
	   Cox[F/m**2]	-> Cox[pF/um**2]
	   surface[um]
	   Leff,Weff[um]
	   Cgso[F/m]	->	Cgso*1E6[pF/um]
	   Cgdo[F/m]	->	Cgdo*1E6[pF/um]
	   Cgbo[F/m]	->	Cgbo*1E6[pF/um]
	   Cj[F/m**2]	->	Cj[pF/um**2]
	   Cjsw[F/m]	->	Cjsw*1E6[pF/um]
	   */

	cgs_n = (0.5*Wdrawn_n*Leff_n*Cox_n) + (Ld_n*Wdrawn_n*Cox_n);
	/* [pF] */
	cgd_n = (0.5*Wdrawn_n*Leff_n*Cox_n) + (Ld_n*Wdrawn_n*Cox_n);

	printf("cgs_n : %lf[pF] cgd_n : %lf[pF]\n", cgs_n, cgd_n);

	/* source-drain $BMFNL$O(B Cox_n*surface_n*CF5 */

	Gate_cap_n = cgs_n + cgd_n + Cox_n*surface_n;
	
/*	Gate_cap_n = (Cox_n*surface_n)*(1 + CF5)
		+ (Weff_n*(Cgso_n*1E6) + Weff_n*(Cgdo_n*1E6));*/

	Gate_cap_p = (Cox_p*surface_p)*(1 + CF5)
		+ Weff_p*(Cgso_p*1E6) + Weff_p*(Cgdo_p*1E6);

	Diff_cap_n = Ldiff_n*Wdrawn_n*Cj_n
		+ 2.0*(Ldiff_n + Wdrawn_n)*(Cjsw_n*1E6);

	Diff_cap_p = Ldiff_p*Wdrawn_p*Cj_p
		+ 2.0*(Ldiff_p + Wdrawn_p)*(Cjsw_p*1E6);
	
	Gate_delay_cap_n = Gate_cap_n + Leff_n*(Cgbo_n*1E6);
	Gate_delay_cap_p = Gate_cap_p + Leff_p*(Cgbo_p*1E6);

#if VERBOSE > 2
	printf("Gate_cap_n : %lf[pF] Gate_cap_p : %lf[pF]\n",
		   Gate_cap_n, Gate_cap_p);
	printf("Diff_cap_n : %lf[pF] Diff_cap_p : %lf[pF]\n",
		   Diff_cap_n, Diff_cap_p);
	printf("Gate_delay_cap_n : %lf[pF] Gate_delay_cap_p : %lf[pF]\n",
		   Gate_delay_cap_n, Gate_delay_cap_p);
#endif /* VERBOSE > 2 */	

	return;
}

/*
 *	$B%Q%9$KD>Ns$KA^F~$9$k%P%C%U%!$NMFNL$r5a$a$k!%(B
 *
 */

static void
#ifdef __STDC__
calc_buf_on_path_cap(void)
#else
calc_buf_on_path_cap(/* void */)
#endif /* __STDC__ */
{
	double nmos_cap, pmos_cap;
	double surface_n, surface_p;
	double weff_n, weff_p;

	weff_n = (double)BUF_ON_PATH_NMOS - 0.765;
	weff_p = (double)BUF_ON_PATH_PMOS - 0.767;

	surface_n = weff_n * Leff_n;
	surface_p = weff_p * Leff_p;

	nmos_cap = (Cox_n*surface_n)*(1 + CF5)
		+ (weff_n*(Cgso_n*1E6) + weff_n*(Cgdo_n*1E6));
	pmos_cap = (Cox_p*surface_p)*(1 + CF5)
		+ weff_p*(Cgso_p*1E6) + weff_p*(Cgdo_p*1E6);

	Ins_buf_on_path_cap = nmos_cap + pmos_cap;

#if VERBOSE > 2
	fprintf(stderr, "Insert Buffer on Path Cap ----> %lf[pF]\n", Ins_buf_on_path_cap);
#endif /* VERBOSE > 2 */	

	return;

}

/*
 *
 *
 */

void
#ifdef __STDC__
calc_val(void)
#else
calc_val()
#endif /* __STDC__ */
{

	/***************** Cox_n,p$B$N7W;;(B *****************/
	/*
	   C_ox : $B;@2=Kl$NC10LLL@QEv$?$j$NMFNL(B[F/m**2]
	   C_ox$B$N%G%U%)%k%HCM$O(B 3.453E-3[F/m**2]

	           Epsilon_sio2 * Epsilon_0
	   C_ox = --------------------------
	                    TOX
	   $B$3$3$G!$(B
	   Epsilon_sio2[no dim.]
	   Epsilon_0[F/m]
	   TOX[m]
	*/

	Cox_n = (Epsilon_sio2 * Epsilon_0)/Tox_n;
	Cox_p = (Epsilon_sio2 * Epsilon_0)/Tox_p;
	
	/****************** Kp_n,p$B$N7W;;(B ******************/
	/*
	   Kp : $B??@-Aj8_%3%s%@%/%?%s%9(B[A/V**2]

	   Kp = UO[cm**2/Vsec] * Cox[F/m**2]

	   Kp$B$r(B[A/V**2]$B$K$9$k$?$a$K!$(B
	        Cox *= 1E-4
	   $B$,I,MW!%(B
	*/

	Kp_n = UO_n*(Cox_n * 1E-4);
	Kp_p = UO_p*(Cox_p * 1E-4);

	/****************** Beta_n,p$B$N7W;;(B ****************/
	/*
	   Beta : $B%I%l%$%sEEN.78?t(B[A/V**2]
	                Weff
	   Beta = Kp * ------
	                Leff
	   [A/V**2] = [F/Vsec]
	*/

	Beta_n = Kp_n*(Weff_n/Leff_n);
	Beta_p = Kp_p*(Weff_p/Leff_p);

#if VERBOSE > 2
	printf("Beta_n : %lf[F/Vsec]\n", Beta_n);
#endif /* VERBOSE > 2 */	

	/**************** Vth_n,p$B$r5a$a$k(B *******************/

	/* BUGBUG */
/*	Vth_n = get_vth_n();*/
/*	Vth_p = fabs(Vto_p);*/

	/* $B$H$j$"$($:!$(BHSPICE$B$GB,Dj$7$?(BThreshold$BEE05$rKd$a9~$`(B */
	/* BUGBUG */
	Vth_n = 1.2;

#if VERBOSE > 2
	printf("Vth_n : %lf[V] Vth_p : %lf[V]\n", Vth_n, Vth_p);
#endif /* VERBOSE > 2 */	

	/************** Tr$B$NMFNL$r5a$a$k(B *********************/

	set_parasitic_capacitance();

	/************** Tr$B$N3H;6AX$NDq93$r5a$a$k(B *************/
	
	set_parasitic_resistance();

	/* *****$B$3$A$i$GMQ0U$9$k%P%C%U%!$J$I$N(BCMOS$BItJ,$NMFNL$r5a$a$k(B */
	calc_buf_on_path_cap();

	return;
}

/*>>>>>>>>>>>>>>>>> SPICE$B$N%Q%i%a!<%?%;%C%H=*$j(B <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>> $BCY1d7W;;$r9T$J$&$?$a$NA0=hM}(B <<<<<<<<<<<<<<<<<<*/

/*
 *	$B?.9f@~$K=LB`$7$F$7$^$&%N!<%I?t$r5a$a$k!%(B
 *
 */

static int
#ifdef __STDC__
get_prim_in_node_num(void)
#else
get_prim_in_node_num(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for (i = 3; i < Max_node_num; i++) {
		CHECK_NODE_T(&(Node_tbl[i]));
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0) &&
			(is_signal(i) == TRUE))
			ct++;
		else
			continue;
	}
	return ct;
}
	

/*
 *	$B?.9f@~$K=LB`$7$F$7$^$&%N!<%I$r(BPrim_in_node_list$B$KEPO?(B
 *
 */

static void
#ifdef __STDC__
set_primary_in_node(void)
#else
set_primary_in_node(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for (i = 3; i < Max_node_num; i++)
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0) &&
			(is_signal(i) == TRUE)) {
			Prim_in_node_list[ct] = i;
			ct++;
		}
	return;
}

/*
 *	$BCY1d7W;;$K;HMQ$9$kJQ?t$r=i4|2=(B 
 *
 */

void
#ifdef __STDC__
init_node_tbl_for_delay(void)
#else
init_node_tbl_for_delay(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Max_node_num; i++) {
		CHECK_NODE_T(&Node_tbl[i]);
		Node_tbl[i].follows_cap = (double)0.0;
	}
	return;
}

/*
 *	$B=PNOC<;R$N%F!<%V%k$NCY1d;~4V$r3JG<$9$k%U%#!<%k%I$K#0$r%;%C%H(B
 *
 */


/*>>>>>>>>>>>>>>>>> $BCY1d7W;;ItJ,(B <<<<<<<<<<<<<<<<<<*/

/*
 *	$B:F5"4X?t(B
 *
 */

static double
#ifdef __STDC__
r_follows_cap(int cur_node, int child_node)
#else
r_follows_cap(cur_node, child_node)
  int cur_node;
  int child_node;
#endif /* __STDC__ */
{
	on_off_t is_on = OFF;
	int cur_level = GET_BDD_LEVEL(cur_node);
	int cur_parent_node;

	assert((2 < cur_node) && (cur_node < Max_node_num));
	assert((0 < child_node) && (child_node < Max_node_num));

	/* 0$B;^$+$iMh$F$k$+!$(B1$B;^$+$iMh$F$k$+(B? $B$=$N$H$-%H%i%s%8%9%?$O(BON/OFF? */
	if (GET_BDD_F0(cur_node) == child_node) {
		if (Tr_on_off_tbl[cur_level].phase == POSI)
			is_on = OFF;
		else {
			assert(Tr_on_off_tbl[cur_level].phase == NEGA);
			is_on = ON;
		}
	} else if (GET_BDD_F1(cur_node) == child_node) {
		if (Tr_on_off_tbl[cur_level].phase == POSI)
			is_on = ON;
		else {
			assert(Tr_on_off_tbl[cur_level].phase == NEGA);
			is_on = OFF;
		}
	} else {
		fprintf(stderr, "[ERROR] : LINE:%d in %s\n", __LINE__, __FILE__);
		exit(-1);
	}

	if (is_on == OFF) {
		return (Diff_cap_n + Gate_cap_n/2.0);
		/* $BK\Ev$O!$(Bcgs_n$B$r2C$($J$1$l$P$J$i$J$$$,!$(Bcgs_n$B$O(Blocal$BJQ?t$G(B */
		/* $B8+$($J$$$N$G!$6/0z$K(BGate_cap_n$B$r#2$G3d$l$PF1$8?t;z$,F@$i$l$k(B */
	} else {
		assert(is_on == ON);

		/* $B=PNO$N$_$K$D$J$,$C$F$$$k>l9g(B */
		/* $B$3$3$K%P%C%U%!$,A^F~$5$l$F$$$k$3$H$O$J$$$+$i!$4X78$J$$(B */
		if ((GET_BDD_REF_CT(cur_node) == 1) &&
			(Edge_tbl[Node_tbl[cur_node].back_pt_list].is_PO == TRUE)) {
			
			Node_tbl[cur_node].follows_cap =
				Gate_cap_n/2.0 + 2.0*Diff_cap_n + PRIMARY_OUTPUT_CAP;

			return Node_tbl[cur_node].follows_cap
				+ (Gate_cap_n/2.0 + Diff_cap_n);
		} else {
			cur_parent_node = Node_tbl[cur_node].back_pt_list;

			/* $B$=$l$>$l$N;X$7@h$K$D$$$FD4$Y$k(B */
			while (cur_parent_node != BACK_PT_NULL) {
				if (Edge_tbl[cur_parent_node].is_PO == FALSE) {
					if (Node_tbl[cur_node].is_buf_inserted == TRUE) { /* $B%P%C%U%!$,$"$k(B */

						/**************************

						           |
						           /\
						          /  \
								 +----+  Ins_buf_on_path_cap
								    |
									|
							+-------+-------+
							|				|
						 --||OFF		ON	||--
							|				|
							|				|

							$B&P6a;w$r$7$F$$$k!%(B

						  *************************/

						Node_tbl[cur_node].follows_cap = Ins_buf_on_path_cap;
						(void)r_follows_cap(Edge_tbl[cur_parent_node].from_node, cur_node);
						/* $B%P%C%U%!$,$"$k$N$G!$8e$m$OL5;k$9$k!%$@$+$i!$JVCM$O$$$i$J$$(B */

					} else { /* $B%P%C%U%!$,$J$$(B */
						assert(Node_tbl[cur_node].is_buf_inserted == FALSE);
						Node_tbl[cur_node].follows_cap +=
							r_follows_cap(Edge_tbl[cur_parent_node].from_node, cur_node);
					}
				}
				cur_parent_node = Edge_tbl[cur_parent_node].next;
			}
			Node_tbl[cur_node].follows_cap += Gate_cap_n/2.0 + 2.0*Diff_cap_n;
		}
	}
	return Node_tbl[cur_node].follows_cap + (Gate_cap_n/2.0 + Diff_cap_n);
}


/*
 *	$B<!CJ$NIi2YMFNL$r:F5"E*$K%;%C%H$9$k!%(B
 *
 */

static void
#ifdef __STDC__
set_follows_cap(void)
#else
set_follows_cap(/* void */)
#endif /* __STDC__ */
{
	int i;
	int cur_node;
	int cur_parent_node;

	/* $B?.9f@~$K$D$$$F$N%k!<%W(B */
	for (i = 0; i < Prim_in_node_num; i++) {
		cur_node = Prim_in_node_list[i];
		cur_parent_node = Node_tbl[cur_node].back_pt_list;

		assert((2 < cur_node) && (cur_node < Max_node_num));

		assert((0 <= cur_parent_node) && (cur_parent_node < Max_edge_num));

		while (cur_parent_node != BACK_PT_NULL) {

			/* $B$b$7?.9f@~$K$J$k%N!<%I$,$$$-$J$j=PNO$K$D$J$,$C$F$$$k>l9g$O(B
			   $BL5;k$9$k$+$i!$$=$l0J30$N$b$N$K$D$$$F%k!<%W$r2s$9(B */
			if(Edge_tbl[cur_parent_node].is_PO == FALSE) {
				(void)r_follows_cap(Edge_tbl[cur_parent_node].from_node, cur_node);
			}
			cur_parent_node = Edge_tbl[cur_parent_node].next;
		}
	}

	/* BDD_FALSE */
	cur_parent_node = Node_tbl[BDD_FALSE].back_pt_list;
	while (cur_parent_node != BACK_PT_NULL) {
		/* $B$b$7?.9f@~$G$J$1$l$P(B */
		if (is_signal(Edge_tbl[cur_parent_node].from_node) == FALSE) {
			(void)r_follows_cap(Edge_tbl[cur_parent_node].from_node, BDD_FALSE);
		}
		cur_parent_node = Edge_tbl[cur_parent_node].next;
	}
	/* BDD_TRUE */
	cur_parent_node = Node_tbl[BDD_TRUE].back_pt_list;
	while (cur_parent_node != BACK_PT_NULL) {
		/* $B$b$7?.9f@~$G$J$1$l$P(B */
		if (is_signal(Edge_tbl[cur_parent_node].from_node) == FALSE) {
			(void)r_follows_cap(Edge_tbl[cur_parent_node].from_node, BDD_TRUE);
		}
		cur_parent_node = Edge_tbl[cur_parent_node].next;
	}
	return;
}

/*
 *	Output_tbl$B$N(Bdelay_time$B$r=i4|2=(B
 *
 */

static void
#ifdef __STDC__
reset_output_tbl_delay(void)
#else
reset_output_tbl_delay(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Function_num; i++)
		Output_val_tbl[i].delay_time = 0.0;

	return;
}

/*
 *	$B:F5"E*$K?<$5(Blevel$B$^$G$NMFNL$NAmOB$r7W;;$9$k!%(B
 *
 */

static double
#ifdef __STDC__
r_get_level_cap(int cur_node, int child_node, int prev_level, int max_level)
#else
r_get_level_cap(cur_node, child_node, prev_level, max_level)
  int cur_node;
  int child_node;
  int prev_level;
  int max_level;
#endif /* __STDC__ */
{
	double ret_val = 0.0;
	int cur_level = GET_BDD_LEVEL(cur_node);
	int cur_edge_idx;
	int parent_node;
	boolean_t is_on = FALSE;

	assert((2 < cur_node) && (cur_node < Max_node_num));
	assert((2 < child_node) && (child_node < Max_node_num));
	assert((2 < cur_level) && (cur_level < (Input_val_num + 3)));

	prev_level++;

	if (prev_level < max_level) { /* $B$^$@%l%Y%k$KC#$7$F$$$J$$(B */
		
		cur_edge_idx = Node_tbl[cur_node].back_pt_list; /* $B%P%C%/%]%$%s%?$N%j%9%H$r$?$0$k(B */
		while (cur_edge_idx != BACK_PT_NULL) {
			if (Edge_tbl[cur_edge_idx].is_PO == TRUE) { /* $B$b$7<+J,$N?F$K=PNO$,$"$l$P(B */
				ret_val += PRIMARY_OUTPUT_CAP;			/* $B:F5"$O$7$J$$$G=hM}$9$k!%(B*/

			} else {
				parent_node = Edge_tbl[cur_edge_idx].from_node; /* $B?F%N!<%I$r=g<!C5$k(B */
				ret_val += r_get_level_cap(parent_node, cur_node, prev_level, max_level);
			}
			cur_edge_idx = Edge_tbl[cur_edge_idx].next;
		}

	} else if (prev_level == max_level) { /* $B%l%Y%k$KC#$7$F$$$?$i!$:F5"$O$7$J$$$G<+J,$N=hM}$N$_(B */
		ret_val = 0.0;
	} else {
		fprintf(stderr, "[ERROR] : LINE:%d in %s\n", __LINE__, __FILE__);
		exit(-1);
	}

	/* 0$B;^$+$iMh$F$k$+!$(B1$B;^$+$iMh$F$k$+(B? $B$=$N$H$-%H%i%s%8%9%?$O(BON/OFF? */
	if (GET_BDD_F0(cur_node) == child_node) {
		if (Tr_on_off_tbl[cur_level].phase == POSI)
			is_on = OFF;
		else {
			assert(Tr_on_off_tbl[cur_level].phase == NEGA);
			is_on = ON;
		}
	} else if (GET_BDD_F1(cur_node) == child_node) {
		if (Tr_on_off_tbl[cur_level].phase == POSI)
			is_on = ON;
		else {
			assert(Tr_on_off_tbl[cur_level].phase == NEGA);
			is_on = OFF;
		}
	} else {
		fprintf(stderr, "[ERROR] : LINE:%d in %s\n", __LINE__, __FILE__);
	}

	/* $B@dBP$K%N!<%I$G$"$k2DG=@-$7$+$J$$!%$b$7=PNO$G$"$l$P!$(B*/
	/* $B$=$l$OA0$NJ8$G%+%C%H$7$F$k(B */
	if (is_on == OFF)
		ret_val = Diff_cap_n;
	else {
		assert(is_on == ON);

		ret_val += (Gate_cap_n/2.0 + 2.0*Diff_cap_n) + (Gate_cap_n/2.0 + Diff_cap_n);
	}
	return ret_val;
}

/*
 *	cur_node$B$+$i!$?<$5(Blevel$B$^$G$NMFNL$NAmOB$r7W;;$9$k!%(B
 */

double
#ifdef __STDC__
get_level_cap(int cur_node, int max_level)
#else
get_level_cap(cur_node, max_level)
  int cur_node;
  int max_level;
#endif /* __STDC__ */
{
	double ret_val = 0.0;
	int cur_edge_idx;
	int parent_node;

	assert((0 < cur_node) && (cur_node < Max_node_num));
	assert((0 < max_level) && (max_level < (Input_val_num +3)));

	cur_edge_idx = Node_tbl[cur_node].back_pt_list;
	while (cur_edge_idx != BACK_PT_NULL) {
		if (Edge_tbl[cur_edge_idx].is_PO == FALSE) { /* $B$b$7?F$,=PNO$G$J$1$l$P(B */
			parent_node = Edge_tbl[cur_edge_idx].from_node;
			assert((2 < parent_node) && (parent_node < Max_node_num));
			ret_val += r_get_level_cap(parent_node, cur_node, 0, max_level);
		} else
			ret_val += PRIMARY_OUTPUT_CAP;

		cur_edge_idx = Edge_tbl[cur_edge_idx].next;
	}

	return ret_val;
}

/*
 *	$BMFNL$r<u$1$H$C$?$i!$$=$l$KBP1~$9$k%$%s%P!<%?$NN)$A>e$,$jCY1d!$(B
 *	$B$9$J$o$A!$<!CJ$N(BnMOS$B$X$NF~NO$N79$-(B(gradient)$B$r5a$a$k!%(B
 */

static double
#ifdef __STDC__
get_init_grad(double cap)
#else
get_init_grad(cap)
  double cap;
#endif /* __STDC__ */
{
	double delay;

	cap += (Diff_cap_p + Gate_cap_p + Diff_cap_n);

	delay = (2.0*cap*V_inv)/(Beta_p*1E3*pow((Vdd - Vth_p), 2.0));

	printf("BUNBO : %lf\n", Beta_p*1E3*pow((Vdd - Vth_p), 2.0));

	printf("cap : %lf delay : %lf\n", cap, delay);

	return delay;
}


/*
 *	$B:F5"ItJ,(B
 *
 */

static void
#ifdef __STDC__
r_delay(double delay_with_buf, double prev_delay, int cur_node, int child_node)
#else
r_delay(delay_with_buf, prev_delay, cur_node, child_node)
  double delay_with_buf;
  double prev_delay;
  int cur_node;
  int child_node;
#endif /* __STDC__ */
{
	double cur_delay;
	double cur_t0;
	double vds;
	double onR;
	double next_delay;
	int cur_level = GET_BDD_LEVEL(cur_node);
	boolean_t is_first_stage = FALSE; /* flag */
	on_off_t is_on = OFF;
	int parent_node;
	double tmp_cap;
	double tmp;
	double tmp_t0;
	double a, b;
	double buf_delay;

	assert(prev_delay >= 0.0);

	assert((0 < cur_node) && (cur_node < Max_node_num));
	CHECK_NODE_T(&(Node_tbl[cur_node]));

	assert((2 < cur_level) && (cur_level < (Input_val_num + 3)));

	/* 0$B;^$+$iMh$F$k$+!$(B1$B;^$+$iMh$F$k$+(B? $B$=$N$H$-%H%i%s%8%9%?$O(BON/OFF? */
	if (GET_BDD_F0(cur_node) == child_node) {
		if (Tr_on_off_tbl[cur_level].phase == POSI)
			is_on = OFF;
		else {
			assert(Tr_on_off_tbl[cur_level].phase == NEGA);
			is_on = ON;
		}
	} else if (GET_BDD_F1(cur_node) == child_node) {
		if (Tr_on_off_tbl[cur_level].phase == POSI)
			is_on = ON;
		else {
			assert(Tr_on_off_tbl[cur_level].phase == NEGA);
			is_on = OFF;
		}
	} else {
		fprintf(stderr, "[ERROR] : LINE:%d in %s\n", __LINE__, __FILE__);
		exit(-1);
	}

	/* $B$b$7!$(BOFF$BB&$N%H%i%s%8%9%?$+$?EA$o$C$F$-$?$i!$$d$a(B */
	if (is_on == OFF) {
		return;
	} else {	/* OFF$B$G$J$1$l$P!$0J2<ItJ,(B */
		/* $B%H%i%s%8%9%?$N(BNEGA */
		if (Tr_on_off_tbl[cur_level].phase == POSI) {

			if ((is_signal(GET_BDD_F1(cur_node)) == TRUE) ||
				(Node_tbl[GET_BDD_F1(cur_node)].is_buf_inserted == TRUE) || /* Buffer */
				(GET_BDD_F1(cur_node) == BDD_FALSE) ||
				(GET_BDD_F1(cur_node) == BDD_TRUE)) {
				is_first_stage = TRUE;
			} else {
				assert((is_signal(GET_BDD_F1(cur_node)) != TRUE) &&
					   (Node_tbl[GET_BDD_F1(cur_node)].is_buf_inserted != TRUE) &&
					   (GET_BDD_F1(cur_node) != BDD_FALSE) &&
					   (GET_BDD_F1(cur_node) != BDD_TRUE));

				is_first_stage = FALSE;
			}

		} else {
			assert(Tr_on_off_tbl[cur_level].phase == NEGA);
			
			if ((is_signal(GET_BDD_F0(cur_node)) == TRUE) ||
				(Node_tbl[GET_BDD_F0(cur_node)].is_buf_inserted == TRUE) ||
				(GET_BDD_F0(cur_node) == BDD_FALSE) ||
				(GET_BDD_F0(cur_node) == BDD_TRUE)) {
				is_first_stage = TRUE;
			} else {
				assert((is_signal(GET_BDD_F0(cur_node)) != TRUE) &&
					   (Node_tbl[GET_BDD_F0(cur_node)].is_buf_inserted != TRUE) &&
					   (GET_BDD_F0(cur_node) != BDD_FALSE) &&
					   (GET_BDD_F0(cur_node) != BDD_TRUE));
				
				is_first_stage = FALSE;
			}
		}

		if (is_first_stage == FALSE) { /* 2$BCJL\0J9_(B */

			cur_t0 = (pow((Vdd - Vth_n), 2.0)/(2.0*V_inv*(Vdd - Vth_n - 0.5*V_inv)))
				*prev_delay + (Node_tbl[cur_node].follows_cap * V_inv)/
					((Beta_n*1E3)*pow((Vdd - Vth_n - 0.5*V_inv),2.0));

			assert(cur_t0 > 0.0);

			vds = (Vdd - Vth_n - 0.5*V_inv) -
				(pow((Vdd - Vth_n), 2.0)/(2.0*V_inv))*(prev_delay/cur_t0);

			assert((0.0 < vds) && (vds < Vdd));

			/* $B;03Q7A$N>l9g(B */
			if (((Vdd - Vth_n)*prev_delay)/V_inv > cur_t0) {

				tmp = prev_delay*Beta_n*1E3*(Vdd - Vth_n - 0.5*V_inv);
				vds = (-tmp*V_inv + V_inv*
					   sqrt(tmp*(tmp + 8.0*Node_tbl[cur_node].follows_cap)))
					/(4.0*tmp);

				/* $B;M3Q7A$N>r7o$K$J$C$F$$$J$$$+%A%'%C%/(B */
				tmp_t0 = (prev_delay*tmp + prev_delay*
						  sqrt(tmp*tmp + 8.0*tmp*Node_tbl[cur_node].follows_cap))/(2.0*tmp);
				assert(((Vdd - Vth_n)*prev_delay)/V_inv > tmp_t0);

			}

			onR = 1.0/((Beta_n*1E3)*(Vdd - Vth_n - 0.5*V_inv - 0.5*vds));

			onR += 2.0*Rd_n; /* $B3H;6AX$NDq93$r2C$($k(B */

			assert(onR > 0.0);

			cur_delay = onR * Node_tbl[cur_node].follows_cap *
				log((Vdd - Vth_n)/(Vdd - Vth_n - V_inv)) + prev_delay;

			assert(cur_delay >= 0.0);

		} else {				/* 1$BCJL\(B */
			
			a = ((Vdd - Vth_n)*prev_delay)/V_inv;
			b = 0.5*V_inv*a - (Vdd - Vth_n)*a - (2.0*Node_tbl[cur_node].follows_cap)/(Beta_n*1E3);

			cur_delay = (-V_inv*b+V_inv*sqrt(b*b - a*a*pow(Vdd - Vth_n - 0.5*V_inv ,2.0)))
				/(2.0*pow((Vdd - Vth_n - 0.5*V_inv) ,2.0));

			assert(cur_delay >= 0.0);
			
		}
		
		if (Node_tbl[cur_node].is_buf_inserted == TRUE) { /* $B%P%C%U%!$"$j(B */

			tmp_cap = 0.0;


			parent_node = Node_tbl[cur_node].back_pt_list;
			while (parent_node != BACK_PT_NULL) {
				if (Edge_tbl[parent_node].is_PO == TRUE) {

					tmp_cap += PRIMARY_OUTPUT_CAP;

					assert(cur_delay >= 0.0);
				} else {
					assert(Edge_tbl[parent_node].is_PO == FALSE);
					/* $B<+J,$N@\B3@h$N%H%i%s%8%9%?0J9_$NMFNL$NOB(B */
					tmp_cap += Node_tbl[parent_node].follows_cap;
					/* $B<+J,$N3H;6AX$NMFNL$J$I$r%;%C%H(B */
					tmp_cap += Diff_cap_n + Gate_cap_n/2.0;
				}
				parent_node = Edge_tbl[parent_node].next;
			}
			tmp_cap += Diff_cap_n;
			

			buf_delay = MID_BUF_CONST_DELAY;

			/* BUGBUG */
			delay_with_buf += cur_delay + buf_delay;

			/* $B<!CJ$N(BnMOS$B$X$NF~NOGH7A$N79$-$r%;%C%H(B */
			next_delay = get_init_grad(tmp_cap);

			printf("next_delay : %lf tmp_cap : %lf follows_cap : %lf\n",
				   next_delay, tmp_cap, Node_tbl[cur_node].follows_cap);

			next_delay = 3.5;
			

		} else {
			assert(Node_tbl[cur_node].is_buf_inserted == FALSE);
			next_delay = cur_delay;
		}
		
		parent_node = Node_tbl[cur_node].back_pt_list;
		while (parent_node != BACK_PT_NULL) {
			if (Edge_tbl[parent_node].is_PO == TRUE) {

				Output_val_tbl[Edge_tbl[parent_node].from_node].delay_time
					= cur_delay + delay_with_buf;
				/* $B%P%C%U%!$K$h$C$F?7$?$K7W;;$7$?ItJ,$H!$%P%C%U%!0JA0$NItJ,$NB-$7;;(B */
							assert(cur_delay >= 0.0);
			} else {
				assert(Edge_tbl[parent_node].is_PO == FALSE);

				r_delay(delay_with_buf, next_delay,
						Edge_tbl[parent_node].from_node, cur_node);
			}
			parent_node = Edge_tbl[parent_node].next;
			
		}
		return;
	}
	fprintf(stderr, "[ERROR] : LINE:%d in %s\n", __LINE__, __FILE__);
	exit(-1);
}


/*
 *	$BCY1d;~4V$r:F5"E*$K5a$a$k!%(B
 *
 */

static void
#ifdef __STDC__
delay(void)
#else
delay(/* void */)
#endif /* __STDC__ */
{
	int i;
	int cur_node;
	int cur_parent_node;

	double initial_delay = HOLDER_INITIAL_DELAY;

	/* $B?.9f@~$K$D$$$F$N%k!<%W(B */
	for (i = 0; i < Prim_in_node_num; i++) {
		cur_node = Prim_in_node_list[i];
		assert((2 < cur_node) && (cur_node < Max_node_num));
		assert((2 < GET_BDD_LEVEL(cur_node)) &&
			   (GET_BDD_LEVEL(cur_node)));

		cur_parent_node = Node_tbl[cur_node].back_pt_list;
		while (cur_parent_node != BACK_PT_NULL) {
			/* $B$b$7?.9f@~$K$J$k%N!<%I$,$$$-$J$j=PNO$K$D$J$,$C$F$$$k>l9g$O(B
			   $BL5;k$9$k$+$i!$$=$l0J30$N$b$N$K$D$$$F%k!<%W$r2s$9(B */
			if (Edge_tbl[cur_parent_node].is_PO == FALSE) {
				r_delay(0.0, initial_delay, Edge_tbl[cur_parent_node].from_node, cur_node);
			}
			cur_parent_node = Edge_tbl[cur_parent_node].next;
		}
	}

	/* BDD_FALSE */
	cur_parent_node = Node_tbl[BDD_FALSE].back_pt_list;
	while (cur_parent_node != BACK_PT_NULL) {
		/* $B$b$7?.9f@~$G$J$1$l$P(B */
		if (is_signal(Edge_tbl[cur_parent_node].from_node) == FALSE) {

			r_delay(0.0, initial_delay, Edge_tbl[cur_parent_node].from_node, BDD_FALSE);
		}
		cur_parent_node = Edge_tbl[cur_parent_node].next;
	}
	/* BDD_TRUE */
	cur_parent_node = Node_tbl[BDD_TRUE].back_pt_list;
	while (cur_parent_node != BACK_PT_NULL) {
		/* $B$b$7?.9f@~$G$J$1$l$P(B */
		if (is_signal(Edge_tbl[cur_parent_node].from_node) == FALSE) {

			r_delay(0.0, initial_delay, Edge_tbl[cur_parent_node].from_node, BDD_TRUE);
		}
		cur_parent_node = Edge_tbl[cur_parent_node].next;
	}
	return;
}


/*
 *	$BCY1d7W;;$r9T$J$&8F$S=P$785(B
 *
 */

void
#ifdef __STDC__
calc_delay_with_buf(char *fname)
#else
calc_delay_with_buf(fname)
  char *fname;
#endif /* __STDC__ */
{
	int i;
	int max_i = 1;

	set_param_default_value();
	read_spice_info(fname);
	set_usr_def_val();
	calc_val();

	for (i = 0; i < max_i; i++) {
		printf("************ Delay Counter : %d\n", i);
		reset_critical_path_ct();
		init_node_tbl_for_delay();

		Prim_in_node_num = get_prim_in_node_num();
		Prim_in_node_list = (int *)malloc(sizeof(int) * Prim_in_node_num);
#if VERBOSE > 2 
	fprintf(stderr, "********* Signal Num : %d\n", Prim_in_node_num);
#endif /* VERBOSE > 2 */	
		if (Prim_in_node_list == NULL)
			MALLOC_ERR;

		set_primary_in_node();

		set_follows_cap();
		delay();

		buf_ins();
	}
	
/*	PRINT_FOLLOWS_CAP;*/
	PRINT_DELAY_TIME; 

#if VERBOSE > 2
	printf("Set Spice Info End\n");
#endif /* VERBOSE > 2 */	

	return;
}
