/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	$BCY1d7W;;$NA0=hM}$r9T$J$&$?$a$N%b%8%e!<%k72(B
*
*******************************************************************/

#include <stdio.h>
#include <math.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "bdd_etc.h"
#include "error.h"
#include "delay_debug.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern int Max_node_num;
extern int Max_edge_num;
extern int Edge_free_list_head;
extern int Function_num;
extern int Input_val_num;

extern node_t *Node_tbl;
extern edge_t *Edge_tbl;
output_node_t *Output_val_tbl;

tr_on_off_tbl_t *Tr_on_off_tbl;
tr_usage_tbl_t **Tr_usage_tbl;

int Max_delay_output_idx;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern void gc(void);
#else
extern void gc(/* void */);
#endif /* __STDC__ */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*>>>>>>>>>>>>>>>>> $BA0H>$O(BBack Pt$B$N@_Dj(B<<<<<<<<<<<<<<<<<<*/

/*
 *	edge_t$B7?$N9=B$BN$N(Bpt$B$rEO$9$H!$$=$NNN0h$r(BFree List$B$K(B
 *	$BLa$9!%(B
 */

static void
#ifdef __STDC__
free_edge_list(int edge_idx)
#else
free_edge_list(edge_idx)
  int edge_idx;
#endif /* __STDC__ */
{
	assert((0 <= edge_idx) && (edge_idx < (Max_edge_num - 1)));
	CHECK_EDGE_T(&Edge_tbl[edge_idx]);

	assert((Edge_tbl[edge_idx].is_PO == FALSE) ||
		   (Edge_tbl[edge_idx].is_PO == TRUE));

	Edge_tbl[edge_idx].next = Edge_free_list_head;
	Edge_tbl[edge_idx].from_node = UN_USED;
	Edge_tbl[edge_idx].is_PO = FALSE;
	Edge_free_list_head = edge_idx;

	return;
}

/*
 *
 *
 */

static int
#ifdef __STDC__
alloc_edge_list(void)
#else
alloc_edge_list(/* void */)
#endif /* __STDC__ */
{
	int new;

	new = Edge_free_list_head;
	Edge_free_list_head = Edge_tbl[Edge_free_list_head].next;

	/* $B%N!<%I?t$N(B2$BG\$@$1MQ0U$7$F$$$k$+$i!$(BEdge$B%F!<%V%k$,0n$l$k$J$i(B */
	/* $B@h$K%N!<%I$,0n$l$k!%(B*/
	assert((0 <= new) && (new < Max_edge_num));
	assert((0 <= Edge_free_list_head) && (Edge_free_list_head < Max_edge_num));

	return new;
}

/*
 *
 *
 */

static void
#ifdef __STDC__
all_free_edge_list(void)
#else
all_free_edge_list(/* void */)
#endif /* __STDC__ */
{
	int i;
	int cur_edge_node;
	int new_list_head;

	for (i = 1; i < Max_node_num; i++) {
		CHECK_NODE_T(&(Node_tbl[i]));

		Node_tbl[i].is_pt_from_pout = FALSE;

		if (Node_tbl[i].back_pt_list != BACK_PT_NULL) {
			cur_edge_node = Node_tbl[i].back_pt_list;

			assert((cur_edge_node != BACK_PT_NULL) ||
				   ((0 < cur_edge_node) && (cur_edge_node < Max_edge_num)));

			while (cur_edge_node != BACK_PT_NULL) {
				assert((0 <= cur_edge_node) && (cur_edge_node < Max_edge_num));
				new_list_head = Edge_tbl[cur_edge_node].next;

				assert((new_list_head == BACK_PT_NULL) ||
					   ((0 <= new_list_head) && (new_list_head < Max_edge_num)));

				free_edge_list(cur_edge_node);
				cur_edge_node = new_list_head;
			}
		}
	}
	return;
}

/*
 *
 *
 */

static void
#ifdef __STDC__
add_back_pt_from_pout(int root_idx, int self)
#else
add_back_pt_from_pout(root_idx, self)
  int root_idx;
  int self;
#endif /* __STDC__ */
{
	int new_edge_node;
	int cur_back_pt_head;

	assert((0 <= root_idx) && (root_idx < Function_num));
	assert((0 < self) && (self < Max_node_num));

	cur_back_pt_head = Node_tbl[self].back_pt_list;

	new_edge_node = alloc_edge_list();

	CHECK_EDGE_T(&(Edge_tbl[new_edge_node]));

	Edge_tbl[new_edge_node].is_PO = TRUE;
	Edge_tbl[new_edge_node].from_node = root_idx;
	Edge_tbl[new_edge_node].next = cur_back_pt_head;
	Node_tbl[self].back_pt_list = new_edge_node;

	return;
}

/*
 *	to$B$GI=$5$l$k%N!<%I$K!$(Bfrom$B$K%]%$%s%H$5$l$F$$$k;]$r=q$-9~$`(B
 */

static void
#ifdef __STDC__
add_back_pt(int from, int to)
#else
add_back_pt(from, to)
  int from, to;
#endif /* __STDC__ */
{
	int new_edge_node;
	int cur_back_pt_head;

	assert((2 < from) && (from < Max_node_num));
	assert((0 < to) && (to < Max_node_num));

	/* idx = to$B$N%N!<%I$K!$8=:_$N(Bback pt$B$N@hF,$r3NJ](B */
	cur_back_pt_head = Node_tbl[to].back_pt_list;

	/* $B?7$7$$%N!<%I$r$H$C$F$/$k(B */
	new_edge_node = alloc_edge_list();

	CHECK_EDGE_T(&(Edge_tbl[new_edge_node]));

	Edge_tbl[new_edge_node].is_PO = FALSE;
	Edge_tbl[new_edge_node].from_node = from;
	Edge_tbl[new_edge_node].next = cur_back_pt_head;
	Node_tbl[to].back_pt_list = new_edge_node;


	return;
}

/*
 *
 *
 */

static void
#ifdef __STDC__
set_pted_from_pout_flag(void)
#else
set_pted_from_pout_flag(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE)
			Node_tbl[Output_val_tbl[i].pt_to_dag].is_pt_from_pout = TRUE;
	}
	return;
}

/*
 *	$B%H%i%s%8%9%?$N%9%$%C%A%s%0%Q%?%s$N$?$a$NJQ?t(B
 *	$B$r=i4|2=(B
 */

static void
#ifdef __STDC__
init_switch_pattern_info(void)
#else
init_switch_pattern_info(/* void */)
#endif /* __STDC__ */
{
	int i, j;

	Tr_on_off_tbl = (tr_on_off_tbl_t *)malloc(sizeof(tr_on_off_tbl_t) * (Input_val_num + 3));
	if (Tr_on_off_tbl == NULL)
		MALLOC_ERR;

	for (i = 3; i < (Input_val_num + 3); i++) {
		Tr_on_off_tbl[i].max_val = 0;
		Tr_on_off_tbl[i].phase = NEGA;
	}

	for (i = 1; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0))
			continue;
		else {
			Node_tbl[i].from_f0 = 0;
			Node_tbl[i].from_f1 = 0;
			Node_tbl[i].all = 0;
			Node_tbl[i].part = 0;
			Node_tbl[i].phase = NEGA;
		}
	}

	/* Tr$B$N(BON/OFF$B%Q%?%s$rC5:w$9$k$N$K!$(B2pass$B$G9T$J$&$,!$$=$N:]$K;HMQ$9$kNN0h(B */
	Tr_usage_tbl = (tr_usage_tbl_t **)malloc(sizeof(tr_usage_tbl_t *) * Function_num);
	if (Tr_usage_tbl == NULL)
		MALLOC_ERR;

	/* $BCf4VJQ?tItJ,$bL5BL$J$N$OJ,$+$C$F$k$1$I!$$H$j$"$($:$H$k!%%P%0F~$j$K$/$=$&$@$+$i(B */
	for (i = 0; i < Function_num; i++) {
		Tr_usage_tbl[i] = (tr_usage_tbl_t *)malloc(sizeof(tr_usage_tbl_t) * (Input_val_num + 3));
		if (Tr_usage_tbl[i] == NULL)
			MALLOC_ERR;
	}

	for (i = 0; i < Function_num; i++) {
		for (j = 3; j < (Input_val_num + 3); j++) {
			Tr_usage_tbl[i][j].usage = UN_USED_TR;
			Tr_usage_tbl[i][j].phase = NEGA;
		}
	}

	return;
}

/*
 *	Tr.$B$N(BON/OFF$B$r7h$a$k(B1pass$BL\(B
 *
 */

static int
#ifdef __STDC__
r_check_on_tr_1pass(int node, int all, int part)
#else
r_check_on_tr_1pass(node, all, part)
  int node;
  int all;
  int part;
#endif /* __STDC__ */
{
	int node_level = GET_BDD_LEVEL(node);
	int ret_val = 0;

	assert((0 < node) && (node < Max_node_num));
	assert((0 < node_level) && (node_level < (Input_val_num + 3)));

	if ((node == BDD_TRUE) ||
		(node == BDD_FALSE) ||
		(is_signal(node) == TRUE)) {
		return all;
	} else {
		
		if (Node_tbl[node].is_buf_inserted == TRUE) { /* Buffer$B$,A^F~$5$l$F$$$?$i(B */

			Node_tbl[node].part = 0;
			Node_tbl[node].all  = 0;
		} else { 									/* Buffer$B$,A^F~$5$l$F$$$J$$(B */
			assert(Node_tbl[node].is_buf_inserted == FALSE);
			Node_tbl[node].part = part + Node_tbl[node].ref_ct;
			Node_tbl[node].all  = Node_tbl[node].part + all;
		}

		/* $B$7$P$i$/$O6&DLItJ,(B */
		Node_tbl[node].from_f0 =
			r_check_on_tr_1pass(GET_BDD_F0(node), Node_tbl[node].all, Node_tbl[node].part);

		Node_tbl[node].from_f1 =
			r_check_on_tr_1pass(GET_BDD_F1(node), Node_tbl[node].all, Node_tbl[node].part);

		/*>>>>>>>>>>>>>>>>> 1pass$BL\$O!$3F%N!<%I$K>pJs$r=q$-9~$`(B <<<<<<<<<<<<<<<<<<*/

		if (Node_tbl[node].from_f0 > Node_tbl[node].from_f1) {

			Node_tbl[node].phase = NEGA;
			ret_val = Node_tbl[node].from_f0;

		} else if (Node_tbl[node].from_f0 < Node_tbl[node].from_f1) {

			Node_tbl[node].phase = POSI;
			ret_val = Node_tbl[node].from_f1;

		} else {
			/* $B$b$7F1$8CM$G!$JRB&$,?.9f@~$J$i!$?.9f@~$rM%@h$9$k!%(B */

			assert(Node_tbl[node].from_f0 == Node_tbl[node].from_f1);
			
			if (is_signal(GET_BDD_F0(node)) == TRUE) {
				assert((is_signal(GET_BDD_F1(node)) == TRUE) ||
					   (GET_BDD_F1(node) == BDD_FALSE) ||
					   (GET_BDD_F1(node) == BDD_TRUE));

				Node_tbl[node].phase = NEGA;

				ret_val = Node_tbl[node].from_f0;
			} else if (is_signal(GET_BDD_F1(node)) == TRUE) {
				assert ((GET_BDD_F0(node) == BDD_FALSE) ||
						(GET_BDD_F0(node) == BDD_TRUE));

				Node_tbl[node].phase = POSI;

				ret_val = Node_tbl[node].from_f1;
			} else if ((is_signal(GET_BDD_F1(node)) == FALSE) &&
					   (is_signal(GET_BDD_F0(node)) == FALSE) &&
					   (GET_BDD_F1(node) != BDD_FALSE) &&
					   (GET_BDD_F1(node) != BDD_TRUE) &&
					   (GET_BDD_F0(node) != BDD_FALSE) &&
					   (GET_BDD_F0(node) != BDD_TRUE)) {

				Node_tbl[node].phase = NEGA;

				ret_val = Node_tbl[node].from_f0;
			} else {
				fprintf(stderr, "[ERROR] : LINE:%d in %s\n", __LINE__, __FILE__);
				exit(-1);
			}
		}
		if (Node_tbl[node].is_buf_inserted == TRUE) { /* Buffer$B$,A^F~$5$l$F$$$?$i(B */
			return (ret_val + 2 + GET_BDD_REF_CT(node));
			/* 2$B$OIi2Y%<%m$N$H$-$N%$%s%P!<%?8GM-CY1d$H$7$F$N8+@Q$j(B */
		} else { 									/* Buffer$B$,A^F~$5$l$F$$$J$$(B */
			assert(Node_tbl[node].is_buf_inserted == FALSE);
			return ret_val;
		}
	}
	fprintf(stderr, "[ERROR] LINE:%d in %s\n", __LINE__, __FILE__);
	exit(-1);
}

/*
 *	Tr.$B$N(BON/OFF$B$r7h$a$k(B2pass$BL\(B
 *
 */

static void
#ifdef __STDC__
r_check_on_tr_2pass(int node, int output_id)
#else
r_check_on_tr_2pass(node, output_id)
  int node;
  int output_id;
#endif /* __STDC__ */
{
	int cur_level = GET_BDD_LEVEL(node);

	assert((0 < node) && (node < Max_node_num));
	assert((0 < cur_level) && (cur_level < (Input_val_num + 3)));

	if ((node == BDD_TRUE) ||
		(node == BDD_FALSE) ||
		(is_signal(node) == TRUE)) {
		return;
	} else {
		if (Node_tbl[node].phase == NEGA) {
			Tr_usage_tbl[output_id][cur_level].phase = NEGA;
			Tr_usage_tbl[output_id][cur_level].usage = USED_TR;
			r_check_on_tr_2pass(GET_BDD_F0(node), output_id);
		} else {
			assert(Node_tbl[node].phase == POSI);

			Tr_usage_tbl[output_id][cur_level].phase = POSI;
			Tr_usage_tbl[output_id][cur_level].usage = USED_TR;
			r_check_on_tr_2pass(GET_BDD_F1(node), output_id);
		}
	}
	return;
}

/*
 *	$B%H%i%s%8%9%?$N(BON/OFF$B$rD4$Y$k!%(B
 *
 */

static void
#ifdef __STDC__
check_on_tr(void)
#else
check_on_tr(/* void */)
#endif /* __STDC__ */
{
	int i, j;
	int ret;

	int max_ret = 0;
	Max_delay_output_idx = 0;	/* $B=PNO$N$?$a$K:GBgCY1d$G$"$m$&$H;W$o$l$k(B */
	                            /* output$B$rJ]B8$9$k!%(B*/

	/* for each output */
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE) {

			ret = r_check_on_tr_1pass(Output_val_tbl[i].pt_to_dag, 0, 0);

			if (ret >= max_ret) {
				Max_delay_output_idx = i;
				max_ret = ret;
			}

			r_check_on_tr_2pass(Output_val_tbl[i].pt_to_dag, i);
			for (j = 3; j < (Input_val_num + 3); j++) {
				if (Tr_usage_tbl[i][j].usage == USED_TR)
					if (Tr_on_off_tbl[j].max_val <= ret) {
						Tr_on_off_tbl[j].phase = Tr_usage_tbl[i][j].phase;
						Tr_on_off_tbl[j].max_val = ret;
					}
				
			}
		}
	}

	PRINT_TR_ON_OFF_TBL;

/*	PRINT_TR_ON_OFF_TBL_FOR_EACH_OUTPUT;*/

	return;
}

/*
 *	$B%H%i%s%8%9%?$NCY1d;~4V$,:G$bBg$-$/$J$k$G$"$m$&!$%H%i%s%8%9%?$N(BON/OFF
 *	$B%Q%?%s$r8+$D$1$k!%(B
 */

void
#ifdef  __STDC__
set_switch_pattern(void)
#else
set_switch_pattern(/* void */)  
#endif /* __STDC__ */
{
	init_switch_pattern_info();
	
	check_on_tr();

/*	PRINT_TR_ON_OFF_TBL;*/

	return;
}


/*
 *	Back Pointer$B$r%;%C%H$9$k4X?t$d!$%H%i%s%8%9%?$N(BON/OFF$B$r8+$k$?$a$N(B
 *	$B:G>eN.$N4X?t!%(B
 */

void
#ifdef __STDC__
set_back_pt(void)
#else
set_back_pt(/* void */)
#endif /* __STDC__ */
{
	int i, j;

	gc();

	all_free_edge_list();

	CHECK_ALL_FREE_EDGE_LIST;

	/* $B%k!<%H$K$5$5$l$F$$$?$i!$$^$:!$%N!<%I$NCf$K%k!<%H$K$5$5$l(B */
	/* $B$F$$$k$H65$($k%U%i%0$rN)$F$k!%(B*/
	set_pted_from_pout_flag();


	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0))
			continue;	/* $BL$;HMQ%N!<%I$O%9%k!<(B */
		else {
			/* $B$b$7%k!<%H$K$5$5$l$F$$$?$i(B */
			if (Node_tbl[i].is_pt_from_pout == TRUE) {
				/* $BA4It$N%k!<%H$K$D$$$F(B */
				for (j = 0; j < Function_num; j++) {
					if ((Output_val_tbl[j].is_primary_out == TRUE) &&
						(Output_val_tbl[j].pt_to_dag == i)) {
						assert(j != NOT_EXIST);
						assert((0 <= j) && (j < Function_num));
						add_back_pt_from_pout(j, i);
					}
				}
			}

			/* 0$B;^$N;X$9@h$K$D$$$F=q$-9~$`(B */
			add_back_pt(i, GET_BDD_F0(i));
			/* 1$B;^$N;X$9@h$K$D$$$F=q$-9~$`(B */
			add_back_pt(i, GET_BDD_F1(i));

		}
	}

	CHECK_BACK_PT_NUM;

	CHECK_BACK_PT;

	return;
}

