/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	$B%P%C%U%!A^F~ItJ,(B
*
*******************************************************************/
#include <stdio.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"

#include "bdd_print.h"

extern int Input_val_num;
extern int Max_node_num;
extern int Function_num;
extern node_t *Node_tbl;
extern tr_on_off_tbl_t *Tr_on_off_tbl;
extern double Const_time;
extern output_node_t *Output_val_tbl;

extern sort_tbl_for_bufins *Bufins_sort_tbl;

int Ct_for_bufins;
double Max_violation_ratio;

/*
 *	$B%P%C%U%!A^F~$N$?$a$N%=!<%H%F!<%V%k$r%/%j%"(B
 *
 */

void
#ifdef __STDC__
reset_sort_tbl_for_bufins(void)
#else
reset_sort_tbl_for_bufins(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Max_node_num; i++) {
		Bufins_sort_tbl[i].node_idx = 0;
		Bufins_sort_tbl[i].on_critical_path_ct = 0;
		Bufins_sort_tbl[i].fanout = 0;
		Bufins_sort_tbl[i].level = 0;
		Bufins_sort_tbl[i].diff = 0;
	}
	return;
}

/*
 *	on_critical_path_ct > 0$B$N%N!<%I$r%3%T!<$9$k!%(B
 *
 */

void
#ifdef __STDC__
copy_sort_tbl(int ideal_level)
#else
copy_sort_tbl(ideal_level)
  int ideal_level;
#endif /* __STDC__ */
{
	int i;

	Ct_for_bufins = 0;
	for (i = 2; i < Max_node_num; i++) {
		if (Node_tbl[i].on_critical_path_ct > 0) {
			printf("PUYOPUYO i : %d\n", i);

			Bufins_sort_tbl[Ct_for_bufins].node_idx = i;
			Bufins_sort_tbl[Ct_for_bufins].on_critical_path_ct =
				Node_tbl[i].on_critical_path_ct;
			Bufins_sort_tbl[Ct_for_bufins].fanout =
				Node_tbl[i].ref_ct;
			Bufins_sort_tbl[Ct_for_bufins].level =
				Node_tbl[i].level;
			Bufins_sort_tbl[Ct_for_bufins].diff =
				abs(Node_tbl[i].level - ideal_level);
			Ct_for_bufins++;
		}
	}
	return;
}

/*
 *	$B%=!<%H$9$k!%(B
 *
 */

void
#ifdef __STDC__
sorting_for_bufins(void)
#else
sorting_for_bufins(/* void */)
#endif /* __STDC__ */
{
	int a = Input_val_num;
	int i, j;
	int key, key2;
	int w1 = 2;
	int w2;
	int tmp;

	while (a >>= 1) {
		w1 *= 2;
	}
	a = Function_num;
	w2 = 2;
	while (a >>= 1)
		w2 *= 2;

	assert((w1 > Input_val_num) && (w2 > Input_val_num));

	w1 *= w2;

	printf("****************************************\n");
	for (i = 0; i < Ct_for_bufins; i++) {
		printf("[%d] %d %d %d %d key1:%d\n",
			   i,
			   Bufins_sort_tbl[i].fanout,
			   Bufins_sort_tbl[i].on_critical_path_ct,
			   Bufins_sort_tbl[i].diff,
			   Bufins_sort_tbl[i].level,
			   Bufins_sort_tbl[i].diff*w1 +
			   Bufins_sort_tbl[i].fanout*w2 +
			   Bufins_sort_tbl[i].on_critical_path_ct);
	}
	printf("****************************************\n");


	for (i = 0; i < (Ct_for_bufins - 1); i++) {

		key = 	Bufins_sort_tbl[i].fanout*w1 +
			    Bufins_sort_tbl[i].diff*w2 + 
				Bufins_sort_tbl[i].on_critical_path_ct;


		for (j = i + 1; j < Ct_for_bufins; j++) {
			key2 = Bufins_sort_tbl[j].fanout*w1 +
				   Bufins_sort_tbl[j].diff*w2 + 
				   Bufins_sort_tbl[j].on_critical_path_ct;
	
			if (key < key2) {

				/* SWAP */
				tmp = Bufins_sort_tbl[i].node_idx;
				Bufins_sort_tbl[i].node_idx = Bufins_sort_tbl[j].node_idx;
				Bufins_sort_tbl[j].node_idx = tmp;

				tmp = Bufins_sort_tbl[i].on_critical_path_ct;
				Bufins_sort_tbl[i].on_critical_path_ct = Bufins_sort_tbl[j].on_critical_path_ct;
				Bufins_sort_tbl[j].on_critical_path_ct = tmp;

				tmp = Bufins_sort_tbl[i].fanout;
				Bufins_sort_tbl[i].fanout = Bufins_sort_tbl[j].fanout;
				Bufins_sort_tbl[j].fanout = tmp;

				tmp = Bufins_sort_tbl[i].level;
				Bufins_sort_tbl[i].level = Bufins_sort_tbl[j].level;
				Bufins_sort_tbl[j].level = tmp;

				tmp = Bufins_sort_tbl[i].diff;
				Bufins_sort_tbl[i].diff = Bufins_sort_tbl[j].diff;
				Bufins_sort_tbl[j].diff = tmp;

				key = key2;
			}
		}
	}

	/* BUGBUG */
	printf("****************************************\n");
	for (i = 0; i < Ct_for_bufins; i++) {
		printf("After Sort [%d] %d %d %d %d\n",
			   Bufins_sort_tbl[i].node_idx,
			   Bufins_sort_tbl[i].fanout,
			   Bufins_sort_tbl[i].on_critical_path_ct,
			   Bufins_sort_tbl[i].diff,
			   Bufins_sort_tbl[i].level);
	}
	printf("****************************************\n");
	return;
}

/*
 *
 *
 */


void
#ifdef __STDC__
reset_critical_path_ct(void)
#else
reset_critical_path_ct(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Max_node_num; i++) {
		Node_tbl[i].on_critical_path_ct = 0;
	}
	return;
}


/*
 *	BDD$B$N%N!<%I$N(Bidx$B$G$"$k(Bidx$B$rEO$9$H!$$=$N;~E@$N%F%9%H%Q%?%s$K=>$C$F(B
 *	$B%Q%9>e$N%N!<%I$N%+%&%s%?$r%$%s%/%j%a%s%H(B
 */

void
#ifdef __STDC__
r_set_buf_ins_ct(int idx)
#else
r_set_buf_ins_ct(idx)
  int idx;
#endif /* __STDC__ */
{
	int level;
	phase_t is_on;

	level = GET_BDD_LEVEL(idx);

	if ((is_signal(idx) == TRUE) ||
		(idx == BDD_TRUE) ||
		(idx == BDD_FALSE))
		return;
	else {
		if (Tr_on_off_tbl[level].phase == NEGA) {
			Node_tbl[idx].on_critical_path_ct++;
			r_set_buf_ins_ct(Node_tbl[idx].f0);
		} else {
			Node_tbl[idx].on_critical_path_ct++;
			r_set_buf_ins_ct(Node_tbl[idx].f1);
		}
	}
	return;
}

/*
 *	$B%P%C%U%!A^F~$N$?$a$N%+%&%s%?$,(B0$B$G$J$$%N!<%I$rI=<((B
 *
 */

void
#ifdef __STDC__
print_buf_candidate_node(void)
#else
print_buf_candidate_node(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Max_node_num; i++) {
		if (Node_tbl[i].on_critical_path_ct > 0)
			printf("Node_tbl[%d].on_critical_path_ct : %d (level:%d fanout:%d)\n",
				   i, Node_tbl[i].on_critical_path_ct,
				   Node_tbl[i].level, Node_tbl[i].ref_ct);
	}
	return;
}


/*
 *	$B%P%C%U%!A^F~$N<BBN(B
 *
 */

void
#ifdef __STDC__
ins_buf(void)
#else
ins_buf(/* void */)
#endif /* __STDC__ */
{
	int node_idx;
	int i;

	for (i = 0; i < Ct_for_bufins; i++) {
		node_idx = Bufins_sort_tbl[i].node_idx;
		if (Node_tbl[node_idx].is_buf_inserted == FALSE) {
			Node_tbl[node_idx].is_buf_inserted = TRUE;
			printf("Node %d is inserted\n", node_idx);
			return;
		}
	}
	return;
}

/*
 *	$B%P%C%U%!A^F~$N%a%$%sItJ,(B
 *
 */

void
#ifdef __STDC__
buf_ins(void)
#else
buf_ins(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ideal_level;
	int max_delay_output;
	double max_delay = 0.0;
	boolean_t is_violation = FALSE;


	reset_sort_tbl_for_bufins();

	for (i = 0; i < Function_num; i++) {
		if (max_delay < Output_val_tbl[i].delay_time) {
			max_delay = Output_val_tbl[i].delay_time;
			max_delay_output = i;
		}
	}


	Max_violation_ratio = 0.0;
	if (max_delay <= Const_time) {
		printf("********** Timing Constraints OK\n");
		return;
	} else {
		printf("********** max_delay : %lf Const_time : %lf\n", max_delay, Const_time);
		Max_violation_ratio = max_delay/Const_time;
	}

	r_set_buf_ins_ct(Output_val_tbl[max_delay_output].pt_to_dag);
	
	ideal_level = (int)(Input_val_num/Max_violation_ratio);
	
	printf("ideal_level = %d\n", ideal_level);
	
	assert((0 < ideal_level) && (ideal_level < Input_val_num));
	
	printf("Before Copy\n");
	
	copy_sort_tbl(ideal_level);
	printf("After Copy\n");
	sorting_for_bufins();
	
	ins_buf();			
	

	print_buf_candidate_node();
}
