/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*****
 *	$B%?%$%^%k!<%A%s(B
 *	UNIX $B%M%C%H%o!<%/%W%m%0%i%_%s%0!J(Bpp.856--$B!K(B
 *
 *	void 	t_start(void)		$B%?%$%^$N5/F0(B
 *	void 	t_stop(void)		$B%?%$%^$NDd;_(B
 *	double	t_getrtime(void)	$B<B7P2a;~4V$rIC$GJV$9!J%^%$%/%mIC$^$G!K(B
 *	double	t_getutime(void)	$B%f!<%6;~4V$rIC$GJV$9!J%^%$%/%mIC$^$G!K(B
 *	double	t_getstime(void)	$B%7%9%F%`;~4V$rIC$GJV$9!%!J%^%$%/%mIC$^$G!K(B
 *
 *	 Programmed by KONISHI,Kenzo and YASHIKI,Masafumi
 *
 *	 Division of Intelligent Science,
 *	 Graduate School of Technology & Science,
 *	 Kobe University
 *
 *****/

#include <stdio.h>

#ifdef SUN413
#define BSD
#endif /* SUN_OS 4.1.3 */

#ifdef SUN_OS
#define BSD
#endif /* SUN_OS */

#ifdef SOLARIS
#define SYSV
#endif /* SOLARIS */

#ifdef BSD
#include <sys/time.h>
#include <sys/resource.h>
#endif /* BSD */

#ifdef SYSV
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>
#define TICKS HZ
#endif /* SYSV */

#ifdef BSD
static struct timeval	time_start, time_stop;
static struct rusage	ru_start, ru_stop;
#endif /* BSD */

#ifdef SYSV
static long time_start, time_stop;
static struct tms tms_start, tms_stop;
long times();
#endif /* SYSV */

static double start, stop, seconds;

/*
 *
 *
 */

void
#ifdef __STDC__
t_start(void)
#else
t_start()
#endif /* __STDC__ */
{

#ifdef BSD
	if (gettimeofday(&time_start, (struct timezone *)0) < 0) {
		fprintf(stderr, "gettimeofday() error LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}
	if (getrusage(RUSAGE_SELF, &ru_start) < 0) {
		fprintf(stderr, "getrusage() error LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}
#endif /* BSD */

#ifdef SYSV
	if ((time_start = times(&tms_start)) == -1) {
		fprintf(stderr, "times() error LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}
#endif /* SYSV */

	return;
}
	
/*
 *
 *
 */

void
#ifdef __STDC__
t_stop(void)
#else
t_stop()
#endif /* __STDC__ */
{
#ifdef BSD
	if (getrusage(RUSAGE_SELF, &ru_stop) < 0) {
		fprintf(stderr, "getrusage() error LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}
	if (gettimeofday(&time_stop, (struct timezone *) 0) < 0) {
		fprintf(stderr, "gettimeofday() error LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}
#endif /* BSD */

#ifdef SYSV
	if ((time_stop = times(&tms_stop)) == -1) {
		fprintf(stderr, "times() error LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}
#endif /* SYSV */

	return;
}

/*
 *
 *
 */

double
#ifdef __STDC__
t_getutime(void)
#else
t_getutime()
#endif /* __STDC__ */
{

#ifdef BSD
	start = ((double) ru_start.ru_utime.tv_sec) * 1000000.0
		+ ru_start.ru_utime.tv_usec;
	stop = ((double) ru_stop.ru_utime.tv_sec) * 1000000.0
		+ ru_stop.ru_utime.tv_usec;
	seconds = (stop - start)/1000000.0;
#endif /* BSD */

#ifdef SYSV
	seconds = (double)(tms_stop.tms_utime - tms_start.tms_utime)/
		(double)TICKS;
#endif /* SYSV */

	return seconds;
}

/*
 *
 *
 */

double
#ifdef __STDC__
t_getstime(void)
#else
t_getstime()
#endif /* __STDC__ */
{

#ifdef BSD
	start = ((double) ru_start.ru_stime.tv_sec) * 1000000.0
		+ ru_start.ru_stime.tv_usec;
	stop = ((double)ru_stop.ru_stime.tv_sec) * 1000000.0
		+ ru_stop.ru_stime.tv_usec;
	seconds = (stop - start)/1000000.0;
#endif /* BSD */

#ifdef SYSV
	seconds = (double)(tms_stop.tms_stime - tms_start.tms_stime)/
		(double)TICKS;
#endif /* SYSV */

	return seconds;
}

/*
 *
 *
 */

double
#ifdef __STDC__
t_getrtime(void)
#else
t_getrtime()
#endif /* __STDC__ */
{

#ifdef BSD
	start = ((double) time_start.tv_sec) * 1000000.0
		+ time_start.tv_usec;
	stop = ((double) time_stop.tv_sec) * 1000000.0
		+ time_stop.tv_usec;
	seconds = (stop - start)/1000000.0;
#endif /* BSD */

#ifdef SYSV
	seconds = (double)(time_stop - time_start)/(double)TICKS;
#endif /* SYSV */

	return seconds;
}


