/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*
*
*******************************************************************/

#include <stdio.h>
#include <string.h>

#include <stdlib.h>
#include <time.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "bdd_etc.h"
#include "error.h"


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/
/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern val_tbl_t *Input_val_tbl;
extern output_node_t *Output_val_tbl;
extern node_t *Node_tbl;

extern int Input_val_num;
extern int Max_node_num;
extern int Function_num;

extern char Module_name_for_HDL[];

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

int Max_grid_width;
int Max_grid_depth;

char Out_Ps_File[STRSIZE];

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/* set_bdd_grid(int depth)
 *   $B3F%N!<%I$N0LCV(B(grid (x,y) )$B$r7h$a$k4X?t(B
 *
 */

static void
#ifdef __STDC__
set_bdd_grid(int depth, int width)
#else
set_bdd_grid(depth, width)
  int depth;
  int width;
#endif /* __STDC__ */
{
	int i, j;
	int middle;
	int x;


	Max_grid_width = width*2 + 1;
	Max_grid_depth = depth*2 + 1;   /* $BJQ99E@!JG[@~NN0h$r9-$2$?!K(B*/

	
	middle = Max_grid_width/2 + 1;

	
	for (i = 3; i <= (Input_val_num + 3); i++) {
		
		if (Input_val_tbl[i].node_num%2 == 0) {

			/* $BI}$,6v?t(B */
			x = middle - Input_val_tbl[i].node_num + 1;
			
			for (j = 0; j < Max_node_num; j++)
				if (Node_tbl[j].level == i) {
					
					Node_tbl[j].x_grid = x;
					Node_tbl[j].y_grid = 2*(i -2) + 1;
					x += 2;
				}
		
		} else {

			/* $BI}$,4q?t(B */
			x = middle - (Input_val_tbl[i].node_num/2)*2;
			
			for (j = 0; j < Max_node_num; j++)
				if (Node_tbl[j].level == i) {
					
					Node_tbl[j].x_grid = x;
					Node_tbl[j].y_grid = 2*(i - 2) + 1;
					x += 2;
				}
		}
	}


	/* 0$B!$#1$N(B grid $B$O!$FCJL07$$(B */
	Node_tbl[BDD_FALSE].x_grid = middle - 1;
	Node_tbl[BDD_FALSE].y_grid = 1;

	Node_tbl[BDD_TRUE].x_grid = middle + 1;
	Node_tbl[BDD_TRUE].y_grid = 1;
	
	return;
}

/*
 *	For DEBUG
 *
 */

static void
#ifdef __STDC__
print_grid(void)
#else
print_grid()
#endif /* __STDC__ */
{
	int i, j;

#if VERBOSE > 2
	printf("\nMax_grid_depth = %d, Max_grid_width = %d\n\n",
		   Max_grid_depth, Max_grid_width);

	for(i = 3; i < (Input_val_num + 3); i ++) {
		printf("%s:%d\n", level_to_val(i), Input_val_tbl[i].node_num);

		for(j = 3; j < Max_node_num; j ++) {
			if(GET_BDD_LEVEL(j) == i)
				printf("(%d,%d) ", Node_tbl[j].x_grid, Node_tbl[j].y_grid);
		}
		printf("\n");
	}

	printf("0: (%d,%d), 1: (%d,%d)\n\n",
		   Node_tbl[BDD_FALSE].x_grid, Node_tbl[BDD_FALSE].y_grid,
		   Node_tbl[BDD_TRUE].x_grid, Node_tbl[BDD_TRUE].y_grid);
		
#endif /* VERBOSE > 2 */

	return;
}

/*
 *
 *
 */

void
#ifdef __STDC__
bdd_ps_out(char *fname)
#else
bdd_ps_out(fname)
  char *fname;
#endif /* __STDC__ */
{
	int max_depth=0;
	int max_width;
	int i;
	int str_size;
	int j, k;
	int name_pos = 0;
	int ext_pos = 0;
	char buf[STRSIZE];

	str_size = strlen(fname);

	for (j = 0; j < str_size; j++) {
		if (fname[j] == '/')
			name_pos = j;
		if (fname[j] == '.')
			ext_pos = j;
	}

	for (k = 0,j = (name_pos + 1); j < ext_pos; j++,k++) {
		buf[k] = fname[j];
	}
	buf[k] = '\0';

	strcpy(Out_Ps_File, buf);

	max_depth = Input_val_num;
	
	max_width = 0;
	count_each_level_node();


	for (i = 3; i < (Input_val_num + 3); i++)
		if (max_width < Input_val_tbl[i].node_num)
			max_width = Input_val_tbl[i].node_num;



	assert(0 < max_width);

	set_bdd_grid(max_depth, max_width);

/*	print_grid(); */

	bdd_ps_init();

	/* $B4X?tL>$r=PNO(B */
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE)
			bdd_func_name(i);
	}

	/* $B%N!<%I$r=PNO(B */
	for (i = 1; i < Max_node_num; i++) {
		if (GET_BDD_LEVEL(i) != UN_USED) {
			
			if ((i == BDD_FALSE) &&
				(GET_BDD_REF_CT(i) > 0) &&
				(GET_BDD_LEVEL(i) != UN_USED)){

				bdd_ps_node0();
			}
			else if ((i == BDD_TRUE) &&
					 (GET_BDD_REF_CT(i) > 0) && 
					 (GET_BDD_LEVEL(i) != UN_USED)){

				bdd_ps_node1();
			}
			else if((i != BDD_FALSE) && (i != BDD_TRUE)) {
				
				assert(GET_BDD_REF_CT(i) != 0);
			
				bdd_ps_node(i, level_to_val(GET_BDD_LEVEL(i)));
			}
			

			if ((i != BDD_FALSE) && (i != BDD_TRUE)) {
				bdd_ps_edge0(i, GET_BDD_F0(i));
				bdd_ps_edge1(i, GET_BDD_F1(i));
			}

		}
	}

	bdd_ps_end();

	return;
}

