/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*
*
*******************************************************************/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <sys/timeb.h>
#include <sys/types.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "bdd_etc.h"
#include "error.h"

#define RAD 20
#define MIN_RAD 5

extern node_t *Node_tbl;

extern int Max_grid_width;
extern int Max_grid_depth;

extern int Function_num;
extern output_node_t *Output_val_tbl;

extern char Out_Ps_File[];

FILE *Bdd_ps_fp;
int **Bdd_grid;

static int Bound_x, Bound_y;

/*
 *
 *
 */

void
#ifdef __STDC__
bdd_ps_init(void)
#else
bdd_ps_init(/* void */)
#endif /* __STDC__ */
{
	char fname[BUFSIZ];

	sprintf(fname, "%s.eps", Out_Ps_File);

	Bdd_ps_fp = fopen(fname, "wt");

	if (Bdd_ps_fp == NULL) {
		fprintf(stderr, "Cannot open file : %s\n", fname);
		exit(-1);
	}

	Bound_x = (2*RAD + 10)*Max_grid_width;
	Bound_y = (2*RAD + 10)*Max_grid_depth + RAD;


	fprintf(Bdd_ps_fp, "%%!PS-Adobe-2.0 EPSF-1.2\n");
	fprintf(Bdd_ps_fp, "%%%%BoundingBox: 0 0 %d %d\n", Bound_x, Bound_y);
	fprintf(Bdd_ps_fp, "%%%%Title: %s\n", Out_Ps_File);
	fprintf(Bdd_ps_fp, "%%%%EndComments\n");
	fprintf(Bdd_ps_fp, "/Times-Roman findfont\n");
	fprintf(Bdd_ps_fp, "20 scalefont\n");
	fprintf(Bdd_ps_fp, "setfont\n");
}

/*
 *
 *
 */
void
#ifdef __STDC__
bdd_func_name(int root_index)
#else
bdd_func_name(root_index)
  int root_index;
#endif /* __STDC__ */
{
	char func_name[BUFSIZ];
	int link_node;
	int x, y;
	int org_ctr_x, org_ctr_y;

	
	assert((0 <= root_index) && (root_index < Function_num));
	
	strcpy(func_name, Output_val_tbl[root_index].output_name);

	link_node = Output_val_tbl[root_index].pt_to_dag;

	assert((0 <= Node_tbl[link_node].x_grid) &&
		   (Node_tbl[link_node].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[link_node].y_grid) &&
		   (Node_tbl[link_node].y_grid <= Max_grid_depth));

	org_ctr_x = (2*RAD + 10)*Node_tbl[link_node].x_grid - (RAD + 5);
	org_ctr_y = (2*RAD + 10)*Node_tbl[link_node].y_grid - (RAD + 5);

	x = org_ctr_x - RAD;
	y = org_ctr_y + RAD;

	assert((0 <= x) && (x <= Bound_x));
	assert((0 <= y) && (y <= Bound_y));

	fprintf(Bdd_ps_fp, "%d %d moveto\n", x-5, y+3);
	fprintf(Bdd_ps_fp, "(%s) show\n", func_name);

	
	return;
}

/*
 *	node1$B$N(B0$B;^$r(Bnode2$B$K$D$J$2$k!%(B
 *
 */

void
#ifdef __STDC__
bdd_ps_edge0(int node1, int node2)
#else
bdd_ps_edge0(node1, node2)
  int node1;
  int node2;
#endif /* __STDC__ */
{
	int src_x, src_y;
	int sink_x, sink_y;

	assert((0 <= Node_tbl[node1].x_grid) &&
		   (Node_tbl[node1].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node1].y_grid) &&
		   (Node_tbl[node1].y_grid <= Max_grid_depth));

	src_x = ((2*RAD + 10)*Node_tbl[node1].x_grid - (RAD + 5)) - (int)((double)RAD/sqrt(2.0));
	src_y = ((2*RAD + 10)*Node_tbl[node1].y_grid - (RAD + 5)) - (int)((double)RAD/sqrt(2.0));

	assert((0 <= src_x) && (src_x <= Bound_x));
	assert((0 <= src_y) && (src_y <= Bound_y));

	assert((0 <= Node_tbl[node2].x_grid) &&
		   (Node_tbl[node2].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node2].y_grid) &&
		   (Node_tbl[node2].y_grid <= Max_grid_depth));
	
	sink_x = ((2*RAD+10)*Node_tbl[node2].x_grid - (RAD + 5)) - src_x;
	sink_y = ((2*RAD+10)*Node_tbl[node2].y_grid - (RAD + 5)) + RAD - src_y;

	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d moveto\n", src_x, src_y);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", sink_x, sink_y);
	fprintf(Bdd_ps_fp, "stroke\n");

	return;
}

/*
 *	node1$B$N(B1$B;^$r(Bnode2$B$K$D$J$2$k!%(B
 *
 */

void
#ifdef __STDC__
bdd_ps_edge1(int node1, int node2)
#else
bdd_ps_edge1(node1, node2)
  int node1;
  int node2;
#endif /* __STDC__ */
{
	int src_x, src_y;
	int sink_x, sink_y;

	src_x = ((2*RAD + 10)*Node_tbl[node1].x_grid - (RAD + 5)) + (int)((double)RAD/sqrt(2.0));
	src_y = ((2*RAD + 10)*Node_tbl[node1].y_grid - (RAD + 5)) - (int)((double)RAD/sqrt(2.0));
	
	assert((0 <= Node_tbl[node1].x_grid) &&
		   (Node_tbl[node1].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node1].y_grid) &&
		   (Node_tbl[node1].y_grid <= Max_grid_depth));


	assert((0 <= src_x) && (src_x <= Bound_x));
	assert((0 <= src_y) && (src_y <= Bound_y));

	assert((0 <= Node_tbl[node2].x_grid) &&
		   (Node_tbl[node2].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node2].y_grid) &&
		   (Node_tbl[node2].y_grid <= Max_grid_depth));

	sink_x = ((2*RAD+10)*Node_tbl[node2].x_grid - (RAD + 5)) - src_x;
	sink_y = ((2*RAD+10)*Node_tbl[node2].y_grid - (RAD + 5)) + RAD - src_y;

	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d moveto\n", src_x, src_y);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", sink_x, sink_y);
	fprintf(Bdd_ps_fp, "stroke\n");


	return;
}

/*
 *	node1$B$N(B1$B;^$rH]Dj;^$H$7$F(Bnode2$B$K$D$J$2$k!%(B
 *
 */

void
#ifdef __STDC__
bdd_ps_not_edge1(int node1, int node2)
#else
bdd_ps_not_edge1(node1, node2)
  int node1;
  int node2;
#endif /* __STDC__ */
{
	int src_x, src_y;
	int sink_x, sink_y;
	int ctr_x, ctr_y;

	assert((0 <= Node_tbl[node1].x_grid) &&
		   (Node_tbl[node1].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node1].y_grid) &&
		   (Node_tbl[node1].y_grid <= Max_grid_depth));

	src_x = ((2*RAD+10)*Node_tbl[node1].x_grid - (RAD + 5))
		+ (int)((double)RAD/sqrt(2.0));
	src_y = ((2*RAD+10)*Node_tbl[node1].y_grid - (RAD + 5))
		- (int)((double)RAD/sqrt(2.0));

	ctr_x = src_x + (int)((double)MIN_RAD/sqrt(2.0));
	ctr_y = src_y - (int)((double)MIN_RAD/sqrt(2.0));

	src_x += (int)(sqrt(2.0)*(double)MIN_RAD);
	src_y -= (int)(sqrt(2.0)*(double)MIN_RAD);

	assert((0 <= src_x) && (src_x <= Bound_x));
	assert((0 <= src_y) && (src_y <= Bound_y));

	assert((0 <= Node_tbl[node2].x_grid) &&
		   (Node_tbl[node2].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node2].y_grid) &&
		   (Node_tbl[node2].y_grid <= Max_grid_depth));

	sink_x = ((2*RAD+10)*Node_tbl[node2].x_grid - (RAD + 5)) - src_x;
	sink_y = ((2*RAD+10)*Node_tbl[node2].y_grid - (RAD + 5)) + RAD - src_y;

	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d %d 0 360 arc stroke\n", ctr_x, ctr_y, MIN_RAD);
	
	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d moveto\n", src_x, src_y);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", sink_x, sink_y);
	fprintf(Bdd_ps_fp, "stroke\n");

	return;
}


/*
 *	node1$B$N(B0$B;^$rH]Dj;^$H$7$F(Bnode2$B$K$D$J$2$k!%(B
 *
 */

void
#ifdef __STDC__
bdd_ps_not_edge0(int node1, int node2)
#else
bdd_ps_not_edge0(node1, node2)
  int node1;
  int node2;
#endif /* __STDC__ */
{
	int src_x, src_y;
	int sink_x, sink_y;
	int ctr_x, ctr_y;

	assert((0 <= Node_tbl[node1].x_grid) &&
		   (Node_tbl[node1].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node1].y_grid) &&
		   (Node_tbl[node1].y_grid <= Max_grid_depth));

	src_x = ((2*RAD+10)*Node_tbl[node1].x_grid - (RAD + 5))
		- (int)((double)RAD/sqrt(2.0));
	src_y = ((2*RAD+10)*Node_tbl[node1].y_grid - (RAD + 5))
		- (int)((double)RAD/sqrt(2.0));

	ctr_x = src_x - (int)((double)MIN_RAD/sqrt(2.0));
	ctr_y = src_y - (int)((double)MIN_RAD/sqrt(2.0));

	src_x -= (int)(sqrt(2.0)*(double)MIN_RAD);
	src_y -= (int)(sqrt(2.0)*(double)MIN_RAD);

	assert((0 <= src_x) && (src_x <= Bound_x));
	assert((0 <= src_y) && (src_y <= Bound_y));

	assert((0 <= Node_tbl[node2].x_grid) &&
		   (Node_tbl[node2].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node2].y_grid) &&
		   (Node_tbl[node2].y_grid <= Max_grid_depth));

	sink_x = ((2*RAD+10)*Node_tbl[node2].x_grid - (RAD + 5)) - src_x;
	sink_y = ((2*RAD+10)*Node_tbl[node2].y_grid - (RAD + 5)) + RAD - src_y;

	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d %d 0 360 arc stroke\n", ctr_x, ctr_y, MIN_RAD);
	
	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d moveto\n", src_x, src_y);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", sink_x, sink_y);
	fprintf(Bdd_ps_fp, "stroke\n");

	return;
}


/*
 *
 *
 */

void
#ifdef __STDC__
bdd_ps_node(int node, char *symbol)
#else
bdd_ps_node(node, symbol)
  int node;
  char *symbol;
#endif /* __STDC__ */
{
	int ctr_x, ctr_y;

	
	assert((0 <= Node_tbl[node].x_grid) &&
		   (Node_tbl[node].x_grid <= Max_grid_width));
	assert((0 <= Node_tbl[node].y_grid) &&
		   (Node_tbl[node].y_grid <= Max_grid_depth));

	ctr_x = (2*RAD + 10)*Node_tbl[node].x_grid - (RAD + 5);
	ctr_y = (2*RAD + 10)*Node_tbl[node].y_grid - (RAD + 5);

	assert((0 <= ctr_x) && (ctr_x <= Bound_x));
	assert((0 <= ctr_y) && (ctr_y <= Bound_y));

	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d 20 0 360 arc stroke\n", ctr_x, ctr_y);

	fprintf(Bdd_ps_fp, "%d %d moveto\n", ctr_x+21, ctr_y);
	fprintf(Bdd_ps_fp, "(%s) show\n", symbol);

	fprintf(Bdd_ps_fp, "%d %d moveto\n", ctr_x - 15, ctr_y - 10
			);
	fprintf(Bdd_ps_fp, "(%d) show\n", node);
	
	return;
}

/*
 *	0$B%N!<%I$r=PNO(B
 *
 */

void
#ifdef __STDC__
bdd_ps_node0(void)
#else
bdd_ps_node0()
#endif /* __STDC__ */
{
	int ctr_x = (2*RAD + 10)*Node_tbl[BDD_FALSE].x_grid - (RAD + 5);
	int ctr_y = (2*RAD + 10)*Node_tbl[BDD_FALSE].y_grid - (RAD + 5);
	
	int start_x = ctr_x - RAD;
	int start_y = ctr_y + RAD;

	assert((0 <= ctr_x) && (ctr_x <= Bound_x));
	assert((0 <= ctr_y) && (ctr_y <= Bound_y));

	assert((0 <= start_x) && (start_x <= Bound_x));
	assert((0 <= start_y) && (start_y <= Bound_y));

	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d moveto\n", start_x, start_y);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", 2*RAD, 0);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", 0, -2*RAD);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", -2*RAD, 0);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", 0, 2*RAD);
	fprintf(Bdd_ps_fp, "1 setlinewidth\n");
	fprintf(Bdd_ps_fp, "stroke\n");

	fprintf(Bdd_ps_fp, "%d %d moveto\n", ctr_x-4, ctr_y-6);
	fprintf(Bdd_ps_fp, "(0) show\n");

	return;
}

/*
 *	1$B%N!<%I$r=PNO(B
 *
 */

void
#ifdef __STDC__
bdd_ps_node1(void)
#else
bdd_ps_node1()
#endif /* __STDC__ */
{
	int ctr_x = (2*RAD + 10)*Node_tbl[BDD_TRUE].x_grid - (RAD + 5);
	int ctr_y = (2*RAD + 10)*Node_tbl[BDD_TRUE].y_grid - (RAD + 5);
	int start_x = ctr_x - RAD;
	int start_y = ctr_y + RAD;

	assert((0 <= ctr_x) && (ctr_x <= Bound_x));
	assert((0 <= ctr_y) && (ctr_y <= Bound_y));

	assert((0 <= start_x) && (start_x <= Bound_x));
	assert((0 <= start_y) && (start_y <= Bound_y));

	fprintf(Bdd_ps_fp, "newpath\n");
	fprintf(Bdd_ps_fp, "%d %d moveto\n", start_x, start_y);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", 2*RAD, 0);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", 0, -2*RAD);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", -2*RAD, 0);
	fprintf(Bdd_ps_fp, "%d %d rlineto\n", 0, 2*RAD);
	fprintf(Bdd_ps_fp, "1 setlinewidth\n");
	fprintf(Bdd_ps_fp, "stroke\n");

	fprintf(Bdd_ps_fp, "%d %d moveto\n", ctr_x-4, ctr_y-6);
	fprintf(Bdd_ps_fp, "(1) show\n");

	return;
}


/*
 *
 *
 */

void
#ifdef __STDC__
bdd_ps_end(void)
#else
bdd_ps_end()
#endif /* __STDC__ */
{
	fprintf(Bdd_ps_fp, "showpage\n");
	fclose(Bdd_ps_fp);

	return;
}

