/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	$B1i;;%-%c%C%7%e4X78(B
*
*******************************************************************/

#include <stdio.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/
/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/
/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern int Ope_cache_size;
extern int Max_node_num;

extern ope_cache_t *Ope_cache_tbl;
extern node_t *Node_tbl;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*
 *	$B1i;;%-%c%C%7%e$N%j%;%C%H(B
 *
 */

void
#ifdef __STDC__
reset_ope_cache(void)
#else
reset_ope_cache(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Ope_cache_size; i++) {
		CHECK_OPE_CACHE_T(&(Ope_cache_tbl[i]));
		Ope_cache_tbl[i].ope = NO_OP;
	}

	return;
}

/*
 *	$B1i;;%-%c%C%7%eMQ$N%O%C%7%e%F!<%V%k(B
 *
 */

int
#ifdef __STDC__
ope_hash_func(int bdd1, int bdd2, ope_t ope)
#else
ope_hash_func(bdd1, bdd2, ope)
  int bdd1;
  int bdd2;
  ope_t ope;
#endif /* __STDC__ */
{
	int cache_key;

	assert((0 < bdd1) && (bdd1 < Max_node_num));
	assert((0 < bdd2) && (bdd2 < Max_node_num));
/*	OPE_CHECK(ope);*/

	cache_key = (ope << 12) + (bdd1 << 10) + bdd2;
	cache_key %= Ope_cache_size;
	cache_key = abs(cache_key);

/*	cache_key = bdd1;
	cache_key %= Ope_cache_size;*/

	assert((0 <= cache_key) && (cache_key < Ope_cache_size));

	return cache_key;
}

/*
 *	$B1i;;%-%c%C%7%e$rC5:w$9$k$?$a$N4X?t(B
 *
 */

int
#ifdef __STD__
search_ope_cache(int bbd1, int bdd2, ope_t ope)
#else
search_ope_cache(bdd1, bdd2, ope)
  int bdd1;
  int bdd2;
  ope_t ope;
#endif /* __STDC__ */
{
	int idx;

	CHECK_NODE_T(&(Node_tbl[bdd1]));
	CHECK_NODE_T(&(Node_tbl[bdd2]));
/*	OPE_CHECK(ope);*/
	
	idx = ope_hash_func(bdd1, bdd2, ope);

	assert((0 <= idx) && (idx < Ope_cache_size));

	if ((Ope_cache_tbl[idx].ope == ope) &&
		(Ope_cache_tbl[idx].bdd1 == bdd1) &&
		(Ope_cache_tbl[idx].bdd2 == bdd2)) {

		assert((2 < Ope_cache_tbl[idx].result) &&
			   (Ope_cache_tbl[idx].result < Max_node_num));

		return Ope_cache_tbl[idx].result;
	} else
		return NOT_EXIST;
}


/*
 *	$B1i;;%-%c%C%7%e$K?7$?$J1i;;7k2L$r3JG<$9$k4X?t(B
 *
 */

void
#ifdef __STDC__
add_ope_cache(int bdd1, int bdd2, ope_t ope, int result)
#else
add_ope_cache(bdd1, bdd2, ope, result)
  int bdd1;
  int bdd2;
  ope_t ope;
  int result;
#endif /* __STDC__ */
{
	int idx;

	idx = ope_hash_func(bdd1, bdd2, ope);

	assert((0 <= idx) && (idx < Ope_cache_size));

	assert((2 < bdd1) && (bdd1 < Max_node_num));
	assert((2 < bdd2) && (bdd2 < Max_node_num));
	assert((2 < result) && (result < Max_node_num));
	OPE_CHECK(ope);

	Ope_cache_tbl[idx].ope = ope;
	Ope_cache_tbl[idx].bdd1 = bdd1;
	Ope_cache_tbl[idx].bdd2 = bdd2;
	Ope_cache_tbl[idx].result = result;

	return;
}
