/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	BDD$B=hM}7O$N=i4|2=$N$?$a$N4X?t72(B
*
*******************************************************************/

#include <stdio.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern int Max_node_num;
extern int Max_edge_num;
extern int Ope_cache_size;
extern int Node_hash_size;
extern int Input_val_num;
extern int Free_list_ct;
extern int Free_list_head;
extern char Spice_file_name[];

extern node_t *Node_tbl;
extern edge_t *Edge_tbl;
extern ope_cache_t *Ope_cache_tbl;
extern int **Node_hash_tbl;
extern int *Tmp_hash_tbl_for_swap;
extern int Edge_free_list_head;
extern sort_tbl_t *Sort_tbl;
extern sort_tbl_for_bufins *Bufins_sort_tbl;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*
 *
 *
 */

static void
#ifdef __STDC__
init_node_tbl(void)
#else
init_node_tbl(/* void */)
#endif /* __STDC__ */
{
	int i;

	assert(0 < Max_node_num);
	assert(Max_node_num <= MAX_NODE_NUM);
	
	Node_tbl = (node_t *)malloc(sizeof(node_t) * Max_node_num);
	if (Node_tbl == NULL)
		MALLOC_ERR;

	SET_NODE_T(&(Node_tbl[0]));

	/* 0$B=*C<(B(BDD_FALSE)$B$NEPO?(B */
	Node_tbl[BDD_FALSE].level = BDD_FALSE;
	Node_tbl[BDD_FALSE].f0 = UN_USED;
	Node_tbl[BDD_FALSE].f1 = UN_USED;
	Node_tbl[BDD_FALSE].ref_ct = 0;
	Node_tbl[BDD_FALSE].next = UN_USED;
	Node_tbl[BDD_FALSE].complement = BDD_TRUE;
	Node_tbl[BDD_FALSE].is_pt_from_pout = FALSE;
	Node_tbl[BDD_FALSE].is_buf_inserted = FALSE;
	Node_tbl[BDD_FALSE].back_pt_list = BACK_PT_NULL;
	SET_NODE_T(&(Node_tbl[BDD_FALSE]));
	CHECK_NODE_T(&(Node_tbl[BDD_FALSE]));
	SET_DEBUG_REF_CT_ZERO(&(Node_tbl[BDD_FALSE]));


	/* 1$B=*C<(B(BDD_TRUE)$B$NEPO?(B */
	Node_tbl[BDD_TRUE].level = BDD_TRUE;
	Node_tbl[BDD_TRUE].f0 = UN_USED;
	Node_tbl[BDD_TRUE].f1 = UN_USED;
	Node_tbl[BDD_TRUE].ref_ct = 0;
	Node_tbl[BDD_TRUE].next = UN_USED;
	Node_tbl[BDD_TRUE].complement = BDD_FALSE;
	Node_tbl[BDD_TRUE].is_pt_from_pout = FALSE;
	Node_tbl[BDD_TRUE].is_buf_inserted = FALSE;
	Node_tbl[BDD_TRUE].back_pt_list = BACK_PT_NULL;
	SET_NODE_T(&(Node_tbl[BDD_TRUE]));
	CHECK_NODE_T(&(Node_tbl[BDD_TRUE]));
	SET_DEBUG_REF_CT_ZERO(&(Node_tbl[BDD_TRUE]));

	for (i = 3; i < Max_node_num; i++) {
		Node_tbl[i].level = UN_USED;
		Node_tbl[i].f0 = UN_USED;
		Node_tbl[i].f1 = UN_USED;
		Node_tbl[i].ref_ct = UN_USED;
		Node_tbl[i].next = i+1;
		Node_tbl[i].complement = UN_USED;
		Node_tbl[i].is_pt_from_pout = FALSE;
		Node_tbl[i].is_buf_inserted = FALSE;
		Node_tbl[i].back_pt_list = BACK_PT_NULL;
		SET_NODE_T(&(Node_tbl[i]));
		CHECK_NODE_T(&(Node_tbl[i]));
		SET_DEBUG_REF_CT_ZERO(&(Node_tbl[i]));

	}

	/* Free List$B$N@hF,$r%]%$%s%H(B */
	Free_list_head = 3;
	Free_list_ct = (Max_node_num - 3);

	return;
}

/*
 *
 *
 */

static void
#ifdef __STDC__
init_edge_tbl(void)
#else
init_edge_tbl(/* void */)
#endif /* __STDC__ */
{
	int i;

	Max_edge_num = Max_node_num * 2;


	Edge_tbl = (edge_t *)malloc(sizeof(edge_t) * Max_edge_num);
	if (Edge_tbl == NULL)
		MALLOC_ERR;
	
	for (i = 0; i < Max_edge_num; i++) {
		Edge_tbl[i].from_node = UN_USED;
		Edge_tbl[i].next = i+1;
		Edge_tbl[i].is_PO = FALSE;
		SET_EDGE_T(&Edge_tbl[i]);
		CHECK_EDGE_T(&Edge_tbl[i]);
	}
	Edge_free_list_head = 0;

}

/*
 *
 *
 */

static void
#ifdef __STDC__
init_ope_cache_tbl(void)
#else
init_ope_cache_tbl(/* void */)
#endif /* __STDC__ */
{
	int i;

	assert(0 < Ope_cache_size);
	assert(Ope_cache_size < Max_node_num);
	Ope_cache_tbl = (ope_cache_t *)malloc(sizeof(ope_cache_t) * Ope_cache_size);
	if (Ope_cache_tbl == NULL)
		MALLOC_ERR;

	for (i = 0; i < Ope_cache_size; i++) {
		Ope_cache_tbl[i].bdd1 = UN_USED;
		Ope_cache_tbl[i].bdd2 = UN_USED;
		Ope_cache_tbl[i].ope = NO_OP;
		Ope_cache_tbl[i].result = UN_USED;
		SET_OPE_CACHE_T(&(Ope_cache_tbl[i]));
		CHECK_OPE_CACHE_T(&(Ope_cache_tbl[i]));
	}

	return;
}

/*
 *	Hash$B%F!<%V%k$r3NJ]!%JQ?t$N8D?t$,J,$+$i$J$$$H7hDj$G$-$J$$$N$G!$(B
 *	YACC$B%=!<%9$NCf$G8F$S=P$7$F$$$k!%(B
 */

void
#ifdef __STDC__
init_hash_tbl(void)
#else
init_hash_tbl(/* void */)
#endif /* __STDC__ */
{
	int i, j;
	int *cur_hash_tbl;

	/* index$B$N(B0,1,2$B$O!$FC<l$JHV9f$H$7$F!$A4BN$KEO$C$F;HMQ$7$J$$$N$G!$(B*/
	/* $B$3$3$G$b%@%_!<07$$(B */
	
	assert(0 < Input_val_num);
	Node_hash_tbl = (int **)malloc(sizeof(int *) * (Input_val_num + 3));
	if (Node_hash_tbl == NULL)
		MALLOC_ERR;

	Node_hash_size = (int)(((double)Max_node_num*NODE_HASH_RATIO)/Input_val_num);

	if (Node_hash_size == 0) {
		fprintf(stderr, "[ERROR] LINE:%d in %s\n", __LINE__, __FILE__);
		fprintf(stderr, "Too small Max Node Size Specification.\n");
		exit(-1);
	}
	
	assert(0 < Node_hash_size);
	assert(Node_hash_size < Max_node_num);

	for (i = 3; i < (Input_val_num + 3); i++) {
		Node_hash_tbl[i] = (int *)malloc(sizeof(int) * Node_hash_size);
		if (Node_hash_tbl[i] == NULL)
			MALLOC_ERR;
		cur_hash_tbl = Node_hash_tbl[i];
		for (j = 0; j < Node_hash_size; j++)
			cur_hash_tbl[j] = HASH_END;
	}

	Tmp_hash_tbl_for_swap = (int *)malloc(sizeof(int) * Node_hash_size);
	if (Tmp_hash_tbl_for_swap == NULL)
		MALLOC_ERR;

#if DEBUG > 2
	for (i = 3; i < (Input_val_num + 3); i++) {
		cur_hash_tbl = Node_hash_tbl[i];
		for (j = 0; j < Node_hash_size; j++)
			if (cur_hash_tbl[j] != HASH_END) {
				fprintf(stderr, "Hash Table is not initialized completely.\n");
				exit(-1);
			}
	}

#endif /* DEBUG > 2 */	


	return;
}

/*
 *
 *
 */

void
#ifdef __STDC__
init_sort_tbl(void)
#else
init_sort_tbl(/* void */)
#endif /* __STDC__ */
{
	int i;

	assert(Input_val_num > 0);

	/* Sifting$B$N$?$a$N%=!<%H%F!<%V%k(B */
	Sort_tbl = (sort_tbl_t *)malloc(sizeof(sort_tbl_t) * (Input_val_num + 3));
	if (Sort_tbl == NULL)
		MALLOC_ERR;

	for (i = 3; i < (Input_val_num + 3); i++)
		SET_SORT_TBL_T(&Sort_tbl[i]);

	/* $B%P%C%U%!A^F~$N$?$a$N%=!<%H%F!<%V%k(B */
	
	Bufins_sort_tbl = (sort_tbl_for_bufins *)
		malloc(sizeof(sort_tbl_for_bufins) * (Max_node_num));
	if (Bufins_sort_tbl == NULL)
		MALLOC_ERR;

	return;
}

/*
 *
 *
 */

void
#ifdef __STDC__
bdd_init(void)
#else
bdd_init(/* void */)
#endif /* __STDC__ */
{
	init_node_tbl();

	init_edge_tbl();

	init_ope_cache_tbl();

	return;
}

/*
 *	$B3NJ]$7$?NN0h$r(Bfree$B$9$k!%(B
 *
 */

void
#ifdef __STDC__
free_all_area(void)
#else
free_all_area(/* void */)
#endif /* __STDC__ */
{
	int i;
	

	free(Node_tbl);			/* free Node_tbl */
	free(Edge_tbl); 		/* free Edge_tbl */
	free(Ope_cache_tbl);	/* free ope_cache_tbl */

	/* free hash tbl */
	for (i = 3; i < (Input_val_num + 3); i++)
		free(Node_hash_tbl[i]);
	free(Node_hash_tbl);
	free(Tmp_hash_tbl_for_swap);
	free(Sort_tbl);

#if VERBOSE > 1
	fprintf(stderr, "All allocated area freed.\n");
#endif /* VERBOSE > 1 */	

	return;
}
