/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	GC,Freelist$B$J$I$N%a%b%j4IM}4X78(B
*
*******************************************************************/

#include <stdio.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"
#include "etc.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

#ifdef __STDC__
extern void reset_ope_cache(void);
#else
extern void reset_ope_cache(/* void */);
#endif /* __STDC__ */

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern node_t *Node_tbl;
extern int **Node_hash_tbl;
extern output_node_t *Output_val_tbl;

extern int Max_node_num;
extern int Input_val_num;
extern int Function_num;
extern int Node_hash_size;
extern int Free_list_head;
extern int Free_list_ct;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*
 *
 *
 */

int
#ifdef __STDC__
node_hash_func(int level, int f0, int f1)
#else
node_hash_func(level, f0, f1)
  int level;
  int f0;
  int f1;
#endif /* __STDC__ */
{
	int key;

	assert(2 < level);
	assert(level < (Input_val_num + 3));

	assert(0 < f0);
	assert(f0 < Max_node_num);

	assert(0 < f1);
	assert(f1 < Max_node_num);

	key = (level << 12) + (f0 << 10) + f1;
	key = key % Node_hash_size;
	key = abs(key);

/*	key = (f0 + f1)%Node_hash_size;*/

	assert(0 <= key);
	assert(key < Node_hash_size);

	return key;
}

/*
 *
 *
 */

int
#ifdef __STDC__
node_hash_search(int level, int f0, int f1)
#else
node_hash_search(level, f0, f1)
  int level;
  int f0;
  int f1;
#endif /* __STDC__ */
{
	int key;
	int cur_pt;
	int *hash_tbl = Node_hash_tbl[level];
	int ret = NOT_EXIST;

	assert((2 < level) && (level < (Input_val_num + 3)));

	CHECK_NODE_T(&(Node_tbl[f0]));
	CHECK_NODE_T(&(Node_tbl[f1]));

	assert((0 < f0) && (f0 < Max_node_num));
	assert((0 < f1) && (f1 < Max_node_num));

	key = node_hash_func(level, f0, f1);

	cur_pt = hash_tbl[key];

	/* $B$9$G$KEPO?$5$l$F$$$k$+!)(B */
	while (cur_pt != HASH_END) {
		CHECK_NODE_T(&(Node_tbl[cur_pt]));

		if ((GET_BDD_LEVEL(cur_pt) == level) &&
			(GET_BDD_F0(cur_pt) == f0) &&
			(GET_BDD_F1(cur_pt) == f1)) {
			ret = cur_pt;
			break;
		}
		cur_pt = GET_BDD_NEXT(cur_pt);
	}

	return ret;
}


/*
 *	$B$9$G$KNN0h$r3NJ]$5$l$F!$FbMF$,=q$+$l$F$$$k%N!<%I$N:FEPO?(B
 */

void
#ifdef __STDC__
entry_into_hash(int node_idx, int level, int hash_idx)
#else
entry_into_hash(node_idx, level, hash_idx)
  int node_idx;
  int level;
  int hash_idx;
#endif /* __STDC__ */
{
	int *hash_tbl;

	assert(0 < node_idx);
	assert(node_idx < Max_node_num);

	assert(3 <= level);
	assert(level <= (Input_val_num + 3));

	assert(0 <= hash_idx);
	assert(hash_idx < Node_hash_size);

	hash_tbl = Node_hash_tbl[level];

	CHECK_NODE_T(&(Node_tbl[node_idx]));

	Node_tbl[node_idx].next = hash_tbl[hash_idx];
	hash_tbl[hash_idx] = node_idx;

	return;
}

/*
 *	$B?7$7$/%N!<%I$r(Bhash table$B$KEPO?$7$F!$$=$N%N!<%I(Bidx$B$rJV$9!%(B
 *
 */

int
#ifdef __STDC__
alloc_node(int level, int f0, int f1)
#else
alloc_node(level, f0, f1)
  int level;
  int f0;
  int f1;
#endif /* __STDC__ */
{
	int new_node_idx;
	int hash_idx;

	assert(3 <= level);
	assert(level < (Input_val_num + 3));

	assert(0 < f0);
	assert(f0 < Max_node_num);

	assert(0 < f1);
	assert(f1 < Max_node_num);

	assert(2 < Free_list_head);
	assert(Free_list_head < Max_node_num);

	assert((0 < Free_list_ct) && (Free_list_ct <= (Max_node_num - 3)));

	if (Free_list_ct == 1) {
		fprintf(stderr, "<<<%d>>>\n", get_cur_node_num());
		fprintf(stderr, "Not exist empty node! LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}

	/* Free_list_head$B$N0\F0(B */
	new_node_idx = Free_list_head;
	Free_list_head = Node_tbl[Free_list_head].next;

	/* $BK\Ev$O(BGC */
	assert((0 < Free_list_ct) && (Free_list_ct <= (Max_node_num - 3)));
	if (Free_list_ct == 1) {
		fprintf(stderr, "Not exist empty node. LINE:%d in %s\n",
				__LINE__, __FILE__);
		exit(-1);
	}

	assert(2 < new_node_idx);
	assert(new_node_idx < Max_node_num);
	assert(2 < Free_list_head);
	assert(Free_list_head < Max_node_num);

	CHECK_NODE_T(&(Node_tbl[new_node_idx]));

	Node_tbl[new_node_idx].level = level;
	Node_tbl[new_node_idx].f0 = f0;
	Node_tbl[new_node_idx].f1 = f1;
	Node_tbl[new_node_idx].ref_ct = 0;

	INC_REF_CT(f0);
	INC_REF_CT(f1);
	
	hash_idx = node_hash_func(level, f0, f1);
	assert(0 <= hash_idx);
	assert(hash_idx < Node_hash_size);

	entry_into_hash(new_node_idx, level, hash_idx);

	Free_list_ct--;
	assert((0 < Free_list_ct) && (Free_list_ct <= (Max_node_num - 3)));

	assert(2 < new_node_idx);
	assert(new_node_idx < Max_node_num);

	return new_node_idx;
}

/*
 *
 *
 */

void
#ifdef __STDC__
delete_node(int node_idx)
#else
delete_node(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int *hash_tbl;
	int hash_idx;
	int level = GET_BDD_LEVEL(node_idx);
	int f0 = GET_BDD_F0(node_idx);
	int f1 = GET_BDD_F1(node_idx);
	int cur_node, prev_node;

	int infinite_loop_ct = 0;

	assert((3 <= node_idx) && (node_idx < Max_node_num));

	assert((0 < level) && (level < (Input_val_num + 3)));
	assert((0 < f0) && (f0 < Max_node_num));
	assert((0 < f1) && (f1 < Max_node_num));

	CHECK_NODE_T(&(Node_tbl[node_idx]));

	if ((node_idx == BDD_FALSE) || (node_idx == BDD_TRUE))
		return;
	
	hash_tbl = Node_hash_tbl[level];

	hash_idx = node_hash_func(level, f0, f1);
	assert((0 <= hash_idx) && (hash_idx < Node_hash_size));

	cur_node = hash_tbl[hash_idx];
	assert((0 < cur_node) && (cur_node < Max_node_num));

	if (cur_node == node_idx) { /* hash table$B$N@hF,$J$i(B */
		hash_tbl[hash_idx] = GET_BDD_NEXT(cur_node);
	} else {
		infinite_loop_ct = 0;
		while (cur_node != node_idx) {
			/* cur_node$B$,30$7$?$$%N!<%I$KC#$9$k$^$G(B */
			prev_node = cur_node;
			cur_node = GET_BDD_NEXT(cur_node);
#if DEBUG > 2			
			infinite_loop_ct++;
			if (infinite_loop_ct > Max_node_num)
				fprintf(stderr, "Infinite LOOP LINE:%d in %s\n",
						__LINE__, __FILE__);
#endif /* DEBUG > 2 */			
		}
		GET_BDD_NEXT(prev_node) = GET_BDD_NEXT(cur_node);
	}
	assert((2 < cur_node) && (cur_node < Max_node_num));

	/* Free_list_head$B$NIU$149$((B */
	GET_BDD_NEXT(cur_node) = Free_list_head;
	Free_list_head = cur_node;
	assert((2 < Free_list_head) && (Free_list_head < Max_node_num));

	Free_list_ct++;
	assert((0 < Free_list_ct) && (Free_list_ct <= (Max_node_num - 3)));

	/* $BITMW$K$J$C$?%N!<%I$,;2>H$7$F$$$?%N!<%I$N(Bref_ct$B$r(BDEC. */
	/* $B$=$N1F6A$G%4%_$,H/@8$9$l$P!$$=$l$b>C5n(B */
	/* $B$^$:(B0$B;^$+$i(B */
	assert(GET_BDD_REF_CT(GET_BDD_F0(cur_node)) > 0);

	DEC_REF_CT(GET_BDD_F0(cur_node));
	if ((GET_BDD_F0(node_idx) != BDD_FALSE) &&
		(GET_BDD_F0(node_idx) != BDD_TRUE) &&
		(GET_BDD_REF_CT(GET_BDD_F0(node_idx)) == 0))
		delete_node(GET_BDD_F0(node_idx));
	
	/* $B$D$.$K(B1$B;^(B */	
	assert(GET_BDD_REF_CT(GET_BDD_F1(cur_node)) > 0);

	DEC_REF_CT(GET_BDD_F1(cur_node));
	if ((GET_BDD_F1(node_idx) != BDD_FALSE) &&
		(GET_BDD_F1(node_idx) != BDD_TRUE) &&
		(GET_BDD_REF_CT(GET_BDD_F1(node_idx)) == 0))
		delete_node(GET_BDD_F1(node_idx));

	/* $BH]Dj4X78$NAj<j$N;2>H$rBG$A>C$9(B */
	if (GET_BDD_COMP(cur_node) != UN_USED)
		GET_BDD_COMP(GET_BDD_COMP(cur_node)) = UN_USED;

	/* $BITMQ$K$J$C$?%N!<%I$KL$;HMQ$N0u(B */
	GET_BDD_LEVEL(cur_node) = UN_USED;
	GET_BDD_F0(cur_node) = UN_USED;
	GET_BDD_F1(cur_node) = UN_USED;
	GET_BDD_COMP(cur_node) = UN_USED;

	return;
}

/*
 *	$BI8=`E*$J(Bgc
 *
 */

void
#ifdef __STDC__
gc(void)
#else
gc(/* void */)
#endif /* __STDC__ */
{
	int i;

#if VERBOSE > 2
	fprintf(stderr, "GC Start -------> ");
#endif /* VERBOSE > 2 */

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_REF_CT(i) == 0) &&
			(GET_BDD_LEVEL(i) != UN_USED)) {

			CHECK_NODE_T(&(Node_tbl[i]));
			delete_node(i);
		}
	}

	reset_ope_cache();

	CHECK_SAME_NODE_IN_HASH_TBL;

#if VERBOSE > 2
	fprintf(stderr, "END\n");
#endif /* VERBOE > 2 */

	return;
}

/*
 *	BDD$B$,0lC6@8@.$5$l$?CJ3,$G9T$J$&(Bgc
 */

void
#ifdef __STDC__
last_gc(void)
#else
last_gc(/* void */)
#endif /* __STDC__ */
{
	int i;

#if VERBOSE > 2
	fprintf(stderr, "Final GC START\n");
#endif /* VERBOSE > 2 */	

	for (i = 0; i < Function_num; i++) {
		assert((0 < Output_val_tbl[i].pt_to_dag) &&
			   (Output_val_tbl[i].pt_to_dag < Max_node_num));
		if (Output_val_tbl[i].is_primary_out != TRUE) {
			assert(GET_BDD_REF_CT(Output_val_tbl[i].pt_to_dag) > 0);
			DEC_REF_CT(Output_val_tbl[i].pt_to_dag);
		}
	}

	gc();

#if VERBOSE > 2
	fprintf(stderr, "Final GC END\n");
#endif /* VERBOSE > 2 */	
	
}

