/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	BDD$B4X78$N%A%g%C%H$7$?4X?t72(B
*
*******************************************************************/

#include <stdio.h>
#include <string.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern val_tbl_t *Input_val_tbl;
extern node_t *Node_tbl;
extern int **Node_hash_tbl;
extern output_node_t *Output_val_tbl;
extern tr_on_off_tbl_t *Tr_on_off_tbl;

extern int Input_val_num;
extern int Max_node_num;
extern int Node_hash_size;
extern int Function_num;
extern int Max_delay_output_idx;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*
 *	int val_to_level(char *val)
 *	$BJQ?tL>$rEO$9$H!$8=:_$N%l%Y%k$rJV$9!%(B
 */

int
#ifdef __STDC__
val_to_level(char *val)
#else
val_to_level(val)
  char *val;
#endif /* __STDC__ */
{
	int i;

	for (i = 3; i < (Input_val_num + 3); i++) {
		if (strcmp(val, Input_val_tbl[i].val) == 0)
			return i;
	}
	return NOT_EXIST;
}


/*
 *	$B%l%Y%k$rM?$($i$l$?$i$=$l$KBP1~$9$kJQ?tL>$rJV$9(B
 *
 */

char *
#ifdef __STDC__
level_to_val(int level)
#else
level_to_val(level)
  int level;
#endif /* __STDC__ */
{
	static char buf[STRSIZE];

	assert((0 < level) && (level < (Input_val_num + 3)));

	if (level == BDD_FALSE)
		strcpy(buf, "v0");
	else if (level == BDD_TRUE)
		strcpy(buf, "v1");
	else
		strcpy(buf, Input_val_tbl[level].val);

	return buf;
}

/*
 *	Primary Out$B$K%]%$%s%H$5$l$F$$$k%N!<%I$,!$<+J,$N%N!<%IHV9f(B
 *	$B$rEO$9$H!$(BOutput_val_tbl$B$NCf$G%]%$%s%H$7$F$$$kJQ?tL>$rJV$9(B
 */

char *
#ifdef __STDC__
node_idx_to_output(int node_idx)
#else
node_idx_to_output(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int i;

	assert((0 < node_idx) && (node_idx < Max_node_num));

	for (i = 0; i < Function_num; i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].pt_to_dag == node_idx))
			return Output_val_tbl[i].output_name;
	}
	return NULL;
}

/*
 *	Primary Out$B$K%]%$%s%H$5$l$F$$$k%N!<%I$,!$<+J,$N%N!<%IHV9f(B
 *	$B$rEO$9$H!$(BOutput_val_tbl$B$NCf$N(Bidx$B2?$K%]%$%s%H$5$l$F$$$k$+!)(B
 */

int
#ifdef __STDC__
node_idx_to_pout_idx(int node_idx)
#else
node_idx_to_pout_idx(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	int i;

	assert((0 < node_idx) && (node_idx < Max_node_num));

	for (i = 0; i < Function_num; i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].pt_to_dag == node_idx))
			return i;
	}
	return NOT_EXIST;
}

/*
 *	Node_tbl$B$r<j7+$j$J$,$i!$8=:_$N;HMQ%N!<%I?t$r5a$a$k!%(B
 */


int
#ifdef __STDC__
get_cur_node_num(void)
#else
get_cur_node_num(/* void */)
#endif /* __STDC__ */
{
	int i;
	int node_num = 0;

	for (i = 1; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0)){
			node_num++;
		}
	}
	return node_num;
}
	
/*
 *	$B3F%l%Y%k$N%N!<%I?t$r%+%&%s%H!%(B
 *
 */

void
#ifdef __STDC__
count_each_level_node(void)
#else
count_each_level_node(/* void */)
#endif /* __STDC__ */
{
	int i, j;
	int ct;
	int cur_node;
	int *cur_hash_tbl;

		  
	for (i = 3; i < (Input_val_num + 3); i++) {
		ct = 0;

		cur_hash_tbl = Node_hash_tbl[i];

		for (j = 0; j < Node_hash_size; j++)
			if (cur_hash_tbl[j] != HASH_END) {
				cur_node = cur_hash_tbl[j];
				while (cur_node != HASH_END) {
					ct++;
					cur_node = GET_BDD_NEXT(cur_node);
				}
			}
		assert((0 <= ct) && (ct < (Max_node_num - 3)));
		if (ct > 0) {
			Input_val_tbl[i].node_num = ct;
			Input_val_tbl[i].is_used = TRUE;
		} 
	}

	return;
}


/*
 *	$BM?$($i$l$?%N!<%I$,(BPrimary Out$B$+$i%]%$%s%H$5$l$F$$$k$+(B
 *
 */

boolean_t
#ifdef __STDC__
is_pt_by_PO(int node_idx)
#else
is_pt_by_PO(node_idx)
#endif /* __STDC__ */
{
	int i;

	for (i = 0; i < Function_num; i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].pt_to_dag == node_idx))
			return TRUE;
	}
	return FALSE;
}

/*
 *	$B?.9f@~$+$I$&$+$r%A%'%C%/!%(B
 *	$B%]%8!$%M%,N>MQ$"$j!%(B
 */

boolean_t
#ifdef __STDC__
is_posi_signal(int node_idx)
#else
is_posi_signal(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	if ((GET_BDD_F0(node_idx) == BDD_FALSE) &&
		(GET_BDD_F1(node_idx) == BDD_TRUE))
		return TRUE;
	else
		return FALSE;
}
		
boolean_t
#ifdef __STDC__
is_nega_signal(int node_idx)
#else
is_nega_signal(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	if ((GET_BDD_F0(node_idx) == BDD_TRUE) &&
		(GET_BDD_F1(node_idx) == BDD_FALSE))
		return TRUE;
	else
		return FALSE;
}

boolean_t
#ifdef __STDC__
is_signal(int node_idx)
#else
is_signal(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	if (((GET_BDD_F0(node_idx) == BDD_FALSE) &&	(GET_BDD_F1(node_idx) == BDD_TRUE))||
		((GET_BDD_F0(node_idx) == BDD_TRUE) && (GET_BDD_F1(node_idx) == BDD_FALSE)))
		return TRUE;
	else
		return FALSE;
}

/*
 *	BDD$B$N%N!<%I$N%?%$%W$rJV$9!%(B
 */

node_type_t
#ifdef __STDC__
check_node_type(int idx)
#else
check_node_type(idx)
  int idx;
#endif /* __STDC__ */
{
	if (idx == BDD_FALSE)
		return GND;
	else if (idx == BDD_TRUE)
		return VDD;
	else if ((GET_BDD_F0(idx) == BDD_FALSE) && (GET_BDD_F1(idx) == BDD_TRUE))
		return POSI_SIGNAL;
	else if ((GET_BDD_F0(idx) == BDD_TRUE) && (GET_BDD_F1(idx) == BDD_FALSE))
		return NEGA_SIGNAL;
	else
		return NODE;
}

/*
 *	$B8=:_$NJQ?t=g=x$rI=<($9$k(B
 *
 */


void
#ifdef __STDC__
print_cur_val_order(void)
#else
print_cur_val_order(/* void */)
#endif /* __STDC__ */
{
	int i;


	printf("* Val Order   : ");
	for (i = 3; i < (Input_val_num + 3); i++)
		printf("%s>", Input_val_tbl[i].val);
	printf(" \n");
	printf("* Reverse val order( ");
	for (i = (Input_val_num + 2); i > 2; i--)
		printf("%s>", Input_val_tbl[i].val);
	printf(" )\n");

	return;
}

/*
 *	int	given_PO_num(void)
 *	$B%G!<%?$H$7$FM?$($i$l$?(BPrimary Out$B$N8D?t$rJV$9(B
 */

int
#ifdef __STDC__
given_PO_num(void)
#else
given_PO_num(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE)
			ct++;
	}
	return ct;
}

/*
 *	int final_PO_num(void)
 *	BDD$B$r9=C[8e!$=LB`$7$F$7$^$C$?=PNO$r9MN8$7$F!$(BPrimary Out$B?t$rJV$9(B
 */

int
#ifdef __STDC__
final_PO_num(void)
#else
final_PO_num(/* void */)
#endif /* __STDC__ */
{
	int ct = 0;
	int i, j;

	/* $B$b$7!$F1$8(BBDD$B$GI=8=$5$l$k4X?t$,B8:_$9$l$P!$(B */
	/* $B$=$N$&$A@hF,$K6a$$$b$N0J30$O(Bflag$B$r$?$F$k(B */
	/* $B=i4|2=(B */
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE) {
			Output_val_tbl[i].is_active = TRUE;
		}
	}
	/* Check$B$7$D$D!$=LB`$7$?=PNO$N>pJs$r(BHSPICE$B%U%!%$%k$N%3%a%s%H$H$7$F=PNO(B */
	for (i = 0; i < (Function_num - 1); i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE) {

				for (j = (i + 1); j < Function_num; j++) {
					if ((Output_val_tbl[j].is_primary_out == TRUE) &&
						(is_signal(Output_val_tbl[i].pt_to_dag) == FALSE)) {
						if (Output_val_tbl[i].pt_to_dag == Output_val_tbl[j].pt_to_dag) {
							Output_val_tbl[j].is_active = FALSE;
						}
					}
				}
			}
	}

	for (i = 0; i < Function_num; i++)
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE))
			ct++;

	return ct;
}

/*
 *	$B$b$C$H$bCY1d;~4V$NBg$-$/$J$kItJ,$N%H%i%s%8%9%?$NCJ?t$rJV$9(B
 *
 */

int
#ifdef __STDC__
cur_max_level(void)
#else
cur_max_level(/* void */)
#endif /* __STDC__ */
{
	int cur_node = Output_val_tbl[Max_delay_output_idx].pt_to_dag;
	int ct = 0;

	assert((0 <= Max_delay_output_idx) && (Max_delay_output_idx < Function_num));
	assert((0 < cur_node) && (cur_node < Max_node_num));

	while (is_signal(cur_node) != TRUE) {
		assert((cur_node != BDD_FALSE) && (cur_node != BDD_TRUE));
		assert((2 < GET_BDD_LEVEL(cur_node)) &&
			   (GET_BDD_LEVEL(cur_node) < (Input_val_num + 3)));

		if (Tr_on_off_tbl[GET_BDD_LEVEL(cur_node)].phase == NEGA) {
			cur_node = GET_BDD_F0(cur_node);
			ct++;
		} else {
			assert(Tr_on_off_tbl[GET_BDD_LEVEL(cur_node)].phase == POSI);
			cur_node = GET_BDD_F1(cur_node);
			ct++;
		}
	}
	return ct;
}

/*
 *	nmos$B%H%i%s%8%9%??t$r5a$a$k(B
 *	$B$D$^$j(BBDD$B$N%N!<%I?t$+$i?.9f@~$K=LB`$7$F$7$^$&%N!<%I?t$r0z$/(B
 */

int
#ifdef __STDC__
cur_nmos_tr_num(void)
#else
cur_nmos_tr_num(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0) ||
			((GET_BDD_F0(i) == BDD_TRUE) && (GET_BDD_F1(i) == BDD_FALSE)) ||
			((GET_BDD_F0(i) == BDD_FALSE) && (GET_BDD_F1(i) == BDD_TRUE)))
			continue;
		else
			ct++;
	}
	ct *= 2;
	return ct;
}

/*
 *	$B:GBg%U%!%s%"%&%H?t$r5a$a$k!%(B
 *
 */

int
#ifdef __STDC__
cur_max_fanout_num(void)
#else
cur_max_fanout_num(/* void */)
#endif /* __STDC__ */
{
	int i;
	int max = 0;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0) ||
			((GET_BDD_F0(i) == BDD_TRUE) && (GET_BDD_F1(i) == BDD_FALSE)) ||
			((GET_BDD_F0(i) == BDD_FALSE) && (GET_BDD_F1(i) == BDD_TRUE)))
			continue;
		else {
			if (GET_BDD_REF_CT(i) > max)
				max = GET_BDD_REF_CT(i);
		}
	}
	return max;
}

/*
 *	$BJ?6Q%U%!%s%"%&%H?t$rJV$9(B
 *
 */

void
#ifdef __STDC__
print_fanout_info(int max_fanout)
#else
print_fanout_info(max_fanout)
  int max_fanout;
#endif /* __STDC__ */
{
	int i;
	int *tbl;

	tbl = (int *)malloc(sizeof(int) * (max_fanout + 1));
	if (tbl == NULL)
		MALLOC_ERR;

	for (i = 0; i < (max_fanout + 1); i++)
		tbl[i] = 0;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0) ||
			((GET_BDD_F0(i) == BDD_TRUE) && (GET_BDD_F1(i) == BDD_FALSE)) ||
			((GET_BDD_F0(i) == BDD_FALSE) && (GET_BDD_F1(i) == BDD_TRUE)))
			continue;
		else {
			assert((0 < GET_BDD_REF_CT(i)) && (GET_BDD_REF_CT(i) <= max_fanout));
			tbl[GET_BDD_REF_CT(i)]++;
		}
	}

	printf("* \t----- Fanout Information(Except Signal Node and Constant Node) -----\n");
	for (i = 0; i < (max_fanout + 1); i++) {
		if (tbl[i] != 0) {
			assert(tbl[i] > 0);
			printf("* \t\tfanout %d \t\t%d nodes\n",
				   i, tbl[i]);
		}
	}
	return;
}

/*
 *	int cur_nega_signal()
 *
 */

int
#ifdef __STDC__
cur_nega_signal(void)
#else
cur_nega_signal(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0))
			if (is_nega_signal(i) == TRUE)
				ct++;
	}
	return ct;
}

/*
 *	int cur_posi_signal()
 *
 */

int
#ifdef __STDC__
cur_posi_signal(void)
#else
cur_posi_signal(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0))
			if (is_posi_signal(i) == TRUE)
				ct++;
	}
	return ct;
}

/*
 *	$B?.9f@~$K$J$k%N!<%I$N?t$r%+%&%s%H$9$k4X?t!%(B	
 *
 */

int
#ifdef __STDC__
get_cur_signal_node_num(void)
#else
get_cur_signal_node_num(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for(i=3;i<Max_node_num;i++){
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(is_signal(i) == TRUE))
			ct++;
	}

	return ct;

}

/*
 *	$B3FJQ?t$N%N!<%I?t$rI=<((B
 *
 */

void
#ifdef __STDC__
print_val_num_each_level(void)
#else
print_val_num_each_level(/* void */)
#endif /* __STDC__ */
{
	int i;
	int *ct_tbl;

	ct_tbl = (int *)malloc(sizeof(int) * (Input_val_num + 3));
	if (ct_tbl == NULL)
		MALLOC_ERR;

	for (i = 0; i < (Input_val_num + 3); i++)
		ct_tbl[i] = 0;

	for (i = 3; i < Max_node_num; i++)
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0))
			ct_tbl[GET_BDD_LEVEL(i)]++;

	printf("************* Print Node Number of each variable\n");
	for (i = 3; i < (Input_val_num + 3); i++)
			printf("*  %s\t\t%d\n", Input_val_tbl[i].val, ct_tbl[i]);

	return;
}

	
/*
 *	$B%f!<%6$X$N%3%a%s%H(B
 *
 */

void
#ifdef __STDC__
print_comment_for_user(void)
#else
print_comment_for_user(/* void */)
#endif /* __STDC__ */
{
	int i;

	boolean_t flag = FALSE;

	/* $BO@M}9g@.$N7k2L!$F~NO$H=PNO$,D>7k$7$F$$$k>l9g(B */
	/* $B$^$:$$$N$G!$%f!<%6$KGI<j$K65$($F>e$2$k(B */

	for (i = 0; i < Function_num; i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE) &&
			(is_signal(Output_val_tbl[i].pt_to_dag) == TRUE))
			flag = TRUE;
	}


	/* flag$B$,(BFALSE$B$J$i!$F~NO!$=PNOD>7k$N%(%i!<$O$J$$!%(B */
	if (flag == FALSE) 
		return;

	printf("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n");
	printf("x                                                                        x\n");
	printf("x    CCCCC       A      U      U  TTTTTTTTT  IIIII   oOOOOOo  NN     N   x\n");
	printf("x   C     C     A A     U      U      T        I    O       O N N    N   x\n");
	printf("x   C          A   A    U      U      T        I    O       O N  N   N   x\n");
	printf("x   C         AaaaaaA   U      U      T        I    O       O N   N  N   x\n");
	printf("x   C     C  A       A  U      U      T        I    O       O N    N N   x\n");
	printf("x    CCCCC  A         A  UuuuuU       T      IIIII   oOOOOOo  N     NN   x\n");
	printf("x                                                                        x\n");
	printf("x                                               Message from Programmer  x\n");
	printf("x                                                                        x\n");

	for (i = 0; i < Function_num; i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE) &&
			(is_signal(Output_val_tbl[i].pt_to_dag) == TRUE)) {
			printf("x\tOutput Terminal : %s is connected Input %s directly!\n",
				   Output_val_tbl[i].output_name,
				   level_to_val(GET_BDD_LEVEL(Output_val_tbl[i].pt_to_dag)));
			printf("x                                                                        x\n");
		}
	}
	printf("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n");

	return;
}
