/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	apply $B1i;;ItJ,(B
*
*******************************************************************/
#include <stdio.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "error.h"

#include "bdd_print.h"


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/
#ifdef __STDC__
extern int alloc_node(int, int, int);
extern int node_hash_search(int, int, int);
extern int search_ope_cache(int, int, ope_t);
extern void add_ope_cache(int, int, ope_t, int);
#else
extern int alloc_node(/* int, int, int */);
extern int node_hash_search(/* int, int, int */);
extern int search_ope_cache(/* int, int, ope_t */);
extern void add_ope_cache(/* int, int, ope_t, int */);
#endif /* __STDC__ */
/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern node_t *Node_tbl;

extern int Max_node_num;
extern int Input_val_num;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/


/*
 *	$BH]Dj4X78$rD4$Y$k4X?t(B
 *
 */
void
#ifdef __STDC__
search_complement(int bdd)
#else
search_complement(bdd)
  int bdd;
#endif /* __STDC__ */
{
	int result;

	assert((0 < bdd) && (bdd < Max_node_num));
	
	if ((bdd == BDD_FALSE) || (bdd == BDD_TRUE))
		return;

	if ((GET_BDD_COMP(GET_BDD_F0(bdd)) != UN_USED) &&
		(GET_BDD_COMP(GET_BDD_F1(bdd)) != UN_USED)){

		result = node_hash_search(GET_BDD_LEVEL(bdd),
								 GET_BDD_COMP(GET_BDD_F0(bdd)),
								 GET_BDD_COMP(GET_BDD_F1(bdd)));

		assert((result == NOT_EXIST) || ((2 < result) && (result < Max_node_num)));

		if (result != NOT_EXIST){
			GET_BDD_COMP(bdd) = result;
			GET_BDD_COMP(result) = bdd;
		}
	}
	return;

}


/*
 * 	NOT$B1i;;(B
 *
 */
int
#ifdef __STDC__
not_ope(int bdd)
#else
not_ope(bdd)
  int bdd;
#endif /* __STDC__ */
{
	int new_level;
	int new_f0;
	int new_f1;
	int result;

	search_complement(bdd);
	
	/* $BH]Dj4X78!$DjCM$N>l9g(B */
	if (GET_BDD_COMP(bdd) != UN_USED) {
		return GET_BDD_COMP(bdd);
	} else if (bdd == BDD_TRUE)
		return BDD_FALSE;
	else if (bdd == BDD_FALSE)
		return BDD_TRUE;

	/* $BCM$,7h$^$i$J$$;~$O99$K2<$r8+$k(B */
	new_level = GET_BDD_LEVEL(bdd);
	new_f0 = not_ope(GET_BDD_F0(bdd));
	new_f1 = not_ope(GET_BDD_F1(bdd));

	assert((2 < new_level) && (new_level < (Input_val_num + 3)));
	assert((0 < new_f0) && (new_f0 < Max_node_num));
	assert((0 < new_f1) && (new_f1 < Max_node_num));

	/* $B7k2L$rEPO?(B */
	result =  alloc_node(new_level,new_f0,new_f1);

	/* $BH]Dj4X78$NEPO?(B */
	GET_BDD_COMP(result) = bdd;
	GET_BDD_COMP(bdd) = result;

	assert((0 < result) && (result < Max_node_num));

	return result;

}
	
	
/*
 *	OR$B1i;;(B
 *
 */
int
#ifdef __STDC__
or_ope(int bdd_1, int bdd_2)
#else
or_ope(bdd_1, bdd_2)
  int bdd_1;
  int bdd_2;
#endif /* __STDC__ */  
{
		   
	assert((0 < bdd_1) && (bdd_1 < Max_node_num));
	assert((0 < bdd_2) && (bdd_2 < Max_node_num));

	if (bdd_1 == BDD_TRUE)
		return BDD_TRUE;				/* 1+f = 1 */
	else if (bdd_1 == BDD_FALSE)
		return bdd_2; 					/* 0+f = f */
	else if (bdd_2 == BDD_TRUE)
		return BDD_TRUE; 				/* f+1 = 1 */
	else if (bdd_2 == BDD_FALSE)
		return bdd_1; 					/* f+0 = f */
	else if ((GET_BDD_COMP(bdd_2) != UN_USED) &&
			 bdd_1 == GET_BDD_COMP(bdd_2))
		return BDD_TRUE;				/* f+~f = 1 */
	else if (bdd_1 == bdd_2)
		return bdd_1;					/* f+f = f */
	else
		return UNKNOWN;
}

/*
 *	NOR$B1i;;(B
 *
 */
int
#ifdef __STDC__
nor_ope(int bdd_1, int bdd_2)
#else
nor_ope(bdd_1, bdd_2)
  int bdd_1;
  int bdd_2;
#endif /* __STDC__ */  
{
	int result;

	result = or_ope(bdd_1,bdd_2);

	if (result == UNKNOWN)
		return UNKNOWN;
	else
		result = not_ope(result);

	return result;

}


/*
 *	AND$B1i;;(B
 *
 */
int
#ifdef __STDC__
and_ope(int bdd_1, int bdd_2)
#else
and_ope(bdd_1, bdd_2)
  int bdd_1;
  int bdd_2;
#endif /* __STDC__ */  
{
		   
	assert((0 < bdd_1) && (bdd_1 < Max_node_num));
	assert((0 < bdd_2) && (bdd_2 < Max_node_num));

	if (bdd_1 == BDD_TRUE)
		return bdd_2;					/* 1*f = f */
	else if ((bdd_1 == BDD_FALSE) ||
			 (bdd_2 == BDD_FALSE) ||
			 ((GET_BDD_COMP(bdd_2) != UN_USED) &&
			 bdd_1 == GET_BDD_COMP(bdd_2)))
		return BDD_FALSE;				/* 0*f = 0 */
	else if ((bdd_2 == BDD_TRUE) ||
			 (bdd_1 == bdd_2))
		return bdd_1;	 				/* f*1 = f */
	else
		return UNKNOWN;
}

/*
 *	NAND$B1i;;(B
 *
 */
int
#ifdef __STDC__
nand_ope(int bdd_1, int bdd_2)
#else
nand_ope(bdd_1, bdd_2)
  int bdd_1;
  int bdd_2;
#endif /* __STDC__ */  
{

	int result;

	assert((0 < bdd_1) && (bdd_1 < Max_node_num));
	assert((0 < bdd_2) && (bdd_2 < Max_node_num));

	result = and_ope(bdd_1,bdd_2);

	if (result == UNKNOWN)
		return UNKNOWN;
	else
		result = not_ope(result);

	return result;

}


/*
 *	XOR$B1i;;(B
 *
 */
int
#ifdef __STDC__
xor_ope(int bdd_1, int bdd_2)
#else
xor_ope(bdd_1, bdd_2)
  int bdd_1;
  int bdd_2;
#endif /* __STDC__ */  
{
	assert((0 < bdd_1) && (bdd_1 < Max_node_num));
	assert((0 < bdd_2) && (bdd_2 < Max_node_num));

	if (bdd_1 == BDD_TRUE)
		return not_ope(bdd_2);			/* 1^f = ~f */
	else if (bdd_1 == BDD_FALSE)
		return bdd_2;					/* 0^f = f */
	else if (bdd_2 == BDD_TRUE)
		return not_ope(bdd_1);	 		/* f^1 = ~f */
	else if (bdd_2 == BDD_FALSE)
		return bdd_1;					/* f^0 = f */
	else if ((GET_BDD_COMP(bdd_2) != UN_USED) &&
			 bdd_1 == GET_BDD_COMP(bdd_2))
		return BDD_TRUE;				/* f^~f = 1 */
	else if (bdd_1 == bdd_2)
		return BDD_FALSE;				/* f^f = 0 */
	else
		return UNKNOWN;
}

/*
 *	XNOR$B1i;;(B
 *
 */
int
#ifdef __STDC__
xnor_ope(int bdd_1, int bdd_2)
#else
xnor_ope(bdd_1, bdd_2)
  int bdd_1;
  int bdd_2;
#endif /* __STDC__ */  
{

	int result;

	assert((0 < bdd_1) && (bdd_1 < Max_node_num));
	assert((0 < bdd_2) && (bdd_2 < Max_node_num));

	result = xor_ope(bdd_1,bdd_2);

	if (result == UNKNOWN)
		return UNKNOWN;
	else
		result = not_ope(result);

	return result;

}

		
/*
 *	$B1i;;$N%a%$%sItJ,(B
 *	$BJV$jCM$O(BBDD$B$N%N!<%I$N%$%s%G%C%/%9(B
 */
int
#ifdef __STDC__
bdd_apply(int bdd_1, int bdd_2, ope_t ope)
#else
bdd_apply(bdd_1, bdd_2, ope)
  int bdd_1;
  int bdd_2;
  ope_t ope;
#endif /* __STDC__ */
{

	int result;
	int new_level;
	int new_f0;
	int new_f1;
	int ope_key;
	
	if ((bdd_1 <= 0) || (Max_node_num <= bdd_1))
		fprintf(stderr, "bdd_1=%d BAD NUMBER LINE:%d in %s\n", bdd_1, __LINE__, __FILE__);
	
	if ((bdd_2 <= 0) || (Max_node_num <= bdd_2))
		fprintf(stderr, "bdd_2=%d BAD NUMBER LINE:%d in %s\n", bdd_2, __LINE__, __FILE__);


	assert((0 < bdd_1) && (bdd_1 < Max_node_num));
	assert((0 < bdd_2) && (bdd_2 < Max_node_num));

	ope_key = search_ope_cache(bdd_1, bdd_2, ope);

	if (ope_key != NOT_EXIST) { /* $B%-%c%C%7%e$KEPO?:Q$_$N1i;;(B */
		return ope_key;

	} else {	/* $B%-%c%C%7%e$K$J$$$N$G7W;;$9$k(B */
		switch (ope) {
		  case OR_OPE:   result = or_ope(bdd_1,bdd_2);  break;
		  case NOR_OPE:  result = nor_ope(bdd_1,bdd_2); break;
		  case AND_OPE:  result = and_ope(bdd_1,bdd_2); break;
		  case NAND_OPE: result = nand_ope(bdd_1,bdd_2);break;
		  case XOR_OPE:	 result = xor_ope(bdd_1,bdd_2); break;
		  case XNOR_OPE: result = xnor_ope(bdd_1,bdd_2);break;
		  default:
			printf("switch error program stop ope : %d LINE:%d in %s\n",
				   ope, __LINE__, __FILE__);
			exit(-1);
		}
	}

	/* $B7k2L$,=P$?;~(B */
	if (result != UNKNOWN) {
		return result;
	}

	/* $B7k2L$,=P$J$+$C$?;~(B */

/*	OPE_CHECK(ope);*/
	if (GET_BDD_LEVEL(bdd_1) > GET_BDD_LEVEL(bdd_2)){
		new_level = GET_BDD_LEVEL(bdd_1);
		new_f0 = bdd_apply(GET_BDD_F0(bdd_1), bdd_2, ope);
		new_f1 = bdd_apply(GET_BDD_F1(bdd_1), bdd_2, ope);
	}
	else if (GET_BDD_LEVEL(bdd_1) < GET_BDD_LEVEL(bdd_2)){
		new_level = GET_BDD_LEVEL(bdd_2);
		new_f0 = bdd_apply(bdd_1, GET_BDD_F0(bdd_2), ope);
		new_f1 = bdd_apply(bdd_1, GET_BDD_F1(bdd_2), ope);
	}
	else if (GET_BDD_LEVEL(bdd_1) == GET_BDD_LEVEL(bdd_2)){
		new_level = GET_BDD_LEVEL(bdd_1);
		new_f0 = bdd_apply(GET_BDD_F0(bdd_1), GET_BDD_F0(bdd_2), ope);
		new_f1 = bdd_apply(GET_BDD_F1(bdd_1), GET_BDD_F1(bdd_2), ope);
	}
	else {
		printf("apply error\n");
		exit(-1);
	}

	/* $B7k2L$rEPO?(B */
	assert((0 < new_f0) && (new_f0 < Max_node_num));
	assert((0 < new_f1) && (new_f1 < Max_node_num));
	assert((2 < new_level) && (new_level < (Input_val_num + 3)));

	/* $B$b$7#0;^$H#1;^$,F1$8$b$N$r;X$7$F$$$k>l9g?7$7$$%N!<%I$O:n$i$J$$(B */
	if (new_f0 == new_f1)
		result = new_f0;
	
	result = node_hash_search(new_level, new_f0, new_f1);


	if (result == NOT_EXIST)
		result = alloc_node(new_level, new_f0, new_f1);


	assert((0 < result) && (result < Max_node_num));

	/* $B1i;;%-%c%C%7%e$KEPO?(B */
	add_ope_cache(bdd_1, bdd_2, ope, result);

	/* $BH]Dj4X78$rD4$Y$k4X?t(B */
	search_complement(result);

	return result;

}
