/*
``Copyright (C) 1996 Kenzo KONISHI and Kazuo TAKI in Kobe University''
*/

/*******************************************************************
*	Verilog-HDL, HSPICE Netlist, $BM=Hw$N(BNetlist$B$r=PNO$9$k$?$a$N4X?t72(B
*
*******************************************************************/

#include <stdio.h>
#include <string.h>

#include <stdlib.h>
#include <time.h>

#include "debug_level.h"
#include "datatype.h"
#include "debug.h"
#include "bdd_etc.h"
#include "error.h"


/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/
/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

extern val_tbl_t *Input_val_tbl;
extern output_node_t *Output_val_tbl;
extern node_t *Node_tbl;
extern edge_t *Edge_tbl;
extern tr_on_off_tbl_t *Tr_on_off_tbl;

extern int Max_node_num;
extern int Input_val_num;
extern int Function_num;
extern boolean_t Layout_flag;
extern boolean_t Hspice_cmos_flag;
extern boolean_t Power_vector_flag;
extern char Spice_file_name[];

extern int Max_delay_output_idx;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

int Hspice_bddnode_num;
char Module_name_for_HDL[STRSIZE];
FILE *Verilog_fp;
FILE *HSPICE_fp;
FILE *Netlist_fp;

int Hspice_module_ct;

/*>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<*/

/*
 * global$BJQ?t(B Module_name_for_HDL[ ]$B$K!$%U%!%$%kL>$+$i@Z$j=P$7$?%b%8%e!<(B
 * $B%kL>$r%;%C%H$9$k!%(B
 */

static void
#ifdef __STDC__
set_data_name(char *fname)
#else
set_data_name(fname)
  char *fname;
#endif /* __STDC__ */
{
	int str_size;
	int i, j;
	int name_pos = 0;
	int ext_pos = 0;
	char buf[STRSIZE];
	boolean_t pos_flag = FALSE;
	boolean_t ext_flag = FALSE;

	str_size = strlen(fname);

	for (i = 0; i < str_size; i++) {
		if (fname[i] == '/') {
			name_pos = (i+1);
			pos_flag = TRUE;
		}

		if (fname[i] == '.') {
			ext_pos = i;
			ext_flag = TRUE;
		}
	}

	if (pos_flag == FALSE)
		name_pos = 0;
	if (ext_flag == FALSE)
		ext_pos = str_size;


	for (j = 0, i = name_pos; i < ext_pos; i++,j++) {
		buf[j] = fname[i];
	}
	buf[j] = '\0';

	strcpy(Module_name_for_HDL, buf);

	return;
}

/*
 * $B$9$Y$F$N%O%C%7%e%F!<%V%k$rD4$Y$F!$%G!<%?$KF~NO$H$7$F4^$^$l$F$$$k$,(B
 * BDD$B$G$O=LB`$J$j$NM}M3$+$i>CLG$7$F$7$^$C$?$b$N$r%A%'%C%/$9$k$?$a$N4X(B
 * $B?t!%$h$&$9$k$K%b%8%e!<%k$KI,MW$J?.9f$rC5$9!%(B
 */

typedef
struct {
	boolean_t nega_usage;
	boolean_t posi_usage;
} verilog_signal_usage_tbl_t;

verilog_signal_usage_tbl_t *Verilog_signal_usage_tbl;

static void
#ifdef __STDC__
check_used_signal(void)
#else
check_used_signal(/* void */)
#endif /* __STDC__ */
{
	int i;
	int cur_level;

	Verilog_signal_usage_tbl
		= (verilog_signal_usage_tbl_t *)malloc(sizeof(verilog_signal_usage_tbl_t) * (Input_val_num + 3));
	if (Verilog_signal_usage_tbl == NULL)
		MALLOC_ERR;

	/* initialize */
	for (i = 3; i < (Input_val_num + 3); i++) {
		Verilog_signal_usage_tbl[i].nega_usage = FALSE;
		Verilog_signal_usage_tbl[i].posi_usage = FALSE;
	}

	/* Check */
	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0)) {

			cur_level = GET_BDD_LEVEL(i);

			if (is_signal(i) == TRUE) {
				if (is_posi_signal(i) == TRUE)
					Verilog_signal_usage_tbl[cur_level].posi_usage = TRUE;
				else {
					assert(is_nega_signal(i) == TRUE);
					Verilog_signal_usage_tbl[cur_level].nega_usage = TRUE;
				}
			} else {
				assert(is_signal(i) == FALSE);
				Verilog_signal_usage_tbl[cur_level].nega_usage = TRUE;
				Verilog_signal_usage_tbl[cur_level].posi_usage = TRUE;
			}
		}
	}
	return;
}

/*>>>>>>>>>>>>>>>>> $B$3$3$+$iA0H>$G(BVerilog$BMQ(B <<<<<<<<<<<<<<<<<<*/

/*
 *
 *
 */

static void
#ifdef __STDC__
print_verilog_passtr(int node_idx, char *d, char *nega_s, char *posi_s, char *g)
#else
print_verilog_passtr(node_idx, d, nega_s, posi_s, g)
  int node_idx;
  char *d, *nega_s, *posi_s, *g;
#endif /* __STDC__ */
{
	fprintf(Verilog_fp, "\tnmos4w IL%d (%s, %s, %sb);\n",
			node_idx, d, nega_s, g);
	fprintf(Verilog_fp, "\tnmos4w IR%d (%s, %s, %s);\n",
			node_idx, d, posi_s, g);
	return;
}


/*
 *
 *	
 */

static void
#ifdef __STDC__
bdd_node_to_verilog(int node_idx)
#else
bdd_node_to_verilog(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	char posi_src[STRSIZE];
	char nega_src[STRSIZE];
	char drn[STRSIZE];
	char gate[STRSIZE];
	node_type_t f0_type;
	node_type_t f1_type;
	char tmp[STRSIZE];
	int edge_idx;
	int min_output_idx;
	boolean_t is_pted_from_output;
	

	assert((2 < node_idx) && (node_idx < Max_node_num));

	/* $B%I%l%$%s$K@\B3$7$F$$$k%M%C%HL>$r7hDj(B */
	if (is_pt_by_PO(node_idx) == TRUE) { 
		sprintf(drn, "%s", node_idx_to_output(node_idx));
	} else {
		/* $B=PNO$K%]%$%s%H$5$l$F$$$J$$$J$i(B */
		assert(is_pt_by_PO(node_idx) == FALSE);
		sprintf(drn, "net%d", node_idx);
	}

	/* $B%=!<%9!J(B0,1$B;^!K$K@\B3$7$F$$$k%M%C%HL>$r7hDj(B */

	/* 0$B;^(B(nega_src)$B$+$i(B */
	f0_type = check_node_type(GET_BDD_F0(node_idx));

	if (f0_type == GND) {
		sprintf(nega_src, "v0");
	} else if (f0_type == VDD) {
		sprintf(nega_src, "v1");
	} else if (f0_type == NEGA_SIGNAL){
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F0(node_idx))));
		sprintf(nega_src, "%sb", tmp);
	} else if (f0_type == POSI_SIGNAL) {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F0(node_idx))));
		sprintf(nega_src, "%s", tmp);
	} else if (f0_type == NODE) {
		/* $B%N!<%I$K$5$5$l$F$$$F!$$+$D!$(B
		   $B=PNO$K$b%]%$%s%H$5$l$F$$$k%N!<%I$OCm0U(B */
		if (GET_BDD_REF_CT(GET_BDD_F0(node_idx)) == 1) /* $B%N!<%I$N$_(B */
			sprintf(nega_src, "net%d", GET_BDD_F0(node_idx));
		else {
			is_pted_from_output = FALSE;   /* initialize */
			min_output_idx = Function_num; /* initialize */

			edge_idx = Node_tbl[GET_BDD_F0(node_idx)].back_pt_list;
			while (edge_idx != BACK_PT_NULL) {
				if (Edge_tbl[edge_idx].is_PO == TRUE) {
					if (min_output_idx >= Edge_tbl[edge_idx].from_node)
						min_output_idx = Edge_tbl[edge_idx].from_node;
					is_pted_from_output = TRUE;
				}
				edge_idx = Edge_tbl[edge_idx].next;
			}
			
			if (is_pted_from_output == TRUE) {
				sprintf(nega_src, "%s", Output_val_tbl[min_output_idx].output_name);
			} else {
				assert(is_pted_from_output == FALSE);
				sprintf(nega_src, "net%d", GET_BDD_F0(node_idx));
			}
		}
	} else {
		fprintf(stderr, "BDD ERROR. LINE:%d in %s\n", __LINE__, __FILE__);
		exit(-1);
	}

	/* 1$B;^(B(posi_src)$B$+$i(B */
	f1_type = check_node_type(GET_BDD_F1(node_idx));

	if (f1_type == GND) {
		sprintf(posi_src, "v0");
	} else if (f1_type == VDD) {
		sprintf(posi_src, "v1");
	} else if (f1_type == NEGA_SIGNAL) {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F1(node_idx))));
		sprintf(posi_src, "%sb", tmp);
	} else if (f1_type == POSI_SIGNAL) {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F1(node_idx))));
		sprintf(posi_src, "%s", tmp);
	} else if (f1_type == NODE) {
		/* $B%N!<%I$K$5$5$l$F$$$F!$$+$D!$(B
		   $B=PNO$K$b%]%$%s%H$5$l$F$$$k%N!<%I$OCm0U(B */
		if (GET_BDD_REF_CT(GET_BDD_F1(node_idx)) == 1) /* $B%N!<%I$N$_(B */
			sprintf(posi_src, "net%d", GET_BDD_F1(node_idx));
		else {
			is_pted_from_output = FALSE;   /* initialize */
			min_output_idx = Function_num; /* initialize */

			edge_idx = Node_tbl[GET_BDD_F1(node_idx)].back_pt_list;
			while (edge_idx != BACK_PT_NULL) {
				if (Edge_tbl[edge_idx].is_PO == TRUE) {
					if (min_output_idx >= Edge_tbl[edge_idx].from_node)
						min_output_idx = Edge_tbl[edge_idx].from_node;
					is_pted_from_output = TRUE;
				}
				assert((0 <= edge_idx) && (edge_idx < 2.0*Max_node_num));
				edge_idx = Edge_tbl[edge_idx].next;
			}
			
			if (is_pted_from_output == TRUE) {
				sprintf(posi_src, "%s", Output_val_tbl[min_output_idx].output_name);
			} else {
				assert(is_pted_from_output == FALSE);
				sprintf(posi_src, "net%d", GET_BDD_F1(node_idx));
			}
		}
	} else {
		fprintf(stderr, "BDD ERROR. LINE:%d in %s\n", __LINE__, __FILE__);
		exit(-1);
	}

	/* $B%2!<%H$K@\B3$7$F$$$k%M%C%H(B */
	strcpy(tmp, level_to_val(GET_BDD_LEVEL(node_idx)));
	sprintf(gate, "%s", tmp);
	
	/* $B=PNO4X?t$KEO$9(B */

	print_verilog_passtr(node_idx , drn, nega_src, posi_src, gate);

	return;
}

/*
 *	BDD$B$r%Q%9%H%i$N(BVerilog$B%M%C%H%j%9%H$KJQ49(B
 *
 */

static void
#ifdef __STDC__
bdd_to_verilog(void)
#else
bdd_to_verilog(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0) ||
			((GET_BDD_F0(i) == BDD_TRUE)&&(GET_BDD_F1(i) == BDD_FALSE)) ||
			((GET_BDD_F0(i) == BDD_FALSE)&&(GET_BDD_F1(i) == BDD_TRUE)))
			continue;
		else
			bdd_node_to_verilog(i);
	}
	return;
}

/*
 *	Verilog$B$N%X%C%@!<>pJs$r=PNO(B
 *
 */

static void
#ifdef __STDC__
verilog_header(void)
#else
verilog_header(/* void */)
#endif /* __STDC__ */
{
	struct tm *p;
	long clock;
	char *usr;

	time(&clock);
	p = localtime(&clock);
	usr = getenv("USER");
	
	fprintf(Verilog_fp, "//\n");
	fprintf(Verilog_fp, "//\n");
	fprintf(Verilog_fp, "// Main Circuit Netlist:\n");
	fprintf(Verilog_fp, "//\n");
	fprintf(Verilog_fp, "// Block: %s\n", Module_name_for_HDL);
	fprintf(Verilog_fp, "//\n");
	fprintf(Verilog_fp, "// Last Time Saved: %s", asctime(p));
	fprintf(Verilog_fp, "//      by %s \n", usr);
	fprintf(Verilog_fp, "//\n");
	fprintf(Verilog_fp, "//\n\n");

	return;
}

/*
 *	BDD$BItJ,$r%H%i%s%8%9%?$N%M%C%H%j%9%H$KJQ49$9$k:,85(B
 *
 */

static void
#ifdef __STDC__
verilog_bdd_module(void)
#else
verilog_bdd_module(/* void */)
#endif /* __STDC__ */
{
	char buf[STRSIZE];
	int i, j;

	sprintf(buf, "%s.verilog", Module_name_for_HDL);

	Verilog_fp = fopen(buf, "wt");
	if (Verilog_fp == NULL)
		FOPEN_ERR(buf);

	verilog_header();
	
	/* $B$b$7!$F1$8(BBDD$B$GI=8=$5$l$k4X?t$,B8:_$9$l$P!$(B */
	/* $B$=$N$&$A@hF,$K6a$$$b$N0J30$O(Bflag$B$r$?$F$k(B */
	/* $B=i4|2=(B */
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE) {
			Output_val_tbl[i].is_active = TRUE;
		}
	}
	/* Check$B$7$D$D!$=LB`$7$?=PNO$N>pJs$r(BVerilog$B%U%!%$%k$N%3%a%s%H$H$7$F=PNO(B */

	for (i = 0; i < (Function_num - 1); i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE)){

				for (j = (i + 1); j < Function_num; j++) {
					if ((Output_val_tbl[j].is_primary_out == TRUE) &&
						(is_signal(Output_val_tbl[i].pt_to_dag) != TRUE)) {
						if (Output_val_tbl[i].pt_to_dag == Output_val_tbl[j].pt_to_dag) {
							Output_val_tbl[j].is_active = FALSE;
						}
					}
				}
			}
	}

	fprintf(Verilog_fp, "module %s(", Module_name_for_HDL);
	/* $B0J2<!$%b%8%e!<%k$N0z?t(B */

	/* $B=PNO4X?tL>$N=PNO(B */

	for (i = 0; i < Function_num; i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE) &&
			(is_signal(Output_val_tbl[i].pt_to_dag) == FALSE)) {
			fprintf(Verilog_fp, "%s", Output_val_tbl[i].output_name);
			break;
		}
	}
	for (j = (i + 1); j < Function_num; j++) {
		if ((Output_val_tbl[j].is_primary_out == TRUE) &&
			(Output_val_tbl[j].is_active == TRUE) &&
			(is_signal(Output_val_tbl[j].pt_to_dag) == FALSE)) {
			fprintf(Verilog_fp, ", %s", Output_val_tbl[j].output_name);
		}
	}

	/* $BI,MW$JF~NOJQ?t$r=PNO(B */
	for (i = 3; i < (Input_val_num + 3); i++) {
		if (Verilog_signal_usage_tbl[i].nega_usage == TRUE) {
			fprintf(Verilog_fp, ", %sb", Input_val_tbl[i].val);
		}
		if (Verilog_signal_usage_tbl[i].posi_usage == TRUE) {
			assert(Verilog_signal_usage_tbl[i].posi_usage == TRUE);
			fprintf(Verilog_fp, ", %s", Input_val_tbl[i].val);
		}
	}

	fprintf(Verilog_fp, ");\n");

	/* $B0z?t!J=PNO!K$NDj5A(B */
	fprintf(Verilog_fp, "\n\n\toutput ");
	/* 1$B$DL\$OFC<l$J$N$G!$0l$DL\$r8+$D$1$?$i$9$0$K(Bbreak; */
	for (i = 0; i < Function_num; i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE) &&
			(is_signal(Output_val_tbl[i].pt_to_dag) != TRUE)) {
			fprintf(Verilog_fp, "%s", Output_val_tbl[i].output_name);
			break;
		}
	}
	for (j = (i + 1); j < Function_num; j++) {
		if ((Output_val_tbl[j].is_primary_out == TRUE) &&
			(Output_val_tbl[j].is_active == TRUE) &&
			(is_signal(Output_val_tbl[j].pt_to_dag) != TRUE)) {
			fprintf(Verilog_fp, ", %s", Output_val_tbl[j].output_name);
		}
	}
	fprintf(Verilog_fp, ";");
	fprintf(Verilog_fp, "\n");

	/* $B0z?t!JF~NO!K$N=PNO(B */
	fprintf(Verilog_fp, "\n\n\tinput ");
	for (i = 3; i < (Input_val_num + 3); i++) {
		if (Verilog_signal_usage_tbl[i].nega_usage == TRUE) {
			fprintf(Verilog_fp, "%sb", Input_val_tbl[i].val);
			/* break$B$7$F$7$^$&A0$K(BPOSI$BB&$N%A%'%C%/$r$9$k(B */
			if (Verilog_signal_usage_tbl[i].posi_usage == TRUE)
				fprintf(Verilog_fp, ", %s", Input_val_tbl[i].val);
			break;
		} else {
			assert(Verilog_signal_usage_tbl[i].posi_usage == TRUE);
			fprintf(Verilog_fp, "%s", Input_val_tbl[i].val);
			/* break$B$7$F$7$^$&A0$K(BNEGA$BB&$N%A%'%C%/$r$9$k(B */
			if (Verilog_signal_usage_tbl[i].nega_usage == TRUE)
				fprintf(Verilog_fp, ", %sb", Input_val_tbl[i].val);
			break;
		}
	}
	for (j = (i+1); j < (Input_val_num + 3); j++) {
		if (Verilog_signal_usage_tbl[j].nega_usage == TRUE) {
			fprintf(Verilog_fp, ", %sb", Input_val_tbl[j].val);
		}
		if (Verilog_signal_usage_tbl[j].posi_usage == TRUE) {
			assert(Verilog_signal_usage_tbl[j].posi_usage == TRUE);
			fprintf(Verilog_fp, ", %s", Input_val_tbl[j].val);
		}
	}

	fprintf(Verilog_fp, ";\n\n");

	bdd_to_verilog();

	fprintf(Verilog_fp, "\n");
	fprintf(Verilog_fp, "endmodule\n");

	return;
}

/*
 *
 *
 */

static void
#ifdef __STDC__
verilog_nmos4w(void)
#else
verilog_nmos4w(/* void */)
#endif /* __STDC__ */
{
	fprintf(Verilog_fp, "\n\nmodule nmos4w(D, S, G);\n");
	fprintf(Verilog_fp, "\tinout D, S, G;\n");
	fprintf(Verilog_fp, "\ttranif1(D, S, G);\n");
	fprintf(Verilog_fp, "endmodule\n");

	return;
}

/*
 *	Verilog$B=PNO$N%a%$%sItJ,(B
 *
 */

void
#ifdef __STDC__
write_verilog(char *fname)
#else
write_verilog(fname)
  char *fname;
#endif /* __STDC__ */
{

	set_data_name(fname);
	check_used_signal();


	verilog_bdd_module();

	verilog_nmos4w();

	fclose(Verilog_fp);

	return;
}

/*>>>>>>>>>>>>>>>>> $B$3$3$+$i8eH>$G(BHSPICE $BMQ(B <<<<<<<<<<<<<<<<<<*/

/*
 *	CMOS$B$H$NHf3SMQ$G=PNOItJ,$K$D$1$k(BInverter$B$N%M%C%H%j%9%H$r=PNO(B
 *
 */

static void
#ifdef __STDC__
print_hspice_spl_out_inv(char *in)
#else  
print_hspice_spl_out_inv(in)
  char *in;
#endif /* __STDC__ */
{
	fprintf(HSPICE_fp, "xi%d %spo %s splinv\n",
			Hspice_module_ct, in, in);

	Hspice_module_ct++;
	return;
}

/*
 *	CMOS$B$H$NHf3SMQ$GF~NOItJ,$K$D$1$k(BHolder$B$N%M%C%H%j%9%H$r=PNO(B
 *
 */

static void
#ifdef __STDC__
print_hspice_spl_in_hold(char *in)
#else
print_hspice_spl_in_hold(in)
  char *in;
#endif /* __STDC__ */
{
	fprintf(HSPICE_fp, "xi%d %s %sb %spi splhold\n",
			Hspice_module_ct, in, in, in);

	Hspice_module_ct++;
	return;
}

/*
 *	HSPICE$B$G(Bhold4$B$H$$$&%b%8%e!<%k!J%[!<%k%@!K$N%M%C%H%j%9%H$r=PNO(B
 *
 *	hold4 in nega posi v0 v1
 */

static void
#ifdef __STDC__
print_hspice_hold4(char *in, char *nega, char *posi)
#else  
print_hspice_hold4(in, nega, posi)
  char *in;
  char *nega;
  char *posi;
#endif /* __STDC__ */
{
	fprintf(HSPICE_fp, "xi%d %s %s %s gnd vdd vdd vdd vdd hold4\n",
			Hspice_module_ct, in, nega, posi);

	Hspice_module_ct++;

	return;
}

/*
 *	BDD$B$NF17?H4$-=P$7$N%2!<%HF~NOItJ,$KA^F~$9$k%P%C%U%!(B
 */

static void
#ifdef __STDC__
print_hspice_mid_buf_gate_in(char *in, char *nega, char *posi)
#else
print_hspice_mid_buf_gate_in(in, nega, posi)
  char *in;
  char *nega, *posi;
#endif /* __STDC__ */
{
	fprintf(HSPICE_fp, "xi%d %s %s %s gnd vdd\n",
			Hspice_module_ct, in, nega, posi);
	Hspice_module_ct++;

	return;
}

/*
 *	$B%H%i%s%8%9%?%M%C%H%o!<%/$N%Q%9>e$KA^F~$9$k%P%C%U%!(B
 *
 */

static void
#ifdef __STDC__
print_hspice_mid_buf_on_path(char *in, char *posi)
#else
print_hspice_mid_buf_on_path(in, posi)
  char *in;
  char *posi;
#endif /* __STDC__ */
{
	fprintf(HSPICE_fp, "xi%d %s %s gnd vdd\n",
			Hspice_module_ct, in, posi);
	Hspice_module_ct++;

	return;
}

/*
 *	$B=PNOItJ,$N(B3state
 *
 */

static void
#ifdef __STDC__
print_hspice_3state_1(char *in)
#else
print_hspice_3state_1(in)
  char *in;
#endif /* __STDC__ */
{
	fprintf(HSPICE_fp, "xi%d %s %s-out gnd vdd en enb m0\n",
			Hspice_module_ct, in, in);
	Hspice_module_ct++;

	return;
}


/*
 *	HSPICE$B$G(Bbddnode$B$H$$$&%b%8%e!<%k$G%M%C%H%j%9%H$r=PNO(B
 *
 */

static void
#ifdef __STDC__
print_hspice_passtr(char *d, char *nega_s, char *posi_s, char *g)
#else
print_hspice_passtr(d, nega_s, posi_s, g)
  char *d, *nega_s, *posi_s, *g;
#endif /* __STDC__ */
{

	if (Layout_flag == TRUE) {
		fprintf(HSPICE_fp, "xi%d %sp %sn %s %s %s bddnode\n",
				Hspice_module_ct, g, g, posi_s, nega_s, d);
	} else {
		assert(Layout_flag == FALSE);
		fprintf(HSPICE_fp, "xi%d %s %sb %s %s %s bddnode\n",
				Hspice_module_ct, g, g, posi_s, nega_s, d);
	}
	Hspice_module_ct++;
	Hspice_bddnode_num = Hspice_module_ct;
	return;
}


/*
 *
 *	
 */

static void
#ifdef __STDC__
bdd_node_to_hspice(int node_idx)
#else
bdd_node_to_hspice(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	char posi_src[STRSIZE];
	char nega_src[STRSIZE];
	char drn[STRSIZE];
	char gate[STRSIZE];
	node_type_t f0_type;
	node_type_t f1_type;
	char tmp[STRSIZE];
	int edge_idx;
	int min_output_idx;
	boolean_t is_pted_from_output;
	char tmp_str[STRSIZE];

	assert((2 < node_idx) && (node_idx < Max_node_num));

	/* $B%I%l%$%s$K@\B3$7$F$$$k%M%C%HL>$r7hDj(B */
	if (is_pt_by_PO(node_idx) == TRUE) { 
		sprintf(drn, "%s", node_idx_to_output(node_idx));
	} else {
		/* $B=PNO$K%]%$%s%H$5$l$F$$$J$$$J$i(B */
		assert(is_pt_by_PO(node_idx) == FALSE);
		sprintf(drn, "net%d", node_idx);
	}

	/* $B%=!<%9!J(B0,1$B;^!K$K@\B3$7$F$$$k%M%C%HL>$r7hDj(B */

	/* 0$B;^(B(nega_src)$B$+$i(B */
	f0_type = check_node_type(GET_BDD_F0(node_idx));

	if (f0_type == GND) {
		sprintf(nega_src, "gnd");
	} else if (f0_type == VDD) {
		sprintf(nega_src, "vdd");
	} else if (f0_type == NEGA_SIGNAL){
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F0(node_idx))));
		if (Layout_flag == TRUE)
			sprintf(nega_src, "%sn", tmp);
		else {
			assert(Layout_flag == FALSE);
			sprintf(nega_src, "%sb", tmp);
		}
	} else if (f0_type == POSI_SIGNAL) {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F0(node_idx))));
		if (Layout_flag == TRUE)
			sprintf(nega_src, "%sp", tmp);
		else {
			assert(Layout_flag == FALSE);
			sprintf(nega_src, "%s", tmp);
		}
	} else if (f0_type == NODE) {
		/* $B%N!<%I$K$5$5$l$F$$$F!$$+$D!$(B
		   $B=PNO$K$b%]%$%s%H$5$l$F$$$k%N!<%I$OCm0U(B */
		if (GET_BDD_REF_CT(GET_BDD_F0(node_idx)) == 1) /* $B%N!<%I$N$_(B */
			sprintf(nega_src, "net%d", GET_BDD_F0(node_idx));
		else {
			is_pted_from_output = FALSE;   /* initialize */
			min_output_idx = Function_num; /* initialize */

			edge_idx = Node_tbl[GET_BDD_F0(node_idx)].back_pt_list;
			while (edge_idx != BACK_PT_NULL) {
				if (Edge_tbl[edge_idx].is_PO == TRUE) {
					if (min_output_idx >= Edge_tbl[edge_idx].from_node)
						min_output_idx = Edge_tbl[edge_idx].from_node;
					is_pted_from_output = TRUE;
				}
				edge_idx = Edge_tbl[edge_idx].next;
			}
			
			if (is_pted_from_output == TRUE) {
				sprintf(nega_src, "%s", Output_val_tbl[min_output_idx].output_name);
			} else {
				assert(is_pted_from_output == FALSE);
				sprintf(nega_src, "net%d", GET_BDD_F0(node_idx));
			}
		}
	} else {
		fprintf(stderr, "BDD ERROR. LINE:%d in %s\n", __LINE__, __FILE__);
		exit(-1);
	}

	/* 1$B;^(B(posi_src)$B$+$i(B */
	f1_type = check_node_type(GET_BDD_F1(node_idx));

	if (f1_type == GND) {
		sprintf(posi_src, "gnd");
	} else if (f1_type == VDD) {
		sprintf(posi_src, "vdd");
	} else if (f1_type == NEGA_SIGNAL) {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F1(node_idx))));
		if (Layout_flag == TRUE) {
			sprintf(posi_src, "%sn", tmp);
		} else {
			assert(Layout_flag == FALSE);
			sprintf(posi_src, "%sb", tmp);
		}
	} else if (f1_type == POSI_SIGNAL) {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(GET_BDD_F1(node_idx))));
		if (Layout_flag == TRUE) {
			sprintf(posi_src, "%sp", tmp);
		} else {
			assert(Layout_flag == FALSE);
			sprintf(posi_src, "%s", tmp);
		}
	} else if (f1_type == NODE) {
		/* $B%N!<%I$K$5$5$l$F$$$F!$$+$D!$(B
		   $B=PNO$K$b%]%$%s%H$5$l$F$$$k%N!<%I$OCm0U(B */
		if (GET_BDD_REF_CT(GET_BDD_F1(node_idx)) == 1) /* $B%N!<%I$N$_(B */
			sprintf(posi_src, "net%d", GET_BDD_F1(node_idx));
		else {
			is_pted_from_output = FALSE;   /* initialize */
			min_output_idx = Function_num; /* initialize */

			edge_idx = Node_tbl[GET_BDD_F1(node_idx)].back_pt_list;
			while (edge_idx != BACK_PT_NULL) {
				if (Edge_tbl[edge_idx].is_PO == TRUE) {
					if (min_output_idx >= Edge_tbl[edge_idx].from_node)
						min_output_idx = Edge_tbl[edge_idx].from_node;
					is_pted_from_output = TRUE;
				}
				assert((0 <= edge_idx) && (edge_idx < 2.0*Max_node_num));
				edge_idx = Edge_tbl[edge_idx].next;
			}
			
			if (is_pted_from_output == TRUE) {
				sprintf(posi_src, "%s", Output_val_tbl[min_output_idx].output_name);
			} else {
				assert(is_pted_from_output == FALSE);
				sprintf(posi_src, "net%d", GET_BDD_F1(node_idx));
			}
		}
	} else {
		fprintf(stderr, "BDD ERROR. LINE:%d in %s\n", __LINE__, __FILE__);
		exit(-1);
	}

	/* $B%2!<%H$K@\B3$7$F$$$k%M%C%H(B */
	strcpy(tmp, level_to_val(GET_BDD_LEVEL(node_idx)));
	sprintf(gate, "%s", tmp);
	
	/* $B=PNO4X?t$KEO$9(B */

	/* $B%P%C%U%!$,A^F~$5$l$F$$$?$i(B */
	if (Node_tbl[node_idx].is_buf_inserted == TRUE) {
		fprintf(HSPICE_fp, "xi%d %s %sbuf midbuf\n",
				Hspice_module_ct, drn, drn);
		Hspice_module_ct++;
		strcpy(tmp_str, drn);
		sprintf(drn, "%sbuf", tmp_str);
	}

	print_hspice_passtr(drn, nega_src, posi_src, gate);

	return;
}

/*
 *	BDD$B$r%Q%9%H%i$N(BHSPICE$B%M%C%H%j%9%H$KJQ49(B
 *
 */

static void
#ifdef __STDC__
bdd_to_hspice(void)
#else
bdd_to_hspice(/* void */)
#endif /* __STDC__ */
{
	int i;

	for (i = 3; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0) ||
			((GET_BDD_F0(i) == BDD_TRUE)&&(GET_BDD_F1(i) == BDD_FALSE)) ||
			((GET_BDD_F0(i) == BDD_FALSE)&&(GET_BDD_F1(i) == BDD_TRUE)))
			continue;
		else {
			bdd_node_to_hspice(i);
		}
		
	}
	return;
}

/*
 *
 *
 */

static void
#ifdef __STDC__
hspice_header(void)
#else
hspice_header(/* void */)
#endif /* __STDC__ */
{
	struct tm *p;
	long clock;
	char *usr;

	time(&clock);
	p = localtime(&clock);
	usr = getenv("USER");

	fprintf(HSPICE_fp, "********************************************\n");
	fprintf(HSPICE_fp, "* Main Circuit Netlist:\n");
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "* Block: %s\n", Module_name_for_HDL);
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "* Last Time Saved: %s", asctime(p));
	fprintf(HSPICE_fp, "*      by %s\n", usr);
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "********************************************\n\n");

	return;
}

/*
 *	int get_odd_deg_node_num(void)
 *
 */

int
#ifdef __STDC__
get_odd_deg_node_num(void)
#else
get_odd_deg_node_num(/* void */)
#endif /* __STDC__ */
{
	int i;
	int ct = 0;

	for (i = 1; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) != UN_USED) &&
			(GET_BDD_REF_CT(i) != 0) &&
			(GET_BDD_REF_CT(i)%2 == 1)){
			ct++;
		}
	}
	return ct;
}

/*
 *	$B%l%$%"%&%H9g@.%D!<%k$GM-MQ$J>pJs$r%3%a%s%H$H$7$FKd$a9~$`!%(B
 */

static void
#ifdef __STDC__
hspice_comment_pre_info(void)
#else
hspice_comment_pre_info(/* void */)
#endif /* __STDC__ */
{
	int i;
	int trail;

	trail = get_odd_deg_node_num()/2;

	fprintf(HSPICE_fp, "********************************************\n");
	fprintf(HSPICE_fp, "* Transistor Netlist More Information from BDD.\n");
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "*\n");

	fprintf(HSPICE_fp, "*Inputnum %d\n", Input_val_num);
	fprintf(HSPICE_fp, "*Outputnum %d\n", final_PO_num());

	fprintf(HSPICE_fp, "*ValOrder ");

	/* $BF~NOJQ?t=g=x$r%3%a%s%H$H$7$F=PNO(B */
	for (i = 3; i < (Input_val_num + 3); i++)
		fprintf(HSPICE_fp, "%s ", Input_val_tbl[i].val);

	fprintf(HSPICE_fp, "\n*\n");
	fprintf(HSPICE_fp, "*PrimeOut ");
	
	/* $B=PNOJQ?t$N%j%9%H$r%3%a%s%H$H$7$F=PNO(B */
	for (i = 0; i < Function_num; i++)
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE))
			fprintf(HSPICE_fp, "%s-out ", Output_val_tbl[i].output_name);

	fprintf(HSPICE_fp, "\n*\n");
	fprintf(HSPICE_fp, "*Blocknum %d\n", (Input_val_num + final_PO_num()));
	fprintf(HSPICE_fp, "*Nodenum %d\n", (cur_nmos_tr_num()/2));
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "* Max Trail = %d\n", trail);
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "*\n");
	fprintf(HSPICE_fp, "********************************************\n\n");

	return;
}

/*
 *	$B:GBgCY1d$G$"$k$HM=A[$5$l$k=PNO$N!$F~NO?.9f@~L>(B(char *)$B$rJV$9(B.
 *
 */

static int
#ifdef __STDC__
get_sig_node(void)
#else
get_sig_node(/* void */)
#endif /* __STDC__ */
{
	int cur_node = Output_val_tbl[Max_delay_output_idx].pt_to_dag;

	assert((0 < cur_node) && (cur_node < Max_node_num));

	while (is_signal(cur_node) != TRUE) {
		assert((cur_node != BDD_FALSE) && (cur_node != BDD_TRUE));
		if (Tr_on_off_tbl[GET_BDD_LEVEL(cur_node)].phase == NEGA) {
			cur_node = GET_BDD_F0(cur_node);
		} else {
			assert(Tr_on_off_tbl[GET_BDD_LEVEL(cur_node)].phase == POSI);
			cur_node = GET_BDD_F1(cur_node);
		}
	}
	return cur_node;
}

/*
 *	$B>CHqEENO7W;;$N$?$a$NA0>pJs$r!$(BHSPICE$B7A<0$G=PNO!%(B
 */

static void
#ifdef __STDC__
hspice_info_for_power_sim(void)
#else
hspice_info_for_power_sim(/* void */)
#endif /* __STDC__ */
{
	int i, j;
	int sig_name_level;
	int sig_node_idx;
	phase_t is_posi;
	char sig_name[STRSIZE];

	fprintf(HSPICE_fp, "\n\n");

	/* $B$b$7!$F1$8(BBDD$B$GI=8=$5$l$k4X?t$,B8:_$9$l$P!$(B */
	/* $B$=$N$&$A@hF,$K6a$$$b$N0J30$O(Bflag$B$r$?$F$k(B */
	/* $B=i4|2=(B */
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE) {
			Output_val_tbl[i].is_active = TRUE;
		}
	}
	/* Check$B$7$D$D!$=LB`$7$?=PNO$N>pJs$r(BHSPICE$B%U%!%$%k$N%3%a%s%H$H$7$F=PNO(B */
	fprintf(HSPICE_fp, "********************************************\n");
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "* Output terminal name list with same SROBDD\n");
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "* \n");
	
	for (i = 0; i < (Function_num - 1); i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE)){

			if (is_signal(Output_val_tbl[i].pt_to_dag) == TRUE) {
				fprintf(HSPICE_fp, "* \n");
				fprintf(HSPICE_fp, "* WARNING: Output %s is connected to input signal directly.\n",
						Output_val_tbl[i].output_name);
				fprintf(HSPICE_fp, "* \n");
			} else {

				fprintf(HSPICE_fp, "* Output %s ---->\n",
						Output_val_tbl[i].output_name);

				for (j = (i + 1); j < Function_num; j++) {
					if ((Output_val_tbl[j].is_primary_out == TRUE) &&
						(is_signal(Output_val_tbl[i].pt_to_dag) == FALSE)) {
						if (Output_val_tbl[i].pt_to_dag == Output_val_tbl[j].pt_to_dag) {
							Output_val_tbl[j].is_active = FALSE;
							fprintf(HSPICE_fp, "* \t%s\n",
									Output_val_tbl[j].output_name);
						}
					}
				}
			}
			fprintf(HSPICE_fp, "* \n");
		}
	}
	fprintf(HSPICE_fp, "********************************************\n");

	/* $B0J2<!$%F%9%H%Y%/%H%k@8@.(B */
	/* measure$B%3%^%s%I=PNO(B */
	/* 100 nsec -> 200 nsec$B$^$G$N(Bvcc$B$NEEN.$NJ?6Q(B */

	fprintf(HSPICE_fp, ".measure tran puyolee avg i(vcc) from=100n to=200n\n");

	fprintf(HSPICE_fp, "\n\nVCC vdd gnd 3.0\n\n");

	for (i = 3; i < (Input_val_num + 3); i++) {
		/* $B@5O@M}(B */
		fprintf(HSPICE_fp, "vhsp%d %s gnd pwl 0,koni%da 100n,koni%da 100.1n,koni%db\n",
				i, Input_val_tbl[i].val, i, i, i);
		/* $BIiO@M}(B */
		fprintf(HSPICE_fp, "vhsp%db %sb gnd pwl 0,koni%dc 100n,koni%dc 100.1n,koni%dd\n",
				i, Input_val_tbl[i].val, i, i, i);
	}
	
	/* 1n$B9o$G(B200n$B$^$G(B */
	fprintf(HSPICE_fp, "\n\n.tran 1n 200n\n");

	fprintf(HSPICE_fp, ".include %s\n", Spice_file_name);

	fprintf(HSPICE_fp, ".global vdd gnd\n\n");

	/* nfet4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nfet4w b d g s\n");
	fprintf(HSPICE_fp, "mxn0 d g s b nt25 w=4e-06 l=9e-07 ad=9.2e-12 as=9.2e-12 pd=1.26e-05\n");
	fprintf(HSPICE_fp, "+ps=1.26e-05\n");
	fprintf(HSPICE_fp, ".ends nfet4w\n\n");

	/* pfet4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pfet4w b d g s\n");
	fprintf(HSPICE_fp, "mxp0 d g s b pt25 w=4e-06 l=1.1e-06 ad=9.2e-12 as=9.2e-12 pd=1.26e-05\n");
	fprintf(HSPICE_fp, "+ps=1.26e-05\n");
	fprintf(HSPICE_fp, ".ends pfet4w\n\n");

	/* pfet1w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pfet1w b d g s\n");
	fprintf(HSPICE_fp, "mxp0 d g s b pt25 w=1.2e-06 l=1.1e-06 ad=2.76e-12 as=2.76e-12 pd=7e-06\n");
	fprintf(HSPICE_fp, "+ps=7e-06\n");
	fprintf(HSPICE_fp, ".ends pfet1w\n\n");

	/* nmos4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nmos4w d g s\n");
	fprintf(HSPICE_fp, "xi0 gnd d g s nfet4w\n");
	fprintf(HSPICE_fp, ".ends nmos4w\n\n");

	/* pmos4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pmos4w d g s\n");
	fprintf(HSPICE_fp, "xi0 vdd d g s pfet4w\n");
	fprintf(HSPICE_fp, ".ends pmos4w\n\n");

	/* pmos1w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pmos1w d g s\n");
	fprintf(HSPICE_fp, "xi0 vdd d g s pfet1w\n");
	fprintf(HSPICE_fp, ".ends pmos1w\n\n");

	/* bddnode$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt bddnode a ab x xb y\n");
	fprintf(HSPICE_fp, "xi6 y a x nmos4w\n");
	fprintf(HSPICE_fp, "xi5 y ab xb nmos4w\n");
	fprintf(HSPICE_fp, ".ends bddnode\n\n");

	/* inv4$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt inv4 a v0 v1 y\n");
	fprintf(HSPICE_fp, "xi0 y a v0 nmos4w\n");
	fprintf(HSPICE_fp, "x14 v1 a y pmos4w\n");
	fprintf(HSPICE_fp, ".ends inv4\n\n");

	/* nnfet4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nnfet4l b d g s\n");
	fprintf(HSPICE_fp, ".mxn0 d g s b nt25 w=1.2e-06 l=4e-06 ad=2.76e-12 as=2.76e-12 pd=7e-06 ps=7e-06\n");
	fprintf(HSPICE_fp, ".ends nnfet4l\n\n");

	/* nnmos4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nnmos4l d g s\n");
	fprintf(HSPICE_fp, "xi0 gnd d g s nnfet4l\n");
	fprintf(HSPICE_fp, ".ends nnmos4l\n\n");

	/* ppfet4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt ppfet4l b d g s\n");
	fprintf(HSPICE_fp, ".mxn0 d g s b pt25 w=1.2e-06 l=4e-06 ad=2.76e-12 as=2.76e-12 pd=7e-06 ps=7e-06\n");
	fprintf(HSPICE_fp, ".ends ppfet4l\n\n");

	/* ppmos4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt ppmos4l d g s\n");
	fprintf(HSPICE_fp, "xi0 vdd g s ppfet4l\n");
	fprintf(HSPICE_fp, ".ends ppmos4l\n\n");

	/* invpn4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt invpn4l a v0 v1 y\n");
	fprintf(HSPICE_fp, "xi0 y a v0 nnmos4l\n");
	fprintf(HSPICE_fp, "x14 v1 a y ppmos4l\n");
	fprintf(HSPICE_fp, ".ends invpn4l\n\n");

	/* inv1n4$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt inv1n4 a v0 v1 y\n");
	fprintf(HSPICE_fp, "xi0 y a v0 nmos4w\n");
	fprintf(HSPICE_fp, "x14 v1 a y pmos1w\n");
	fprintf(HSPICE_fp, ".ends inv1n4\n\n");

	/* splhold$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt splhold posi nega in\n");
	fprintf(HSPICE_fp, "xi8 nega gnd vdd posi inv4\n");
	fprintf(HSPICE_fp, "xi0 in gnd vdd nega inv4\n");
	fprintf(HSPICE_fp, "xi1 nega gnd vdd in invpn4l\n");
	fprintf(HSPICE_fp, ".ends splhold\n\n");

	/* splinv$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt splinv nega in\n");
	fprintf(HSPICE_fp, "xi3 in nega vdd ppmos4l\n");
	fprintf(HSPICE_fp, "xi2 in gnd vdd nega inv1n4\n");
	fprintf(HSPICE_fp, ".ends splinv\n\n");

	/* $B=PNO$,$$$-$J$jF~NO$K$J$C$F$$$k>l9g$O%3%a%s%H$H$7$F=PNO$9$k!%(B*/
	for (i = 0; i < Function_num; i++) {
		if (is_signal(Output_val_tbl[i].pt_to_dag) == TRUE) {
			fprintf(HSPICE_fp, "********************************************\n");
			fprintf(HSPICE_fp, "* WARNING:\n");
			fprintf(HSPICE_fp, "* Input ---> Output is connected directly!\n");
			fprintf(HSPICE_fp, "* \n");
			fprintf(HSPICE_fp, "* \n");
			break;
		}
	}
	for (i = 0; i < Function_num; i++) {
		if (is_signal(Output_val_tbl[i].pt_to_dag) == TRUE) {
			fprintf(HSPICE_fp, "* Output %s <--------> Input %s\n",
					Output_val_tbl[i].output_name,
					level_to_val(GET_BDD_LEVEL(Output_val_tbl[i].pt_to_dag)));
		}
	}
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "********************************************\n");		

	fprintf(HSPICE_fp, "\n");

	return;

}

/*
 *
 *
 */

static void
#ifdef __STDC__
hspice_info_for_sim(void)
#else
hspice_info_for_sim(/* void */)
#endif /* __STDC__ */
{
	int i, j;
	int sig_name_level;
	int sig_node_idx;
	phase_t is_posi;
	char sig_name[STRSIZE];

	fprintf(HSPICE_fp, "\n\n");

	/* $B$b$7!$F1$8(BBDD$B$GI=8=$5$l$k4X?t$,B8:_$9$l$P!$(B */
	/* $B$=$N$&$A@hF,$K6a$$$b$N0J30$O(Bflag$B$r$?$F$k(B */
	/* $B=i4|2=(B */
	for (i = 0; i < Function_num; i++) {
		if (Output_val_tbl[i].is_primary_out == TRUE) {
			Output_val_tbl[i].is_active = TRUE;
		}
	}
	/* Check$B$7$D$D!$=LB`$7$?=PNO$N>pJs$r(BHSPICE$B%U%!%$%k$N%3%a%s%H$H$7$F=PNO(B */
	fprintf(HSPICE_fp, "********************************************\n");
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "* Output terminal name list with same SROBDD\n");
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "* \n");
	
	for (i = 0; i < (Function_num - 1); i++) {
		if ((Output_val_tbl[i].is_primary_out == TRUE) &&
			(Output_val_tbl[i].is_active == TRUE)){

			if (is_signal(Output_val_tbl[i].pt_to_dag) == TRUE) {
				fprintf(HSPICE_fp, "* \n");
				fprintf(HSPICE_fp, "* WARNING: Output %s is connected to input signal directly.\n",
						Output_val_tbl[i].output_name);
				fprintf(HSPICE_fp, "* \n");
			} else {

				fprintf(HSPICE_fp, "* Output %s ---->\n",
						Output_val_tbl[i].output_name);

				for (j = (i + 1); j < Function_num; j++) {
					if ((Output_val_tbl[j].is_primary_out == TRUE) &&
						(is_signal(Output_val_tbl[i].pt_to_dag) == FALSE)) {
						if (Output_val_tbl[i].pt_to_dag == Output_val_tbl[j].pt_to_dag) {
							Output_val_tbl[j].is_active = FALSE;
							fprintf(HSPICE_fp, "* \t%s\n",
									Output_val_tbl[j].output_name);
						}
					}
				}
			}
			fprintf(HSPICE_fp, "* \n");
		}
	}
	fprintf(HSPICE_fp, "********************************************\n");

	/* $B8=:_$N:GD9CY1d$G$"$k$HM=A[$5$l$k=PNO$NF~NO?.9f@~$r8+$D$1$k(B */
	sig_node_idx = get_sig_node();
	sig_name_level = GET_BDD_LEVEL(sig_node_idx);
	is_posi = is_posi_signal(sig_node_idx);
	strcpy(sig_name, level_to_val(sig_name_level));

	/* $B$9$Y$F$N(BPrimary OUT$B$KBP$7$F!$CY1d;~4V$r5a$a$?$$(B */
	if (is_posi == TRUE) {
		for (i = 0; i < Function_num; i++) {
			if ((Output_val_tbl[i].is_active == TRUE) &&
				(Output_val_tbl[i].is_primary_out == TRUE)) {
				/* for Posi Signal */

				if (Hspice_cmos_flag == TRUE) { /* $B=PNO$K$V$i$5$2$k(BInv */
					fprintf(HSPICE_fp, ".measure tran R%s trig v(%s) val=0.01 td=50ns rise=1\n",
							Output_val_tbl[i].output_name, sig_name);
					fprintf(HSPICE_fp, "+targ v(%spo) val=%4.2lf fall = 1\n",
							Output_val_tbl[i].output_name, V_INV);
				} else {
					assert(Hspice_cmos_flag == FALSE);
					fprintf(HSPICE_fp, ".measure tran R%s trig v(%s) val=0.01 td=50ns rise=1\n",
							Output_val_tbl[i].output_name, sig_name);
					fprintf(HSPICE_fp, "+targ v(%s) val=%4.2lf rise = 1\n",
							Output_val_tbl[i].output_name, V_INV);
				}
			}
		}

	} else {
		assert(is_posi == FALSE);
		for (i = 0; i < Function_num; i++) {
			if ((Output_val_tbl[i].is_active == TRUE) &&
				(Output_val_tbl[i].is_primary_out == TRUE)) {
				/* for Nega Signal */

				if (Hspice_cmos_flag == TRUE) {	/* $B=PNO$K$V$i$5$2$k(BInv */
					fprintf(HSPICE_fp, ".measure tran R%s trig v(%sb) val=0.01 td=50ns rise=1\n",
							Output_val_tbl[i].output_name, sig_name);
					fprintf(HSPICE_fp, "+targ v(%spo) val=%4.2lf fall = 1\n",
							Output_val_tbl[i].output_name, V_INV);
				} else {
					assert(Hspice_cmos_flag == FALSE);
					fprintf(HSPICE_fp, ".measure tran R%s trig v(%sb) val=0.01 td=50ns rise=1\n",
							Output_val_tbl[i].output_name, sig_name);
					fprintf(HSPICE_fp, "+targ v(%s) val=%4.2lf rise = 1\n",
							Output_val_tbl[i].output_name, V_INV);
				}
			}
		}
	}
	fprintf(HSPICE_fp, "\n\nVCC vdd gnd 3.0\n\n");

	/* $BF~NO%Q%?%s$rM?$($k(B */

	for (i = 3; i < (Input_val_num + 3); i++) {
		if (Hspice_cmos_flag == TRUE) {
			if (i == sig_name_level) {
				if (is_posi == TRUE) {
					fprintf(HSPICE_fp, "vhsp%d %spi gnd pwl 0,0 100n,0 100.1n,3.0\n",
							i, Input_val_tbl[i].val);
				} else {
					assert(is_posi == FALSE);
					fprintf(HSPICE_fp, "vhsp%d %spi gnd pwl 0,3.0 100n,3.0 100.1n,0\n",
							i, Input_val_tbl[i].val);
				}
			} else {
				if (Tr_on_off_tbl[i].phase == NEGA) {
					fprintf(HSPICE_fp, "vhsp%d %spi gnd 0\n", i, Input_val_tbl[i].val);
				} else {
					assert(Tr_on_off_tbl[i].phase == POSI);
					fprintf(HSPICE_fp, "vhsp%d %spi gnd 3.0\n", i, Input_val_tbl[i].val);
				}
			}
		} else {
			assert(Hspice_cmos_flag == FALSE);
			if (i == sig_name_level) {
				if (is_posi == TRUE) {
					fprintf(HSPICE_fp, "vhsp%d %s gnd pwl 0,0 100n,0 100.1n,3.0\n",
							i, Input_val_tbl[i].val);
					fprintf(HSPICE_fp, "vhsp%db %sb gnd pwl 0,3.0 100n,3.0 100.1n,0\n",
							i, Input_val_tbl[i].val);
				} else {
					assert(is_posi == FALSE);
					fprintf(HSPICE_fp, "vhsp%d %s gnd pwl 0,3.0 100n,3.0 100.1n,0\n",
							i, Input_val_tbl[i].val);
					fprintf(HSPICE_fp, "vhsp%db %sb gnd pwl 0,0 100n,0 100.1n,3.0\n",
							i, Input_val_tbl[i].val);
				}
			} else {
				if (Tr_on_off_tbl[i].phase == NEGA) {
					fprintf(HSPICE_fp, "vhsp%d %s gnd 0\n", i, Input_val_tbl[i].val);
					fprintf(HSPICE_fp, "vhsp%db %sb gnd 3.0\n", i, Input_val_tbl[i].val);
				} else {
					assert(Tr_on_off_tbl[i].phase == POSI);
					fprintf(HSPICE_fp, "vhsp%d %s gnd 3.0\n", i, Input_val_tbl[i].val);
					fprintf(HSPICE_fp, "vhsp%db %sb gnd 0\n", i, Input_val_tbl[i].val);
				}
			}
		}
	}

	fprintf(HSPICE_fp, "\n\n.tran 0.1n %dn\n",
			(int)(Output_val_tbl[Max_delay_output_idx].delay_time) + 150);
	/* $BM=A[$7$F$$$kCY1d;~4V(B $B!\#1#0#0(B $B!\(B $B>/$7$N%^!<%8%s(B */


	fprintf(HSPICE_fp, ".include %s\n", Spice_file_name);

	fprintf(HSPICE_fp, ".global vdd gnd\n\n");

	/* nfet4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nfet4w b d g s\n");
	fprintf(HSPICE_fp, "mxn0 d g s b nt25 w=4e-06 l=9e-07 ad=9.2e-12 as=9.2e-12 pd=1.26e-05\n");
	fprintf(HSPICE_fp, "+ps=1.26e-05\n");
	fprintf(HSPICE_fp, ".ends nfet4w\n\n");

	/* pfet4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pfet4w b d g s\n");
	fprintf(HSPICE_fp, "mxp0 d g s b pt25 w=4e-06 l=1.1e-06 ad=9.2e-12 as=9.2e-12 pd=1.26e-05\n");
	fprintf(HSPICE_fp, "+ps=1.26e-05\n");
	fprintf(HSPICE_fp, ".ends pfet4w\n\n");

	/* pfet1w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pfet1w b d g s\n");
	fprintf(HSPICE_fp, "mxp0 d g s b pt25 w=1.2e-06 l=1.1e-06 ad=2.76e-12 as=2.76e-12 pd=7e-06\n");
	fprintf(HSPICE_fp, "+ps=7e-06\n");
	fprintf(HSPICE_fp, ".ends pfet1w\n\n");

	/* nmos4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nmos4w d g s\n");
	fprintf(HSPICE_fp, "xi0 gnd d g s nfet4w\n");
	fprintf(HSPICE_fp, ".ends nmos4w\n\n");

	/* pmos4w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pmos4w d g s\n");
	fprintf(HSPICE_fp, "xi0 vdd d g s pfet4w\n");
	fprintf(HSPICE_fp, ".ends pmos4w\n\n");

	/* pmos1w$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt pmos1w d g s\n");
	fprintf(HSPICE_fp, "xi0 vdd d g s pfet1w\n");
	fprintf(HSPICE_fp, ".ends pmos1w\n\n");

	/* bddnode$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt bddnode a ab x xb y\n");
	fprintf(HSPICE_fp, "xi6 y a x nmos4w\n");
	fprintf(HSPICE_fp, "xi5 y ab xb nmos4w\n");
	fprintf(HSPICE_fp, ".ends bddnode\n\n");

	/* inv4$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt inv4 a v0 v1 y\n");
	fprintf(HSPICE_fp, "xi0 y a v0 nmos4w\n");
	fprintf(HSPICE_fp, "x14 v1 a y pmos4w\n");
	fprintf(HSPICE_fp, ".ends inv4\n\n");

	/* nnfet4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nnfet4l b d g s\n");
	fprintf(HSPICE_fp, "mxn0 d g s b nt25 w=1.2e-06 l=4e-06 ad=2.76e-12 as=2.76e-12 pd=7e-06 ps=7e-06\n");
	fprintf(HSPICE_fp, ".ends nnfet4l\n\n");

	/* nnmos4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt nnmos4l d g s\n");
	fprintf(HSPICE_fp, "xi0 gnd d g s nnfet4l\n");
	fprintf(HSPICE_fp, ".ends nnmos4l\n\n");

	/* ppfet4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt ppfet4l b d g s\n");
	fprintf(HSPICE_fp, "mxn0 d g s b pt25 w=1.2e-06 l=4e-06 ad=2.76e-12 as=2.76e-12 pd=7e-06 ps=7e-06\n");
	fprintf(HSPICE_fp, ".ends ppfet4l\n\n");

	/* ppmos4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt ppmos4l d g s\n");
	fprintf(HSPICE_fp, "xi0 vdd d g s ppfet4l\n");
	fprintf(HSPICE_fp, ".ends ppmos4l\n\n");

	/* invpn4l$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt invpn4l a v0 v1 y\n");
	fprintf(HSPICE_fp, "xi0 y a v0 nnmos4l\n");
	fprintf(HSPICE_fp, "x14 v1 a y ppmos4l\n");
	fprintf(HSPICE_fp, ".ends invpn4l\n\n");

	/* inv1n4$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt inv1n4 a v0 v1 y\n");
	fprintf(HSPICE_fp, "xi0 y a v0 nmos4w\n");
	fprintf(HSPICE_fp, "x14 v1 a y pmos1w\n");
	fprintf(HSPICE_fp, ".ends inv1n4\n\n");

	/* splhold$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt splhold posi nega in\n");
	fprintf(HSPICE_fp, "xi8 nega gnd vdd posi inv4\n");
	fprintf(HSPICE_fp, "xi0 in gnd vdd nega inv4\n");
	fprintf(HSPICE_fp, "xi1 nega gnd vdd in invpn4l\n");
	fprintf(HSPICE_fp, ".ends splhold\n\n");

	/* splinv$B$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt splinv nega in\n");
	fprintf(HSPICE_fp, "xi3 in nega vdd ppmos4l\n");
	fprintf(HSPICE_fp, "xi2 in gnd vdd nega inv1n4\n");
	fprintf(HSPICE_fp, ".ends splinv\n\n");

	/* $BCf4V%P%C%U%!$N(Bsub circuit$B>pJs(B */
	fprintf(HSPICE_fp, ".subckt midbuf posi in\n");
	fprintf(HSPICE_fp, "xi0 in nega vdd ppmos4l\n");
	fprintf(HSPICE_fp, "xi1 nega gnd vdd posi inv4\n");
	fprintf(HSPICE_fp, "xi2 in gnd vdd nega inv1n4\n");
	fprintf(HSPICE_fp, ".ends midbuf\n");

	/* $B=PNO$,$$$-$J$jF~NO$K$J$C$F$$$k>l9g$O%3%a%s%H$H$7$F=PNO$9$k!%(B*/
	for (i = 0; i < Function_num; i++) {
		if (is_signal(Output_val_tbl[i].pt_to_dag) == TRUE) {
			fprintf(HSPICE_fp, "********************************************\n");
			fprintf(HSPICE_fp, "* WARNING:\n");
			fprintf(HSPICE_fp, "* Input ---> Output is connected directly!\n");
			fprintf(HSPICE_fp, "* \n");
			fprintf(HSPICE_fp, "* \n");
			break;
		}
	}
	for (i = 0; i < Function_num; i++) {
		if (is_signal(Output_val_tbl[i].pt_to_dag) == TRUE) {
			fprintf(HSPICE_fp, "* Output %s <--------> Input %s\n",
					Output_val_tbl[i].output_name,
					level_to_val(GET_BDD_LEVEL(Output_val_tbl[i].pt_to_dag)));
		}
	}
	fprintf(HSPICE_fp, "* \n");
	fprintf(HSPICE_fp, "********************************************\n");		

	fprintf(HSPICE_fp, "\n");

	return;
}

/*
 *	HSPICE$B$N%M%C%H%j%9%H$KF~=PNOItJ,$N>pJs$rIU2C$9$k!%(B
 */

static void
#ifdef __STDC__
hspice_cmos_netlist(void)
#else
hspice_cmos_netlist(/* void */)
#endif /* __STDC__ */
{
	char hold_in[STRSIZE], hold_nega[STRSIZE], hold_posi[STRSIZE];
	int i;

	/* $BF~NOItJ,$N=hM}(B */
	/* Layout_flag$B$,(BTRUE$B$N$H$-$N$_$N=hM}(B */
	if (Layout_flag == TRUE) {
		for (i = 3; i < (Input_val_num + 3); i++) {
			sprintf(hold_in, "%s", Input_val_tbl[i].val);
			sprintf(hold_nega, "%sn", Input_val_tbl[i].val);
			sprintf(hold_posi, "%sp", Input_val_tbl[i].val);
			print_hspice_hold4(hold_in, hold_nega, hold_posi);
		}
	} else if (Hspice_cmos_flag == TRUE) {
		for (i = 3; i < (Input_val_num + 3); i++) {
			print_hspice_spl_in_hold(Input_val_tbl[i].val);
		}
	}

	/* $B=PNOItJ,$N=hM}(B */
	if (Layout_flag == TRUE) {	/* $B4_K\%l%$%"%&%HMQ(B */
		/* $B=PNOItJ,$K(B3-state$B%P%C%U%!$r$V$i$5$2$k(B */
		for (i = 0; i < Function_num; i++) {
			if ((Output_val_tbl[i].is_active == TRUE) &&
				(Output_val_tbl[i].is_primary_out == TRUE) &&
				(is_signal(Output_val_tbl[i].pt_to_dag) == FALSE)) {
				print_hspice_3state_1(Output_val_tbl[i].output_name);
			}
		}
	} else if (Hspice_cmos_flag == TRUE) {	/* SPL$BI>2AMQ!JBP(BCMOS$BMQ!K(B */
		/* $B=PNO$K%$%s%P!<%?$r$V$i$5$2$k(B */
		for (i = 0; i < Function_num; i++) {
			if ((Output_val_tbl[i].is_active == TRUE) &&
				(Output_val_tbl[i].is_primary_out == TRUE) &&
				(is_signal(Output_val_tbl[i].pt_to_dag) == FALSE)) {
				/* $B$3$3$rD{@5$9$k(B */
				print_hspice_spl_out_inv(Output_val_tbl[i].output_name);
			}
		}
	} else {
		assert(Layout_flag == FALSE);
		/* $B=PNOItJ,$KMFNL%<%m$N%3%s%G%s%5$r$V$i$5$2$k(B */
		for (i = 0; i < Function_num; i++) {
			if ((Output_val_tbl[i].is_active == TRUE) &&
				(Output_val_tbl[i].is_primary_out == TRUE) &&
				(is_signal(Output_val_tbl[i].pt_to_dag) == FALSE)) {
				fprintf(HSPICE_fp, "c%d %s gnd 0\n", i, Output_val_tbl[i].output_name);
			}
		}
	}
	return;
}

/*
 *	$B>CHqEENO7W;;$N$?$a$N%F%9%H%Y%/%H%kI=<(!%(B
 */

static void
#ifdef __STDC__
gen_power_vector(void)
#else
gen_power_vector(/* void */)
#endif /* __STDC__ */
{
	int seed = 10;
	int i, j;
	int ret;

	srand(seed);

	for (i = 0; i < RAND_DATA_NUM; i++) {
		fprintf(HSPICE_fp, ".PARAM \n");
		for (j = 3; j < (Input_val_num + 3); j++) {
			ret = rand();

			if (((ret>>7)%2) == 1) {
				fprintf(HSPICE_fp, "+koni%da=3.0 koni%dd=3.0 ", j, j);
			} else {
				fprintf(HSPICE_fp, "+koni%da=0.0 koni%dd=0.0 ", j, j);
			}

			ret = rand();

			if (((ret>>7)%2) == 1) {
				fprintf(HSPICE_fp, "koni%db=3.0 koni%dc=3.0 \n", j, j);
			} else {
				fprintf(HSPICE_fp, "koni%db=0.0 koni%dc=0.0 \n", j, j);
			}
		}
		if (i != (RAND_DATA_NUM - 1)) {
			fprintf(HSPICE_fp, ".ALTER\n");
		}
	}
	return;
}

/*
 *
 *
 */

static void
#ifdef __STDC__
hspice_comment_post_info(void)
#else
hspice_comment_post_info(/* void */)
#endif /* __STDC__ */
{
	fprintf(HSPICE_fp, ".end\n");
	return;
}

/*
 *	BDD$BItJ,$r%H%i%s%8%9%?$N%M%C%H%j%9%H$KJQ49$9$k:,85(B
 *
 */

static void
#ifdef __STDC__
hspice_bdd_module(void)
#else
hspice_bdd_module(/* void */)
#endif /* __STDC__ */
{
	char buf[STRSIZE];

	sprintf(buf, "%s.hspice", Module_name_for_HDL);

	HSPICE_fp = fopen(buf, "wt");

	if (HSPICE_fp == NULL)
		FOPEN_ERR(buf);

	hspice_header();

	if (Layout_flag == TRUE)
		hspice_comment_pre_info();

	if (Layout_flag != TRUE) {
		if (Power_vector_flag == TRUE) {
/*			hspice_info_for_power_sim();*/
		} else {
			assert(Power_vector_flag == FALSE);
/*			hspice_info_for_sim();*/
		}
	}

	hspice_cmos_netlist();

	bdd_to_hspice();

	if (Power_vector_flag == TRUE)
		gen_power_vector();

	if (Layout_flag == FALSE)
		hspice_comment_post_info();

	return;
}

/*
 *
 *
 */

void
#ifdef __STDC__
write_hspice(char *fname)
#else
write_hspice(fname)
  char *fname;
#endif /* __STDC__ */
{
	set_data_name(fname);
	check_used_signal();

	Hspice_module_ct = 0; /* $B$9$Y$F$N%b%8%e!<%k$K0l0U$K?6$jJ,$1$k%$%s%G%/%9(B */

	hspice_bdd_module();

	fclose(HSPICE_fp);
	return;
}

		
/*>>>>>>>>>>>>>>>>> $B$3$3$+$iM=HwMQ$N(BNetlist <<<<<<<<<<<<<<<<<<*/

/*
 *
 *
 */

static void
#ifdef __STDC__
bdd_node_to_netlist(int node_idx)
#else
bdd_node_to_netlist(node_idx)
  int node_idx;
#endif /* __STDC__ */
{
	char val[STRSIZE];
	char f0_val[STRSIZE];
	char f1_val[STRSIZE];
	int f0, f1;
	int ref_ct;
	char tmp[STRSIZE];

	if (node_idx == BDD_FALSE) {
		fprintf(Netlist_fp, "(1(0), NULL(END), NULL(END), %d)\n",
				GET_BDD_REF_CT(BDD_FALSE));
		return;
	} else if (node_idx == BDD_TRUE) {
		fprintf(Netlist_fp, "(2(1), NULL(END), NULL(END), %d)\n",
				GET_BDD_REF_CT(BDD_TRUE));
		return;
	}

	assert((2 < node_idx) && (node_idx < Max_node_num));

	/* $B%N!<%I$N%i%Y%k$rF@$k(B */
	if (GET_BDD_LEVEL(node_idx) == BDD_FALSE)
		sprintf(val, "0");
	else if (GET_BDD_LEVEL(node_idx) == BDD_TRUE)
		sprintf(val, "1");
	else {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(node_idx)));
		sprintf(val, "%s", tmp);
	}

	/* 0$B;^$N>pJs$rF@$k(B */
	f0 = GET_BDD_F0(node_idx);

	if (GET_BDD_LEVEL(f0) == BDD_FALSE)
		sprintf(f0_val, "0");
	else if (GET_BDD_LEVEL(f0) == BDD_TRUE)
		sprintf(f0_val, "1");
	else {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(f0)));
		sprintf(f0_val, "%s", tmp);
	}

	/* 1$B;^$N>pJs$rF@$k(B */
	f1 = GET_BDD_F1(node_idx);

	if (GET_BDD_LEVEL(f1) == BDD_FALSE)
		sprintf(f1_val, "0");
	else if (GET_BDD_LEVEL(f1) == BDD_TRUE)
		sprintf(f1_val, "1");
	else {
		strcpy(tmp, level_to_val(GET_BDD_LEVEL(f1)));
		sprintf(f1_val, "%s", tmp);
	}
	
	/* Ref.Ct.$B$rF@$k(B */

	ref_ct = GET_BDD_REF_CT(node_idx);


	/* $B=PNO(B */
	fprintf(Netlist_fp, "(%d(%s), %d(%s), %d(%s), %d)\n",
			node_idx, val,
			f0, f0_val,
			f1, f1_val, ref_ct);

	return;
}

/*
 *	BDD$B$rM=HwMQ$N%M%C%H%j%9%H$KJQ49$9$k%b%8%e!<%k$N:,85(B
 */

void
#ifdef __STDC__
write_netlist(char *fname)
#else
write_netlist(fname)
  char *fname;
#endif /* __STDC__ */
{
	int i;
	char buf[STRSIZE];

	set_data_name(fname);

	sprintf(buf, "%s.lst", Module_name_for_HDL);

	Netlist_fp = fopen(buf, "wt");
	if (Netlist_fp == NULL)
		FOPEN_ERR(buf);


	fprintf(Netlist_fp, "Node(val), 0-edge(val), 1-edge(val), ref_ct\n");
	for (i = 1; i < Max_node_num; i++) {
		if ((GET_BDD_LEVEL(i) == UN_USED) ||
			(GET_BDD_REF_CT(i) == 0))
			continue;
		else
			bdd_node_to_netlist(i);
	}
	return;
}

