/*-----------------------------------------------------------------------------
|	toHPI.c		ߥλ˰ʲλɸƤ		      |
|			ʣHydropathy Index from K-D			      |
|			ʣModify Hydropathy Index from k-D and N-T	      |
|			ʣNon charge Index				      |
|									      |
|	Copyright(C)1996 Shigeki Mitaku					      |
------------------------------------------------------------------------------*/

#include <stdio.h>

#define	ML	5000	/*	갷륢ߥλĹ	   	      */

/*-----------------------------------------------------------------------------
|	ߥλ˳ƻɸƤ				      |
------------------------------------------------------------------------------*/

void ToHydropathyIndex(oneltteramino,hpindex,m_hpindex,charge_index,length)
char	oneltteramino[ML][2];	/*  ߥλʸ    			      */
float	*hpindex;		/*  K-Dɸγ		     	      */
float	*m_hpindex;		/*  N-Tɸγ		              */
int	*charge_index;		/*  Ťγ		              */
int	*length;		/*  ĴĹ			              */
{

	int	i,j,a;

	struct _AminoData{
		char	symbol3[4];		/*  ߥλʸɽ	      */
		char	symbol1l[2];		/*  ߥλʸɽ  */
		char	symbol1s[2];		/*  ߥλʸɽʾ  */
		float	hydropathy;		/*  k-D¿ɸ	      */
		float	m_hydropathy;		/*  N-T¿ɸ	      */
		float	mol_weight;		/*  ʬ		      */
		float	chargeindex;		/*  Żɸ		      */
		enum	{non,hb,mn,pl} mode;	/*  Ĵ		      */
	};

	static struct _AminoData init_data[23] = {
        {"ILE","I","i",4.5,4.5,-.59,0,hb},
	{"VAL","V","v",4.2,4.2,-1.57,0,hb},
        {"LEU","L","l",3.8,3.8,-.59,0,hb},
	{"PHE","F","f",2.8,2.8,-1.78,0,hb},
        {"CYS","C","c",2.5,2.5,-1.29,0,hb},
	{"MET","M","m",1.9,1.9,.66,0,hb},
        {"ALA","A","a",1.8,1.8,-3.52,0,hb},
	{"GLY","G","g",-.4,-.4,-4.5,0,non},
        {"THR","T","t",-.7,-.7,-1.43,0,non},
	{"SER","S","s",-.8,-.8,-2.41,0,non},
        {"TRP","W","w",-.9,3.0,4.5,0,non},
        {"TYR","Y","y",-1.3,3.0,2.9,0,non},
        {"PRO","P","p",-1.6,-1.6,-1.71,0,non},
        {"HYP","$","$",-1.6,-1.6,-1.71,0,non},
        {"HIS","H","h",-3.2,-1.0,1.08,1.0,pl},
	{"GLU","E","e",-3.5,-3.5,.45,-1.0,mn},
        {"GLN","Q","q",-3.5,-3.5,.45,0,non},
	{"GLX","$","$",-3.5,-3.5,.45,0,non},
        {"ASP","D","d",-3.5,-3.5,-.52,-1.0,mn},
	{"ASN","N","n",-3.5,-3.5,-.52,0,non},
        {"ASX","$","$",-3.5,-3.5,-.52,0,non},
	{"LYS","K","k",-3.9,0.0,.5,1.0,pl},
        {"ARG","R","r",-4.5,-3.0,2.48,1.0,pl}
	};

	struct	_AminoData	*p;

	for(i=0;i<(*length);i++){
	   p = init_data;
	   for(a=0;a<23;a++,p++){
	      if(!(strcmp(oneltteramino[i],p->symbol1l))){
	         hpindex[i] = p->hydropathy;		/*  K-Dɸγ */
	         m_hpindex[i] = p->m_hydropathy;	/*  N-Tɸγ */
	         charge_index[i] = p->chargeindex;	/*  Żɸγ*/
	      }
	   }
	}
}
