/*
 * Copyright(C)1996 Shigeki Mitaku                                           
 *
 *   sosui/memcalc.c
 *                                            
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>


#define	ML	5000

void memcalc(arr_hydro,ana_start,ana_end,
	     order_m,sort_mode,
             spc_plot,sort_max,sort_max1,sort_max2,sort_max3,spc_max,av1)
	float	 *arr_hydro;/***  input data ***/
	int	 *ana_start;	/***  input data ***/
	int	 *ana_end;	/***  input data ***/
	float	 *order_m;	/***  input data ***/
	int	 *sort_mode;	/***  input data ***/
	float	 *spc_plot;/*** output data ***/
	float	 *sort_max;	/*** output data ***/
        float    *sort_max1;     /*** output data ***/
        float    *sort_max2;     /*** output data ***/
        float    *sort_max3;     /*** output data ***/
	float	 *spc_max;	/*** output data ***/
	float	 *av1;		/*** output data ***/
{
	int	i,j,ii,jj,
		sort_start,sort_end,
		sub_resi,m,n,minm;
	float	arr_mem[ML],
		hydro_sum,sum,sumn,sumd,sum1,sum2,
		pm,pm1,pmm,rm,fpemin,
		wnint,wnmin,wnmax,f,ci,cc,
		y[ML],r[100],rr[100],z,
		rfpe[100],fpe[100];

	sub_resi = (*ana_end) - (*ana_start) + 1;


	/*
	 *	sort mode
	 *
	 * ------------------------------------------------------------------
	 * | 2-2.8<1> | 2.8-4.5<2> | 4.5-9<3> | 9-20<4> | 20-i<5> | 30-i<6> | 
	 * ------------------------------------------------------------------
	 * 1          73           141        195       225       234      250
	 *
	 */


	switch(*sort_mode)
	 {
	  case 1:	ii=1;	jj=72;	break;
	  case 2:	ii=73;	jj=140;	break;
	  case 3:	ii=141;	jj=194;	break;
	  case 4:	ii=195;	jj=224;	break;
	  case 5:	ii=225;	jj=250;	break;
	  case 6:	ii=234;	jj=250;	break;
	 }


	for(i=0;i<5000;i++)
		arr_mem[i] = 0.0;	/*** Initialize ***/

	for(i=0;i<250;i++)
		spc_plot[i] = 0.0;	/*** Initialize ***/


	for(i=1;i<=sub_resi;i++)
		arr_mem[i] = arr_hydro[i+(*ana_start)-1];

	hydro_sum = 0.0;	sum = 0.0;

	for(i=1;i<=sub_resi;i++)
		hydro_sum += arr_mem[i];

	(*av1) = hydro_sum/sub_resi;


	for(i=1;i<=sub_resi;i++){
		z = arr_mem[i]-(*av1);
		arr_mem[i] = z;
		y[i-1] = z;
		sum += z*z;}

	pm = sum / sub_resi;

	fpemin = 1.0*(sub_resi+1)/(sub_resi-1)*pm;	fpe[1] = fpemin;

	for(m=1;m<=(*order_m);m++){
		sumn = 0.0;	sumd = 0.0;
		for(i=1;i<=sub_resi-1;i++){
			sumn += arr_mem[i]*y[i];	
			sumd += arr_mem[i]*arr_mem[i] + y[i]*y[i];}

	if(sumd==0.0){
		for(i=0;i<=sub_resi;i++)  arr_mem[i] = 0.0;}

	rm = -2.0*sumn/sumd;	r[m] = rm;	 pm = pm*(1-rm*rm);

	if(m!=1){
		for(i=1;i<m-1;i++)	r[i] = rr[i] + rm*rr[m-i];}

	rr[m] = r[m];

	for(i=1;i<=sub_resi-m-1;i++){
		arr_mem[i] = arr_mem[i] + rm*y[i];
		y[i] = y[i+1] + rm*arr_mem[i+1];}

	fpe[m] = 1.0*(sub_resi+m+1)/(sub_resi-m-1)*pm;
	}

	pmm = pm;            minm = (*order_m);          wnmin = 0.0;  
	wnmax = sub_resi/2;  wnint = (wnmax-wnmin)/250;

	ci = 2*3.14159265/sub_resi;


	for(i=1;i<=250;i++){
		sum1 = 1.0;	sum2 = 0.0;
		f = wnmin + wnint*i;
		for(j=1;j<=minm;j++){
			cc = ci*f*j;
			sum1 = sum1 + r[j]*cos(cc);
			sum2 = sum2 + r[j]*sin(cc);}
		spc_plot[251-i] = pmm/(sum1*sum1 + sum2*sum2); }


	/*******  sort ********/

	(*sort_max1) = 0.0;	(*spc_max) = 0.0;	/*** Initialize ***/
        (*sort_max) = 0.0;        (*sort_max2) = 0.0;       (*sort_max3) = 0.0;

 	for(i=1;i<=250;i++){
		if(spc_plot[i]>(*spc_max))
			(*spc_max) = spc_plot[i];}

        for(i=ii;i<=jj;i++){
                if(spc_plot[i]>(*sort_max))
                        (*sort_max) = spc_plot[i];}

 	for(i=1;i<=72;i++){
		if(spc_plot[i]>(*sort_max1))
			(*sort_max1) = spc_plot[i];}

        for(i=195;i<250;i++){
                if(spc_plot[i]>(*sort_max3))
                        (*sort_max3) = spc_plot[i];}


        for(i=73;i<=140;i++){
                if(spc_plot[i]>(*sort_max2))
                        (*sort_max2) = spc_plot[i];}

}
