/*-----------------------------------------------------------------------------
|	identSH.c	ʣ˥󥫡̥إå¸ͽ¬	      |
|			ʣ˹¤̥إå¸ͽ¬	      |
|									      |
|	Copyright(C)1996 Shigeki Mitaku					      |
------------------------------------------------------------------------------*/
 
#include <stdio.h>
#include <math.h>

#define ML  5000		/*  갷륢ߥλĹ 	      */
#define MH  50			/*  ͽ¬ǽʥإåܿ		      */

struct _cm_data {		/*  󥫡إåξ	      	      */
        int     start;		/*  ü			      	      */
        int     end;		/*  ü			              */
        int     center;		/*  إåΰ濴		      */
	int	type;};		/*  إåΥ	              	      */

struct _sh_data {		/*  ¤إåξ	      	      */
        int     start;		/*  ü			      	      */
        int     end;		/*  ü			              */
        int     center;		/*  إåΰ濴		      */
	int	core_len;	/*  إåΰĹ			      */
	float	ave;		/*  إåΰʿ¿  	      */
	int	type;};		/*  إåΥ	              	      */

/*-----------------------------------------------------------------------------
|	֥롼						      |
------------------------------------------------------------------------------*/

void	soapmethod();		/*  ưʿˡ׻֥롼		      */
void	calc_sh_index();	/*  ¿ѲΨ׻		      */

/*-----------------------------------------------------------------------------
|	󥫡̥إå¸ͽ¬			      |
------------------------------------------------------------------------------*/

void ClassificationMembrane(length,hpindex,m_hpindex,
                                cm_code,cm_seg_num,cm_core_len,cm_ave,cm)
int     *length;                /*  ͡ĴĹ                            */
float   *hpindex;               /*  ͡K-Dɸ                           */
float   *m_hpindex;             /*  ͡K-Dɸ                           */
int     *cm_code;               /*  ֤͡ɡʣ                  */
int     *cm_seg_num;            /*  ֤͡إåܿ                    */
int	*cm_core_len;		/*  ֤͡إåΰĹ		      */
float	*cm_ave;		/*  ֤͡إåΰʿ¿	      */
struct  _cm_data        *cm;    /*  ֤͡إå                    */
{
        int     i,j,k,m,	/*  ѿ				      */
                window,         /*  ưʿˡκݤΥɥ          */
                pred[2][ML],    /*  Ūͽ¬̤γǼ                    */
                center,         /*  ŪʥȤ濴Ĵֹ          */
                final_center,   /*  ¿㤤ʬθ濴Ĵֹ    */
                core_len,       /*  ͽ¬ȤĹ                  */
                top_core,       /*  ͽ¬ȤĹ                  */
                h_num,		/*  إåʬκݤΥإåʬܿ    */
                sur,		/*  إåʬܿǳäȤ;      */
                h_sur;		/*  ʬإåܤ;            */

        float   s_max[ML],      /*  ɽΰǤ¿                */
                s_min[ML],      /*  ɽΰǤ¿Ǿ                */
		cm_index[ML],
                init_value,     /*  ΰ濴뤿ν͡ʣ  */
                average,        /*  Ȥʿ¿                  */
                init_ave,
                sum,            /*  Ȥʿ¿ͤ뤿ѿ*/
                cut,            /*  濳ؿ                                */
                arg_exp,        /*  濳ؿEXP׻                     */
                soap7[ML],      /*  ưʿˡη׻̡ʣĴ            */
                soap_m7[ML],    /*  ưʿˡη׻̡ʣĴ            */
                soap9[ML];      /*  ưʿˡη׻̡ʣĴ            */


/*-----------------------------------------------------------------------------
|       ưʿˡη׻ʣĴ---> ¤ɸ뤿˻         |
------------------------------------------------------------------------------*/
        window = 4;
        soapmethod(     length,         /*  ĴĹ                            */
                        hpindex,        /*  K-D¿ɸ                     */
                        &window,        /*  ɥ                  */
                        &soap9);        /*  ưʿѷ                      */

/*-----------------------------------------------------------------------------
|       ưʿˡη׻ʣĴ                                            |
------------------------------------------------------------------------------*/
        for(i=0;i<(*length);i++) {
                        pred[0][i]=0;
                        pred[1][i]=0;
	}

        window = 3;
        soapmethod(length,hpindex,&window,&soap7);

        window = 3;
        soapmethod(length,m_hpindex,&window,&soap_m7);

        window = 3;
        calc_sh_index(length,&window,&soap9,&s_max,&s_min);


        for(i=0;i<(*length);i++) {

                if(s_max[i] >= 0. && s_min[i] >= 0.)
                        cm_index[i]=s_max[i]+s_min[i];
                if(s_max[i] > 0. && s_min[i] < 0.)
                        cm_index[i]=s_max[i]-s_min[i];
                if(s_max[i] <= 0. && s_min[i] <= 0.)
                        cm_index[i]=0.;

                if(cm_index[i] >= 1.15)
                        pred[0][i]=1;

        }

        for(i=8;i<(*length)-8;i++){
                k=0;
                for(j=i-8;j<=i+8;j++)
                {
                        if(pred[0][j]==1) k++;
                }

                if(k==(2*8+1))
                {
                        for(j=i-8;j<=i+8;j++)
                                pred[1][j]=1;
                }
        }


        i=0;
        while(i!=(*length))
        {
          k=0;
          if(pred[1][i]==1)
          {
            while(pred[1][i]!=0)
	     {
		k++;i++;
		if(i==(*length)) break;
	     }

            h_num = k/23;

           if(h_num>1)
           {
            for(j=1;j<h_num;j++)
            {
                sur = k - (23*h_num);
                h_sur = sur / (h_num-1);
                center = i-k+23*j+h_sur;

                init_value = 100.;

                for(m=center-h_sur;m<=center;m++)
                {
                   if(soap9[m] < init_value)
                    {
                        init_value = soap9[m];
                        final_center = m;
                    }
                 }

                for(m=final_center-2;m<=final_center+2;m++)
                        pred[1][m]=0;
             }
            }

           }
           else i++;
         }


        i=0;k=0;
        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             cm[k].start=i;
             while(pred[1][i]!=0)
	     {
		i++;
		if(i==(*length)) break;
	     }
             cm[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*cm_seg_num) = k;


        for(i=0;i<(*cm_seg_num);i++)
        {
           core_len = cm[i].end-cm[i].start+1;
           sum = 0.0;
           for(j=cm[i].start;j<=cm[i].end;j++)
               sum += soap7[j];
           average = sum / (1.*core_len);

           arg_exp = ((2.*8+1.)-1.0*core_len)/2.;
           cut = 0.6 + 0.9*exp(arg_exp);
           if(average < cut)
           {
             for(j=cm[i].start;j<=cm[i].end;j++)
                        pred[1][j]=0;
           }
        }

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             cm[k].start=i;
             while(pred[1][i]!=0)
	     {
		i++;
		if(i==(*length)) break;
	     }
             cm[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*cm_seg_num) = k;


        init_ave = 0.;

        for(i=0;i<(*cm_seg_num);i++)
        {
           core_len = cm[i].end-cm[i].start+1;
           sum = 0.0;
           for(j=cm[i].start;j<=cm[i].end;j++)
               sum += soap_m7[j];
           average = sum / (1.*core_len);

            arg_exp = ((2.*8+1.)-1.0*core_len)/2.0;
            cut = 1.4 + 0.4*exp(arg_exp);

              if(average < cut)
                {
                for(k=cm[i].start;k<=cm[i].end;k++)
                  pred[1][k] = 0;
                }


           if(average > init_ave) {init_ave = average; top_core = core_len;}

        }

        /*printf("%f %d",init_ave,top_core);*/

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             cm[k].start=i;
             while(pred[1][i]!=0)
	     {
		i++;
		if(i==(*length)) break;
	     }
             cm[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*cm_seg_num) = k;


/********
        arg_exp = ((2.*8+1.)-1.0*top_core)/2.0;
        cut = 1.4 + 0.4*exp(arg_exp);


        if(init_ave < cut) (*cm_seg_num) = 0;
*************/
            
        for(i=0;i<(*length);i++)
           cm_code[i]=pred[1][i];


}




void IdentifiedStructuralHelix(length,hpindex,m_hpindex,
				sh_code,sh_core_len,sh_ave,sh_seg_num,sh,sh_index,cm_code,
				SH_TO,SH_CORE_WIN,SH_CORE_AVE,A,ramda)
int	*length;		/*  ͡ĴĹ			      */
float	*hpindex;		/*  ͡K-Dɸ			      */
float	*m_hpindex;		/*  ͡K-Dɸ			      */
int	*sh_code;		/*  ֤͡ɡʣ		      */
int	*sh_core_len;
float	*sh_ave;
int	*sh_seg_num;		/*  ֤͡إåܿ		      */
struct	_sh_data	*sh;	/*  ֤͡إå		      */
float	*sh_index;		/*  ֤͡¤ɸ			      */
int	*cm_code;
float	*SH_TO;			/*  ͡⤵Τ		      */
int	*SH_CORE_WIN;		/*  ͡Ϣ³ĴΤ		      */
float	*SH_CORE_AVE;		/*  ͡ʿͤΤ		      */
float	*A;			/*  ͡濳ؿ		      */
float	*ramda;			/*  ͡濳ؿ 		      */
{
	int	i,j,k,m,
		window,		/*  ưʿˡκݤΥɥ	      */
		pred[2][ML],	/*  Ūͽ¬̤γǼ		      */
		center,		/*  ŪʥȤ濴Ĵֹ	      */
		final_center,	/*  ¿㤤ʬθ濴Ĵֹ    */
		core_len,	/*  ͽ¬ȤĹ		      */
		top_core,	/*  ͽ¬ȤĹ		      */
		h_num,
		sur,
		over_lap_sum,
		h_sur;
	float	s_max[ML],	/*  ɽΰǤ¿		      */
		s_min[ML],	/*  ɽΰǤ¿Ǿ                */
		init_value,	/*  ΰ濴뤿ν͡ʣ  */
		average,	/*  Ȥʿ¿		      */
		init_ave,
		sum,		/*  Ȥʿ¿ͤ뤿ѿ*/
		cut,		/*  濳ؿ				      */
		arg_exp,	/*  濳ؿEXP׻		      */
		soap7[ML],	/*  ưʿˡη׻̡ʣĴ	      */
		soap_m7[ML],	/*  ưʿˡη׻̡ʣĴ	      */
		soap9[ML];	/*  ưʿˡη׻̡ʣĴ            */


/*-----------------------------------------------------------------------------
|	ưʿˡη׻ʣĴ---> ¤ɸ뤿˻	      |
------------------------------------------------------------------------------*/
	window = 4;
	soapmethod(	length,		/*  ĴĹ			      */
			hpindex,	/*  K-D¿ɸ		      */
			&window,	/*  ɥ		      */
			&soap9);	/*  ưʿѷ		      */

/*-----------------------------------------------------------------------------
|	ưʿˡη׻ʣĴ					      |
------------------------------------------------------------------------------*/
	for(i=0;i<(*length);i++) {
		pred[0][i]=0;
		pred[1][i]=0;
	}


	window = 3; soapmethod(length,hpindex,&window,&soap7);

	window = 3; soapmethod(length,m_hpindex,&window,&soap_m7);

	window = 3; calc_sh_index(length,&window,&soap9,&s_max,&s_min);

	for(i=0;i<(*length);i++) {

		if(s_max[i] >= 0. && s_min[i] >= 0.)
			sh_index[i]=s_max[i]+s_min[i];
		if(s_max[i] > 0. && s_min[i] < 0.)
			sh_index[i]=s_max[i]-s_min[i];
		if(s_max[i] <= 0. && s_min[i] <= 0.)
			sh_index[i]=0.;

		if(sh_index[i] >= (*SH_TO))
			pred[0][i]=1;			

	}

	for(i=(*SH_CORE_WIN);i<(*length)-(*SH_CORE_WIN);i++){
		k=0;
		for(j=i-(*SH_CORE_WIN);j<=i+(*SH_CORE_WIN);j++)
		{
			if(pred[0][j]==1) k++;
		}

		if(k==(2*(*SH_CORE_WIN)+1))
		{
			for(j=i-(*SH_CORE_WIN);j<=i+(*SH_CORE_WIN);j++)
				pred[1][j]=1;
		}
	}


        i=0;
        while(i!=(*length))
        {
          k=0;
          if(pred[1][i]==1)
          {
            while(pred[1][i]!=0)
	    {
		k++;i++;
		if(i==(*length)) break;
	    }

	    h_num = k/23;
	
	   if(h_num>1)
	   {
	    for(j=1;j<h_num;j++)
	    {
	        sur = k - (23*h_num);
	        h_sur = sur / (h_num-1);
                center = i-k+23*j+h_sur;

                init_value = 100.;

                for(m=center-h_sur;m<=center;m++)
                {
                   if(soap9[m] < init_value)
                    {
                        init_value = soap9[m];
                        final_center = m;
                    }
                 }

                for(m=final_center-2;m<=final_center+2;m++)
                        pred[1][m]=0;
             }
            }

           }
           else i++;
         }


	i=0;k=0;
	while(i!=(*length))
	{
	  if(pred[1][i]==1)
	  {
	     sh[k].start=i;
	     while(pred[1][i]!=0)
	     {
		i++;
		if(i==(*length)) break;
	     }
	     sh[k].end=i-1;
             k++;
           }
	   else i++;
	}

	(*sh_seg_num) = k;

	for(i=0;i<(*sh_seg_num);i++){
	  over_lap_sum = 0;	
	    for(j=sh[i].start;j<=sh[i].end;j++)
		over_lap_sum = over_lap_sum + pred[1][j] + cm_code[j];
	    if(over_lap_sum > (sh[i].end-sh[i].start+1)){
	       for(j=sh[i].start;j<=sh[i].end;j++)
		  pred[1][j]=0;
	    }
	    if(cm_code[sh[i].start-1]==1) pred[1][sh[i].start]=0;
	    if(cm_code[sh[i].end+1]==1) pred[1][sh[i].end]=0;
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             sh[k].start=i;
             while(pred[1][i]!=0)
	     {
		i++;
		if(i==(*length)) break;
	     }
             sh[k].end=i-1;
             k++;
           }
           else i++;
        }


	for(i=0;i<(*sh_seg_num);i++)
        {
           core_len = sh[i].end-sh[i].start+1;
           sum = 0.0;
           for(j=sh[i].start;j<=sh[i].end;j++)
               sum += soap7[j];
           average = sum / (1.*core_len);

           for(j=sh[i].start;j<=sh[i].end;j++){
	   sh_core_len[j] = core_len;
	   sh_ave[j] = average;}

	   arg_exp = ((2.*(*SH_CORE_WIN)+1.)-1.0*core_len)/(*ramda);
	   cut = (*SH_CORE_AVE) + (*A)*exp(arg_exp);
           if(average < cut)
           {
             for(j=sh[i].start;j<=sh[i].end;j++)
                        pred[1][j]=0;
           }

        }


        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             sh[k].start=i;
             while(pred[1][i]!=0)
	     {
		i++;
		if(i==(*length)) break;
	     }
             sh[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*sh_seg_num) = k;


	for(i=0;i<(*length);i++)
	{
	   sh_code[i]=pred[1][i];
	}


}



/*=======================================================
void soapmethod(int *length,float *hpindex,int *window,float *average_hp)
=======================================================*/

void soapmethod(length,hpindex,window,average_hp)
int *length;
float *hpindex;
int *window;
float *average_hp;
{
        int     i,j;
        float  sum;

        sum = 0.;
        for(i=0;i<(*window);i++)
           sum += hpindex[i];

        for(i=0;i<(*window);i++)
           average_hp[i] = sum / (1.0*(*window));
 
        for(i=(*window);i<(*length)-(*window);i++){
           sum = 0.;
           for(j=i-(*window);j<=i+(*window);j++) 
                sum += hpindex[j];       
           average_hp[i] = sum / (2*(*window)+1);
        }

        sum = 0.;
        for(i=(*length)-(*window);i<(*length);i++)
           sum += hpindex[i];

        for(i=(*length)-(*window);i<(*length);i++)
           average_hp[i] = sum / (1.0*(*window));

}

/*=======================================================
void calc_sh_index( int *length, int *window, float *average_hp, 
			float *s_max, float *s_min)
=======================================================*/

void calc_sh_index(length,window,average_hp,s_max,s_min)
int *length;
int *window;
float *average_hp;
float *s_max;
float *s_min;
{
	int	i,j,k,l,m,s;
	float	min,t,
		sort[20];

        for(i=0;i<(*window);i++){
	   k=0;
           for(j=0;j<=i+(*window);j++){
		sort[k]=average_hp[j];
		k++;
	   }
	   for(l=0;l<k-1;l++){
	   	min = sort[l];
		s = l;
		for(m=l+1;m<k;m++){
		   if(sort[m]<min){
			min = sort[m];
			s = m;
		   }
		}
		t = sort[l]; sort[l]=sort[s]; sort[s]=t;
	   }
	   s_max[i]=sort[k-1]; s_min[i]=sort[0];
        }

        for(i=(*window);i<(*length)-(*window);i++){
	   k=0;
           for(j=i-(*window);j<=i+(*window);j++){
		sort[k]=average_hp[j];
		k++;
	   }
	   for(l=0;l<k-1;l++){
	   	min = sort[l];
		s = l;
		for(m=l+1;m<k;m++){
		   if(sort[m]<min){
			min = sort[m];
			s = m;
		   }
		}
		t = sort[l]; sort[l]=sort[s]; sort[s]=t;
	   }
	   s_max[i]=sort[k-1]; s_min[i]=sort[0];
        }


        for(i=(*length)-(*window);i<(*length);i++){
	   k=0;
           for(j=i-(*window);j<(*length);j++){
		sort[k]=average_hp[j];
		k++;
	   }
	   for(l=0;l<k-1;l++){
	   	min = sort[l];
		s = l;
		for(m=l+1;m<k;m++){
		   if(sort[m]<min){
			min = sort[m];
			s = m;
		   }
		}
		t = sort[l]; sort[l]=sort[s]; sort[s]=t;
	   }
	   s_max[i]=sort[k-1]; s_min[i]=sort[0];
        }

}
