/*=================================================================
   SOSUI: A Tool for Secondary Structure Prediction
   of Membrane Proteins based on Physicochemical Interactions
 
   Coded by Hirokawa, T. and Seah, B.C.
 
   Copyright(C)1996 Shigeki Mitaku
=================================================================*/
 
#include <stdio.h>
#include <math.h>

#define	VI_TO	1.10

/*=================================================================
   Define
=================================================================*/

#define ML  5000        /* Maximum of Amino Acid Length */
#define MH  50          /* Maximum of Helix */

struct _fh_data {          /* Information of Structural Helix */
        int     start;     /* Starting point of Structural Helix */
        int     end;       /* Endeing point of Structural Helix */
        int     center;    /* Center of Structural Helical Segment */
};

struct _vi_data {          /* Information of Structural Helix */
        int     start;     /* Starting point of Structural Helix */
        int     end;       /* Endeing point of Structural Helix */
        int     center;    /* Center of Structural Helical Segment */
};


void	soapmethod();

/*=================================================================
void IdentifiedFunctinalHelix(int *length,float *hpindex,int *sh_code, 
			int *sh_seg_num,struct _sh_data *sh)
=================================================================*/

IdentifiedFunctionalHelix(FH_CORE_WIN,FH_TO,SOAPWIN_NT,FH_CORE_AVE,
				length,hpindex,m_hpindex,charge_index,
				fh_seg_num,fh_code,fh_core_len,fh_ave,
				fh,sh_code,fh_index,B,ramda,cm_code)
int	*FH_CORE_WIN;
float	*FH_TO;
int	*SOAPWIN_NT;
float	*FH_CORE_AVE;
int	*length;
float	*hpindex;
float	*m_hpindex;
int	*charge_index;
int	*fh_seg_num;
int	*fh_code;
int	*fh_core_len;
float	*fh_ave;
struct _fh_data *fh;
int	*sh_code;
float	*fh_index;
float	*B;
float	*ramda;
int	*cm_code;
{

	int	i,j,k,m,
		window,
		pred[2][ML],
		center,final_center,
		core_len,
		over_lap_sum,
		h_num,
		sur,
		h_sur,
		afterstart,
		afterend;
	float	m_charge[ML],
		soap7[ML], 	/* Soap Calculation of Modified Hydropathy Index */
		soap[ML],	/* Soap Calculation of K-D Hydropathy Index */
		init_value,
		sum,
		init_ave,
		average_hp,
		cut,
		arg_exp;

	for(i=0;i<(*length);i++)
	{
		pred[0][i]=0;
		pred[1][i]=0;
	}


	window = 3;
	soapmethod(length,m_hpindex,&window,&soap7);
	soapmethod(length,hpindex,SOAPWIN_NT,&soap);

	for(i=0;i<(*length);i++)
	{
	  if(charge_index[i]==0)
	     m_charge[i] = (*FH_TO);
           else
	     m_charge[i] = 0.0;
	}


	for(i=0;i<(*length);i++)
	{
 	  if(soap7[i] > m_charge[i])
	     fh_index[i] = soap7[i];
	  else if((charge_index[i]==0) && (soap7[i] <= (*FH_TO)))
	     fh_index[i] = (*FH_TO);
	  else if((charge_index[i]!=0) && (soap7[i] >= (*FH_TO)))
	     fh_index[i] = soap7[i];
	  else
	     fh_index[i] = 0.;
	}


	for(i=0;i<(*length);i++)
	  if(fh_index[i] >= (*FH_TO)) pred[0][i]=1;	



	for(i=(*FH_CORE_WIN);i<(*length)-(*FH_CORE_WIN);i++)
	{
	  k = 0;
	  for(j=i-(*FH_CORE_WIN);j<=i+(*FH_CORE_WIN);j++)
	  {
	     if(pred[0][j]==1) k++;
   	  }

	   if(k==(2*(*FH_CORE_WIN)+1))
	   {
	     for(j=i-(*FH_CORE_WIN);j<=i+(*FH_CORE_WIN);j++)
	       pred[1][j]=1;
	   }
	}


        i=0;

        while(i!=(*length))
        {
          k=0;
          if(pred[1][i]==1)
          {
            while(pred[1][i]!=0)
		{
			k++;i++;
			if(i==(*length)) break;
		}

	    h_num = k/23;
	
	   if(h_num>1)
	   {
	    for(j=1;j<h_num;j++)
	    {
	        sur = k - (23*h_num);
	        h_sur = sur / (h_num-1);
                center = i-k+23*j+h_sur;

                init_value = 100.;

                for(m=center-h_sur;m<=center;m++)
                {
                   if(soap[m] < init_value)
                    {
                        init_value = soap[m];
                        final_center = m;
                    }
                 }

                for(m=final_center-2;m<=final_center+2;m++)
                        pred[1][m]=0;
             }
            }

           }
           else i++;
         }


        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             fh[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             fh[k].end=i-1;
             k++;
           }
           else i++;
        }
 

        (*fh_seg_num) = k;

	for(i=0;i<(*fh_seg_num);i++){
	  over_lap_sum = 0;	
	    for(j=fh[i].start;j<=fh[i].end;j++)
		over_lap_sum = over_lap_sum + pred[1][j] + cm_code[j];
	    if(over_lap_sum > (fh[i].end-fh[i].start+1)){
	       for(j=fh[i].start;j<=fh[i].end;j++)
		  pred[1][j]=0;
	    }
	    if(cm_code[fh[i].start-1]==1) pred[1][fh[i].start]=0;
	    if(cm_code[fh[i].end+1]==1) pred[1][fh[i].end]=0;
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             fh[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             fh[k].end=i-1;
             k++;
           }
           else i++;
        }
 

        (*fh_seg_num) = k;

	
	for(i=0;i<(*fh_seg_num);i++){
	  over_lap_sum = 0;	
	    for(j=fh[i].start;j<=fh[i].end;j++)
		over_lap_sum = over_lap_sum + pred[1][j] + sh_code[j];
	    if(over_lap_sum > (fh[i].end-fh[i].start+1)){
	       for(j=fh[i].start;j<=fh[i].end;j++)
		  pred[1][j]=0;
	    }
	    if(sh_code[fh[i].start-1]==1) pred[1][fh[i].start]=0;
	    if(sh_code[fh[i].end+1]==1) pred[1][fh[i].end]=0;
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             fh[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             fh[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*fh_seg_num) = k;



/*
	for(i=0;i<(*fh_seg_num);i++)
	{
	   core_len = fh[i].end-fh[i].start+1;
	   sum = 0.0;
           for(j=fh[i].start;j<=fh[i].end;j++)
	       sum += soap7[j];
	   average_hp = sum / (1.*core_len);

           for(j=fh[i].start;j<=fh[i].end;j++)
	   {
		fh_core_len[j]=core_len;
		fh_ave[j]=average_hp;
	   }
	}
*/


	for(i=0;i<(*fh_seg_num);i++)
	{
	   core_len = fh[i].end-fh[i].start+1;
	   sum = 0.0;
           for(j=fh[i].start;j<=fh[i].end;j++)
	       sum += soap7[j];
	   average_hp = sum / (1.*core_len);
	   arg_exp = ((2.*(*FH_CORE_WIN)+1.)-1.0*core_len)/(*ramda);
           cut = (*FH_CORE_AVE) + (*B)*exp(arg_exp);

	   if(average_hp < cut)
	   {
             for(j=fh[i].start;j<=fh[i].end;j++)
                        pred[1][j]=0;
	   }
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             fh[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             fh[k].end=i-1;
             k++;
           }
           else i++;
        }
 
        (*fh_seg_num) = k;


	for(i=0;i<(*length);i++)
	{
	   fh_code[i]=pred[1][i];
	}


}


IdentifiedVeryImportantHelix(FH_CORE_WIN,FH_TO,SOAPWIN_NT,FH_CORE_AVE,
				length,hpindex,m_hpindex,charge_index,
				vi_seg_num,vi_code,vi_core_len,vi_ave,
				vi,sh_code,vi_index,B,ramda,cm_code,fh_code)
int	*FH_CORE_WIN;
float	*FH_TO;
int	*SOAPWIN_NT;
float	*FH_CORE_AVE;
int	*length;
float	*hpindex;
float	*m_hpindex;
int	*charge_index;
int	*vi_seg_num;
int	*vi_code;
int	*vi_core_len;
float	*vi_ave;
struct _vi_data *vi;
int	*sh_code;
float	*vi_index;
float	*B;
float	*ramda;
int	*cm_code;
int	*fh_code;
{

	int	i,j,k,m,
		window,
		pred[2][ML],
		center,final_center,
		core_len,
		over_lap_sum,
		h_num,
		sur,
		h_sur,
		afterstart,
		afterend,
		mask_num,
		vi_center,
		mask_region[ML];
	float	m_charge[ML],
		soap7[ML], 	/* Soap Calculation of Modified Hydropathy Index */
		soap[ML],	/* Soap Calculation of K-D Hydropathy Index */
		init_value,
		sum,
		init_ave,
		average_hp,
		cut,
		arg_exp;

	for(i=0;i<(*length);i++)
	{
		pred[0][i]=0;
		pred[1][i]=0;
	}


	window = 3;
	soapmethod(length,m_hpindex,&window,&soap7);
	soapmethod(length,hpindex,SOAPWIN_NT,&soap);

	for(i=0;i<(*length);i++)
	{
	  if(charge_index[i]==0)
	     m_charge[i] = VI_TO;
           else
	     m_charge[i] = 0.0;
	}


	for(i=0;i<(*length);i++)
	{
 	  if(soap7[i] > m_charge[i])
	     vi_index[i] = soap7[i];
	  else if((charge_index[i]==0) && (soap7[i] <= VI_TO))
	     vi_index[i] = VI_TO;
	  else if((charge_index[i]!=0) && (soap7[i] >= VI_TO))
	     vi_index[i] = soap7[i];
	  else
	     vi_index[i] = 0.;
	}


	for(i=0;i<(*length);i++)
	{
	  if(vi_index[i] >= VI_TO)
		 pred[0][i]=1;
	}

	mask_num=0;

	for(i=1;i<(*length)-1;i++)
	{
	   if(pred[0][i-1]==1 && pred[0][i]==0 && pred[0][i+1]==1 
		&& charge_index[i]!=0)
	    {
		pred[0][i]=1;
		mask_region[mask_num]=i;
		mask_num++;
	    }
	}


	for(i=(*FH_CORE_WIN);i<(*length)-(*FH_CORE_WIN);i++)
	{
	  k = 0;
	  for(j=i-(*FH_CORE_WIN);j<=i+(*FH_CORE_WIN);j++)
	  {
	     if(pred[0][j]==1) k++;
   	  }

	   if(k==(2*(*FH_CORE_WIN)+1))
	   {
	     for(j=i-(*FH_CORE_WIN);j<=i+(*FH_CORE_WIN);j++)
	       pred[1][j]=1;
	   }
	}


        i=0;

        while(i!=(*length))
        {
          k=0;
          if(pred[1][i]==1)
          {
            while(pred[1][i]!=0)
		{
			k++;i++;
			if(i==(*length)) break;
		}

	    h_num = k/23;
	
	   if(h_num>1)
	   {
	    for(j=1;j<h_num;j++)
	    {
	        sur = k - (23*h_num);
	        h_sur = sur / (h_num-1);
                center = i-k+23*j+h_sur;

                init_value = 100.;

                for(m=center-h_sur;m<=center;m++)
                {
                   if(soap[m] < init_value)
                    {
                        init_value = soap[m];
                        final_center = m;
                    }
                 }

                for(m=final_center-2;m<=final_center+2;m++)
                        pred[1][m]=0;
             }
            }

           }
           else i++;
         }


        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             vi[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             vi[k].end=i-1;
             k++;
           }
           else i++;
        }
 

        (*vi_seg_num) = k;

	for(i=0;i<(*vi_seg_num);i++){
	  over_lap_sum = 0;	
	    for(j=vi[i].start;j<=vi[i].end;j++)
		over_lap_sum = over_lap_sum + pred[1][j] + cm_code[j];
	    if(over_lap_sum > (vi[i].end-vi[i].start+1)){
	       for(j=vi[i].start;j<=vi[i].end;j++)
		  pred[1][j]=0;
	    }
	    if(cm_code[vi[i].start-1]==1) pred[1][vi[i].start]=0;
	    if(cm_code[vi[i].end+1]==1) pred[1][vi[i].end]=0;
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             vi[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             vi[k].end=i-1;
             k++;
           }
           else i++;
        }
 

        (*vi_seg_num) = k;

	
	for(i=0;i<(*vi_seg_num);i++){
	  over_lap_sum = 0;	
	    for(j=vi[i].start;j<=vi[i].end;j++)
		over_lap_sum = over_lap_sum + pred[1][j] + sh_code[j];
	    if(over_lap_sum > (vi[i].end-vi[i].start+1)){
	       for(j=vi[i].start;j<=vi[i].end;j++)
		  pred[1][j]=0;
	    }
	    if(sh_code[vi[i].start-1]==1) pred[1][vi[i].start]=0;
	    if(sh_code[vi[i].end+1]==1) pred[1][vi[i].end]=0;
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             vi[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             vi[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*vi_seg_num) = k;

	for(i=0;i<(*vi_seg_num);i++){
	  over_lap_sum = 0;	
	    for(j=vi[i].start;j<=vi[i].end;j++)
		over_lap_sum = over_lap_sum + pred[1][j] + fh_code[j];
	    if(over_lap_sum > (vi[i].end-vi[i].start+1)){
	       for(j=vi[i].start;j<=vi[i].end;j++)
		  pred[1][j]=0;
	    }
	    if(fh_code[vi[i].start-1]==1) pred[1][vi[i].start]=0;
	    if(fh_code[vi[i].end+1]==1) pred[1][vi[i].end]=0;
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             vi[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             vi[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*vi_seg_num) = k;

	for(i=0;i<(*vi_seg_num);i++){
	  over_lap_sum = 0;	
          vi_center = vi[i].start+0.5*(vi[i].end-vi[i].start+1);

	  for(j=0;j<mask_num;j++){
                if((mask_region[j] >= (vi_center-6))
                && (mask_region[j] <= (vi_center+6)))
			over_lap_sum++;
	  }
	 if(over_lap_sum==0){
	       for(j=vi[i].start;j<=vi[i].end;j++)
		  pred[1][j]=0;
	    }

	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             vi[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             vi[k].end=i-1;
             k++;
           }
           else i++;
        }

        (*vi_seg_num) = k;

/*******

	for(i=0;i<(*vi_seg_num);i++)
	{
	   core_len = vi[i].end-vi[i].start+1;
	   sum = 0.0;
           for(j=vi[i].start;j<=vi[i].end;j++)
	       sum += soap7[j];
	   average_hp = sum / (1.*core_len);

           for(j=vi[i].start;j<=vi[i].end;j++)
	   {
		vi_core_len[j]=core_len;
		vi_ave[j]=average_hp;
	   }
	}
*******/


	for(i=0;i<(*vi_seg_num);i++)
	{
	   core_len = vi[i].end-vi[i].start+1;
	   sum = 0.0;
           for(j=vi[i].start;j<=vi[i].end;j++)
	       sum += soap7[j];
	   average_hp = sum / (1.*core_len);
	   arg_exp = ((2.*(*FH_CORE_WIN)+1.)-1.0*core_len)/17.5;
           cut = 1.0 + 0.6*exp(arg_exp);

	   if(average_hp < cut)
	   {
             for(j=vi[i].start;j<=vi[i].end;j++)
                        pred[1][j]=0;
	   }
	}

        i=0;k=0;

        while(i!=(*length))
        {
          if(pred[1][i]==1)
          {
             vi[k].start=i;
             while(pred[1][i]!=0)
		{
			i++;
			if(i==(*length)) break;
		}
             vi[k].end=i-1;
             k++;
           }
           else i++;
        }
 
        (*vi_seg_num) = k;

	for(i=0;i<(*length);i++)
	{
	   vi_code[i]=pred[1][i];
	}

}
