%  demo.cl .... Knowledge Base for demo
%  Copyright (C) 1996  Tokuyasu Kakuta, Makoto Haraguchi, Yoshiaki Okubo
animal=<object.
arms=<object.
bag=<object.
vehicle=<object.
ship=<object.
tank=<object.
ufo=<object.
mountain=<object.
elephant=<animal.
man=<animal.
cat=<animal.
gun=<arms.
bomb=<arms.
planet=<place.
mountain=<place.
country=<place.
park=<place.
bed=<place.
pocket=<place.
school=<place.
zoo=<place.
cinema=<place.
bank=<place.
store=<place.

rule(not_in(X:vehicle,Y:park),move(X,Z:place,Y)).

move(_:object,_:place,_:place):-true.

danger(X:object):-big(X),movable(X),in(X,Z:place),gather(Y:man,Z).
danger(X:arms):-have(A:man,X),in(A,Z:place),gather(Y:man,Z).

sorrowful(X:man):-love(X,Y:man),dead(Y).
sorrowful(X:man):-like(X,Y:animal),dead(Y).
sorrowful(X:man):-war(Y:country,_),in(X,Y).
sorrowful(X:man):-war(_,Y:country),in(X,Y).

war(X:country,Y:country):-invade(X:country,Y:country).
war(X:country,Y:country):-in(A:man,X),in(B:man,Y),attack(A,Y),attack(B,X).

accident(X:place):-earthquake(X).
accident(X:mountain):-eruption(X).

invade(X:country,Y:country):-in(A:man,X),move(A,X,Y),attack(A,Y).
invade(X:ufo,Y:planet):-attack(X,Y).

have(X:man,Y:object):-small(Y),in_hand(X,Y).
have(X:man,Y:object):-small(Y),on(X,Z:pocket),in(Z,Y).
have(X:man,Y:object):-small(Y),with(X,Z:bag),in(Z,Y).
have(X:man,Y:object):-big(X,Y),register(X,Y).
have(X:man,Y:place):-register(X,Y).

gather(X:man,Y:place):-rest(X,Y).
gather(_:man,Y:place):-pleasant(Y).
gather(_:man,Y:place):-convenience(Y).
gather(_:man,Y:place):-important(Y).

like(X:man,Y:objcet):-love(X,Y).

small(_:gun):-true.

pleasant(_:zoo):-true.
pleasant(_:cinema):-true.

important(_:bank):-true.
important(_:store):-true.
important(_:school):-true.

rest(_:man,_:park):-true.
rest(_:man,_:bed):-true.

big(_:tank):-true.
big(_:vehicle):-true.
big(_:elephant):-true.
big(_:ship):-true.
big(_:mountain):-true.

movable(_:tank):-true.
movable(_:vehicle):-true.
movable(_:ship):-true.
movable(_:animal):-true.
movable(_:ufo):-true.

cf([danger/1]).
rev_info(not_in,in).
