% Copyright (C) 1996   ͵

/*
	쿹Ÿ
*/

unpack_forest(F,T,N) :-
	(
	    now_option(one_tree), !,
	    unpack_forest0(F,T1,N,_)
	;
	    unpack_forest0(F,T1,N)
	),
	par(T1,T).

% ̤٤Ƥ unpack_forest 
unpack_forest0([],[],0) :- !.
unpack_forest0([F1|F2],[T1|T2],N) :-
        unpack(F1,T1,N1),
        unpack_forest0(F2,T2,N2),
        N is N1+N2.

% bigram 򤫤̤򸫤ơΰֹ⤤Τ unpack_forest 
unpack_forest0(F,T,N,S) :-
	now_option(a,2), !,
	unpack_forest1(F,T1,T2,N1,N2,S1,S2),
	T = [T1,T2].
unpack_forest0([],[],0,0) :- !.
unpack_forest0([F1|F2],T,N,S) :-
	unpack_forest0(F2,T2,N2,S2),
	unpack(F1,T1,N1,_,S1,'not_bunsetsu'),
	(
	    S1 > S2, !,
	    N is N1,
	    T = [T1],
	    S is S1
	;
	    S1 < S2, !,
	    N is N2,
	    T = T2,
	    S is S2
	;
	    N is N1+N2,
	    T = [T1|T2],
	    S is S1
	).

unpack_forest1([],[],[],0,0,0,0) :- !.
unpack_forest1([F1|F2],Tree1,Tree2,No1,No2,Score1,Score2) :-
	unpack_forest1(F2,T21,T22,N21,N22,S21,S22),
	unpack(F1,T1,N1,_,S1,'not_bunsetsu'),
	(
	    S1 > S21, !,
	    Tree1 = [T1],
	    Tree2 = T21,
	    No1 is N1,
	    No2 is N21,
	    Score1 is S1,
	    Score2 is S21
	;
	    S1 == S21, !,
	    Tree1 = [T1|T21],
	    Tree2 = T22,
	    No1 is N1+N21,
	    No2 is N22,
	    Score1 is S1,
	    Score2 is S22
	;
	    S1 < S21, S1 > S22, !,
	    Tree1 = T21,
	    Tree2 = [T1],
	    No1 is N21,
	    No2 is N1,
	    Score1 is S21,
	    Score2 is S1
	;
	    S1 == S22, !,
	    Tree1 = T21,
	    Tree2 = [T1|T22],
	    No1 is N21,
	    No2 is N1+N22,
	    Score1 is S21,
	    Score2 is S1
	;
	    Tree1 = T21,
	    Tree2 = T22,
	    No1 is N21,
	    No2 is N22,
	    Score1 is S21,
	    Score2 is S22
	).
	    
par(X,Y) :- par_dl(X,Y-[]).
par_dl([],X-X) :- !.
par_dl([X|Y],[Y|D]-D) :-
	number(X), !.
par_dl([X|Y],Z-W) :-
	par_dl(X,Z-D), par_dl(Y,D-W).

% ̤٤Ƥ unpack 
unpack([],[],0) :- !.
unpack([[X,Y]],Z,B) :-
	atom(Y), !,
	(
	    atom(X), !,
	    Z = [1,[X,Y]],
	    B is 1
	;
	    X = X1/X2, !,
	    unpack([[X1,Y]],Z1,B1),
	    append_org(Z1,[1,[X2,Y]],Z),
	    B is B1+1
	).
unpack([X|Y],Z,B) :-
        atom(X), !, unpack(Y,Y1,B),
        (
            B = 1, !,
            append_auto([0,X],Y1,Z)
        ;
            extend_tail([0,X],Y1,Z)
        ).
unpack(X/Y,Z,B) :- !,
        unpack(X,X1,BX),
        unpack(Y,Y1,BY),
        append_org(X1,Y1,Z),
        B is BX+BY.
unpack([X|Y],Z,B) :-
        (
            Y = [], !,
	    unpack(X,Z,B)
        ;
            unpack(Y,Y1,BY),
	    unpack(X,X1,BX),
            B is BX*BY,
            (
                BX = 1, BY = 1, !,
                append_auto(X1,Y1,Z)
            ;
                BX = 1, BY > 1, !,
                extend_tail(X1,Y1,Z)
            ;
                BX > 1, BY = 1, !,
                extend_top(X1,Y1,Z)
            ;
                extend(X1,Y1,Z)
            )
        ).

% bigram 򤫤ơΰֹ⤫äΤ unpack
unpack([],[],0,[],1.0,_) :- !.
unpack([P,[Q,R]],Z,B,H,S,_) :-
	atom(P), atom(Q), atom(R), !,
	unpack([[Q,R]],Y1,B,H1,S1,_),
	S is S1,
	(
	    B = 1, !,
	    append_auto([0,P],Y1,Z)
	;
	    extend_tail([0,P],Y1,Z)
	),
	H = H1.
unpack([[P,[Q,R]]],Z,B,H,S,_) :-
	atom(R), atom(Q), atom(P), !,
	unpack([[Q,R]],Y1,B,H1,S1,_),
	S is S1,
	(
	    B = 1, !,
	    append_auto([0,P],Y1,Z)
	;
	    extend_tail([0,P],Y1,Z)
	),
	H = H1.
unpack([[X,Y]],Z,B,H,1.0,_) :-
	atom(Y), !,
	(
	    atom(X), !,
	    Z = [1,[X,Y]],
	    B is 1,
	    H = [X]
	;
	    X = X1/X2, !,
	    unpack([[X1,Y]],Z1,B1,H1,_,_),
	    append_org(Z1,[1,[X2,Y]],Z),
	    B is B1+1,
	    slash_append(H1,[X2],H)
	).
unpack([X|Y],Z,B,H,S,Category) :-
	atom(X), !,
	(
	    (
		X = 'bunsetsu'
	    ;
		X = 'last_bunsetsu'
	    ), !,
	    unpack(Y,Y1,B,H1,S,'bunsetsu')
	;
	    Category = 'bunsetsu', !,
	    unpack(Y,Y1,B,H1,S,X)
	;
	    score(Category,X,Weight), !,
	    unpack(Y,Y1,B,H1,S1,'dummy'),
	    S is S1/Weight
	;
	    unpack(Y,Y1,B,H1,S,'dummy')
	),
	(
	    B = 1, !,
	    append_auto([0,X],Y1,Z)
	;
	    extend_tail([0,X],Y1,Z)
	),
	H = H1.
unpack(X/Y,Z,B,H,S,Category) :- !,
	(
	    Category = 'bunsetsu', !,
	    unpack(X,X1,BX,HX,SX,Category),
	    unpack(Y,Y1,BY,HY,SY,Category)
	;
	    score(Category,_,_), !,
	    unpack(X,X1,BX,HX,SX,Category),
	    unpack(Y,Y1,BY,HY,SY,Category)
	;
	    unpack(X,X1,BX,HX,SX,'dummy'),
	    unpack(Y,Y1,BY,HY,SY,'dummy')
	),
	(
	    SX > SY, !,
	    Z = X1,
	    B is BX,
	    H = HX,
	    S is SX
	;
	    SX < SY, !,
	    Z = Y1,
	    B is BY,
	    H = HY,
	    S is SY
	;
	    append_org(X1,Y1,Z),
	    B is BX+BY,
	    slash_append(HX,HY,H),
	    S is SX
	).
unpack([X|Y],Z,B,H,S,Category) :-
	unpack(X,X1,BX1,HX,SX,Category),
	(
	    Y = [], !,
	    B = BX1, Z = X1, H = HX, S is SX
	;
	    unpack(Y,Y1,_,HY,SY,'dummy'),
	    select_one(X1,X2,HX,_,SX,Y1,Y2,HY,_,SY,H,S),
	    (
		X2 = [NX|_],
		number(NX),
		BX is 1
	    ;
		length(X2,BX)
	    ),
	    (
		Y2 = [NY|_],
		number(NY),
		BY is 1
	    ;
		length(Y2,BY)
	    ),
	    B is BX*BY,
	    (
		BX = 1, BY = 1, !,
		append_auto(X2,Y2,Z)
	    ;
		BX = 1, BY > 1, !,
		extend_tail(X2,Y2,Z)
	    ;
		BX > 1, BY = 1, !,
		extend_top(X2,Y2,Z)
	    ;
		extend(X2,Y2,Z)
	    )
	).

select_one(X1,X2,HX1,HX2,SX,Y1,Y2,HY1,HY2,SY,H,S) :-
	(
	    (
		HX1 = _/_,
		reverse(X1,X1REV),
		(
		    HY1 = _/_,
		    reverse(Y1,Y1REV),
		    select_one0(X1REV,X2,HX1,HX2,Y1REV,Y2,HY1,HY2,S2)
		;
		    select_one0(X1REV,X2,HX1,HX2,Y1,Y2,HY1,HY2,S2)
		)
	    ;
		HY1 = _/_,
		reverse(Y1,Y1REV),
		select_one0(X1,X2,HX1,HX2,Y1REV,Y2,HY1,HY2,S2)
	    ),
	    unpack_append(HX2,HY2,H),
	    S is SX*SY*S2
	;
	    HY1 = [A2|_], !,
	    last(HX1,A1),
	    bigram(A1,A2,S2),
	    append(HX1,HY1,H),
	    S is SX*SY*S2,
	    X2 = X1,
	    HX2 = HX1,
	    Y2 = Y1,
	    HY2 = HY1
	;
	    H = HX1,
	    S is SX,
	    X2 = X1,
	    HX2 = HX1,
	    Y2 = Y1,
	    HY2 = HY1
	).

select_one0(X1,X2,HX1,HX2,Y1,Y2,HY1,HY2,S) :-
	now_option(best,2), !,
	select_two(X1,X21,X22,HX1,HX21,HX22,Y1,Y21,Y22,HY1,HY21,HY22,S,_),
	(
	    X22 = [], !,
	    (
		length(X21,1), !,
		[X2] = X21
	    ;
		X2 = X21
	    ),
	    HX2 = HX21
	;
	    X21 = X22, !,
	    (
		length(X21,1), !,
		[X2] = X21
	    ;
		X2 = X21
	    ),
	    HX2 = HX21
	;
	    append(X21,X22,X2),
	    slash_append(HX21,HX22,HX2)
	),
	(
	    Y22 = [], !,
	    (
		length(Y21,1), !,
		[Y2] = Y21
	    ;
		Y2 = Y21
	    ),
	    HY2 = HY21
	;
	    Y21 = Y22, !,
	    (
		length(Y21,1), !,
		[Y2] = Y21
	    ;
		Y2 = Y21
	    ),
	    HY2 = HY21
	;
	    append(Y21,Y22,Y2),
	    slash_append(HY21,HY22,HY2)
	).
	
select_one0([X1|X],X2,HX/HXLast,HX2,Y1,Y2,HY,HY2,S) :-
        select_one0(X1,X21,HXLast,HX21,Y1,Y21,HY,HY21,S1),
        select_one0(X,X22,HX,HX22,Y1,Y22,HY,HY22,S2),
        (
            S1 > S2, !,
            X2 = X21, HX2 = HX21, Y2 = Y21, HY2 = HY21,
            S is S1
        ;
            S1 < S2, !,
            X2 = X22, HX2 = HX22, Y2 = Y22, HY2 = HY22,
            S is S2
        ;
            (
		HX22 = _/_,
                append([X21],X22,X2)
            ;
                append([X21],[X22],X2)
            ),
	    slash_append(HX21,HX22,HX2),
	    Y2 = Y21, HY2 = HY21,   % 䤷...
            S is S1
        ).
select_one0(X1,X2,HX,HX2,[Y1|Y],Y2,HY/HYLast,HY2,S) :-
        select_one0(X1,X2,HX,HX2,Y1,Y21,HYLast,HY21,S1),
        select_one0(X1,X2,HX,HX2,Y,Y22,HY,HY22,S2),
        (
            S1 > S2, !,
            Y2 = Y21, HY2 = HY21,
            S is S1
        ;
            S1 < S2, !,
            Y2 = Y22, HY2 = HY22,
            S is S2
        ;
            (
                HY22 = _/_,
                append([Y21],Y22,Y2)
            ;
                append([Y21],[Y22],Y2)
            ),
	    slash_append(HY21,HY22,HY2),
            S is S1
        ).
select_one0([X1],X2,HX,HX2,Y1,Y2,HY,HY2,S) :-
        select_one0(X1,X2,HX,HX2,Y1,Y2,HY,HY2,S).
select_one0(X1,X2,HX,HX2,[Y1],Y2,HY,HY2,S) :-
        select_one0(X1,X2,HX,HX2,Y1,Y2,HY,HY2,S).
select_one0(X1,X1,HX,HX,Y1,Y1,HY,HY,S) :-
        last(HX,A1),
        HY = [A2|_],
        bigram(A1,A2,S).

select_two([X1|X],X21,X22,HX1/HXLast,HX21,HX22,Y1,Y21,Y22,HY1,HY21,HY22,S1,S2) :-
	select_two(X1,X211,X221,HXLast,HX211,HX221,Y1,Y211,Y221,HY1,HY211,HY221,S11,S21),
	select_two(X,X212,X222,HX1,HX212,HX222,Y1,Y212,Y222,HY1,HY212,HY222,S12,S22),
	(
	    S21 > S12, !,
	    X21 = [X211], X22 = X221,
	    HX21 = HX211, HX22 = HX221,
	    Y21 = Y211, Y22 = Y221,
	    HY21 = HY211, HY22 = HY221,
	    S1 is S11, S2 is S21
	;
	    S11 < S22, !,
	    X21 = X212, X22 = X222,
	    HX21 = HX212, HX22 = HX222,
	    Y21 = Y212, Y22 = Y222,
	    HY21 = HY212, HY22 = HY222,
	    S1 is S12, S2 is S22
	;
	    S11 > S12,
	    X21 = [X211], X22 = X212,
	    HX21 = HX211, HX22 = HX212,
	    Y21 = Y211, Y22 = Y212,
	    HY21 = HY211, HY22 = HY212,
	    S1 is S11, S2 is S12
	;
	    S12 > S11,
	    X21 = X212, X22 = [X211],
	    HX21 = HX212, HX22 = HX211,
	    Y21 = Y212, Y22 = Y211,
	    HY21 = HY212, HY22 = HY211,
	    S1 is S12, S2 is S11
	;
	    S11 == S12, !,
	    append([X211],X212,X21),
	    slash_append(HX211,HX212,HX21),
	    (
		S21 > S22, !,
		X22 = X221, HX22 = HX221,
		Y21 = Y211, Y22 = Y221,
		HY21 = HY211, HY22 = HY221,
		S1 is S11, S2 is S21
	    ;
		S22 > S21, !,
		X22 = X222, HX22 = HX222,
		Y21 = Y212, Y22 = Y222,
		HY21 = HY212, HY22 = HY222,
		S1 is S11, S2 is S22
	    ;
		S21 == S22, !,
		(
		    S21 > 0,
		    append([X221],X222,X22),
		    slash_append(HX221,HX222,HX22)
		;
		    X22 = X221, HX22 = HX221
		),
		Y21 = Y211, Y22 = Y221,
		HY21 = HY211, HY22 = HY221,
		S1 is S11, S2 is S21
	    )
	).
select_two(X1,X21,X22,HX1,HX21,HX22,[Y1|Y],Y21,Y22,HY1/HYLast,HY21,HY22,S1,S2) :-
	select_two(X1,X211,X221,HX1,HX211,HX221,Y1,Y211,Y221,HYLast,HY211,HY221,S11,S21),
	select_two(X1,X212,X222,HX1,HX212,HX222,Y,Y212,Y222,HY1,HY212,HY222,S12,S22),
	(
	    S21 > S12, !,
	    X21 = X211, X22 = X221,
	    HX21 = HX211, HX22 = HX221,
	    Y21 = [Y211], Y22 = Y221,
	    HY21 = HY211, HY22 = HY221,
	    S1 is S11, S2 is S21
	;
	    S11 < S22, !,
	    X21 = X212, X22 = X222,
	    HX21 = HX212, HX22 = HX222,
	    Y21 = Y212, Y22 = Y222,
	    HY21 = HY212, HY22 = HY222,
	    S1 is S12, S2 is S22
	;
	    S11 > S12,
	    X21 = X211, X22 = X212,
	    HX21 = HX211, HX22 = HX212,
	    Y21 = [Y211], Y22 = Y212,
	    HY21 = HY211, HY22 = HY212,
	    S1 is S11, S2 is S12
	;
	    S12 > S11,
	    X21 = X212, X22 = X211,
	    HX21 = HX212, HX22 = HX211,
	    Y21 = Y212, Y22 = [Y211],
	    HY21 = HY212, HY22 = HY211,
	    S1 is S12, S2 is S11
	;
	    S11 == S12, !,
	    append([Y211],Y212,Y21),
	    slash_append(HY211,HY212,HY21),
	    (
		S21 > S22, !,
		X21 = X211, X22 = X221,
		HX21 = HX211, HX22 = HX221,
		Y22 = Y221,HY22 = HY221,
		S1 is S11, S2 is S21
	    ;
		S22 > S21, !,
		X21 = X212, X22 = X222,
		HX21 = HX212, HX22 = HX222,
		Y22 = Y222, HY22 = HY222,
		S1 is S11, S2 is S22
	    ;
		S21 == S22, !,
		(
		    S21 > 0,
		    append([Y221],Y222,Y22),
		    slash_append(HY221,HY222,HY22)
		;
		    Y22 = Y221, HY22 = HY221
		),
		X21 = X211, X22 = X221,
		HX21 = HX211, HX22 = HX221,
		S1 is S11, S2 is S21
	    )
	).
select_two(X1,X1,[],HX,HX,[],Y1,Y1,[],HY,HY,[],S,0) :-
	last(HX,A1),
	HY = [A2|_],
	bigram(A1,A2,S).

unpack_append(HX21/HX22,HY2,H) :-
	unpack_append(HX21,HY2,H1),
	unpack_append(HX22,HY2,H2),
	slash_append(H1,H2,H).
unpack_append(HX2,HY21/HY22,H) :-
	unpack_append(HX2,HY21,H1),
	unpack_append(HX2,HY22,H2),
	slash_append(H1,H2,H).
unpack_append(HX2,HY2,H) :-
	append(HX2,HY2,H).

slash_append(X,Y1/Y2,Z) :- !,
	slash_append(X,Y1,Z1),
	Z = Z1/Y2.
slash_append(X,Y,X/Y) :- !.

member_(_,[]) :- fail, !.
member_(X,[X|_]) :- !.
member_(X,[Y|Z]) :-
	member_(X,Y); member_(X,Z).

extend_top(X,Y,Z) :-
	extend_top0(X,Y,Z1),
	after_append(Z1,Z).
extend_top0([],_,[]) :- !.
extend_top0([X1|X2],Y,Z) :-
	append_auto(X1,Y,Z1),
	(
	    X2 = [], !, Z = Z1
	;
	    extend_top0(X2,Y,Z2),
	    append_org(Z1,Z2,Z)
	).

extend(X,Y,Z) :-
	extend0(X,Y,Z1),
	after_append(Z1,Z).
extend0([],_,[]) :- !.
extend0([X1|X2],Y,[Z1|Z2]) :-
	extend_tail(X1,Y,Z1),
	extend0(X2,Y,Z2).

extend_tail(X,Y,Z) :-
	extend_tail0(X,Y,Z1),
	after_append(Z1,Z).
extend_tail0(_,[],[]) :- !.
extend_tail0(X,[Y1|Y2],Z) :-
	append_auto(X,Y1,Z1),
	(
	    Y2 = [], !, Z = Z1
	;
	    extend_tail0(X,Y2,Z2),
	    append_org(Z1,Z2,Z)
	).

append_auto(X,[],X) :- !.
append_auto([],Y,Y) :- !.
append_auto([A,B],[C,D],[E,Z]) :- !,
	(
	    A > 1, !, X = B, E = 2
	;
	    A = 1, X = [B], E = 2
	;
	    A = 0, X = [B], E = 1
	),
	(
	    C > 1, !, Y = D
	;
	    Y = [D]
	),
	append(X,Y,Z).

append_org(X,Y,Z) :-
	append([X],[Y],Z1),
	after_append(Z1,Z).

after_append(Z1,Z) :-
	after_append_dl(Z1,Z-[]).
after_append_dl([],X-X) :- !.
after_append_dl([A,B],[[A,B]|D]-D) :-
	number(A), !.
after_append_dl([X|Y],X1-Y1) :- 
	after_append_dl(X,X1-D),
	after_append_dl(Y,D-Y1).


%
% Ǥɽپط
%

% 쿹ǤŸ롣
seg_morph([],[]) :- !.
seg_morph([X|Y],Z) :- 
	(
	    abolish(bunsetsu_no)
	;
	    true
	),
	seg_morph0(X,top,XN),
	seg_morph(Y,YN),
	append(XN,YN,Z).
seg_morph0([],O,O) :- !.
seg_morph0(X,O,N) :-
	is_morph(X,XM), !,
	(
	    now_option(bunsetsu), !,
	    bunsetsu_no(B),
	    chain_morph1(XM,O,N,B)
	;
	    chain_morph(XM,O,N)
	).
seg_morph0(X,O,N) :- X = [_|A/B], !,
	seg_morph0(A,O,NA), seg_morph0(B,O,NB), append(NA,NB,N).
seg_morph0(X/Y,O,N) :- !,
	seg_morph0(X,O,NX), seg_morph0(Y,O,NY), append(NX,NY,N).
seg_morph0([T|X],O,N) :-
	atom(T), !,
	(
	    now_option(bunsetsu), !,
	    (
		T = 's1', !,
		(
		    retract(bunsetsu_no(B)),
		    B1 is B+1,
		    assert(bunsetsu_no(B1))
		;
		    assert(bunsetsu_no(1))
		)
	    ;
		true
	    ),
	    seg_morph0(X,O,N)
	;
	    seg_morph0(X,O,N)
	).
seg_morph0([X|Y],O,N) :- seg_morph0(X,O,NX), seg_morph0(Y,NX,N).

% Ǥ(ʣꤦ)ˤĤʤ롣
chain_morph(X,top,[[X]]) :- !.
chain_morph(_,[],[]) :- !.
chain_morph(X,[Y|Z],[XY]) :-
	Z = [], !,
	append(Y,[X],XY).
chain_morph(X,[Y|Z],W) :-
	append(Y,[X],XY), chain_morph(X,Z,XZ),
	append([XY],XZ,W).

chain_morph1(X,top,[[Y]],_) :-
	bunsetsu_no(_), !,
	(
	    X = [A,B], atom(A), atom(B), !,
	    Y = [[B],[A]]
	;
	    X = [A,[B,C]], atom(A), atom(B), atom(C), !,
	    Y = [[C],[[A],[B]]]
	).
chain_morph1(X,[[]],[[Y]],_) :-
	(
	    X = [A,B], atom(A), atom(B), !,
	    Y = [[B],[A]]
	;
	    X = [A,[B,C]], atom(A), atom(B), atom(C), !,
	    Y = [[C],[[A],[B]]]
	).
chain_morph1([X,Y],[[[H,S]|Z1]|Z2],W,B) :-
	Z2 = [], !,
	(
	    B = 1, !, Z1 = [], !,
	    (
		now_option(s), !,
		Y = [YA,YB],
		S = [SA,SB],
		append(H,[YB],H1),
		append(SA,[X],S11),
		append(SB,[YA],S12),
		S1 = [S11,S12]
	    ;
		append(H,[Y],H1),
		append(S,[X],S1)
	    ),
	    W = [[[H1,S1]]]
	;
	    B1 is B-1,
	    chain_morph1([X,Y],[Z1],[W1],B1),
	    W = [[[H,S]|W1]]
	).
chain_morph1(X,[Y|Z],W,B) :-
	chain_morph1(X,Z,XZ,B),
	append([Y],XZ,W).


% ڤǤ˶ڤäɽ롣
disp_morph(X) :-
	disp_morph0(X,0,C),
	write('Number of result = '), write(C), nl.
disp_morph0([],C,C) :- !, nl.
disp_morph0([X|Y],C1,C2) :-
	disp_word(X), nl,
	(
	    now_option(output), !,
	    tell('bunsetsu_result'),
	    nl,
	    tell('mslr_result'),
	    nl,
	    tell(user)
	;
	    true
	),
	C3 is C1+1, disp_morph0(Y,C3,C2).
disp_word([]) :- !.
disp_word([[A,B]|Y]) :-
	(
	    atom(A), atom(B), !,
	    write('('), write(B), write(' '), write(A), write(')'),
	    disp_word(Y)
	;
	    A = [_|_], B = [_|_], !,
	    disp_hyouki(A),
	    make_string(A,Word),
	    atom_chars(Word,Word2),
	    length(Word2,WL),
	    (
		30-WL > 0, !,
		TAB is 30-WL
	    ;
		TAB is 2
	    ),
	    tab(TAB),
	    (
		now_option(s),
		now_option(tango), !,
		B = [_,SAI],
		write(SAI)
	    ;
		write(B)
	    ),
	    nl,
	    (
		now_option(output), !,
		output_log(A,B)
	    ;
		true
	    ),
	    disp_word(Y)
	).
disp_word([[A,[B,C]]|Y]) :-
	(
	    atom(A), atom(B), atom(C), !,
	    write('('), write(C), write(' '),
	    write(A), write('('), write(B), write(')'), write(')'),
% ʻǤʤʻξɽ褦ˤ롣
% modified by ueki@cs.titech.ac.jp  on 16 Dec 1994
	    disp_word(Y)
	;
	    A = [_|_], B = [_|_], C = [_|_], !,
	    disp_hyouki(A),
	    make_string(A,Word),
	    atom_chars(Word,Word2),
	    length(Word2,WL),
	    (
		30-WL > 0, !,
		TAB is 30-WL
	    ;
		TAB is 2
	    ),
	    tab(TAB),
	    write('['),
	    disp_hinshi_saihinshi(B,C),
	    write(']'),nl,
	    (
		now_option(output), !,
		tell('bunsetsu_result'),
		write('('),
		disp_hyouki(A),
		write(' '),
		write(B),
		write(')'),
		tell(user)
	    ;
		true
	    ),
	    disp_word(Y)
	).

% ǤκǾñ
is_morph(X,Y) :-
	X = [A,[B,C]], atom(A), atom(B), atom(C), !,
	(
	    now_option(s), !,
	    Y = [A,[B,C]]
	;
	    Y = [A,C]
	).

% ʣꥹȤ
del_red(X,Y) :- del_red_dl(X,Y-[]).
del_red_dl([],X-X) :- !.
del_red_dl([X|Y],Z-W) :-
	del_red_dl(Y,Y1-W),
	(
	    member(X,Y1), !,
	    Z = Y1
	;
	    Z = [X|Y1]
	).

indep_min_morph(X,Y) :- indep_min_morph0(X,10000,[],Y).
indep_min_morph0([],_,X,X) :- !.
indep_min_morph0([X|Y],S,Z,W) :-
	score_of_tree(X,XS),
	(
	    XS < S, !, indep_min_morph0(Y,XS,[X],W)
	;
	    XS > S, !, indep_min_morph0(Y,S,Z,W)
	;
	    XS = S, !, append(Z,[X],ZX), indep_min_morph0(Y,S,ZX,W)
	).

score_of_morph([],0) :- !.
score_of_morph([X|Y],S) :-
	score_of_morph(Y,YS),
	X = [A,_],
	(
	    jiritsugo(A), !, S is YS + 1
	;
	    YS = S
	).

% ʻζ
prob(X,Y) :- prob_dl(X,_,Y-[]).
prob_dl([],0,X-X) :- !.
prob_dl([X|Y],S,Z-W) :-
	prob_dl(Y,YS,Y1-W),
	calc_prob(X,XS),
	(
	    XS > YS, !, Z = [X], S = XS
	;
	    XS < YS, !, Z = Y1, S = YS
	;
	    XS = YS, !, Z = [X|Y1], S = XS
	).
calc_prob(X,S) :-
	(
	    now_option(bunsetsu), !,
	    calc_prob1(X,1,S)
	;
	    calc_prob0(X,1,S)
	).

% ʻξ
calc_prob0([[_,[_,_]]],_,1.0) :- now_option(s), !.
calc_prob0([[A,[B,C]],[D,[E,F]]],OS,NS) :-
        now_option(s),
        atom(A), atom(B), atom(C),
        atom(D), atom(E), atom(F), !,
        (
%	    bigram(A,D,S), !, NS is OS*S     Ǥ bigram ʻΤ
		bigram(B,E,S), !, NS is OS*S     % äϺʻ bigram
% modified by ueki@cs.titech.ac.jp  on 25 Dec 1994
        ;
            NS = 0
        ).
calc_prob0([[A,[B,C]],[D,[E,F]]|X],OS,NS) :-
        now_option(s),
        atom(A), atom(B), atom(C),
        atom(D), atom(E), atom(F), !,
        (
%	    bigram(A,D,S1), !, S2 is OS*S1,  Ǥ bigram ʻΤ
		bigram(B,E,S1), !, S2 is OS*S1,  % äϺʻ bigram
% modified by ueki@cs.titech.ac.jp  on 25 Dec 1994
            calc_prob0([[D,[E,F]]|X],S2,NS)
        ;
            NS = 0
        ).

% ʻǤʤ
calc_prob0([[_,_]],_,1.0) :- !.
calc_prob0([[A,B],[C,D]],OS,NS) :-
        atom(A), atom(B), atom(C), atom(D), !,
        (
            bigram(A,C,S), !, NS is OS*S
        ;
            NS = 0
        ).
calc_prob0([[A,B],[C,D]|X],OS,NS) :-
        atom(A), atom(B), atom(C), atom(D), !,
        (
            bigram(A,C,S1), !, S2 is OS*S1,
            calc_prob0([[C,D]|X],S2,NS)
        ;
            NS = 0
        ).

% ʸᤴȤνϤξ
calc_prob1([[_,[_]]],_,1.0) :- !.
calc_prob1([[_,A]],OS,NS) :-
	A = [_|_], !,
	calc_prob12(A,OS,NS).
calc_prob1([[_,A]|B],OS,NS) :-
	A = [_|_], !,
	calc_prob11(A,B,OS,NS).

calc_prob11(H,[],OS,NS) :- !,
	calc_prob12(H,OS,NS).
calc_prob11(H,[[A,B]|X],OS,NS) :-
	A = [_|_], B = [_|_], !,
	append(H,B,H1),
	calc_prob11(H1,X,OS,NS).
calc_prob11(H,[[A,[B,C]]|X],OS,NS) :-
	A = [_|_], B = [_|_], C = [_|_], !,
	append(H,C,H1),
	calc_prob11(H1,X,OS,NS).

calc_prob12([_],_,1.0) :- !.
calc_prob12([A,B],OS,NS) :-
	atom(A), atom(B), !,
	(
	    bigram(A,B,S), !, NS is OS*S
	;
	    NS = 0
	).
calc_prob12([A,B|X],OS,NS) :-
	atom(A), atom(B), !,
	(
	    bigram(A,B,S1), !, S2 is OS*S1,
	    calc_prob12([B|X],S2,NS)
	;
	    NS = 0
	).

% ƱʻΤΤʸǾΤΤ
check_bunsetsu(X,Y) :-
	abolish(min_bunsetsu),
	check_bunsetsu0(X),
	collect_bunsetsu(Y).

% ʻμऴȤʸǾΤΤĤ
check_bunsetsu0([]) :- !.
check_bunsetsu0([X|Y]) :-
	check_bunsetsu0(Y),
	get_hinshi_bunsetsu(X,H1,B1),
	(
	    min_bunsetsu(A,H1,BMIN), !,
	    (
		B1 > BMIN, !
	    ;
		B1 < BMIN, !,
		retract(min_bunsetsu(A,H1,BMIN)),
		assert(min_bunsetsu([X],H1,B1))
	    ;
		retract(min_bunsetsu(A,H1,BMIN)),
		assert(min_bunsetsu([X|A],H1,BMIN))
	    )
	;
	    assert(min_bunsetsu([X],H1,B1))
	).

get_hinshi_bunsetsu([],[],0) :- !.
get_hinshi_bunsetsu([[_,Y]|Z],H,B) :-
	get_hinshi_bunsetsu(Z,H1,B1),
	append(Y,H1,H),
	B is B1+1.

% ʸǾΤΤΥꥹȤ
collect_bunsetsu(Y) :-
	(
	    retract(min_bunsetsu(A,_,_)), !,
	    collect_bunsetsu(Y1),
	    append(A,Y1,Y)
	;
	    Y = []
	).


get_bunsetsu(_,10000,[],0,0) :- !.
get_bunsetsu(H,B,[H,B|_],N,N) :- !.
get_bunsetsu(H,B,[_,_|X],N,NO) :-
	get_bunsetsu(H,B,X,N1,NO),
	N is N1+1.

change_bunsetsu(H,B,[],[H,B]) :- !.
change_bunsetsu(H,B,[H,_|X],[H,B|X]) :- !.
change_bunsetsu(H,B,[_,_|X],Y) :-
	change_bunsetsu(H,B,X,Y).

% 쿹ǤŸ줿ΤʸᤴȤˤޤȤ롣
make_bunsetsu([],[[[],[]]]) :- !.
make_bunsetsu([],[[[],[[],[]]]]) :- !.
make_bunsetsu([[H,W]|T],[[[W|W1],[H|H1]]]) :-
	make_bunsetsu(T,[[W1,H1]]).
make_bunsetsu([[H,[S,W]]|T],[[[W|W1],[[H|H1],[S|S1]]]]) :-
	make_bunsetsu(T,[[W1,[H1,S1]]]).

% ʸᤴȤɽϢ³ɽ롣
disp_hyouki([]) :- !.
disp_hyouki([A|B]) :-
	write(A),
	disp_hyouki(B).

% ʸᤴȤʻȺʻޡɽ롣
disp_hinshi_saihinshi([],[]) :- !.
disp_hinshi_saihinshi([A1,B1|C1],[A2,B2|C2]) :-
	write(A1), write('('), write(A2), write(')'), write(' '),
	disp_hinshi_saihinshi([B1|C1],[B2|C2]).
disp_hinshi_saihinshi([A1|B1],[A2|B2]) :-
	write(A1), write('('), write(A2), write(')'),
	disp_hinshi_saihinshi(B1,B2).

% log file ˷̤񤭽Ф
output_log(Hyouki, Hinshi) :-
	tell('bunsetsu_result'),
	write('('),disp_hyouki(Hyouki),write(' '),
	(
	    now_option(s),
	    now_option(tango), !,
	    Hinshi = [_,SAI],
	    write(SAI)
	;
	    write(Hinshi)
	),
	write(')'),
	tell('mslr_result'),
	output_log0(Hyouki,Hinshi),
	tell(user).
output_log0([],[]) :- !.
output_log0([],[[],[]]) :- !.
output_log0([Word|Hyouki], [[POS|Hinshi],[SAI|SaiHinshi]]) :-
	now_option(s), !,
	write('('),write(Word),write(','),
	(
	    now_option(tango), !,
	    write(SAI)
	;
	    write(POS),write('('),write(SAI),write(')')
	),
	write(')'),
	output_log0(Hyouki,[Hinshi,SaiHinshi]).
output_log0([Word|Hyouki], [POS|Hinshi]) :-
	write('('),write(Word),write(','),write(POS),write(')'),
	output_log0(Hyouki,Hinshi).
