% Copyright (C) 1996   ͵

calc_tree([],_,_,_,0,0) :- !.
calc_tree([F1|Forests],N,Base,OrigFile,MaxX,MaxY) :-
	MinY is 30,
	calc_var(F1,MinY,MaxY1,MaxL), !,
	MinX is (MaxL//2 +1)*8,
	(
	    MinX < 50, !,
	    MinX1 is 50
	;
	    MinX1 is MinX
	),
	make_string(['/tmp/',Base,N],File),
	abolish(current_tree),
	assert(current_tree(N)),
	tell(File),
	calc_data(F1,MinX1,MinY,MaxX1,MaxY1,MaxL,_,Base,File,0,_,_,_),
	told,
	tell(OrigFile),
	N1 is N+1,
	calc_tree(Forests,N1,Base,OrigFile,MaxX2,MaxY2),
	(
	    MaxX1 > MaxX2, !,
	    MaxX is MaxX1
	;
	    MaxX is MaxX2
	),
	(
	    MaxY1 > MaxY2, !,
	    MaxY is MaxY1
	;
	    MaxY is MaxY2
	).

calc_var([],Y,Y,0) :- !.
calc_var([A,B],MinY,MaxY,MaxL) :-
	atom(B), !,
	(
	    atom(A),
	    atom_chars(A,AC),
	    length(AC,AL)
	;
	    A = _/_,
	    AL is 5
	),
	MaxY is MinY+50,
	atom_chars(B,BC),
	length(BC,BL),
	(
	    AL > BL, !,
	    MaxL is AL
	;
	    MaxL is BL
	).
calc_var([H|T],MinY,MaxY,MaxL) :-
	atom(H), !,
	MinY1 is MinY+50,
	calc_var(T,MinY1,MaxY,MaxL1),
	atom_chars(H,HC),
	length(HC,HL),
	(
	    HL > MaxL1, !,
	    MaxL is HL
	;
	    MaxL is MaxL1
	).
calc_var([H|T],MinY,MaxY,MaxL) :-
	(
	    T = [], !,
	    calc_var(H,MinY,MaxY,MaxL)
	;
	    calc_var(H,MinY,MaxY1,MaxL1),
	    calc_var(T,MinY,MaxY2,MaxL2),
	    (
		MaxY1 > MaxY2, !,
		MaxY is MaxY1
	    ;
		MaxY is MaxY2
	    ),
	    (
		MaxL1 > MaxL2, !,
		MaxL is MaxL1
	    ;
		MaxL is MaxL2
	    )
	).
calc_var(H/T,MinY,MaxY,MaxL) :-
	calc_var(T,MinY,MaxY1,MaxL1),
	calc_var(H,MinY,MaxY2,MaxL2),
	(
	    MaxY1 > MaxY2, !,
	    MaxY is MaxY1
	;
	    MaxY is MaxY2
	),
	(
	    MaxL1 > MaxL2, !,
	    MaxL is MaxL1
	;
	    MaxL is MaxL2
	).



calc_data([],_,_,_,_,_,_,_,_,Ambig,Ambig,0,'') :- !.
calc_data([A,B],MinX,MinY,MinX,MaxY,_,List,
	        Base,File,Ambig1,Ambig2,Select,Tag) :-
	atom(B), !,
	(
	    atom(A),
	    Ambig2 is Ambig1, Select is 0, Tag = '',
	    List = [[MinX,MinY]],
	    write('text '),write(MinX),write(' '),write(MinY),write(' '),
	    write('-text <'),write(A),write('> -anchor center'),nl
	;
	    A = _/_,
	    Select is 1,
	    write('_'),
	    calc_data0(A,MinX,MinY,MinX,MaxY,_,List,
	               Base,File,Ambig1,Ambig2,Tag), nl
	), !,
	Y1 is MinY+8, Y2 is MaxY-8,
	(
	    Select == 1, !,
	    true
	;
	    write('line '),write(MinX),write(' '),write(Y1),write(' '),
	    write(MinX),write(' '),write(Y2),nl
	),
	write('text '),write(MinX),write(' '),write(MaxY),write(' '),
	write('-text '),write(B),write(' -anchor center'),nl.
calc_data([H|T],MinX,MinY,MaxX1,MaxY,MaxL,[[X,MinY]],
	        Base,File,Ambig1,Ambig2,S,'') :-
	atom(H), !,
	MinY1 is MinY+50,
	calc_data(T,MinX,MinY1,MaxX1,MaxY,MaxL,Child,
	          Base,File,Ambig1,Ambig2,S1,Tag),
	calc_x(CMinX,CMaxX,Child),
	X is (CMinX+CMaxX)//2 + (CMinX+CMaxX) mod 2,
	(
	    S1 == 1, !,
	    true
	;
	    make_line(X,MinY,0,8,Child)
	),
	write('text '),write(X),write(' '),write(MinY),write(' '),
	write('-text <'),write(H),write('> -anchor center'),
	(
	    S1 == 1, !,
	    write(' -fill red -tag _'),write(Tag)
	;
	    true
	), nl,
	S is 0.
calc_data([H|T],MinX,MinY,MaxX,MaxY,MaxL,List,Base,File,Ambig1,Ambig3,S,Tag) :-
	(
	    T = [], !,
	    calc_data(H,MinX,MinY,MaxX,MaxY,MaxL,List,
	              Base,File,Ambig1,Ambig3,S,Tag)
	;
	    calc_data(H,MinX,MinY,MaxX1,MaxY,MaxL,L1,
	              Base,File,Ambig1,Ambig2,S1,Tag1),
	    MinX2 is MaxX1+MaxL*8+5,
	    calc_data(T,MinX2,MinY,MaxX2,MaxY,MaxL,L2,
	              Base,File,Ambig2,Ambig3,S2,Tag2),
	    append(L1,L2,List),
	    MaxX is MaxX2,
	    (
		S1 == 1, !, S is 1, Tag = Tag1
	    ;
		S2 == 1, !, S is 1, Tag = Tag2
	    ;
		S is 0, Tag = ''
	    )
	).
calc_data(H/T,MinX,MinY,MaxX,MaxY,MaxL,List,Base,File,Ambig1,Ambig2,1,Tag) :-
	write('_'),
	calc_data0(H/T,MinX,MinY,MaxX,MaxY,MaxL,List,
	           Base,File,Ambig1,Ambig2,Tag),
	nl.

calc_data0(A,MinX,MinY,MinX,MaxY,_,[[MinX,MinY]],
	   Base,File,Ambig1,Ambig2,Tag) :-
	atom(A), !,
	write('part'),write(Ambig1),
	Ambig2 is Ambig1+1,
	make_string(['part',Ambig1],Tag),
	current_tree(N),
	make_string(['/tmp/',Base,N,'_',Tag],File2),
	tell(File2),
	write('text '),write(MinX),write(' '),write(MinY),write(' '),
	write('-text <'),write(A),write('> -anchor center'),nl,
	Y1 is MinY+8, Y2 is MaxY-8,
	write('line '),write(MinX),write(' '),write(Y1),write(' '),
	write(MinX),write(' '),write(Y2),nl,
	Y3 is MinY-8, Y4 is MinY-50+8,
	write('line '),write(MinX),write(' '),write(Y3),write(' '),
	write(MinX),write(' '),write(Y4),nl,
	told,
	tell(File).
calc_data0(A/B,MinX,MinY,MaxX,MaxY,MaxL,List,Base,File,Ambig1,Ambig3,Tag) :-
	calc_data0(A,MinX,MinY,MaxX1,MaxY,MaxL,L1,
	           Base,File,Ambig1,Ambig2,T1),
	calc_data0(B,MinX,MinY,MaxX2,MaxY,MaxL,L2,
	           Base,File,Ambig2,Ambig3,T2),
	make_string([T1,T2],Tag),
	append(L1,L2,List),
	(
	    MaxX1 > MaxX2, !,
	    MaxX is MaxX1
	;
	    MaxX is MaxX2
	).
calc_data0(A,MinX,MinY,MaxX,MaxY,MaxL,List,Base,File,Ambig1,Ambig3,Tag) :-
	write('part'),write(Ambig1),
	make_string(['part',Ambig1],Tag),
	current_tree(N),
	make_string(['/tmp/',Base,N,'_',Tag],File2),
	tell(File2),
	Ambig2 is Ambig1+1,
	calc_data(A,MinX,MinY,MaxX,MaxY,MaxL,List,
	          Base,File2,Ambig2,Ambig3,S,T),
	calc_x(CMinX,CMaxX,List),
	X is (CMinX+CMaxX)//2 + (CMinX+CMaxX) mod 2,
	MinY1 is MinY-50,
	make_line(X,MinY1,0,8,List),
	told,
	tell(File).

make_line(_,_,_,_,[]) :- !.
make_line(X,Y,X_wid,Y_wid,[CX,CY]) :-
	number(CX), number(CY), !,
	X1 is X+X_wid, CX1 is CX-X_wid,
	Y1 is Y+Y_wid, CY1 is CY-Y_wid,
	write('line '),write(X1),write(' '),write(Y1),write(' '),
	write(CX1),write(' '),write(CY1),nl.
make_line(X,Y,X_wid,Y_wid,[C1|Child]) :-
	make_line(X,Y,X_wid,Y_wid,C1),
	make_line(X,Y,X_wid,Y_wid,Child).

calc_x(X,X,[[X,_]]) :- !.
calc_x(MinX,MaxX,[[X,_]|Child]) :-
	calc_x(MinX1,MaxX1,Child),
	(
	    X < MinX1, !,
	    MinX is X
	;
	    MinX is MinX1
	),
	(
	    X > MaxX1, !,
	    MaxX is X
	;
	    MaxX is MaxX1
	).

xdisp_tree(No) :-
	number(No), !,
	(
	    x_is(open),
	    plsys(shell('touch /tmp/input')),
	    plsys(shell('rm -f /tmp/input /tmp/result /tmp/tree* /tmp/part* /tmp/node*'))
	;
	    xopen
	), !,
	input_sentence(No,S),
	tell('/tmp/input'),write(S),write('.'),told,
	tree_data(No,Trees,Forest),
	length(Trees,TreeL),
	write('calculating tree data ... '),
	calc_tree(Forest,0,'tree','user',_,_),
	current_tree(TreeNo),
	MaxTreeNo is TreeNo+1,
	make_string(['set max_tree_no ',MaxTreeNo],SetL),
	tcl_eval(SetL),
	write('done.'),nl,
	xdisp_input,
	write('drawing tree data ... '),
	tcl_eval('disp_tree new'),
	write('done.'),nl.

xdisp_sentence(Win) :-
	abolish(current_no),
	assert(current_no(0)),
	repeat,
	xdisp_sentence1(Win,State),
	(
	    State = false
	;
	    gc, fail
	).
xdisp_sentence1(Win,State) :-
	retract(current_no(N)),
	(
	    now_option(debug), !,
            (
                N == 0,
                N1 is 1
            ;
                N1 is N+2
            )
        ;
            N1 is N+1
        ),
        assert(current_no(N1)),
        (
            (
                input_sentence(N1, S),
		make_string([Win,' insert end ',S],Ins),
		tcl_eval(Ins), !,
                State = success
            ;
                fail
            )
        ;
            State = false
        ).
