% Copyright (C) 1996  ƣ    ͵

/*
	msLRΥåXWindowɽ
 
			 by A.Fujii 1994 May
		modified by ueki    1995 Oct
*/ 


:- prolog_flag(single_var_warnings,_,off).
:- unknown(_,fail).


% ɡץ
xopen :- 
	(
	    x_is(open), !
	;
	    tk([]), tcl_eval('source xmslr.tk'),
	    abolish(x_is), assert(x_is(open)),
	    plsys(shell('touch /tmp/input'))
	).

% ɡ
xclose :- tcl_eval('catch {destroy .}'),
	abolish(x_is), assert(x_is(not_open)),
	plsys(shell('touch /tmp/input')),
	plsys(shell('rm -f /tmp/input /tmp/result /tmp/tree* /tmp/part* /tmp/node* /tmp/stage* /tmp/ptree*')).


% X  stack  trace ɽ
xtrace(No) :-
	number(No), !,
	(
	    x_is(open),
	    plsys(shell('touch /tmp/input')),
	    plsys(shell('rm -f /tmp/input /tmp/result /tmp/tree* /tmp/part* /tmp/node*'))
	;
	    xopen
	), !,
	input_sentence(No,S),
	tell('/tmp/input'),write(S),write('.'),told,
	tree_data(No,Trees,Forest),
	write('calculating tree data ... '),
	calc_tree(Forest,0,'tree','user',_,_),
	current_tree(TreeNo),
	MaxTreeNo is TreeNo+1,
	make_string(['set max_tree_no ',MaxTreeNo],SetL),
	tcl_eval(SetL),
	write('done.'),nl,
	stack_data(No,Stack),
	write('calculating stack data ... '),nl,
	stack_init(Stack),
	write('done.'),nl,
	max_node(MaxNode),
	make_string(['/tmp/node',MaxNode],File),
	tell(File),
	result_data(No,Result),
	write_morph(Result),
	told,
	make_string(['set max_node ',MaxNode],SetMax),
	tcl_eval(SetMax),
	write('drawing tree data ... '),
	tcl_eval('disp_tree new'),
	write('done.'),nl.

%
% msLR¦ƤӽФ(åSϤ)
%
stack_init(S) :-
	var_init,
	xdisp_input,
	calc_node(S),
	abolish(node_history),
	tcl_eval('eraser'),
	stage_num(N),
	N1 is N-1,
	make_string(['set max_stage ',N1],Set),
	tcl_eval(Set),
	write('drawing stack data ... '),
	tcl_eval('disp_stack first').

calc_node([]) :- !.
calc_node([S|SList]) :-
	calc_node0(S),
	retract(stage_num(N)),
	N1 is N+1,
	assert(stage_num(N1)),
	calc_node(SList).
calc_node0([S|SList]) :-
	S = [N|_],
	number(N), !,
	calc_longest_stack([S|SList],MaxL),
	stage_num(Stage),
	make_string(['/tmp/stage',Stage],File),
	tell(File),
	MinX is 30, MinY is 30,
	calc_node1([S|SList],MinX,MinY,MaxL,File),
	told.
calc_node0([S]) :-
	stage_num(Stage),
	make_string(['/tmp/stage',Stage],File),
	tell(File),
	write('text 30 30 -text 0'),nl,
	write('oval 15 15 45 45'),nl,
	write('line 45 30 85 30'),nl,
	retract(max_node(N)),
	NodeNo is N+1,
	assert(max_node(NodeNo)),
	assert(node_history(NodeNo,S)),
	write('rectangle 85 15 115 45 -tag node'),write(NodeNo),nl,
	write('text 100 30 -text '),write(NodeNo),write(' -tag text'),nl,
	write('line 115 30 155 30'),nl,
	write('text 170 30 -text 1040'),nl,
	write('oval 155 15 185 45'),nl,
	told.

% 1 stage ʬ stack η׻
calc_node1([],_,_,_,_) :- !.
calc_node1([[0]],MinX,MinY,_,_) :-
	write('text '),write(MinX),write(' '),write(MinY),
	write(' -text 0'),nl,
	L is MinX-15, R is MinX+15, T is MinY-15, B is MinY+15,
	write('oval '),write(L),write(' '),write(T),write(' '),
	write(R),write(' '),write(B),nl.
calc_node1([S|SList],MinX,MinY,MaxL,File) :-
	S = [Top|List],
	number(Top), !,
	calc_node2(List,MinX,MinY,MaxX,MaxY,MaxL,File,_),
	MaxX1 is (MaxL-1)*70+30,
	write('text '),write(MaxX1),write(' '),write(MinY),
	write(' -text '),write(Top),nl,
	L is MaxX1-15, R is MaxX1+15, T is MinY-15, B is MinY+15,
	write('oval '),write(L),write(' '),write(T),write(' '),
	write(R),write(' '),write(B),nl,
	LL is MaxX-70+15, LR is MaxX1-15,
	write('line '),write(LL),write(' '),write(MinY),write(' '),
	write(LR),write(' '),write(MinY),nl,
	MinY1 is MaxY+70,
	calc_node1(SList,MinX,MinY1,MaxL,File).
% stack  1 item Ȥη׻
calc_node2([],_,_,_,_,_,_,[]) :- !.
calc_node2([0],MinX,MinY,MaxX,MinY,MaxL,File,[[MinX,MinY]]) :-
	(
	    MinY == 30, !,
	    write('text '),write(MinX),write(' '),write(MinY),
	    write(' -text 0'),nl,
	    L is MinX-15, R is MinX+15, T is MinY-15, B is MinY+15,
	    write('oval '),write(L),write(' '),write(T),write(' '),
	    write(R),write(' '),write(B),nl
	;
	    X is MinX+15,
	    make_line(X,MinY,0,0,[[X,30]])
	),
	MaxX is MinX+70.
calc_node2([Top|List],MinX,MinY,MaxX,MaxY,MaxL,File,[[MaxX1,MinY]]) :-
	number(Top), !,
	calc_node2(List,MinX,MinY,MaxX1,MaxY,MaxL,File,Child),
	write('text '),write(MaxX1),write(' '),write(MinY),
	write(' -text '),write(Top),nl,
	L is MaxX1-15, R is MaxX1+15, T is MinY-15, B is MinY+15,
	write('oval '),write(L),write(' '),write(T),write(' '),
	write(R),write(' '),write(B),nl,
	length(Child,CL),
	(
	    CL == 1, !,
	    make_line(MaxX1,MinY,-15,0,Child)
	;
	    make_line_para(MaxX1,MinY,-15,0,Child,C_MaxY),
	    X is MaxX1-15,
	    make_line(X,MinY,0,0,[[X,C_MaxY]])
	),
	MaxX is MaxX1+70.
calc_node2([Top|List],MinX,MinY,MaxX,MaxY,MaxL,File,[[MaxX1,MinY]]) :-
	calc_node2(List,MinX,MinY,MaxX1,MaxY,MaxL,File,Child),
	(
	    node_history(NodeNo,Top)
	;
	    retract(max_node(N)),
	    NodeNo is N+1,
	    assert(max_node(NodeNo)),
	    assert(node_history(NodeNo,Top)),
	    calc_tree(Top,NodeNo,'tree0_node',File,_,_),
	    node_info(Top,NodeNo,File)
	),!,
	L is MaxX1-15, R is MaxX1+15, T is MinY-15, B is MinY+15,
	write('rectangle '),write(L),write(' '),write(T),write(' '),
	write(R),write(' '),write(B),write(' -tag node'),write(NodeNo),nl,
	write('text '),write(MaxX1),write(' '),write(MinY),
	write(' -text '),write(NodeNo),write(' -tag text'),nl,
	length(Child,CL),
	(
	    CL == 1, !,
	    make_line(MaxX1,MinY,-15,0,Child)
	;
	    make_line_para(MaxX1,MinY,-15,0,Child,C_MaxY),
	    X is MaxX1-15,
	    make_line(X,MinY,0,0,[[X,C_MaxY]])
	),
	MaxX is MaxX1+70.
calc_node2(List/Tail,MinX,MinY,MaxX,MaxY,MaxL,File,Child) :-
	calc_node2(Tail,MinX,MinY,MaxX1,MaxY1,MaxL,File,Child1),
	MinY1 is MaxY1+70,
	calc_node2(List,MinX,MinY1,MaxX2,MaxY,MaxL,File,Child2),
	(
	    MaxX1 > MaxX2, !,
	    MaxX is MaxX1
	;
	    MaxX is MaxX2
	),
	append(Child1,Child2,Child).

make_line_para(_,_,_,_,[],0) :- !.
make_line_para(X,Y,X_wid,Y_wid,[[X1,Y1]|Child],MaxY) :-
	make_line(X,Y1,X_wid,Y_wid,[[X1,Y1]]),
	make_line_para(X,Y,X_wid,Y_wid,Child,MaxY1),
	(
	    Y1 > MaxY1, !,
	    MaxY is Y1
	;
	    MaxY is MaxY1
	).

node_info(X,N,File) :-
	make_string(['/tmp/node',N],File2),
	tell(File2),
	X = [[Sym|_]],
	write(N),
	name(N,NList),
	length(NList,NL),
	Gap1 is (4-NL)*2,
	tab(Gap1),
	write(Sym),
	name(Sym,SymList),
	length(SymList,SymL),
	Gap2 is (10-SymL)*2,
	tab(Gap2),
	node_info0(X,Words),
	write(Words),
	told,
	tell(File).
node_info0([],'') :- !.
node_info0([A,B],Words) :-
	(
	    atom(A)
	;
	    A = _/_
	),
	(
	    atom(B), !,
	    Words = B
	;
	    node_info0(B,Words)
	).
node_info0([A|B],Words) :-
	(
	    atom(A), !,
	    W1 = ''
	;
	    node_info0(A,W1)
	),
	node_info0(B,W2),
	make_string([W1,W2],Words).
node_info0(A/B,Words) :-
	node_info0(B,Words).




calc_longest_stack([],0) :- !.
calc_longest_stack([S|SList],MaxL) :-
	calc_longest_stack0(S,L1),
	calc_longest_stack(SList,L2),
	(
	    L1 > L2, !,
	    MaxL is L1
	;
	    MaxL is L2
	).
calc_longest_stack0([],0) :- !.
calc_longest_stack0([S|SList],MaxL) :-
	calc_longest_stack0(SList,MaxL1),
	MaxL is MaxL1+1.
calc_longest_stack0(S,MaxL) :-
	calc_longest_stack1(S,MaxL).
calc_longest_stack1(SList/S,MaxL) :- !,
	calc_longest_stack0(S,L1),
	calc_longest_stack1(SList,L2),
	(
	    L1 > L2, !,
	    MaxL is L1
	;
	    MaxL is L2
	).
calc_longest_stack1(S,MaxL) :-
	calc_longest_stack0(S,MaxL).




% Хѿν
var_init :-
	abolish(max_node),
	abolish(map),
	abolish(screen),
	abolish(stage_num),
	abolish(node_list),
	abolish(node),
	abolish(zoom),
	abolish(node_history),
	assert(max_node(0)),
	assert(stage_num(0)),
	assert(node_list([])),
	assert(zoom(1)).





% ꥹXǤĤʤʸ(ȥ)Y
make_string(X,Y) :-
	list_to_atom(X,X1), name(Y,X1).
list_to_atom([],[]) :- !.
list_to_atom([X|Y],Z) :-
	name(X,X1), list_to_atom(Y,Y1), append(X1,Y1,Z).

%
% XWindow
%

% Ρ
xdisp_node(X,Y,N) :-
	make_string(['node ',X,' ',Y,' ',N],Z),
	tcl_eval(Z).
% 
xdisp_state(X,Y,N) :-
	make_string(['state ',X,' ',Y,' ',N],Z),
	tcl_eval(Z).
% 
xdisp_edge(X1,Y1,X2,Y2) :-
	make_string(['edge ',X1,' ',Y1,' ',X2,' ',Y2],Z),
	tcl_eval(Z).
% ꥢ
xerase :- tcl_eval('eraser').

% ʸ
xdisp_input :-
	see('/tmp/input'), read(X), seen,
	(
	    X = end_of_file, !
	;
	    make_string(['set input_sentence ',X],Z),
	    tcl_eval(Z)
	).

% ΨѤ
xzoom(X) :-
	make_string(['zoom ',X],Z),			 
	tcl_eval(Z),
	(stage_num(S), xdisp(S), !; true).
xzoom_up :-
	zoom(Z), !,
	(
	    Z < 1.5, !,
	    Z1 is Z+0.1, abolish(zoom), assert(zoom(Z1)),
	    xzoom(Z1)
	;
	    true
	).
xzoom_down :-
	zoom(Z), !,
	(
	    Z > 0.7, !,
	    Z1 is Z-0.1, abolish(zoom), assert(zoom(Z1)),
	    xzoom(Z1)
	;
	    true
	).
	
% å
xdisp(X) :-
	xerase, screen(X,S), xdisp0(S),
	make_string(['read_text /tmp/node',X],Z),
	tcl_eval(Z).
xdisp0([]) :- !.
xdisp0([X|Y]) :-
	call(X), xdisp0(Y).

% ꤵ줿Ρɤбֹtk֤
xset_line_number(X) :-
	name(X,X1), name(X2,X1), % tkǡatomľ(?)
	stage_num(S), node(S,NL),
	list_locate(X2,NL,1,L),
	make_string(['set line_number ',L],Z),
	tcl_eval(Z).
list_locate(_,[],_,-1) :- !.
list_locate(X,[Y|Z],N,L) :-
	(
	    Y = [X,_], !, L = N
	;
	    N1 is N+1,
	    list_locate(X,Z,N1,L)
	).

% mapϿ
regist_map(X,Y) :-
	(
	    map(X,Z), !, retract(map(X,Z)),
	    append(Y,Z,W), assert(map(X,W))
	;
	    assert(map(X,Y))
	).

% åɸ(map)
stacklist([],_) :- !.
stacklist([S|T],A) :-
	number_of_stk(S,N),
	B is A+1,
	(
	    N = 1, !, S = [S1],
	    stack(S1,Z),
	    regist_map(A,Z),
	    stacklist(T,B)
	;
	    N = 0, !,
	    stacklist(T,A)
	;
	    N = -1, !,
	    sentence_list(S,A)
	;
	    stacklist(S,0,A),
	    stacklist(T,B)
	).
stacklist([],_,_) :- !.
stacklist([S|T],Y,A) :-
	makemap(S,0,Y,[],X,YY,Z),
	adjust_x(Z,X,W),
	regist_map(A,W),
	NY is YY+1,
	stacklist(T,NY,A).
stack(S,T) :-
	makemap(S,0,0,[],X,Y,Z),
	adjust_x(Z,X,T).

% map
%	makemap(S,OX,OY,OZ,NX,NY,NZ)
%		S: å
%		OX,OY,OZ: ߰
%		NX,NY,NZ: SŸȤΰ
makemap([],X,Y,Z,X,Y,Z) :- !.
makemap([S1|S2],OX,OY,OZ,NX,NY,NZ) :-
	number(S1), !,
	X1 is OX-1,
	append([[xdisp_state,X1,OY,S1]],OZ,Z),
	makemap(S2,X1,OY,Z,NX,NY,NZ).
makemap([S1|S2],OX,OY,OZ,NX,NY,NZ) :-
	get_len(S1,LEN),
	X1 is OX-LEN*2+1,
	append([[xdisp_node,X1,OY,S1]],OZ,Z),
	makemap(S2,X1,OY,Z,NX,NY,NZ).
makemap(T1/T2,OX,OY,OZ,NX,NY,NZ) :-
	makemap(T2,OX,OY,OZ,X2,Y2,Z2),
	Y1 is Y2+1,
	makemap(T1,OX,Y1,Z2,NX,NY,NZ).

% sentenceե˽񤭹
sentence_list(S,A) :-
	make_string(['/tmp/node',A],FILE),
	tell(FILE), write(S), told.

% xɸ
adjust_x([],_,[]) :- !.
adjust_x([A|B],X,[C|D]) :-
	adjust_x(B,X,D),
	A = [I,X1|Y], X2 is X1-X,
	C = [I,X2|Y].

% ΡɤȤĹ
get_len([],0) :- !.
get_len([A,B],L) :-
	(
	    atom(A)
	;
	    A = _/AT,
	    atom(AT)
	), atom(B), !,
	atom_chars(B,C), length(C,L1), L is L1//2.
get_len([A|B],L) :-
	atom(A), !, get_len(B,L).
get_len([A|X/Y],L) :- !,
	get_len(Y,L).
get_len(X/Y,L) :- !,
	get_len(Y,L).
get_len([X|Y],L) :- !,
	get_len(X,XL), get_len(Y,YL), L is XL + YL.
get_len(X,0).

% åʬĴ٤
number_of_stk([[X|_]|_],-1) :- top_node_symbol(X), !. % Ͻλξ
number_of_stk([X|Y],A) :- !,
	number_of_stk(Y,B), A is B+1.
number_of_stk(X,0).

% ɸˤ륯å
quick_sort([],[]) :- !.
quick_sort([X|XS],YS) :-
	partition(XS,X,LT,BG),
	quick_sort(LT,LS),
	quick_sort(BG,BS),
	append(LS,[X|BS],YS).
partition([],_,[],[]) :- !.
partition([X|XS],Y,[X|LS],BS) :-
	X = [_,A,B,_], Y = [_,C,D,_],
	B < D, !, partition(XS,Y,LS,BS).
partition([X|XS],Y,[X|LS],BS) :-
	X = [_,A,B,_], Y = [_,C,D,_],
	B = D, A =< C, !, partition(XS,Y,LS,BS).
partition([X|XS],Y,LS,[X|BS]) :-
	partition(XS,Y,LS,BS).

% ΡɥꥹȤΥ
quick_sort_node([],[]) :- !.
quick_sort_node([X|XS],YS) :-
	partition_node(XS,X,LT,BG),
	quick_sort_node(LT,LS),
	quick_sort_node(BG,BS),
	append(LS,[X|BS],YS).
partition_node([],_,[],[]) :- !.
partition_node([X|XS],Y,[X|LS],BS) :-
	X = [A,_], Y = [B,_],
	A < B, !, partition_node(XS,Y,LS,BS).
partition_node([X|XS],Y,LS,[X|BS]) :-
	partition_node(XS,Y,LS,BS).

% Ρɤե˽񤭹
write_node([]) :- !, nl.
write_node([[X,Y]|Z]) :-
	write(X), tab(4), write(Y), nl, write_node(Z).
search_node([],_,[]) :- !.
search_node([X|Y],Z,W) :-
	(
	    X = [_,Z], !, W = X
	;
	    search_node(Y,Z,W)
	).
regist_node(A,B,C,D,E) :-
	regist_node0(B,C,[],NL,D,E),
	quick_sort_node(NL,NL1),
	assert(node(A,NL1)),
	make_string(['/tmp/node',A],FILE),
	tell(FILE), write_node(NL1), told.
regist_node0([],[],X,X,N,N) :- !.
regist_node0([A|B],[C|D],X,Z,N,NM) :-
	(
	    A = [xdisp_node,DX,DY,L], !,
	    node_list(NL),
	    search_node(NL,L,L1),
	    (
		L1 = [], !,
		C = [xdisp_node,DX,DY,N],
		append(X,[[N,L]],Y),
		append(NL,[[N,L]],NL1),
		abolish(node_list), assert(node_list(NL1)),
		M is N+1,
		regist_node0(B,D,Y,Z,M,NM)
	    ;
		search_node(X,L,L2),
		L1 = [N1,_],
		C = [xdisp_node,DX,DY,N1],
		(
		    L2 = [], !,
		    append(X,[[N1,L]],Y),
		    regist_node0(B,D,Y,Z,N,NM)
		;
		    regist_node0(B,D,X,Z,N,NM)
		)
	    )
	;
	    C = A,
	    regist_node0(B,D,X,Z,N,NM)
	).


% ޤĹĴ
adjust(M,NM) :-
	adjust0(M,0,NM).
adjust0(X,C,Y) :-
	(
	    exist_num(X,C), !,
	    NC is C+1, adjust0(X,NC,Y)
	;
	    shorten(X,C,X1),
	    (
		X = X1, !, Y = X
	    ;
		adjust0(X1,C,Y)
	    )
	).
% ;ʬʻޤ򥫥å
shorten([],_,[]) :- !.
shorten([X|Y],C,Z) :-
	shorten(Y,C,Y1),
	(
	    X = [I,XC,YC,N], !,
	    (
		XC > C, !,
		XC1 is XC-1, X1 = [I,XC1,YC,N],
		append([X1],Y1,Z)
	    ;
		append([X],Y1,Z)
	    )
	;
	    X = [I,XC,YC,XXC,YYC], !,
	    (
		XC > C, !,
		XC1 is XC-1, XXC1 is XXC-1, X1 = [I,XC1,YC,XXC1,YYC],
		append([X1],Y1,Z)
	    ;
		XC < C, XXC > C, !,
		XXC1 is XXC-1, X1 = [I,XC,YC,XXC1,YYC],
		append([X1],Y1,Z)
	    ;
		append([X],Y1,Z)
	    )
	).
exist_num([],_) :- false.
exist_num([[xdisp_state,N,_,_]|Y],N) :- !.
exist_num([[xdisp_node,N,_,_]|Y],N) :- !.
exist_num([[xdisp_edge,N,_,_,_]|Y],N) :- !.
exist_num([_|Y],N) :- exist_num(Y,N).

% mapZɸ(X,Y)ΤWõ
search_map(X,Y,Z,W) :-
	search_map0(X,Y,Z,W).
search_map0(_,_,[],[]) :- !.
search_map0(X,Y,[A|B],A) :-
	A = [_,X,Y,_], !.
search_map0(X,Y,[_|B],A) :-
	search_map0(X,Y,B,A).

xfirst_stage :-
	xdisp(0),
	abolish(stage_num), assert(stage_num(0)).

% β̤˿ʤ
xnext_stage :-
	stage_num(S),
	S1 is S+1,
	(
	    screen(S1,_), !,
	    xdisp(S1), abolish(stage_num), assert(stage_num(S1))
	;
	    true
	).

% β̤
xprev_stage :-
	stage_num(S),
	S1 is S-1,
	(
	    S1 >= 0, !,
	    xdisp(S1), abolish(stage_num), assert(stage_num(S1))
	;
	    true
	).
	
% mapscreen
map_to_screen(X,N) :-
	X1 is X+1,
	(
	    map(X1,_), !,
	    map_to_screen0(X,N,M), !,
	    map_to_screen(X1,M)
	;
	    map_to_screen0(X,N,M),
	    S = [xdisp_state(0,0,0), xdisp_edge(0,0,1,0),
	    xdisp_node(1,0,M), xdisp_edge(1,0,2,0), xdisp_state(2,0,1)],
	    assert(screen(X1,S)),
	    assert(node(X1,[[M,S]]))
	).
map_to_screen0(X,ON,NN) :-
	map(X,M),
	quick_sort(M,M1),
	adjust(M1,M2),
	del_red_stack(M2,M2,M3,0),
	regist_node(X,M3,M4,ON,NN),
	make_edge(M4,M5),
	make_pred(M5,S),
	assert(screen(X,S)).

% ʣΥåƬʬޤȤ
del_red_stack(OM,W,NM,Y) :-
	Y1 is Y+1,
	search_map(0,Y1,OM,M),
	(
	    M = [], !, NM = W
	;
	    del_red_stack_x(OM,W,TMP,0,Y,Y1),
	    del_red_stack(OM,TMP,NM,Y1)
	).
del_red_stack_x(OM,W,NM,X,Y1,Y2) :-
	search_map(X,Y1,OM,M1), search_map(X,Y2,OM,M2),
	(
	    M1 = [H,X,Y1,NUM], M2 = [H,X,Y2,NUM], !,
	    delete(W,M2,TMP),
	    X1 is X+1, del_red_stack_x(OM,TMP,NM,X1,Y1,Y2)
	;
	    NM = W
	).

% PrologҸ
make_pred([],[]) :- !.
make_pred([X|Y],[Z|W]) :-
	Z =.. X, make_pred(Y,W).

% ޤĥ
make_edge(M,NM) :-
	make_edge0(0,M,M,NM).

make_edge0(_,_,[],[]) :- !.
make_edge0(_,M,[A],Z) :-
	A = [_,AX,AY,_], AX1 is AX+1,
	search_tail(AX1,AY,M,AX2,AY2),
	(
	    AX2 > -1, !,
	    E = [xdisp_edge,AX,AY,AX2,AY2],
	    Z = [A,E]
	;
	    Z = [A]
	).
make_edge0(Y,M,[M1,M2|M3],[M1,E,M2|M4]) :-
	M1 = [_,X1,Y,_], M2 = [_,X2,Y,_], !,
	E = [xdisp_edge,X1,Y,X2,Y],
	make_edge0(Y,M,[M2|M3],[M2|M4]).
make_edge0(Y,M,[A,B|C],Z) :-
	A = [_,AX,AY,_], AX1 is AX+1,
	search_tail(AX1,AY,M,AX2,AY2),
	(
	    AX2 > -1, !,
	    E = [xdisp_edge,AX,AY,AX2,AY2],
	    Z = [A,E,F|D]
	;
	    Z = [A,F|D]
	),
	B = [_,BX,BY,_], BX1 is BX-1,
	search_head(BX1,BY,M,BX2,BY2),
	F = [xdisp_edge,BX2,BY2,BX,BY],
	make_edge0(BY,M,[B|C],D).
% ʬõ
search_head(X,Y,A,X1,Y1) :-
	search_map(X,Y,A,M),
	(
	    M = [] , !,
	    Y2 is Y-1, search_head(X,Y2,A,X1,Y1)
	;
	    M = [_,X1,Y1,_]
	).
% ʬνõ
search_tail(X,Y,A,X1,Y1) :-
	search_map(X,Y,A,M),
	(
	    M = [] , !,
	    Y2 is Y-1,
	    (
		Y2 < 0, !, X1 = -1, Y1 = -1
	    ;
		search_tail(X,Y2,A,X1,Y1)
	    )
	;
	    M = [_,X1,Y1,_]
	).


%
% ɽط(for sglr-parser)
%
write_tree(Info):-
	( tree_option, disp_tree,!,
	  disp_tree_org(0,N,Info)
	; count_stack(0,N,Info) ),
	  display('Number of Trees is : '),display(N),ttynl,!.
% disp_tree
disp_tree_org(N,N,[]):-!.
disp_tree_org(N,M,[[T|_]|Y]) :-
	show_org(T,n,[],last),
	nl,
	( output_result(I),! ; true ),
	nl,
	N1 is N+1,
	disp_tree_org(N1,M,Y).
show_org([Nt|T],P,X,H):-	% T=[[det,the],[n,door]]/[[pron,i]]
	( X==[],!
	; displ_org(X) ),
	( P==p,!,
	   write('  '),!
	; write('  ') ),
	write(Nt),
	( T=[T1],atom(T1),!
	; T=T1/[T2],atom(T2),!
	; nl ),
	( H==last,!,append(X,['   '],NN)
	; P==p,!,append(X,['  '],NN)
	; append(X,['  '],NN) ),
	showt_org(T,n,NN).
showt_org([T],P,X):- atom(T),!,
	write('  '),write(T),nl.
showt_org(T/T1,P,X):-!,
	showt_org(T1,p,X),
	showt_org(T,p,X).
showt_org([T],P,X):-!,
	show_org(T,P,X,last).
showt_org([T|R],P,X):-!,
	show_org(T,P,X,middle),
	showt_org(R,P,X).
displ_org([X|Y]):-!,
	write(X),
	displ_org(Y).
displ_org([]).
displ_org(X):-
	write(X).

% ڤǤ˶ڤäɽ롣
%write_morph([]) :- !, nl.
%write_morph([X|Y]) :- write_word(X), nl, write_morph(Y).
%write_word([]) :- !.
%write_word([[A,B]|Y]) :-
%	write(''), write(B), tab(3), write(A), write(''),
%	write_word(Y).

write_morph(X) :-
	write_morph0(X,0,C).

write_morph0([],C,C) :- !, nl.
write_morph0([X|Y],C1,C2) :-
	write_word(X), nl,
	C3 is C1+1, write_morph0(Y,C3,C2).

write_word([]) :- !.
write_word([[A,B]|Y]) :-
	(
	    atom(A), atom(B), !,
	    write('('), write(B), write(' '), write(A), write(')'),
	    write_word(Y)
	;
	    A = [_|_], B = [_|_], !,
	    write_hyouki(A),
	    write('    '),
	    write_word(Y)
	).
write_word([[A,[B,C]]|Y]) :-
	(
	    atom(A), atom(B), atom(C), !,
	    write('('), write(C), write(' '),
	    write(A), write('('), write(B), write(')'), write(')'),
% ʻǤʤʻξɽ褦ˤ롣
% modified by ueki@cs.titech.ac.jp  on 16 Dec 1994
	    write_word(Y)
	;
	    A = [_|_], B = [_|_], C = [_|_], !,
	    write_hyouki(A),
	    write('    '),
	    write_word(Y)
	).

write_hyouki([]) :- !.
write_hyouki([A|B]) :-
	write(A),
	write_hyouki(B).

write_hinshi_saihinshi([],[]) :- !.
write_hinshi_saihinshi([A1,B1|C1],[A2,B2|C2]) :-
	write(A1), write('('), write(A2), write(')'), write(' '),
	write_hinshi_saihinshi([B1|C1],[B2|C2]).
write_hinshi_saihinshi([A1|B1],[A2|B2]) :-
	write(A1), write('('), write(A2), write(')'),
	write_hinshi_saihinshi(B1,B2).
