% Copyright (C) 1996  º    ͵

/*

		* SGLR 2.0 Parser Main Program *

					1990.10.8
					H.Numazaki
*/

	
/*
:-	nl,nl,write('		*** SGLR Parser ***'),nl,nl,
	write('	    Please start this program as follows :'),nl,nl,
	write('	    ?- start.'),nl,
	write('	      or'),nl,
	write('	    ?- start( file ).'),nl,
	write('	      where ''file'' is the name of the text file'),nl,nl,
	write('	    ?- deb. (for debug option on)'),nl,
	write('	    ?- nodeb. (for debug option off)'),nl,
	write('	    ?- tree. (for parse-tree display mode on)'),nl,
	write('	    ?- notree. (for parse-tree display mode off)'),nl.
*/

deb :- 
	assert(debug_option).
nodeb :- 
	abolish(debug_option,0).
tree :-
	assert(disp_tree).
notree :-
	abolish(disp_tree,0).

start :- 
	prompt(_,'input sentense : '),
	read(Sentence),
	morph(0,L,Sentence,Result),
	mk_exe(Result,[[0]],Goals,Info),
	nl,write(Sentence),nl,
	nl,write('Length : '),write(L),nl,
	time(Goals), fin(Info).

start(F) :- 
	see(F),
	repeat,
	  read(Sentence),
	  ( Sentence==end_of_file,!,seen
	  ; morph(0,L,Sentence,Result),
	    mk_exe(Result,[[0]],Goals,Info),
	    nl,write(Sentence),nl,
	    nl,write('Length : '),write(L),nl,
	    time(Goals), fin(Info),gc,fail ).

startT(F) :- 
	see(F),
	tell('t.tree'),
	repeat,
	  read(Sentence),
	  ( Sentence==end_of_file,!,seen
	  ; morph(0,L,Sentence,Result),
	    mk_exe(Result,[[0]],Goals,Info),
	    ttynl,display(Sentence),ttynl,
	    ttynl,display('Length : '),display(L),ttynl,
	    call(Goals),write('['),fin1(Info),write('].'),nl,gc,fail ),
	told.

fin1([]):-!.
fin1([A/[T|_]]):-!,
	writeq(T),write(','),
	fin1([A]).
fin1([[T|_]]):-!,
	writeq(T).
fin1([A/[T|_]|I]):-!,
	writeq(T),write(','),
	fin1([A|I]).
fin1([[T|_]|I]):-!,
	writeq(T),write(','),
	fin1(I).

morph(N,N,X,[]):- var(X),!.
morph(N,M,(Word,Words),[Word,Dict|Rest]):-!,
	N1 is N+1,
	( dict(Word,Dict),!
	; dicta(Word,Dict,_),!
	; write('Unknown : '),write(Word),Dict=[[n,[[]]]] ),
	morph(N1,M,Words,Rest),!.
morph(N,N1,(Word),[Word,Dict]):-
	N1 is N+1,
	( dict(Word,Dict),!
	; dicta(Word,Dict,_),!
	; write('Unknown : '),write(Word),Dict=[[n,[[]]]] ).

mk_exe(Result,In,Goals,Info):-
	tree_option,!,
	( debug_option,!,mk_exed0(t,Result,In,Goals,Info)
	; mk_exe0(t,Result,In,Goals,Info) ).
mk_exe(Result,In,Goals,Info):-
	( debug_option,!,mk_exed0(n,Result,In,Goals,Info)
	; mk_exe0(n,Result,In,Goals,Info) ).

mk_exe0(_,[],In,($(In,[],Info-[])),Info):-!.
mk_exe0(O,[Word,Dict|Rest],In,(Goal,mg_st(Out1,Out),Goals),Info):-
	mk_exe1(O,Word,Dict,In,Out1,[],Goal),
	mk_exe0(O,Rest,Out,Goals,Info).

mk_exed0(_,[],In,($(In,[],Info-[])),Info):-!.
mk_exed0(O,[Word,Dict|Rest],In,(Goal,ck_st(Word,Out1),mg_st(Out1,Out),Goals),Info):-
	mk_exe1(O,Word,Dict,In,Out1,[],Goal),
	mk_exed0(O,Rest,Out,Goals,Info).

mk_exe1(t,Word,[[Cat,Arg]],In,Out,X,Goal):-!,
	Goal=..[Cat,In,[[Cat,Word]|Arg],Out-X].
mk_exe1(t,Word,[[Cat,Arg]|Rest],In,Out,X,(Goal,Goals)):-
	Goal=..[Cat,In,[[Cat,Word]|Arg],Out-X1],
	mk_exe1(t,Word,Rest,In,X1,X,Goals).
mk_exe1(n,_,[[Cat,Arg]],In,Out,X,Goal):-!,
	Goal=..[Cat,In,Arg,Out-X].
mk_exe1(n,_,[[Cat,Arg]|Rest],In,Out,X,(Goal,Goals)):-
	Goal=..[Cat,In,Arg,Out-X1],
	mk_exe1(n,_,Rest,In,X1,X,Goals).

fin(Info):-
	( tree_option, disp_tree,!,
	  disp_tree(0,N,Info)
	; count_stack(0,N,Info) ),
	  display('Number of Trees is : '),display(N),ttynl,!.


mg_st( [], [] ) :- !.
mg_st([ [N,[[A1,[A2,A3]]] | [S1,[[bunsetsu|X]] |S2]] ], B) :-
	(
	    part_of_noun(A1), !,
	    (
		part_of_number(A1), !,
		(
		    (
			X = [[noun|[[suuryou|Suuryou]]]]
		    ;
			X = _/[[noun|[[suuryou|Suuryou]]]]
		    ), !,
		    flat2(Suuryou,H,_,_),
		    (
			member(tani,H), !,
			B = [[N,[[A1,[A2,A3]]]|[S1,[[bunsetsu|X]]|S2]]]
		    ;
			B = []
		    )
		;
		    B = [[N,[[A1,[A2,A3]]]|[S1,[[bunsetsu|X]]|S2]]]
		)
	    ;
		remove_noun(X,Y),
		(
		    Y = [], !,
		    B = []
		;
		    B = [[N,[[A1,[A2,A3]]]|[S1,[[bunsetsu|Y]]|S2]]]
		)
	    )
	;
	    B = [[N,[[A1,[A2,A3]]]|[S1,[[bunsetsu|X]]|S2]]]
	).
mg_st( [ [N,[[A1,[A2,A3]]]|S] | I], B) :-
	part_of_noun(A1), !,
	(
	    S = [S1,[[bunsetsu|X]]|S2],
	    (
		part_of_number(A1), !,
		(
		    (
			X = [[noun|[[suuryou|Suuryou]]]]
		    ;
			X = _/[[noun|[[suuryou|Suuryou]]]]
		    ), !,
		    flat2(Suuryou,H,_,_),
		    (
			member(tani,H), !,
			mk_br(N,[[A1,[A2,A3]]],S,I,B1,O1),
			mg_st(O1,O),
			B = [[N,[[A1,[A2,A3]]]|B1]|O]
		    ;
			mg_st(I,B)
		    )
		;
		    mk_br(N,[[A1,[A2,A3]]],S,I,B1,O1),
		    remove_suuryou(B1,B2),
		    mg_st(O1,O),
		    B = [[N,[[A1,[A2,A3]]]|B2]|O]
		)
	    ;
		remove_noun(X,Y),
		(
		    Y == [], !,
		    mg_st(I,B)
		;
		    NewS = [S1,[[bunsetsu|Y]]|S2],
		    mk_br(N,[[A1,[A2,A3]]],NewS,I,B1,O1),
		    mg_st(O1,O),
		    B = [[N,[[A1,[A2,A3]]]|B1]|O]
		)
	    )
	;
	    mk_br(N,[[A1,[A2,A3]]],S,I,B1,O1),
	    mg_st(O1,O),
	    B = [[N,[[A1,[A2,A3]]]|B1]|O]
	).
mg_st( [ [N,A|S] |I], [ [N,A|B] |O] ) :-
	mk_br( N,A,S, I, B, O1 ),
	mg_st( O1, O ).

mk_br( _,_,S, [], S, [] ):- !.
mk_br( N,[[A1,[A2,A3]]],S, [[N,[[A1,[A2,A3]]]|B1] | I], B, O) :-
	part_of_noun(A1), !,
	(
	    B1 = [B11,[[bunsetsu|X]]|B12],
	    remove_noun(X,Y),
	    (
		Y == [], !,
		mk_br(N,[[A1,[A1,A3]]],S,I,B,O)
	    ;
		NewB1 = [B11,[[bunsetsu|Y]]|B12],
		mk_br(N,[[A1,[A2,A3]]],S,I,B2,O),
		B = B2/NewB1
	    )
	;
	    mk_br(N,[[A1,[A2,A3]]],S,I,B2,O),
	    B = B2/B1
	).
mk_br( N,A,S, [[N,A|B1] |I], B/B1, O ) :-!,
	mk_br( N,A,S, I, B, O ).
mk_br( N,A,S, [S1|I], B, [S1|O] ) :-
	mk_br( N,A,S, I, B, O ).

re( [_,A1|S], P, R, A, D ):- !,
	( P==1,!,
	  cnd( R, S, (A1,A), D )
	; P1 is P-1,
	  re( S, P1, R, (A1,A), D ) ).
re( B/[_,A1|S], P, R, A, O-X ):- !,
	( P==1,!,
	  cnd( R, S, (A1,A), O-O1 )
	; P1 is P-1,
	  re( S, P1, R, (A1,A), O-O1 ) ),
	  re( B, P, R, A, O1-X ).

ck_st(W,[]):-!,
	nl,write('	Stack is empty at '),
	write(W),nl,nl,ttyget0(_).
ck_st(W,L):-
	count(L,0,N),
	write(W),write(' '),write(N),nl.

count([],N,N):-!.
count([_|R],N,M):-
	N1 is N+1,
	count(R,N1,M).

cnd_(0,N,S,O0):-
	cnd(N,S,_,O1-[]),
	mg_st(O1,O0).
cnd_(1,N,[X,A0|S],O0):-
	cnd(N,S,A0,O1-[]),
	mg_st(O1,O0).
re_([X,A0|S],State,Ruleno,O0):-
	re(S,State,Ruleno,A0,O1-[]),
	mg_st(O1,O0).


act_t(CND_S,CND_T,RE_S,RE_R,S,O0):-
	act_t(CND_S,CND_T,RE_S,RE_R,S,O0,O1,O1).

act_t([],[],[],[],_,O0,O1,_):-
	mg_st(O1,O0).

act_t([],[],[State],[Ruleno],[X,A0|S],O0,O1,O_cur):-
	re(S,State,Ruleno,A0,O_cur-[]),
	act_t([],[],[],[],_,O0,O1,_).
act_t([],[],[State0|SList],[Rule0|RList],[X,A0|S],O0,O1,O_cur):-
	re(S,State0,Rule0,A0,O_cur-O_cur_new),
	act_t([],[],SList,RList,[X,A0|S],O0,O1,O_cur_new).

act_t([State],[0],[],[],S,O0,O1,O_cur):-
	cnd(State,S,_,O_cur-[]),
	act_t([],[],[],[],_,O0,O1,_).
act_t([State],[1],[],[],[X,A0|S],O0,O1,O_cur):-
	cnd(State,S,A0,O_cur-[]),
	act_t([],[],[],[],_,O0,O1,_).
act_t([State0|SList],[0|TList],RE_S,RE_R,S,O0,O1,O_cur):-
	cnd(State0,S,_,O_cur-O_cur_new),
	act_t(SList,TList,RE_S,RE_R,S,O0,O1,O_cur_new).
act_t([State0|SList],[1|TList],RE_S,RE_R,[X,A0|S],O0,O1,O_cur):-
	cnd(State0,S,A0,O_cur-O_cur_new),
	act_t(SList,TList,RE_S,RE_R,[X,A0|S],O0,O1,O_cur_new).

remove_noun([[noun|X]],Y) :-
	(
	    (
		X = [[n_sahen|_]]
	    ;
		X = [[n_̤|_]]
	    ;
		X = [[nn|_]]
	    ), !,
	    Y = []
	;
	    Y = [[noun|X]]
	).
remove_noun(X/[[noun|X1]],Y) :-
	(
	    (
		X = [[n_sahen|_]]
	    ;
		X = [[n_̤|_]]
	    ;
		X = [[nn|_]]
	    ), !,
	    remove_noun(X,Y)
	;
	    remove_noun(X,Y1),
	    (
		Y == [], !,
		Y = [[noun|X1]]
	    ;
		Y = Y1/[[noun|X1]]
	    )
	).
remove_noun(X/X1,Y) :-
	remove_noun(X,Y1),
	(
	    Y1 == [], !,
	    Y = X1
	;
	    Y = Y1/X1
	).
remove_noun(X,X) :- !.

remove_suuryou(X/[S,[[bunsetsu,[noun,[suuryou|Suuryou]]]]|T],Y) :-
	flat2(Suuryou,List,_,_),
	(
	    member(tani,List), !,
	    Y = Y1/[S,[[bunsetsu,[noun,[suuryou|Suuryou]]]]|T]
	;
	    Y = Y1
	),
	remove_suuryou(X,Y1).
remove_suuryou(X/Y,X1/Y) :-
	remove_suuryou(X,X1).
remove_suuryou(X,X) :- !.
